/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.annotations.datasource;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.ReadOnlyException;
import com.laytonsmith.persistence.SQLDataSource;
import com.laytonsmith.persistence.io.ConnectionMixin;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sqlite.JDBC;
import org.sqlite.SQLiteJDBCLoader;
import org.sqlite.util.OSInfo;

@datasource(value="sqlite")
public class SQLiteDataSource
extends SQLDataSource {
    private static final String TABLE_NAME = "persistance";
    private String path;
    private ConnectionMixin mixin;
    private static final boolean DO_DISCONNECTS = true;
    private static final int TIMEOUT = 30000;

    private SQLiteDataSource() {
    }

    public SQLiteDataSource(URI uri, ConnectionMixinFactory.ConnectionMixinOptions options) throws DataSourceException {
        super(uri, options);
        this.mixin = this.getConnectionMixin();
        try {
            Class.forName(JDBC.class.getName());
            if (System.getProperty("org.sqlite.lib.path") == null) {
                System.setProperty("org.sqlite.lib.path", new File(MethodScriptFileLocations.getDefault().getConfigDirectory(), "sqlite/native/" + OSInfo.getNativeLibFolderPathForCurrentOS()).getAbsolutePath());
            }
            try {
                SQLiteJDBCLoader.initialize();
            }
            catch (Exception ex) {
                throw new DataSourceException("Failed to load a native sqlite library for your platform. You can download the library file from https://github.com/xerial/sqlite-jdbc/tree/master/src/main/resources/org/sqlite/native/" + OSInfo.getNativeLibFolderPathForCurrentOS() + " and place it into " + System.getProperty("org.sqlite.lib.path"));
            }
            this.path = this.mixin.getPath();
            this.connect();
            long startTime = System.currentTimeMillis();
            while (true) {
                if (System.currentTimeMillis() - 30000L > startTime) {
                    throw new DataSourceException("Data source at " + uri + " could not connect for 30 seconds, so we're giving up on retrying.");
                }
                try {
                    try (Statement statement = this.getConnection().createStatement();){
                        statement.executeUpdate(this.getTableCreationQuery());
                    }
                    this.updateLastConnected();
                }
                catch (SQLException ex) {
                    if (ex.getMessage().startsWith("[SQLITE_BUSY]") || ex.getMessage().equals("database is locked")) {
                        try {
                            Thread.sleep(this.getRandomSleepTime());
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw ex;
                }
                break;
            }
        }
        catch (IOException | ClassNotFoundException | UnsupportedOperationException | SQLException ex) {
            throw new DataSourceException("An error occurred while setting up a connection to the SQLite database", ex);
        }
        finally {
            this.disconnect();
        }
    }

    @Override
    protected void connect() throws IOException, SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = DriverManager.getConnection(this.getConnectionString());
    }

    @Override
    public boolean set0(DaemonManager dm, String[] key, String value) throws ReadOnlyException, DataSourceException, IOException {
        try {
            this.connect();
            if (value == null) {
                this.clearKey0(dm, key);
            } else {
                long startTime = System.currentTimeMillis();
                while (true) {
                    if (System.currentTimeMillis() - 30000L > startTime) {
                        throw new DataSourceException("Data source at " + this.uri + " could not connect for 30 seconds, so we're giving up on retrying.");
                    }
                    try (PreparedStatement statement = this.getConnection().prepareStatement("INSERT OR REPLACE INTO `persistance` (`" + this.getKeyColumn() + "`, `" + this.getValueColumn() + "`) VALUES (?, ?)");){
                        statement.setString(1, StringUtils.Join(key, "."));
                        statement.setString(2, value);
                        statement.executeUpdate();
                    }
                    catch (SQLException ex) {
                        if (ex.getMessage().startsWith("[SQLITE_BUSY]") || ex.getMessage().equals("cannot commit transaction - SQL statements in progress")) {
                            try {
                                int sleepTime = this.getRandomSleepTime();
                                MSLog.GetLogger().d(MSLog.Tags.PERSISTENCE, "Got recoverable error from SQLite DB, sleeping for " + sleepTime + " then potentially retrying. (" + ex.getMessage() + ")", Target.UNKNOWN);
                                Thread.sleep(sleepTime);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        throw ex;
                    }
                    break;
                }
            }
            this.updateLastConnected();
            boolean startTime = true;
            return startTime;
        }
        catch (SQLException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
        finally {
            this.disconnect();
        }
    }

    @Override
    public Set<String[]> keySet(String[] keyBase) throws DataSourceException {
        String searchPrefix = StringUtils.Join(keyBase, ".");
        try {
            this.connect();
            HashSet<String[]> set = new HashSet<String[]>();
            long startTime = System.currentTimeMillis();
            while (true) {
                if (System.currentTimeMillis() - 30000L > startTime) {
                    throw new DataSourceException("Data source at " + this.uri + " could not connect for 30 seconds, so we're giving up on retrying.");
                }
                try {
                    try (PreparedStatement statement = this.getConnection().prepareStatement("SELECT `" + this.getKeyColumn() + "` FROM `" + this.getEscapedTable() + "` WHERE `" + this.getKeyColumn() + "` LIKE ?");){
                        statement.setString(1, searchPrefix + "%");
                        try (ResultSet result = statement.executeQuery();){
                            while (result.next()) {
                                set.add(result.getString(this.getKeyColumn()).split("\\."));
                            }
                        }
                    }
                    this.updateLastConnected();
                }
                catch (SQLException ex) {
                    if (ex.getMessage().startsWith("[SQLITE_BUSY]")) {
                        try {
                            Thread.sleep(this.getRandomSleepTime());
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw ex;
                }
                break;
            }
            HashSet<String[]> hashSet = set;
            return hashSet;
        }
        catch (IOException | SQLException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
        finally {
            this.disconnect();
        }
    }

    @Override
    public String get0(String[] key) throws DataSourceException {
        try {
            this.connect();
            String ret = null;
            long startTime = System.currentTimeMillis();
            while (true) {
                if (System.currentTimeMillis() - 30000L > startTime) {
                    throw new DataSourceException("Data source at " + this.uri + " could not connect for 30 seconds, so we're giving up on retrying.");
                }
                try (PreparedStatement statement = this.getConnection().prepareStatement("SELECT `" + this.getValueColumn() + "` FROM `" + this.getEscapedTable() + "` WHERE `" + this.getKeyColumn() + "`=? LIMIT 1");){
                    statement.setString(1, StringUtils.Join(key, "."));
                    try (ResultSet result = statement.executeQuery();){
                        if (result.next()) {
                            ret = result.getString(this.getValueColumn());
                        }
                    }
                }
                catch (SQLException ex) {
                    if (ex.getMessage().startsWith("[SQLITE_BUSY]")) {
                        try {
                            int sleepTime = this.getRandomSleepTime();
                            MSLog.GetLogger().d(MSLog.Tags.PERSISTENCE, "Got recoverable error from SQLite DB, sleeping for " + sleepTime + " then potentially retrying. (" + ex.getMessage() + ")", Target.UNKNOWN);
                            Thread.sleep(sleepTime);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw ex;
                }
                break;
            }
            this.updateLastConnected();
            String string = ret;
            return string;
        }
        catch (IOException | SQLException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
        finally {
            this.disconnect();
        }
    }

    @Override
    protected Map<String[], String> getValues0(String[] leadKey) throws DataSourceException {
        try {
            this.connect();
            HashMap<String[], String> map = new HashMap<String[], String>();
            long startTime = System.currentTimeMillis();
            while (true) {
                if (System.currentTimeMillis() - 30000L > startTime) {
                    throw new DataSourceException("Data source at " + this.uri + " could not connect for 30 seconds, so we're giving up on retrying.");
                }
                try (PreparedStatement statement = this.getConnection().prepareStatement("SELECT `" + this.getKeyColumn() + "`, `" + this.getValueColumn() + "` FROM `" + this.getEscapedTable() + "` WHERE `" + this.getKeyColumn() + "` LIKE ?");){
                    statement.setString(1, StringUtils.Join(leadKey, ".") + "%");
                    try (ResultSet results = statement.executeQuery();){
                        while (results.next()) {
                            map.put(results.getString(this.getKeyColumn()).split("\\."), results.getString(this.getValueColumn()));
                        }
                    }
                }
                catch (SQLException ex) {
                    if (ex.getMessage().startsWith("[SQLITE_BUSY]")) {
                        try {
                            Thread.sleep(this.getRandomSleepTime());
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw ex;
                }
                break;
            }
            this.updateLastConnected();
            HashMap<String[], String> hashMap = map;
            return hashMap;
        }
        catch (IOException | SQLException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
        finally {
            this.disconnect();
        }
    }

    @Override
    protected void clearKey0(DaemonManager dm, String[] key) throws ReadOnlyException, DataSourceException, IOException {
        try {
            dm.activateThread(Thread.currentThread());
            this.connect();
            long startTime = System.currentTimeMillis();
            while (true) {
                if (System.currentTimeMillis() - 30000L > startTime) {
                    throw new DataSourceException("Data source at " + this.uri + " could not connect for 30 seconds, so we're giving up on retrying.");
                }
                try (PreparedStatement statement = this.getConnection().prepareStatement("DELETE FROM `" + this.getEscapedTable() + "` WHERE `" + this.getKeyColumn() + "`=?");){
                    statement.setString(1, StringUtils.Join(key, "."));
                    statement.executeUpdate();
                    this.updateLastConnected();
                }
                catch (SQLException ex) {
                    if (ex.getMessage().startsWith("[SQLITE_BUSY]") || ex.getMessage().equals("cannot commit transaction - SQL statements in progress")) {
                        try {
                            Thread.sleep(this.getRandomSleepTime());
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw ex;
                }
                break;
            }
        }
        catch (IOException | SQLException e) {
            throw new DataSourceException(e.getMessage(), e);
        }
        finally {
            this.disconnect();
            dm.deactivateThread(Thread.currentThread());
        }
    }

    @Override
    public String docs() {
        return "SQLite {sqlite://path/to/db/file.db} This type store data in a SQLite database. All the pros and cons of MySQL apply here. The database will contain a lone table, and the table should be created with the query: <%SYNTAX|sql|" + this.getTableCreationQuery() + "%>";
    }

    public final String getTableCreationQuery() {
        return "CREATE TABLE IF NOT EXISTS `persistance` (`" + this.getKeyColumn() + "` TEXT PRIMARY KEY, `" + this.getValueColumn() + "` TEXT)";
    }

    @Override
    public MSVersion since() {
        return MSVersion.V3_3_1;
    }

    @Override
    protected void startTransaction0(DaemonManager dm) {
        try {
            try (PreparedStatement statement = this.getConnection().prepareStatement("BEGIN EXCLUSIVE TRANSACTION");){
                statement.execute();
            }
            this.updateLastConnected();
        }
        catch (SQLException ex) {
            Logger.getLogger(SQLiteDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected void stopTransaction0(DaemonManager dm, boolean rollback) throws DataSourceException, IOException {
        try {
            if (rollback) {
                try (PreparedStatement statement = this.getConnection().prepareStatement("ROLLBACK TRANSACTION");){
                    statement.execute();
                }
            }
            try (PreparedStatement statement = this.getConnection().prepareStatement("END TRANSACTION");){
                statement.execute();
            }
            this.updateLastConnected();
        }
        catch (SQLException ex) {
            Logger.getLogger(SQLiteDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected String getTable() {
        return TABLE_NAME;
    }

    @Override
    protected String getConnectionString() {
        return "jdbc:sqlite:" + this.path;
    }

    private int getRandomSleepTime() {
        return (int)(Math.random() * 10.0) % 10;
    }
}

