/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading.ClassMirror;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;

public class ModifierMirror
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int access;
    private int modifiers = 0;
    private static final transient Object[] ORDER = new Object[]{1, "public", 2, "private", 4, "protected", 8, "static", 16, "final", 32, "synchronized", 64, "volatile", 128, "transient", 256, "native", 512, "interface", 1024, "abstract", 2048, "strictfp"};

    public ModifierMirror(int modifier) {
        this.access = 0;
        this.modifiers = modifier;
    }

    public ModifierMirror(Type type, int access) {
        this.access = access;
        if (type == Type.CLASS || type == Type.METHOD || type == Type.FIELD) {
            if (this.hasFlag(2)) {
                this.modifiers |= 2;
            }
            if (this.hasFlag(4)) {
                this.modifiers |= 4;
            }
            if (this.hasFlag(1)) {
                this.modifiers |= 1;
            }
            if (this.hasFlag(16)) {
                this.modifiers |= 0x10;
            }
        }
        if ((type == Type.FIELD || type == Type.METHOD) && this.hasFlag(8)) {
            this.modifiers |= 8;
        }
        if (type == Type.CLASS && this.hasFlag(512)) {
            this.modifiers |= 0x200;
        }
        if ((type == Type.CLASS || type == Type.METHOD) && this.hasFlag(1024)) {
            this.modifiers |= 0x400;
        }
        if (type == Type.METHOD) {
            if (this.hasFlag(256)) {
                this.modifiers |= 0x100;
            }
            if (this.hasFlag(2048)) {
                this.modifiers |= 0x800;
            }
            if (this.hasFlag(32)) {
                this.modifiers |= 0x20;
            }
        }
        if (type == Type.FIELD) {
            if (this.hasFlag(128)) {
                this.modifiers |= 0x80;
            }
            if (this.hasFlag(64)) {
                this.modifiers |= 0x40;
            }
        }
    }

    private boolean hasFlag(int flag) {
        return (this.access & flag) > 0;
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) > 0;
    }

    public boolean isFinal() {
        return (this.modifiers & 0x10) > 0;
    }

    public boolean isInterface() {
        return (this.modifiers & 0x400) > 0;
    }

    public boolean isNative() {
        return (this.modifiers & 0x100) > 0;
    }

    public boolean isPrivate() {
        return (this.modifiers & 2) > 0;
    }

    public boolean isProtected() {
        return (this.modifiers & 4) > 0;
    }

    public boolean isPublic() {
        return (this.modifiers & 1) > 0;
    }

    public boolean isPackagePrivate() {
        return !this.isPrivate() && !this.isProtected() && !this.isPublic();
    }

    public boolean isStatic() {
        return (this.modifiers & 8) > 0;
    }

    public boolean isStrict() {
        return (this.modifiers & 0x800) > 0;
    }

    public boolean isSynchronized() {
        return (this.modifiers & 0x20) > 0;
    }

    public boolean isTransient() {
        return (this.modifiers & 0x80) > 0;
    }

    public boolean isVolatile() {
        return (this.modifiers & 0x40) > 0;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String toString() {
        ArrayList<String> build = new ArrayList<String>();
        for (int i = 0; i < ORDER.length; ++i) {
            int type = (Integer)ORDER[i];
            String name = (String)ORDER[++i];
            if ((this.modifiers & type) <= 0) continue;
            build.add(name);
        }
        return StringUtils.Join(build, " ");
    }

    public static enum Type {
        CLASS,
        METHOD,
        FIELD;

    }
}

