/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.SignalType;

public enum Signals implements SignalType
{
    SIGABRT("ABRT", SignalType.DefaultAction.ACTION_TERMINATE),
    SIGALRM("ALRM", SignalType.DefaultAction.TERMINATE),
    SIGBUS("BUS", SignalType.DefaultAction.ACTION_TERMINATE),
    SIGCHLD("CHLD", SignalType.DefaultAction.IGNORE),
    SIGCONT("CONT", SignalType.DefaultAction.CONTINUE),
    SIGFPE("FPE", SignalType.DefaultAction.ACTION_TERMINATE),
    SIGHUP("HUP", SignalType.DefaultAction.TERMINATE),
    SIGILL("ILL", SignalType.DefaultAction.ACTION_TERMINATE),
    SIGINT("INT", SignalType.DefaultAction.TERMINATE),
    SIGKILL("KILL", SignalType.DefaultAction.TERMINATE, false),
    SIGPIPE("PIPE", SignalType.DefaultAction.TERMINATE),
    SIGQUIT("QUIT", SignalType.DefaultAction.ACTION_TERMINATE),
    SIGSEGV("SEGV", SignalType.DefaultAction.ACTION_TERMINATE),
    SIGSTOP("STOP", SignalType.DefaultAction.STOP, false),
    SIGTERM("TERM", SignalType.DefaultAction.TERMINATE),
    SIGTSTP("STP", SignalType.DefaultAction.STOP),
    SIGTTIN("TTIN", SignalType.DefaultAction.STOP),
    SIGTTOU("TTOU", SignalType.DefaultAction.STOP),
    SIGUSR1("USR1", SignalType.DefaultAction.TERMINATE),
    SIGUSR2("USR2", SignalType.DefaultAction.TERMINATE),
    SIGPOLL("POLL", SignalType.DefaultAction.TERMINATE),
    SIGPROF("PROF", SignalType.DefaultAction.TERMINATE),
    SIGSYS("SYS", SignalType.DefaultAction.ACTION_TERMINATE),
    SIGTRAP("TRAP", SignalType.DefaultAction.ACTION_TERMINATE),
    SIGURG("URG", SignalType.DefaultAction.IGNORE),
    SIGVTALRM("VTALRM", SignalType.DefaultAction.TERMINATE),
    SIGXCPU("XCPU", SignalType.DefaultAction.ACTION_TERMINATE),
    SIGXFSZ("XFSZ", SignalType.DefaultAction.ACTION_TERMINATE);

    private final String signalName;
    private final SignalType.DefaultAction defaultAction;
    private final boolean catchable;

    private Signals(String signalName, SignalType.DefaultAction defaultAction) {
        this(signalName, defaultAction, true);
    }

    private Signals(String signalName, SignalType.DefaultAction defaultAction, boolean catchable) {
        this.signalName = signalName;
        this.defaultAction = defaultAction;
        this.catchable = catchable;
    }

    @Override
    public SignalType.DefaultAction getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public boolean isCatchable() {
        return this.catchable;
    }

    @Override
    public String getSignalName() {
        return this.signalName;
    }
}

