/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.MCColor;
import org.bukkit.Color;

public final class BukkitMCColor
implements MCColor {
    private static final BukkitMCColor BUILDER = new BukkitMCColor();
    private int red;
    private int green;
    private int blue;

    public static MCColor GetMCColor(Color c) {
        return BUILDER.build(c.getRed(), c.getGreen(), c.getBlue());
    }

    public static Color GetColor(MCColor c) {
        return Color.fromRGB((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue());
    }

    private BukkitMCColor() {
    }

    @Override
    public int getRed() {
        return this.red;
    }

    @Override
    public int getGreen() {
        return this.green;
    }

    @Override
    public int getBlue() {
        return this.blue;
    }

    @Override
    public MCColor build(int red, int green, int blue) {
        BukkitMCColor color2 = new BukkitMCColor();
        color2.red = red;
        color2.green = green;
        color2.blue = blue;
        return color2;
    }

    public int hashCode() {
        int hash2 = 5;
        hash2 = 11 * hash2 + this.red;
        hash2 = 11 * hash2 + this.green;
        hash2 = 11 * hash2 + this.blue;
        return hash2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BukkitMCColor other = (BukkitMCColor)obj;
        if (this.red != other.red) {
            return false;
        }
        if (this.green != other.green) {
            return false;
        }
        return this.blue == other.blue;
    }
}

