/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.ArgumentParser;
import com.laytonsmith.PureUtilities.ArgumentSuite;
import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscoveryCache;
import com.laytonsmith.PureUtilities.CommandExecutor;
import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.FileWriteMode;
import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.PureUtilities.Common.RSAEncrypt;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Common.UIUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.PureUtilities.JavaVersion;
import com.laytonsmith.PureUtilities.MapBuilder;
import com.laytonsmith.PureUtilities.TermColors;
import com.laytonsmith.PureUtilities.Web.WebUtility;
import com.laytonsmith.PureUtilities.XMLDocument;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.AbstractCommandLineTool;
import com.laytonsmith.core.CommandLineTool;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.Security;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.Updater;
import com.laytonsmith.core.apps.AppsApiUtil;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.OptimizationUtilities;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.environments.RuntimeMode;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.extensions.Extension;
import com.laytonsmith.core.extensions.ExtensionManager;
import com.laytonsmith.core.extensions.ExtensionTracker;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.core.functions.Meta;
import com.laytonsmith.core.functions.Scheduling;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.telemetry.DefaultTelemetry;
import com.laytonsmith.core.telemetry.Telemetry;
import com.laytonsmith.core.tool;
import com.laytonsmith.libs.jline.console.ConsoleReader;
import com.laytonsmith.libs.org.json.simple.JSONValue;
import com.laytonsmith.persistence.PersistenceNetwork;
import com.laytonsmith.persistence.PersistenceNetworkImpl;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import com.laytonsmith.tools.ExampleLocalPackageInstaller;
import com.laytonsmith.tools.Interpreter;
import com.laytonsmith.tools.MSLPMaker;
import com.laytonsmith.tools.Manager;
import com.laytonsmith.tools.ProfilerSummary;
import com.laytonsmith.tools.SyntaxHighlighters;
import com.laytonsmith.tools.UILauncher;
import com.laytonsmith.tools.docgen.DocGen;
import com.laytonsmith.tools.docgen.DocGenExportTool;
import com.laytonsmith.tools.docgen.DocGenTemplates;
import com.laytonsmith.tools.docgen.ExtensionDocGen;
import com.laytonsmith.tools.docgen.sitedeploy.APIBuilder;
import com.laytonsmith.tools.docgen.sitedeploy.SiteDeploy;
import com.laytonsmith.tools.pnviewer.PNViewer;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.fusesource.jansi.AnsiConsole;

public class Main {
    private static final boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
    private static final Class[] FAST_STARTUP = new Class[]{CopyrightMode.class, InstallCmdlineMode.class, NewMode.class, NewTypeMode.class, JavaVersionMode.class, EditPrefsMode.class, InstallMSSQLAuthMode.class, Updater.CheckUpdate.class, CmdlineArgsTool.class};

    public static CmdlineToolCollection GetCommandLineTools() {
        ArgumentSuite suite = new ArgumentSuite().addDescription("These are the command line tools for MethodScript. For more information about a particular mode, run the help mode with the mode you need help in as the argument. To run a command, in general, use the command:\n\n\tjava -jar " + MethodScriptFileLocations.getDefault().getJarFile().getName() + " <mode name> <[mode specific arguments]>\nor\n\tmscript -- <mode name> <[mode specific arguments]>\nif you have previously installed the command line version.");
        HashMap<ArgumentParser, CommandLineTool> dynamicTools = new HashMap<ArgumentParser, CommandLineTool>();
        for (Class<CommandLineTool> ctool : ClassDiscovery.getDefaultInstance().loadClassesWithAnnotationThatExtend(tool.class, CommandLineTool.class)) {
            try {
                CommandLineTool tool2 = ctool.newInstance();
                ArgumentParser ap = tool2.getArgumentParser();
                String toolName = ctool.getAnnotation(tool.class).value();
                suite.addMode(toolName, ap, ctool.getAnnotation(tool.class).undocumented());
                String[] aliases = ctool.getAnnotation(tool.class).aliases();
                if (aliases != null) {
                    for (String alias : aliases) {
                        suite.addModeAlias(alias, toolName);
                    }
                }
                dynamicTools.put(ap, tool2);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, "Could not load " + ctool.getName(), ex);
            }
        }
        return new CmdlineToolCollection(suite, dynamicTools);
    }

    private static void HandleModeStartupTelemetry(String mode2, boolean full) {
        block6: {
            try {
                File cache = new File(MethodScriptFileLocations.getDefault().getCacheDirectory(), "telemetry.cache");
                if (!full) {
                    FileUtil.write(mode2 + "\n", cache, FileWriteMode.APPEND, true);
                } else {
                    Telemetry.GetDefault().initializeTelemetry();
                    if (cache.exists()) {
                        String[] previousStarts;
                        for (String s : previousStarts = FileUtil.read(cache).split("\n")) {
                            if (s.trim().equals("")) continue;
                            Telemetry.GetDefault().log(DefaultTelemetry.StartupModeMetric.class, MapBuilder.start("mode", s), null);
                        }
                        cache.delete();
                        cache.deleteOnExit();
                    }
                    Telemetry.GetDefault().log(DefaultTelemetry.StartupModeMetric.class, MapBuilder.start("mode", mode2), null);
                }
            }
            catch (Throwable ex) {
                if (!IS_DEBUG) break block6;
                ex.printStackTrace(StreamUtils.GetSystemErr());
            }
        }
    }

    public static void main(String[] args2) throws Exception {
        ArgumentParser.ArgumentParserResults parsedArgs;
        ArgumentParser mode2;
        Implementation.setServerType(Implementation.Type.SHELL);
        AppsApiUtil.ConfigureDefaults();
        if (args2.length > 0) {
            for (Class c : FAST_STARTUP) {
                ArgumentParser.ArgumentParserResults res;
                String tool2 = c.getAnnotation(tool.class).value();
                if (!args2[0].equals(tool2)) continue;
                String[] a = args2.length > 1 ? ArrayUtils.slice(args2, 1, args2.length - 1) : new String[]{};
                Main.HandleModeStartupTelemetry(tool2, false);
                CommandLineTool t = (CommandLineTool)c.newInstance();
                try {
                    res = t.getArgumentParser().match(a);
                }
                catch (ArgumentParser.ResultUseException | ArgumentParser.ValidationException e) {
                    break;
                }
                t.execute(res);
                return;
            }
        }
        ClassDiscovery cd2 = ClassDiscovery.getDefaultInstance();
        cd2.addThisJar();
        MethodScriptFileLocations.setDefault(new MethodScriptFileLocations());
        ClassDiscoveryCache cdcCache = new ClassDiscoveryCache(MethodScriptFileLocations.getDefault().getCacheDirectory());
        cd2.setClassDiscoveryCache(cdcCache);
        MSLog.initialize(MethodScriptFileLocations.getDefault().getJarDirectory());
        Prefs.init(MethodScriptFileLocations.getDefault().getPreferencesFile());
        Prefs.SetColors();
        if (Prefs.UseColors().booleanValue()) {
            AnsiConsole.systemInstall();
        }
        cd2.addAllJarsInFolder(MethodScriptFileLocations.getDefault().getExtensionsDirectory());
        ExtensionManager.AddDiscoveryLocation(MethodScriptFileLocations.getDefault().getExtensionsDirectory());
        ExtensionManager.Cache(MethodScriptFileLocations.getDefault().getExtensionCacheDirectory(), new Class[0]);
        ExtensionManager.Initialize(ClassDiscovery.getDefaultInstance());
        if (args2.length == 0) {
            args2 = new String[]{"help"};
        }
        CmdlineToolCollection collection = Main.GetCommandLineTools();
        ArgumentSuite suite = collection.getSuite();
        String helpModeName = HelpMode.class.getAnnotation(tool.class).value();
        boolean wasError = false;
        try {
            ArgumentSuite.ArgumentSuiteResults results = suite.match(args2, helpModeName);
            mode2 = results.getMode();
            parsedArgs = results.getResults();
        }
        catch (ArgumentParser.ResultUseException | ArgumentParser.ValidationException e) {
            System.out.println(TermColors.RED + e.getMessage() + "\nSee usage.\n" + TermColors.RESET);
            String[] newArgs = new String[]{"help", args2[0]};
            ArgumentSuite.ArgumentSuiteResults results = suite.match(newArgs, helpModeName);
            mode2 = results.getMode();
            parsedArgs = results.getResults();
            wasError = true;
        }
        catch (ArgumentSuite.ModeNotFoundException e) {
            StreamUtils.GetSystemOut().println(TermColors.RED + e.getMessage() + TermColors.RESET);
            mode2 = suite.getMode(helpModeName);
            parsedArgs = null;
            wasError = true;
        }
        if (collection.getDynamicTools().containsKey(mode2)) {
            CommandLineTool tool3 = collection.getDynamicTools().get(mode2);
            tool3.setSuite(suite);
            if (tool3.startupExtensionManager()) {
                ExtensionManager.Startup();
            }
            Main.HandleModeStartupTelemetry(args2[0], true);
            tool3.execute(parsedArgs);
            if (wasError) {
                System.exit(1);
            }
            if (!tool3.noExitOnReturn()) {
                System.exit(0);
            }
        } else {
            throw new Error("Should not have gotten here");
        }
    }

    public static ArgumentParser.ArgumentBuilder.ArgumentBuilderFinal GetEnvironmentParameter() {
        ClassDiscovery cd2 = ClassDiscovery.getDefaultInstance();
        cd2.addDiscoveryLocation(ClassDiscovery.GetClassContainer(Main.class));
        String envs = StringUtils.Join(cd2.getClassesThatExtend(Environment.EnvironmentImpl.class).stream().map(c -> c.getClassName()).collect(Collectors.toSet()), ", ", ", or ");
        return new ArgumentParser.ArgumentBuilder().setDescription("The environments to target during compilation. May be one or more of " + envs + ", but note that " + GlobalEnv.class.getName() + " and " + CompilerEnvironment.class.getName() + " are provided for you.").setUsageName("environments").setOptional().setName("environments").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.ARRAY_OF_STRINGS);
    }

    public static Set<Class<? extends Environment.EnvironmentImpl>> GetEnvironmentValue(ArgumentParser.ArgumentParserResults parsedArgs) {
        List<String> environments = parsedArgs.getStringListArgument("environments", new ArrayList<String>());
        HashSet<Class<? extends Environment.EnvironmentImpl>> envs = new HashSet<Class<? extends Environment.EnvironmentImpl>>();
        envs.add(GlobalEnv.class);
        envs.add(CompilerEnvironment.class);
        for (String e : environments) {
            try {
                Class<?> c = ClassDiscovery.getDefaultInstance().forName(e).loadClass();
                if (!Environment.EnvironmentImpl.class.isAssignableFrom(c)) {
                    System.out.println("The class " + e + " is not a valid option!");
                    System.exit(1);
                }
                envs.add(c);
            }
            catch (ClassNotFoundException ex) {
                System.out.println("The class " + e + " could not be found!");
                System.exit(1);
            }
        }
        return envs;
    }

    public static String GetDirectoryTextEditor() {
        String cmd = OSUtils.GetOS().isWindows() ? "code.cmd" : "vim";
        if (OSUtils.GetOS().isUnixLike()) {
            if (System.getenv("EDITOR") != null) {
                cmd = System.getenv("EDITOR");
            }
            if (System.getenv("VISUAL") != null) {
                cmd = System.getenv("VISUAL");
            }
        }
        if (System.getenv("MS_EDITOR") != null && !System.getenv("MS_EDITOR").equals("")) {
            cmd = System.getenv("MS_EDITOR");
        }
        return cmd;
    }

    public static class CmdlineToolCollection {
        private final ArgumentSuite suite;
        private final Map<ArgumentParser, CommandLineTool> dynamicTools;

        public CmdlineToolCollection(ArgumentSuite suite, Map<ArgumentParser, CommandLineTool> dynamicTools) {
            this.suite = suite;
            this.dynamicTools = dynamicTools;
        }

        public ArgumentSuite getSuite() {
            return this.suite;
        }

        public Map<ArgumentParser, CommandLineTool> getDynamicTools() {
            return this.dynamicTools;
        }
    }

    @tool(value="help", aliases={"/?", "--help", "-help", "-h"})
    public static class HelpMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Displays help for all modes, or the given mode if one is provided.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Displays help for the given mode.").setUsageName("mode name").setOptionalAndDefault().setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).setErrorOnUnknownArgs(false);
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            String modeForHelp = null;
            if (parsedArgs != null) {
                modeForHelp = parsedArgs.getStringArgument();
            }
            if ((modeForHelp = this.getSuite().getModeFromAlias(modeForHelp)) == null) {
                ArgumentSuite suite = this.getSuite();
                StreamUtils.GetSystemOut().println(suite.getBuiltDescription());
                System.exit(0);
            } else {
                StreamUtils.GetSystemOut().println(this.getSuite().getMode(modeForHelp).getBuiltDescription());
            }
        }

        @Override
        public boolean startupExtensionManager() {
            return false;
        }
    }

    @tool(value="copyright")
    public static class CopyrightMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Prints the copyright and exits.");
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            String buildYear = new Scheduling.simple_date().exec(Target.UNKNOWN, null, new CString("yyyy", Target.UNKNOWN), new Meta.engine_build_date().exec(Target.UNKNOWN, null, new Mixed[0])).val();
            StreamUtils.GetSystemOut().println("The MIT License (MIT)\n\nCopyright (c) 2012-" + buildYear + " Methodscript Contributors\n\nPermission is hereby granted, free of charge, to any person obtaining a copy of \nthis software and associated documentation files (the \"Software\"), to deal in \nthe Software without restriction, including without limitation the rights to \nuse, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of \nthe Software, and to permit persons to whom the Software is furnished to do so, \nsubject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all \ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR \nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS \nFOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR \nCOPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER \nIN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN \nCONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.");
            System.exit(0);
        }
    }

    @tool(value="install-cmdline")
    public static class InstallCmdlineMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Installs MethodScript to your system, so that commandline scripts work. (Currently only unix is supported.)").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Sets the name of the command. This allows support for multiple installations per system.").setUsageName("command name").setOptional().setName("command").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal("mscript"));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            Prefs.init(MethodScriptFileLocations.getDefault().getPreferencesFile());
            Telemetry.GetDefault().doNag();
            String commandName = parsedArgs.getStringArgument("command");
            Interpreter.install(commandName);
            System.exit(0);
        }
    }

    @tool(value="new")
    public static class NewMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Creates a blank, executable script in the specified location with the appropriate permissions, having the correct hashbang, and ready to be executed. If the specified file already exists, it will refuse to create it, unless --force is set.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Location and name to create the script as. Multiple arguments can be provided, and they will create multiple files.").setUsageName("file").setRequiredAndDefault()).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Forces the file to be overwritten, even if it already exists.").asFlag().setName('f', "force"));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws IOException {
            NewMode.CreateNewFiles(parsedArgs.getStringListArgument(), parsedArgs.isFlagSet(Character.valueOf('f')));
        }

        public static void CreateNewFiles(List<String> files, boolean force) throws IOException {
            String li = OSUtils.GetLineEnding();
            for (String file : files) {
                File f = new File(file);
                if (f.exists() && !force) {
                    System.out.println(file + " already exists, refusing to create");
                    continue;
                }
                f.createNewFile();
                f.setExecutable(true);
                FileUtil.write("#!/usr/bin/env /usr/local/bin/mscript" + li + "<!" + li + "\tstrict;" + li + "\tname: " + f.getName() + ";" + li + "\tauthor: " + System.getProperty("user.name") + ";" + li + "\tcreated: " + new Scheduling.simple_date().exec(Target.UNKNOWN, null, new CString("yyyy-MM-dd", Target.UNKNOWN)).val() + ";" + li + "\tdescription: ;" + li + ">" + li + li, f, true);
            }
        }
    }

    @tool(value="new-type")
    public static class NewTypeMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Creates a new type. This command should only be run at the root of a classLibrary, and given the class name, will create the appropriate folder structure (as necessary) as well as providing a default file prepopulated with a reasonable template. If the file already exists, will refuse to continue.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The template type to use").setUsageName("template").setOptional().setName('t', "type").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal("class")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The class name to create. This should be the fully qualified class name.").setUsageName("fully qualified class name").setRequiredAndDefault().setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            String clazz = parsedArgs.getStringArgument();
            String template = parsedArgs.getStringArgument(Character.valueOf('t')).toLowerCase();
            List<String> validTemplates = Arrays.asList("annotation", "class", "enum", "interface");
            if (!validTemplates.contains(template)) {
                System.err.println("Invalid template type specified. Valid template types are: " + validTemplates.toString());
            }
            String[] split2 = clazz.split("\\.", -1);
            String classSimpleName = split2[split2.length - 1];
            String author = System.getProperty("user.name");
            String created = new Scheduling.simple_date().exec(Target.UNKNOWN, null, new CString("yyyy-MM-dd", Target.UNKNOWN)).val();
            File file = new File(clazz.replace(".", "/") + ".ms");
            if (file.exists()) {
                System.err.println("File " + file + " already exists. Refusing to continue.");
                System.exit(1);
            }
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            String allTemplate = split2[0].equals("ms") ? StreamUtils.GetResource("/templates/new-type-templates/native-all.ms") : StreamUtils.GetResource("/templates/new-type-templates/all.ms");
            String typeTemplate = StreamUtils.GetResource("/templates/new-type-templates/" + template + ".ms");
            allTemplate = String.format(allTemplate, classSimpleName, author, created, clazz);
            typeTemplate = String.format(typeTemplate, clazz);
            FileUtil.write(allTemplate + typeTemplate, file);
        }
    }

    @tool(value="java-version")
    public static class JavaVersionMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Prints the current major java version then exits.");
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            System.out.println(JavaVersion.GetMajorVersion());
            System.exit(0);
        }

        @Override
        public boolean startupExtensionManager() {
            return false;
        }
    }

    @tool(value="edit-prefs")
    public static class EditPrefsMode
    extends AbstractCommandLineTool {
        private static final String[] NEEDS_WAIT = new String[]{"vim", "nano", "emacs"};

        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Launches the prefs directory in a default text editor, or your defined editor.").addExtendedDescription("By default, on Windows, \"code.cmd\" (Visual Studio Code) is the default editor. On Linux systems, vim is default, though if $EDITOR is set, that is used, or if $VISUAL is also set, that is used instead. In all OSes, you can override the default editor with the MS_EDITOR environment variable. The prefs folder is passed as the last argument to the command. Passing in the editor to the command will bypass all these mechanisms, and use the specified editor in that one launch.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Waits for the editor to finish. This is implied for some known programs, where that is necessary (" + StringUtils.Join(NEEDS_WAIT, ", ", ", and ", " and ") + ") but may be specified manually. This is generally not necessary for GUI editors that open in a new window.").asFlag().setName("wait")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Uses a different command to open the editor. This overrides the environment value (if set).").setUsageName("command").setOptionalAndDefault().setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal(""));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            Implementation.forceServerType(Implementation.Type.SHELL);
            if (!MethodScriptFileLocations.getDefault().getPreferencesDirectory().exists()) {
                System.err.println("Prefs directory does not exist!");
                System.exit(1);
            }
            boolean wait = false;
            Object cmd = Main.GetDirectoryTextEditor() + " %s";
            if (!parsedArgs.getStringArgument().equals("")) {
                cmd = parsedArgs.getStringArgument();
            }
            for (String nw : NEEDS_WAIT) {
                if (!((String)cmd).startsWith(nw + " ")) continue;
                wait = true;
                break;
            }
            CommandExecutor c = new CommandExecutor(String.format((String)cmd, "\"" + MethodScriptFileLocations.getDefault().getPreferencesDirectory()) + "\"");
            c.setSystemInputsAndOutputs();
            try {
                c.start();
            }
            catch (IOException ex) {
                System.err.println("Could not launch editor: " + ex.getMessage());
            }
            if (parsedArgs.isFlagSet("wait") || wait) {
                c.waitFor();
            }
            System.exit(0);
        }
    }

    @tool(value="install-mssql-auth")
    public static class InstallMSSQLAuthMode
    extends AbstractCommandLineTool {
        @Override
        public boolean startupExtensionManager() {
            return false;
        }

        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Downloads the correct MSSQL JDBC Auth dll and places it in the C:\\Program Files\\MethodScript folder. It is required that MethodScript be generally installed first. This command is only useable on Windows.");
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            if (OSUtils.GetOS() != OSUtils.OS.WINDOWS) {
                System.err.println("Can only run this command on Windows.");
                System.exit(1);
            }
            if (!MethodScriptFileLocations.getDefault().getWindowsNativeDirectory().exists()) {
                System.err.println("MethodScript must be installed using install-cmdline before running this command.");
                System.exit(1);
            }
            try {
                switch (JavaVersion.GetJVMBitDepth()) {
                    case 32: {
                        this.doDownload(32);
                        return;
                    }
                    case 64: {
                        this.doDownload(64);
                        return;
                    }
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            System.err.println("Could not determine JVM bit depth. Please manually download the MSSQL JDBC Auth dll, and place it on your system path.");
            System.exit(1);
        }

        private void doDownload(int bitdepth) throws IOException {
            String url;
            String fname = switch (bitdepth) {
                case 32 -> {
                    url = "https://repo1.maven.org/maven2/com/microsoft/sqlserver/mssql-jdbc_auth/8.2.2.x86/mssql-jdbc_auth-8.2.2.x86.dll";
                    yield "mssql-jdbc_auth-8.2.2.x86.dll";
                }
                case 64 -> {
                    url = "https://repo1.maven.org/maven2/com/microsoft/sqlserver/mssql-jdbc_auth/8.2.2.x64/mssql-jdbc_auth-8.2.2.x64.dll";
                    yield "mssql-jdbc_auth-8.2.2.x64.dll";
                }
                default -> throw new Error();
            };
            byte[] dll = WebUtility.GetPageContentsBinary(url);
            File to = new File(new File("C:\\Program Files\\MethodScript").getAbsoluteFile(), fname).getAbsoluteFile();
            try {
                FileUtil.write(dll, to, FileWriteMode.OVERWRITE, false);
            }
            catch (FileNotFoundException ex) {
                System.err.println("Could not write file to " + to.getAbsolutePath() + ". Did you run this as Administrator?");
                System.exit(1);
            }
            System.out.println(url + " downloaded to " + to);
            System.exit(0);
        }
    }

    @tool(value="cmdline-args")
    public static class CmdlineArgsTool
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription(Implementation.GetServerType().getBranding() + " requires certain arguments to be passed to the java program to properly start up. This tool prints out the arguments that it needs, in a version specific manner. Depending on your system, and the version of the program, you may get different arguments, but these will always be up to date. You can either integrate them into your startup flow manually, or dynamically call this command to automatically update it. The command may return an empty string. If so, this means that no commandline flags are needed.");
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            Object args2 = "";
            if (JavaVersion.GetMajorVersion() > 8) {
                String modules = Static.GetStringResource("/interpreter-helpers/modules");
                modules = modules.replaceAll("(.*)\n", "--add-opens $1=ALL-UNNAMED ");
                args2 = (String)args2 + " " + modules;
            }
            args2 = (String)args2 + "-Xrs ";
            StreamUtils.GetSystemOut().println(((String)args2).trim());
        }
    }

    @tool(value="cycle", undocumented=true)
    public static class CycleMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Fully starts up the interpreter engine, and runs exit(0), which represents the engine overhead. Meant for performance testing of the engine itself. Note that the first run will install various things, which should not be compared against second startup. In general, you can time this command, with, for instance `time` on linux.");
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            Environment env = Static.GenerateStandaloneEnvironment(true);
            try {
                MethodScriptCompiler.execute("exit(0);", null, true, env, Environment.getDefaultEnvClasses(), output -> {}, null, null);
            }
            catch (CancelCommandException cancelCommandException) {
                // empty catch block
            }
        }
    }

    @tool(value="help-topic")
    public static class HelpTopicMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Provides information on a general topic. To see the list of topics, run with no arguments.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The topic to read more about.").setUsageName("topic name").setOptionalAndDefault().setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            Prefs.init(MethodScriptFileLocations.getDefault().getPreferencesFile());
            Telemetry.GetDefault().doNag();
            HashMap<String, String> topics = new HashMap<String, String>();
            for (ExtensionTracker t : ExtensionManager.getTrackers().values()) {
                for (Extension e : t.getExtensions()) {
                    Map<String, String> extTopics = e.getHelpTopics();
                    if (extTopics == null) continue;
                    topics.putAll(extTopics);
                }
            }
            String arg = parsedArgs.getStringArgument();
            if ("".equals(arg)) {
                TreeSet st = new TreeSet(topics.keySet());
                System.out.println(StringUtils.Join(st, ", "));
            } else if (topics.containsKey(arg)) {
                String output = (String)topics.get(arg);
                output = DocGenTemplates.DoTemplateReplacement(output, DocGenTemplates.GetGenerators());
                output = Interpreter.reverseHTML(output);
                System.out.println(output);
            } else {
                System.out.println(TermColors.RED + "Could not find that help topic." + TermColors.RESET);
            }
        }
    }

    @tool(value="build-extension")
    public static class ExtensionBuilderMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Given a path to the git source repo, pulls down the code, builds the extension with maven, and places the artifact in the extension folder. Git, Maven, and the JDK must all be pre-installed on your system for this to work, but once those are configued and working so you can run git and mvn from the cmdline, the rest of the build system should work.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The path to the git repo (ending in .git usually). May be either http or ssh, this parameter is just passed through to git.").setUsageName("git repo path").setRequired().setName('s', "source").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The branch to check out. Defaults to \"master\".").setUsageName("branch").setOptional().setName('b', "branch").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal("master")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The extension directory you want to install the built artifact to, by default, this installation's extension directory.").setUsageName("dir").setOptional().setName('e', "extension-dir").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal(MethodScriptFileLocations.getDefault().getExtensionsDirectory().getAbsolutePath())).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("If the checkout folder already exists, it is first deleted, then cloned again.").asFlag().setName('f', "force"));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            String mvnCommand = "mvn";
            try {
                new CommandExecutor("git --version").start().waitFor();
                try {
                    new CommandExecutor("mvn --version").start().waitFor();
                }
                catch (IOException e) {
                    new CommandExecutor("mvn.cmd --version").start().waitFor();
                    mvnCommand = "mvn.cmd";
                }
            }
            catch (IOException e) {
                System.err.println("Git and Maven are required (and Maven requires the JDK). These three components must be already installed to use this tool.");
                System.exit(1);
            }
            String branch = parsedArgs.getStringArgument("branch");
            String source2 = parsedArgs.getStringArgument("source");
            boolean force = parsedArgs.isFlagSet("force");
            File extensionDir = new File(parsedArgs.getStringArgument("extension-dir"));
            File checkoutPath = new File(MethodScriptFileLocations.getDefault().getTempDir(), source2.replaceAll("^.*/(.*?)(?:.git)*?$", "$1"));
            System.out.println("Cloning " + source2);
            System.out.println("Using branch " + branch);
            System.out.println("Checkout path is " + checkoutPath);
            System.out.println("Deploying to " + extensionDir);
            System.out.println("------------------------------------------------");
            if (!extensionDir.exists()) {
                if (force) {
                    extensionDir.mkdirs();
                } else {
                    System.err.println("Extension directory does not exist, refusing to continue. If " + extensionDir.getAbsolutePath() + " is the correct directory, manually create it and try again, or use --force.");
                    System.exit(1);
                }
            }
            try {
                if (checkoutPath.exists()) {
                    if (!force) {
                        System.err.println("Checkout path already exists (" + checkoutPath.getAbsolutePath() + "), refusing to continue.");
                        System.exit(1);
                    } else {
                        System.out.println("Deleting " + checkoutPath + " directory...");
                        if (!FileUtil.recursiveDelete(checkoutPath)) {
                            System.err.println("Could not fully delete checkout path, refusing to continue. Please manually delete " + checkoutPath + ", and try again.");
                            System.exit(1);
                        }
                    }
                }
                new CommandExecutor("git", "clone", "--single-branch", "--branch", branch, "--depth=1", source2, checkoutPath.getAbsolutePath()).setSystemInputsAndOutputs().start().waitFor();
                System.out.println("Building extension...");
                int mvnBuild = new CommandExecutor(mvnCommand, "package", "-DskipTests").setSystemInputsAndOutputs().setWorkingDir(checkoutPath).start().waitFor();
                if (mvnBuild != 0) {
                    System.err.println("Something went wrong in the maven build, unable to continue. Please correct the listed error, and then try again.");
                    System.err.flush();
                    System.exit(1);
                }
                System.out.println("Extension built, moving artifact to extension directory...");
                XMLDocument pom = new XMLDocument(new FileInputStream(new File(checkoutPath, "pom.xml")));
                String artifactId = pom.getNode("/project/artifactId");
                String version = pom.getNode("/project/version");
                String artifactName = artifactId + "-" + version + ".jar";
                System.out.println("Identified " + artifactName + " as the artifact to use");
                FileUtil.copy(new File(checkoutPath, "target/" + artifactName), new File(extensionDir, artifactName), null);
                System.out.println("Build complete, cleaning up...");
                if (!FileUtil.recursiveDelete(checkoutPath)) {
                    System.err.println("Could not delete " + checkoutPath + ", but build completed successfully.");
                    System.exit(1);
                }
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    @tool(value="ui")
    public static class UIMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Launches a GUI that provides a list of all the sub GUI tools provided, and allows selection of a module. This command creates a subshell to run the launcher in, so that the original cmdline shell returns.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Runs the launcher in the same shell process. By default, it creates a new process and causes the initial shell to return.").asFlag().setName("in-shell"));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            if (parsedArgs.isFlagSet("in-shell")) {
                UILauncher.main(parsedArgs.getRawArguments().toArray(new String[0]));
            } else {
                ArrayList<String> largs = new ArrayList<String>();
                largs.add("java");
                largs.add("-jar");
                String jarPath = ClassDiscovery.GetClassContainer(Main.class).getPath();
                if (OSUtils.GetOS().isWindows() && jarPath.startsWith("/")) {
                    jarPath = jarPath.substring(1);
                }
                largs.add(jarPath);
                largs.addAll(parsedArgs.getRawArguments());
                largs.add("--in-shell");
                CommandExecutor ce = new CommandExecutor(largs.toArray(new String[largs.size()]));
                ce.start();
                System.exit(0);
            }
        }
    }

    @tool(value="core-functions")
    public static class CoreFunctionsMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Prints a list of functions tagged with the @core annotation, then exits.");
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            TreeSet<String> core2 = new TreeSet<String>();
            for (api.Platforms platform : api.Platforms.values()) {
                for (FunctionBase f : FunctionList.getFunctionList(platform, null)) {
                    if (!f.isCore()) continue;
                    core2.add(f.getName());
                }
            }
            StreamUtils.GetSystemOut().println(StringUtils.Join(core2, ", "));
            System.exit(0);
        }
    }

    @tool(value="pn-viewer")
    public static class PNViewerMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Launches the Persistence Network viewer. This is a GUI tool that can help you visualize your databases.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Sets up a server running on this machine, that can be accessed by remote Persistence Network Viewers. If this is set, you must also provide the --port and --password options.").asFlag().setName("server")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The port for the server to listen on.").setUsageName("port").setOptional().setName("port").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.NUMBER)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The password that remote clients will need to provide to connect. Leave the field blank to be prompted for a password.").setUsageName("password").setOptional().setName("password").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            Implementation.forceServerType(Implementation.Type.SHELL);
            ClassDiscovery.getDefaultInstance().addDiscoveryLocation(ClassDiscovery.GetClassContainer(Main.class));
            if (parsedArgs.isFlagSet("server")) {
                String password;
                int port;
                if (parsedArgs.getNumberArgument("port") == null) {
                    StreamUtils.GetSystemErr().println("When running as a server, port is required.");
                    System.exit(1);
                }
                if ((port = parsedArgs.getNumberArgument("port").intValue()) > 65535 || port < 1) {
                    StreamUtils.GetSystemErr().println("Port must be between 1 and 65535.");
                    System.exit(1);
                }
                if ("".equals(password = parsedArgs.getStringArgument("password"))) {
                    try (ConsoleReader reader = new ConsoleReader();){
                        reader.setExpandEvents(false);
                        Character cha = Character.valueOf('\u0000');
                        password = reader.readLine("Enter password: ", cha);
                    }
                }
                if (password == null) {
                    StreamUtils.GetSystemErr().println("Warning! Running server with no password, anyone will be able to connect!");
                    password = "";
                }
                try {
                    PNViewer.startServer(port, password);
                }
                catch (IOException ex) {
                    StreamUtils.GetSystemErr().println(ex.getMessage());
                    System.exit(1);
                }
            } else {
                try {
                    PNViewer.main(parsedArgs.getStringListArgument().toArray(ArrayUtils.EMPTY_STRING_ARRAY));
                }
                catch (HeadlessException ex) {
                    StreamUtils.GetSystemErr().println("The Persistence Network Viewer may not be run from a headless environment.");
                    System.exit(1);
                }
            }
        }
    }

    @tool(value="key-gen")
    public static class RSAKeyGenMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Creates an ssh compatible rsa key pair. This is used with the Federation system, but is useful with other tools as well.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Output file for the keys. For instance, \"/home/user/.ssh/id_rsa\". The public key will have the same name, with \".pub\" appended.").setUsageName("file").setRequired().setName('o', "output-file").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Label for the public key. For instance, \"user@localhost\" or an email address.").setUsageName("label").setRequired().setName('l', "label").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            String outputFileString = parsedArgs.getStringArgument(Character.valueOf('o'));
            File privOutputFile = new File(outputFileString);
            File pubOutputFile = new File(outputFileString + ".pub");
            String label = parsedArgs.getStringArgument(Character.valueOf('l'));
            if (privOutputFile.exists() || pubOutputFile.exists()) {
                StreamUtils.GetSystemErr().println("Either the public key or private key file already exists. This utility will not overwrite any existing files.");
                System.exit(1);
            }
            RSAEncrypt enc = RSAEncrypt.generateKey(label);
            FileUtil.write(enc.getPrivateKey(), privOutputFile);
            FileUtil.write(enc.getPublicKey(), pubOutputFile);
            System.exit(0);
        }
    }

    @tool(value="profiler-summary")
    public static class ProfilerSummaryMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Analyzes the output file for a profiler session, and generates a summary report of the results.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("This value dictates how much of the lower end data is ignored. If the function took less time than this percentage of the total time, it is omitted from the results.").setUsageName("ignore-percentage").setOptional().setName('i', "ignore-percentage").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.NUMBER).setDefaultVal("0")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Path to the profiler file to use.").setUsageName("input-file").setRequiredAndDefault());
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            String input = parsedArgs.getStringArgument();
            if ("".equals(input)) {
                StreamUtils.GetSystemErr().println(TermColors.RED + "No input file specified! Run `help profiler-summary' for usage." + TermColors.RESET);
                System.exit(1);
            }
            double ignorePercentage = parsedArgs.getNumberArgument("ignore-percentage");
            ProfilerSummary summary = new ProfilerSummary(new FileInputStream(input));
            try {
                summary.setIgnorePercentage(ignorePercentage);
            }
            catch (IllegalArgumentException ex) {
                StreamUtils.GetSystemErr().println(TermColors.RED + ex.getMessage() + TermColors.RESET);
                System.exit(1);
            }
            StreamUtils.GetSystemOut().println(summary.getAnalysis());
            System.exit(0);
        }
    }

    @tool(value="extension-docs")
    public static class ExtensionDocsMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Generates markdown documentation for the specified extension utilizing its code, to be used most likely on the extensions github page.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The extension jar to generate documentation for.").setUsageName("path to jar file").setRequired().setName('i', "input-jar").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The file to output the generated documentation to. (Should probably end in .md, but is not required to.) This argument is optional, and if left off, the output will instead print to stdout.").setUsageName("output file name").setOptional().setName('o', "output-file").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            String inputJarS = parsedArgs.getStringArgument("input-jar");
            String outputFileS = parsedArgs.getStringArgument("output-file");
            File inputJar = new File(inputJarS);
            OutputStream outputFile = StreamUtils.GetSystemOut();
            if (outputFileS != null) {
                outputFile = new FileOutputStream(new File(outputFileS));
            }
            ExtensionDocGen.generate(inputJar, outputFile);
        }
    }

    @tool(value="cmdline")
    public static class CmdlineMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Given a source file, runs it in cmdline mode. This is the \"main\" way of executing source files.").setErrorOnUnknownArgs(false).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("File path/arguments").setUsageName("file and args").setRequiredAndDefault());
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            List<String> allArgs = parsedArgs.getRawArguments();
            if (allArgs.isEmpty()) {
                StreamUtils.GetSystemErr().println("Usage: path/to/file.ms [arg1 arg2]");
                System.exit(1);
            }
            String fileName = allArgs.get(0);
            allArgs.remove(0);
            try {
                Interpreter.startWithTTY(fileName, allArgs);
            }
            catch (Profiles.InvalidProfileException ex) {
                StreamUtils.GetSystemErr().println("Invalid profile file at " + MethodScriptFileLocations.getDefault().getProfilesFile() + ": " + ex.getMessage());
                System.exit(1);
            }
            StaticLayer.GetConvertor().runShutdownHooks();
            System.exit(0);
        }
    }

    @tool(value="examples")
    public static class ExamplesMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Installs one of the built in LocalPackage examples, which may in and of itself be useful, but is primarily meant to showcase various features.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The name of the package to install. Leave blank to see a list of examples to choose from.").setUsageName("packageName").setOptionalAndDefault());
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            ExampleLocalPackageInstaller.run(MethodScriptFileLocations.getDefault().getJarDirectory(), parsedArgs.getStringArgument());
        }
    }

    @tool(value="syntax")
    public static class SyntaxMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Generates the syntax highlighter for the specified editor (if available).").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The type of the syntax file to generate. Don't specify a type to see the available options.").setUsageName("type").setOptionalAndDefault().setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            List<String> syntax = parsedArgs.getStringListArgument();
            String type = syntax.size() >= 1 ? syntax.get(0) : null;
            String theme = syntax.size() >= 2 ? syntax.get(1) : null;
            Implementation.forceServerType(Implementation.Type.BUKKIT);
            StreamUtils.GetSystemOut().println(SyntaxHighlighters.generate(type, theme));
            System.exit(0);
        }
    }

    @tool(value="docs")
    public static class DocsMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Prints documentation for the functions that CommandHelper knows about, then exits.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The type of the documentation, defaulting to html. It may be one of the following: " + StringUtils.Join(DocGen.MarkupType.values(), ", ", ", or ")).setUsageName("type").setOptionalAndDefault().setDefaultVal("html"));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            DocGen.MarkupType docs;
            try {
                docs = DocGen.MarkupType.valueOf(parsedArgs.getStringArgument().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                StreamUtils.GetSystemOut().println("The type of documentation must be one of the following: " + StringUtils.Join(DocGen.MarkupType.values(), ", ", ", or "));
                System.exit(1);
                return;
            }
            StreamUtils.GetSystemErr().print("Creating " + docs + " documentation...");
            StreamUtils.GetSystemOut().println(DocGen.functions(docs, api.Platforms.INTERPRETER_JAVA, true));
            StreamUtils.GetSystemErr().println("Done.");
            System.exit(0);
        }
    }

    @tool(value="print-db")
    public static class PrintDBMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Prints out the built in database in a human readable form, then exits.");
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            ConnectionMixinFactory.ConnectionMixinOptions options = new ConnectionMixinFactory.ConnectionMixinOptions();
            options.setWorkingDirectory(MethodScriptFileLocations.getDefault().getConfigDirectory());
            PersistenceNetworkImpl pn = new PersistenceNetworkImpl(MethodScriptFileLocations.getDefault().getPersistenceConfig(), new URI("sqlite://" + MethodScriptFileLocations.getDefault().getDefaultPersistenceDBFile().getCanonicalPath().replace('\\', '/')), options);
            Map<String[], String> values2 = pn.getNamespace(new String[0]);
            for (String[] s : values2.keySet()) {
                StreamUtils.GetSystemOut().println(StringUtils.Join(s, ".") + "=" + values2.get(s));
            }
            System.exit(0);
        }
    }

    @tool(value="eval")
    public static class EvalMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Runs the given MethodScript code, then exits.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The code to run").setUsageName("methodscript code").setRequiredAndDefault());
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            ClassDiscovery.getDefaultInstance().addThisJar();
            String script = parsedArgs.getStringArgument();
            File file = new File("Interpreter");
            Environment env = Static.GenerateStandaloneEnvironment(true, EnumSet.of(RuntimeMode.CMDLINE, RuntimeMode.INTERPRETER));
            Set<Class<? extends Environment.EnvironmentImpl>> envs = Environment.getDefaultEnvClasses();
            MethodScriptCompiler.execute(script, file, true, env, envs, s -> System.out.println(s), null, null);
        }
    }

    @tool(value="optimizer-test")
    public static class OptimizerTestMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Given a source file, reads it in and outputs the \"optimized\" version. This is meant as a debug tool, but could be used as an obfuscation tool as well. The target environment(s) must be specified if not targetting command line.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("File path").setUsageName("file").setRequiredAndDefault()).addArgument(Main.GetEnvironmentParameter());
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            String optimized;
            String path = parsedArgs.getStringArgument();
            Set<Class<? extends Environment.EnvironmentImpl>> envs = Main.GetEnvironmentValue(parsedArgs);
            File source2 = new File(path);
            String plain = FileUtil.read(source2);
            Security.setSecurityEnabled(false);
            Environment env = Environment.createEnvironment(new CompilerEnvironment());
            env.getEnv(CompilerEnvironment.class).setLogCompilerWarnings(false);
            try {
                try {
                    optimized = OptimizationUtilities.optimize(plain, null, envs, source2, true, true);
                }
                catch (ConfigCompileException ex) {
                    HashSet<ConfigCompileException> group = new HashSet<ConfigCompileException>();
                    group.add(ex);
                    throw new ConfigCompileGroupException(group);
                }
            }
            catch (ConfigCompileGroupException ex) {
                ConfigRuntimeException.HandleUncaughtException(ex, null);
                System.exit(1);
                return;
            }
            StreamUtils.GetSystemOut().println(optimized);
            System.exit(0);
        }
    }

    @tool(value="verify")
    public static class VerifyMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Compiles the given file, returning a json describing the errors in the file, or returning nothing if the file compiles cleanly. The target environment(s) must be specified if not targetting command line.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The file to check").setUsageName("file").setRequiredAndDefault()).addArgument(Main.GetEnvironmentParameter());
        }

        @Override
        public boolean startupExtensionManager() {
            return false;
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            String file = parsedArgs.getStringArgument();
            if ("".equals(file)) {
                StreamUtils.GetSystemErr().println("File parameter is required.");
                System.exit(1);
            }
            Environment env = Environment.createEnvironment(new CompilerEnvironment());
            env.getEnv(CompilerEnvironment.class).setLogCompilerWarnings(false);
            Set<Class<? extends Environment.EnvironmentImpl>> envs = Main.GetEnvironmentValue(parsedArgs);
            File f = new File(file);
            String script = FileUtil.read(f);
            try {
                try {
                    MethodScriptCompiler.compile(MethodScriptCompiler.lex(script, env, f, file.endsWith("ms")), null, envs);
                }
                catch (ConfigCompileException ex) {
                    HashSet<ConfigCompileException> s = new HashSet<ConfigCompileException>(1);
                    s.add(ex);
                    throw new ConfigCompileGroupException(s);
                }
            }
            catch (ConfigCompileGroupException ex) {
                ArrayList err = new ArrayList();
                for (ConfigCompileException e : ex.getList()) {
                    HashMap<String, Object> error = new HashMap<String, Object>();
                    error.put("msg", e.getMessage());
                    error.put("file", e.getFile().getAbsolutePath());
                    error.put("line", e.getLineNum());
                    error.put("col", e.getColumn());
                    error.put("len", 0);
                    err.add(error);
                }
                String serr = JSONValue.toJSONString(err);
                StreamUtils.GetSystemOut().println(serr);
            }
        }
    }

    @tool(value="api")
    public static class APIMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Prints documentation for the function specified, then exits. The argument is actually a regex, with ^ and $ added to it, so if you would like to search the function list, you can instead provide the rest of the regex. If multiple matches are found, the full list of matches is printed out. For instance \"array.*\" will return all the functions that start with the word \"array\".").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The name of the function to print the information for").setUsageName("functionRegex").setRequiredAndDefault().setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Instead of displaying the results in the console, launches the website with this function highlighted. The local documentation is guaranteed to be consistent with your local version of MethodScript, while the online results may be slightly stale, or may be from a different build, but the results are generally richer.").asFlag().setName('o', "online")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Also prints out the examples for the function (if any).").asFlag().setName('e', "examples")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The API platform to use. By default, INTERPRETER_JAVA, but may be one of " + StringUtils.Join(api.Platforms.values(), ", ", ", or ")).setUsageName("platform").setOptional().setName("platform").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal("INTERPRETER_JAVA"));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            String function = parsedArgs.getStringArgument();
            boolean examples = parsedArgs.isFlagSet(Character.valueOf('e'));
            api.Platforms platform = api.Platforms.valueOf(parsedArgs.getStringArgument("platform"));
            if ("".equals(function)) {
                StreamUtils.GetSystemErr().println("Usage: java -jar CommandHelper.jar api <function name>");
                System.exit(1);
            }
            ArrayList<FunctionBase> fl = new ArrayList<FunctionBase>();
            for (FunctionBase fb : FunctionList.getFunctionList(platform, null)) {
                if (!fb.getName().matches("^" + function + "$")) continue;
                fl.add(fb);
            }
            if (fl.isEmpty()) {
                StreamUtils.GetSystemErr().println("The function '" + function + "' was not found.");
                System.exit(1);
            } else if (fl.size() == 1) {
                FunctionBase f = (FunctionBase)fl.get(0);
                if (parsedArgs.isFlagSet("online")) {
                    String url = String.format("https://methodscript.com/docs/%s/API/functions/%s", MSVersion.LATEST.toString(), f.getName());
                    System.out.println("Launching browser to " + url);
                    if (!UIUtils.openWebpage(new URL(url))) {
                        System.err.println("Could not launch browser");
                    }
                } else {
                    StreamUtils.GetSystemOut().println(Interpreter.formatDocsForCmdline(f.getName(), examples));
                }
            } else {
                StreamUtils.GetSystemOut().println("Multiple function matches found:");
                for (FunctionBase fb : fl) {
                    StreamUtils.GetSystemOut().println(fb.getName());
                }
            }
            System.exit(0);
        }
    }

    @tool(value="site-deploy")
    public static class SiteDeployTool
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Deploys the documentation site, using the preferences specified in the configuration file. This mechanism completely re-writes the remote site, so that builds are totally reproduceable.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The path to the config file for deployment").setUsageName("config file").setOptional().setName('c', "config").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal(MethodScriptFileLocations.getDefault().getSiteDeployFile().getAbsolutePath())).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Generates the preferences file initially, which you can then fill in.").asFlag().setName("generate-prefs")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Generally, when the uploader runs, it checks the remote server to see if the file already exists there (and is unchanged compared to the local file). If it is unchanged, the upload is skipped. However, even checking with the remote to see what the status of the remote file is takes time. If you are the only one uploading files, then we can simply use a local cache of what the remote system has, and we can skip the step of checking with the remote server for any given file. The cache is always populated, whether or not this flag is set, so if you aren't sure if you can trust the cache, run once without this flag, then for future runs, you can be sure that the local cache is up to date.").asFlag().setName("use-local-cache")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Clears the local cache of all entries, then exits.").asFlag().setName("clear-local-cache")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Validates all of the uploaded web pages, and prints out a summary of the results. This uses the value defined in the config file for validation.").asFlag().setName('d', "do-validation")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("When set, does not clear the progress bar line. This is mostly useful when debugging the site-deploy tool itself.").asFlag().setName("no-progress-clear")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("If set, overrides the post-script value in the config.").setUsageName("script-location").setOptional().setName("override-post-script").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal("")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("If the rsa key is in the non-default location, that location be specified here").setUsageName("id-rsa-path").setOptional().setName("override-id-rsa").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal(""));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            boolean clearLocalCache = parsedArgs.isFlagSet("clear-local-cache");
            if (clearLocalCache) {
                PersistenceNetwork p2 = SiteDeploy.getPersistenceNetwork();
                if (p2 == null) {
                    System.out.println("Cannot get reference to persistence network");
                    System.exit(1);
                    return;
                }
                DaemonManager dm = new DaemonManager();
                p2.clearKey(dm, new String[]{"site_deploy", "local_cache"});
                dm.waitForThreads();
                System.out.println("Local cache cleared");
                System.exit(0);
            }
            boolean generatePrefs = parsedArgs.isFlagSet("generate-prefs");
            boolean useLocalCache = parsedArgs.isFlagSet("use-local-cache");
            boolean doValidation = parsedArgs.isFlagSet("do-validation");
            boolean noProgressClear = parsedArgs.isFlagSet("no-progress-clear");
            String configString = parsedArgs.getStringArgument("config");
            String overridePostScript = parsedArgs.getStringArgument("override-post-script");
            String overrideIdRsa = parsedArgs.getStringArgument("override-id-rsa");
            if (overrideIdRsa.equals("")) {
                overrideIdRsa = null;
            }
            if ("".equals(configString)) {
                System.err.println("Config file missing, check command and try again");
                System.exit(1);
            }
            File config = new File(configString);
            SiteDeploy.run(generatePrefs, useLocalCache, config, "", doValidation, !noProgressClear, overridePostScript, overrideIdRsa);
        }
    }

    @tool(value="doc-export")
    public static class DocExportMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Outputs all known function documentation as a json. This includes known extensions as well as the built in functions.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Provides the path to your extension directory.").setUsageName("extension folder").setOptional().setName("extension-dir").setDefaultVal("./CommandHelper/extensions").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The file to output the generated json to. If this parameter is missing, it is simply printed to screen.").setUsageName("output file").setOptional().setName('o', "output-file").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            ClassDiscovery cd2 = ClassDiscovery.getDefaultInstance();
            String extensionDirS = parsedArgs.getStringArgument("extension-dir");
            String outputFileS = parsedArgs.getStringArgument("output-file");
            OutputStream outputFile = StreamUtils.GetSystemOut();
            if (outputFileS != null) {
                outputFile = new FileOutputStream(new File(outputFileS));
            }
            Implementation.forceServerType(Implementation.Type.BUKKIT);
            File extensionDir = new File(extensionDirS);
            if (extensionDir.exists()) {
                for (File f : extensionDir.listFiles()) {
                    if (!f.getName().endsWith(".jar")) continue;
                    cd2.addDiscoveryLocation(f.toURI().toURL());
                }
            } else {
                StreamUtils.GetSystemErr().println("Extension directory specified doesn't exist: " + extensionDirS + ". Continuing anyways.");
            }
            new DocGenExportTool(cd2, outputFile).export();
        }
    }

    @tool(value="json-api")
    public static class JsonTool
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Prints the api.json file to stdout. This takes no parameters.");
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            APIBuilder.main(null);
            System.exit(0);
        }

        @Override
        public boolean startupExtensionManager() {
            return false;
        }
    }

    @tool(value="interpreter")
    public static class InterpreterMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Launches the minimal cmdline interpreter.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Sets the initial working directory of the interpreter. This is optional, but is automatically set by the mscript program. The option name is strange, to avoid any conflicts with script arguments.").setUsageName("location").setOptional().setName("location-----").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal("."));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            Prefs.init(MethodScriptFileLocations.getDefault().getPreferencesFile());
            Telemetry.GetDefault().doNag();
            new Interpreter(parsedArgs.getStringListArgument(), parsedArgs.getStringArgument("location-----"));
        }
    }

    @tool(value="mslp")
    public static class MSLPMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Creates an MSLP file based on the directory specified.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The path to the folder").setUsageName("path/to/folder").setRequiredAndDefault()).addArgument(Main.GetEnvironmentParameter());
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            String mslp = parsedArgs.getStringArgument();
            Set<Class<? extends Environment.EnvironmentImpl>> envs = Main.GetEnvironmentValue(parsedArgs);
            if (mslp.isEmpty()) {
                StreamUtils.GetSystemOut().println("Usage: --mslp path/to/folder");
                System.exit(1);
            }
            MSLPMaker.start(mslp, envs);
        }
    }

    @tool(value="manager")
    public static class ManagerMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Launches the built in interactive data manager, which will allow command line access to the full persistence database.");
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            Implementation.forceServerType(Implementation.Type.SHELL);
            ClassDiscovery.getDefaultInstance().addDiscoveryLocation(ClassDiscovery.GetClassContainer(Main.class));
            Manager.start();
        }
    }

    @tool(value="version", aliases={"-v", "--v", "-version", "--version"})
    public static class VersionMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Prints the version of CommandHelper, and exits.");
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            Prefs.init(MethodScriptFileLocations.getDefault().getPreferencesFile());
            Telemetry.GetDefault().doNag();
            StreamUtils.GetSystemOut().println("You are running " + Implementation.GetServerType().getBranding() + " version " + Static.loadSelfVersion());
            for (ExtensionTracker e : ExtensionManager.getTrackers().values()) {
                StreamUtils.GetSystemOut().println(e.getIdentifier() + ": " + e.getVersion());
            }
        }
    }

    @tool(value="uninstall-cmdline")
    public static class UninstallCmdlineMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Uninstalls the MethodScript interpreter from your system.").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Specify the name of instance to be uninstalled.").setUsageName("command name").setOptional().setName("command").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING).setDefaultVal("mscript"));
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            Interpreter.uninstall(parsedArgs.getStringArgument("command"));
            System.exit(0);
        }
    }
}

