/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.core.NodeModifiers;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.compiler.analysis.Declaration;
import com.laytonsmith.core.compiler.analysis.Namespace;
import com.laytonsmith.core.compiler.analysis.StaticAnalysis;
import com.laytonsmith.core.constructs.Auto;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.objects.ObjectType;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class ParseTree
implements Cloneable {
    private static Map<ParseTree, Map<CacheTypes, Object>> cache = new WeakHashMap<ParseTree, Map<CacheTypes, Object>>();
    private Mixed data = null;
    private boolean isOptimized = false;
    private final FileOptions fileOptions;
    private List<ParseTree> children = null;
    private boolean hasBeenMadeStatic = false;
    private NodeModifiers nodeModifiers = new NodeModifiers();
    private boolean isSyntheticNode;

    private static boolean isCached(ParseTree tree, CacheTypes type) {
        if (!cache.containsKey(tree)) {
            return false;
        }
        return cache.get(tree).containsKey((Object)type);
    }

    private static Object getCache(ParseTree tree, CacheTypes type) {
        if (!ParseTree.isCached(tree, type)) {
            throw new Error("It is an error to call getCache on an object that does not already have a cached value");
        }
        return cache.get(tree).get((Object)type);
    }

    private static void setCache(ParseTree tree, CacheTypes type, Object value) {
        if (!cache.containsKey(tree)) {
            cache.put(tree, new EnumMap(CacheTypes.class));
        }
        cache.get(tree).put(type, value);
    }

    private static void clearCache(ParseTree tree) {
        cache.remove(tree);
    }

    public ParseTree(FileOptions options) {
        this.children = new ArrayList<ParseTree>();
        this.fileOptions = options;
    }

    public ParseTree(Mixed construct, FileOptions options) {
        this(construct, options, false);
    }

    public ParseTree(Mixed construct, FileOptions options, boolean isSyntheticNode) {
        this(options);
        this.setData(construct);
        this.isSyntheticNode = isSyntheticNode;
    }

    public void replace(ParseTree newData) {
        this.setData(newData.data);
        this.setChildren(newData.children);
        this.getNodeModifiers().merge(newData.nodeModifiers);
        this.isSyntheticNode = newData.isSyntheticNode;
    }

    public boolean isSyntheticNode() {
        return this.isSyntheticNode;
    }

    public FileOptions getFileOptions() {
        return this.fileOptions;
    }

    public void setData(Mixed data) {
        this.data = data;
    }

    public void setOptimized(boolean optimized) {
        this.isOptimized = optimized;
    }

    public boolean isOptimized() {
        return this.isOptimized;
    }

    public boolean hasBeenMadeStatic() {
        return this.hasBeenMadeStatic;
    }

    public void hasBeenMadeStatic(boolean state) {
        this.hasBeenMadeStatic = state;
    }

    public List<Mixed> getAllData() {
        ArrayList<Mixed> list = new ArrayList<Mixed>();
        list.add(this.getData());
        for (ParseTree node : this.getChildren()) {
            list.addAll(node.getAllData());
        }
        return list;
    }

    public List<ParseTree> getAllNodes() {
        ArrayList<ParseTree> list = new ArrayList<ParseTree>();
        list.add(this);
        for (ParseTree node : this.getChildren()) {
            list.addAll(node.getAllNodes());
        }
        return list;
    }

    public List<ParseTree> getChildren() {
        return this.children;
    }

    public ParseTree getChildAt(int index) {
        return this.children.get(index);
    }

    public Mixed getData() {
        return this.data;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void setChildren(List<ParseTree> children) {
        this.children = children;
    }

    public void addChild(ParseTree node) {
        this.children.add(node);
    }

    public void addChildAt(int index, ParseTree node) {
        this.children.add(index, node);
    }

    public int numberOfChildren() {
        return this.children.size();
    }

    public void removeChildAt(int index) {
        this.children.remove(index);
    }

    public void removeChildren() {
        this.children.clear();
    }

    public boolean isConst() {
        if (this.data instanceof Construct) {
            return !((Construct)this.data).isDynamic();
        }
        return this.data.getObjectType() == ObjectType.ENUM;
    }

    public boolean isDynamic() {
        if (this.data instanceof Construct) {
            return ((Construct)this.data).isDynamic();
        }
        return this.data.getObjectType() != ObjectType.ENUM;
    }

    public List<Function> getFunctions() {
        if (ParseTree.isCached(this, CacheTypes.FUNCTIONS)) {
            return new ArrayList<Function>((List)ParseTree.getCache(this, CacheTypes.FUNCTIONS));
        }
        ArrayList<Function> functions = new ArrayList<Function>();
        List<Mixed> allChildren = this.getAllData();
        for (Mixed c : allChildren) {
            if (!(c instanceof CFunction)) continue;
            try {
                FunctionBase f = FunctionList.getFunction((CFunction)c, null);
                if (!(f instanceof Function)) continue;
                Function ff = (Function)f;
                functions.add(ff);
            }
            catch (ConfigCompileException ex) {
                throw new Error(ex);
            }
        }
        ParseTree.setCache(this, CacheTypes.FUNCTIONS, functions);
        return new ArrayList<Function>(functions);
    }

    public ParseTree clone() throws CloneNotSupportedException {
        ParseTree clone = (ParseTree)super.clone();
        clone.data = this.data.clone();
        clone.children = new ArrayList<ParseTree>(this.children);
        return clone;
    }

    public String toString() {
        return this.data.toString();
    }

    public String toStringVerbose() {
        StringBuilder stringRepresentation = new StringBuilder();
        if (this.data instanceof CFunction) {
            stringRepresentation.append(this.data.toString());
            stringRepresentation.append("(");
            boolean first = true;
            for (ParseTree child : this.children) {
                if (!first) {
                    stringRepresentation.append(", ");
                }
                first = false;
                stringRepresentation.append(child.toStringVerbose());
            }
            stringRepresentation.append(")");
        } else if (this.data instanceof CString) {
            stringRepresentation.append("'").append(this.data.val().replaceAll("\t", "\\t").replaceAll("\n", "\\n").replace("\\", "\\\\").replace("'", "\\'")).append("'");
        } else if (this.data instanceof IVariable) {
            stringRepresentation.append(((IVariable)this.data).getVariableName());
        } else {
            stringRepresentation.append(this.data.val());
        }
        return stringRepresentation.toString();
    }

    public Target getTarget() {
        if (this.data == null) {
            return Target.UNKNOWN;
        }
        return this.data.getTarget();
    }

    public CClassType getDeclaredType(Environment env) {
        Object sa;
        if (this.isConst()) {
            return this.getData().typeof();
        }
        Mixed mixed = this.getData();
        if (mixed instanceof IVariable) {
            IVariable ivar = (IVariable)mixed;
            sa = env.getEnv(CompilerEnvironment.class).getStaticAnalysis();
            if (((StaticAnalysis)sa).isLocalEnabled()) {
                ArrayList<Declaration> decls = new ArrayList<Declaration>(((StaticAnalysis)sa).getTermScope(this).getDeclarations(Namespace.IVARIABLE, ivar.getVariableName()));
                if (decls.size() == 1) {
                    return ((Declaration)decls.get(0)).getType();
                }
                return Auto.TYPE;
            }
            return Auto.TYPE;
        }
        sa = this.getData();
        if (sa instanceof CFunction) {
            CFunction cf = (CFunction)sa;
            if (cf.hasProcedure()) {
                sa = env.getEnv(CompilerEnvironment.class).getStaticAnalysis();
                if (((StaticAnalysis)sa).isLocalEnabled()) {
                    ArrayList<Declaration> decls = new ArrayList<Declaration>(((StaticAnalysis)sa).getTermScope(this).getDeclarations(Namespace.PROCEDURE, cf.val()));
                    if (decls.size() == 1) {
                        return ((Declaration)decls.get(0)).getType();
                    }
                    return Auto.TYPE;
                }
                return Auto.TYPE;
            }
            ArrayList<CClassType> argTypes = new ArrayList<CClassType>();
            ArrayList<Target> argTargets = new ArrayList<Target>();
            HashSet<ConfigCompileException> exceptions = new HashSet<ConfigCompileException>();
            for (ParseTree child : this.getChildren()) {
                argTypes.add(child.getDeclaredType(env));
                argTargets.add(child.getTarget());
            }
            return cf.getCachedFunction().getReturnType(this.getTarget(), argTypes, argTargets, env, exceptions);
        }
        throw new Error("Unhandled type, please report this bug");
    }

    public NodeModifiers getNodeModifiers() {
        return this.nodeModifiers;
    }

    private static enum CacheTypes {
        IS_SYNC,
        IS_ASYNC,
        FUNCTIONS;

    }
}

