/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler;

import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.TokenStream;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CKeyword;
import com.laytonsmith.core.constructs.CLabel;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CSymbol;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.NewIVariable;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Token;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;

class CompilerObject {
    TokenStream stream;
    Stack<ParseTree> nodes = new Stack();
    int autoConcatCounter = 0;
    int bracketCounter = 0;
    Stack<Target> bracketLines = new Stack();
    int braceCounter = 0;
    Stack<Target> braceLines = new Stack();
    Stack<Target> functionLines = new Stack();
    ParseTree pointer;
    ParseTree root;
    CompilerEnvironment env;
    private static final List<String> KEYWORDS = Arrays.asList("else", "bind", "proc");

    CompilerObject(TokenStream stream) {
        this.stream = stream;
    }

    Token peek() {
        if (this.stream.isEmpty()) {
            return new Token(Token.TType.UNKNOWN, "", Target.UNKNOWN);
        }
        return (Token)this.stream.get(0);
    }

    Token consume() {
        return (Token)this.stream.remove(0);
    }

    void compile(ParseTree root, Environment compilerEnv) throws ConfigCompileException {
        this.root = root;
        this.nodes.push(root);
        this.pointer = root;
        this.env = compilerEnv.getEnv(CompilerEnvironment.class);
        while (!this.stream.isEmpty()) {
            this.compile0();
        }
        if (this.bracketCounter > 0) {
            throw new ConfigCompileException("Unclosed brackets. (Did you forget a right bracket (])?)", this.bracketLines.peek());
        }
        if (this.braceCounter > 0) {
            throw new ConfigCompileException("Unclosed braces. (Did you forget a right brace (})?)", this.braceLines.peek());
        }
        if (!this.functionLines.isEmpty()) {
            throw new ConfigCompileException("Unclosed left parenthesis. (Did you forget to close a function?)", this.functionLines.peek());
        }
    }

    void compile0() throws ConfigCompileException {
        CFunction f;
        Token t = this.consume();
        if (t.type == Token.TType.NEWLINE) {
            return;
        }
        if (t.type == Token.TType.CONST_START) {
            StringBuilder constName = new StringBuilder();
            while (true) {
                t = this.consume();
                if (t.type == Token.TType.RCURLY_BRACKET) break;
                if (t.type != Token.TType.BARE_STRING && t.type != Token.TType.CONCAT) {
                    throw new ConfigCompileException("Constant names may only contain names and dots.", t.getTarget());
                }
                constName.append(t.val());
            }
            Construct constant = this.env.getConstant(constName.toString());
            if (constant == null) {
                throw new ConfigCompileException("Expected the constant ${" + constName.toString() + "} to be provided in the compilation options, but it wasn't.", t.getTarget());
            }
            t = new Token(Token.TType.STRING, constant.val(), constant.getTarget());
        }
        if (t.type == Token.TType.BARE_STRING && this.peek().type == Token.TType.FUNC_START) {
            this.consume();
            f = new CFunction(t.val(), t.getTarget());
            this.functionLines.add(this.peek().getTarget());
            this.pushNode(f);
            return;
        }
        if ((t.type == Token.TType.FUNC_END || t.type == Token.TType.COMMA) && this.autoConcatCounter > 0) {
            --this.autoConcatCounter;
            this.popNode(t.getTarget());
        }
        if (t.type == Token.TType.COMMA) {
            return;
        }
        if (t.type == Token.TType.FUNC_END) {
            this.popNode(t.getTarget());
            this.functionLines.pop();
            return;
        }
        if (t.type == Token.TType.LSQUARE_BRACKET) {
            f = new CFunction("__cbracket__", Target.UNKNOWN);
            this.pushNode(f);
            ++this.bracketCounter;
            this.bracketLines.push(t.getTarget());
            return;
        }
        if (t.type == Token.TType.RSQUARE_BRACKET) {
            if (this.bracketCounter == 0) {
                throw new ConfigCompileException("Unexpected right bracket. (Did you have too many right square brackets (]) in your code?)", t.getTarget());
            }
            --this.bracketCounter;
            this.bracketLines.pop();
            this.popNode(t.getTarget());
            return;
        }
        if (t.type == Token.TType.LCURLY_BRACKET) {
            f = new CFunction("__cbrace__", Target.UNKNOWN);
            this.pushNode(f);
            ++this.braceCounter;
            this.braceLines.push(t.getTarget());
            return;
        }
        if (t.type == Token.TType.RCURLY_BRACKET) {
            if (this.braceCounter == 0) {
                throw new ConfigCompileException("Unexpected right brace. (Did you have too many right braces (}) in your code?)", t.getTarget());
            }
            --this.braceCounter;
            this.braceLines.pop();
            this.popNode(t.getTarget());
            return;
        }
        if (!(this.peek().type == Token.TType.FUNC_END || this.peek().type == Token.TType.COMMA || this.peek().type == Token.TType.RCURLY_BRACKET || this.peek().type == Token.TType.RSQUARE_BRACKET || this.pointer.getData() instanceof CFunction && ((CFunction)this.pointer.getData()).val().equals("__autoconcat__"))) {
            f = new CFunction("__autoconcat__", Target.UNKNOWN);
            this.pushNode(f);
            ++this.autoConcatCounter;
        }
        if (t.type == Token.TType.BARE_STRING && this.peek().type == Token.TType.LABEL) {
            this.consume();
            this.pointer.addChild(new ParseTree(new CLabel(new CString(t.val(), t.getTarget())), this.stream.getFileOptions()));
            return;
        }
        if (t.type.isIdentifier()) {
            this.pointer.addChild(new ParseTree(this.resolveIdentifier(t), this.stream.getFileOptions()));
            return;
        }
        if (t.type.isSymbol()) {
            this.pointer.addChild(new ParseTree(new CSymbol(t.val(), t.type, t.getTarget()), this.stream.getFileOptions()));
            return;
        }
    }

    private void pushNode(CFunction node) {
        ParseTree n = new ParseTree(node, this.stream.getFileOptions());
        this.pointer.addChild(n);
        this.nodes.push(n);
        this.pointer = n;
    }

    private void popNode(Target t) throws ConfigCompileException {
        try {
            this.nodes.pop();
            this.pointer = this.nodes.peek();
        }
        catch (EmptyStackException e) {
            throw new ConfigCompileException("Unmatched closing parenthesis. (Did you put too many right parenthesis?)", t);
        }
    }

    private Construct resolveIdentifier(Token t) throws ConfigCompileException {
        switch (t.type) {
            case STRING: {
                return new CString(t.val(), t.getTarget());
            }
            case IVARIABLE: {
                return new NewIVariable(t.val(), t.getTarget());
            }
            case BARE_STRING: {
                if (t.val().equals("true")) {
                    return CBoolean.GenerateCBoolean(true, t.getTarget());
                }
                if (t.val().equals("false")) {
                    return CBoolean.GenerateCBoolean(false, t.getTarget());
                }
                if (t.val().equals("null")) {
                    return CNull.GenerateCNull(t.getTarget());
                }
                if (KEYWORDS.contains(t.val())) {
                    return new CKeyword(t.val(), t.getTarget());
                }
                if (this.stream.getFileOptions().isStrict()) {
                    throw new ConfigCompileException("Bare strings not allowed in strict mode. (" + t.val() + ")", t.getTarget());
                }
                return new CString(t.val(), t.getTarget());
            }
            case DOUBLE: {
                return new CDouble(t.val(), t.getTarget());
            }
            case INTEGER: {
                return new CInt(t.val(), t.getTarget());
            }
        }
        throw new ConfigCompileException("Unexpected identifier? Found '" + t.val() + "' but was not any expected value.", t.getTarget());
    }
}

