/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.events.prefilters;

import com.laytonsmith.PureUtilities.ObjectHelpers;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.prefilters.PrefilterMatcher;
import com.laytonsmith.core.events.prefilters.PrefilterStatus;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

@ObjectHelpers.StandardField
public class Prefilter<T extends BindableEvent>
implements Comparable<Prefilter<? extends BindableEvent>> {
    private final String prefilterName;
    private final String docs;
    private final PrefilterMatcher<T> matcher;
    private final Set<PrefilterStatus> status;
    private final int priority;

    public Prefilter(String prefilterName, String docs, PrefilterMatcher<T> matcher, Set<PrefilterStatus> status, int priority) {
        Objects.requireNonNull(prefilterName);
        Objects.requireNonNull(docs);
        Objects.requireNonNull(matcher);
        this.prefilterName = prefilterName;
        this.docs = docs;
        this.matcher = matcher;
        this.status = status == null ? EnumSet.noneOf(PrefilterStatus.class) : status;
        this.priority = priority;
    }

    public String getDocs() {
        return this.docs;
    }

    public PrefilterMatcher<T> getMatcher() {
        return this.matcher;
    }

    public String getPrefilterName() {
        return this.prefilterName;
    }

    public Set<PrefilterStatus> getStatus() {
        return EnumSet.copyOf(this.status);
    }

    public boolean equals(Object obj) {
        return ObjectHelpers.DoEquals(this, obj);
    }

    public int hashCode() {
        return ObjectHelpers.DoHashCode(this);
    }

    public String toString() {
        return ObjectHelpers.DoToString(this);
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(Prefilter<? extends BindableEvent> o) {
        return Integer.compare(this.priority, o.priority);
    }
}

