/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.core;
import com.laytonsmith.annotations.noboilerplate;
import com.laytonsmith.annotations.seealso;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.compiler.BranchStatement;
import com.laytonsmith.core.compiler.SelfStatement;
import com.laytonsmith.core.compiler.VariableScope;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.StaticRuntimeEnv;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREInterruptedException;
import com.laytonsmith.core.exceptions.CRE.CRENullPointerException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.LoopManipulationException;
import com.laytonsmith.core.exceptions.ProgramFlowManipulationException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.functions.Echoes;
import com.laytonsmith.core.functions.ExampleScript;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

@core
public class Threading {
    public static final Map<String, Thread> THREAD_ID_MAP = new HashMap<String, Thread>();

    public static String docs() {
        return "This experimental and private API is subject to removal, or incompatible changes, and should not be yet heavily relied on in normal development.";
    }

    @api
    @seealso(value={x_interrupt.class, x_is_interrupted.class})
    public static class x_clear_interrupt
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            return CBoolean.get(Thread.interrupted());
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_4;
        }

        @Override
        public String getName() {
            return "x_clear_interrupt";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0};
        }

        @Override
        public String docs() {
            return "boolean {} Clears the interrupt status of the current thread. If this call actually cleared the interrupt status, true is returned, if the thread was already not interrupted, false is returned.";
        }
    }

    @api
    @seealso(value={x_interrupt.class, x_clear_interrupt.class})
    public static class x_is_interrupted
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            if (args2.length == 1) {
                Thread th;
                String threadId = args2[0].val();
                Map<String, Thread> map = THREAD_ID_MAP;
                synchronized (map) {
                    th = THREAD_ID_MAP.get(threadId);
                }
                if (th != null) {
                    return CBoolean.get(th.isInterrupted());
                }
                return CBoolean.FALSE;
            }
            return CBoolean.get(Thread.currentThread().isInterrupted());
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_4;
        }

        @Override
        public String getName() {
            return "x_is_interrupted";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        @Override
        public String docs() {
            return "boolean {[string id]} Tests whether the thread with the given id (or the current thread if none is provided) is interrupted via " + new x_interrupt().getName() + ". If the thread doesn't exist, or is not alive, false is returned.";
        }
    }

    @api
    @seealso(value={x_is_interrupted.class, x_clear_interrupt.class})
    public static class x_interrupt
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            if (args2.length == 1) {
                Thread th;
                String threadId = args2[0].val();
                Map<String, Thread> map = THREAD_ID_MAP;
                synchronized (map) {
                    th = THREAD_ID_MAP.get(threadId);
                }
                if (th != null) {
                    th.interrupt();
                }
            } else {
                Thread.currentThread().interrupt();
            }
            return CVoid.VOID;
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_4;
        }

        @Override
        public String getName() {
            return "x_interrupt";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        @Override
        public String docs() {
            return "void {[string id]} Interrupts the thread with the given id, or the current thread if no id is given. When a thread is interrupted, its interrupt status is set to true. This status can be checked using the " + new x_is_interrupted().getName() + " and " + new x_clear_interrupt().getName() + " function. Note that some blocking functions will throw an InterruptedException when the thread on which they are executed is interrupted.";
        }
    }

    @api
    public static class x_thread_is_alive
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            Thread th;
            String threadId = args2[0].val();
            Map<String, Thread> map = THREAD_ID_MAP;
            synchronized (map) {
                th = THREAD_ID_MAP.get(threadId);
            }
            if (th == null) {
                return CBoolean.FALSE;
            }
            return CBoolean.get(th.isAlive());
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_4;
        }

        @Override
        public String getName() {
            return "x_thread_is_alive";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {string id} Tests if this thread with the given id is alive. A thread is alive if it has been started and has not yet died.";
        }
    }

    @api
    public static class x_thread_join
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInterruptedException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            Thread th;
            String threadId = args2[0].val();
            Map<String, Thread> map = THREAD_ID_MAP;
            synchronized (map) {
                th = THREAD_ID_MAP.get(threadId);
            }
            if (th == null) {
                return CVoid.VOID;
            }
            int wait = 0;
            if (args2.length > 1) {
                wait = ArgumentValidation.getInt32(args2[1], t);
            }
            try {
                th.join(wait);
            }
            catch (InterruptedException ex) {
                throw new CREInterruptedException(ex, t);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "x_thread_join";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        @Override
        public String docs() {
            return "void {string id, [int maxWait]} Waits for the thread with the given id to exit. By default, we wait potentially forever, but if maxWait is specified, we will only wait that many milliseconds. (Sending 0 for this value causes an infinite wait.) If the timeout occurs or thread interrupted, an InterruptedException is thrown. If the id is unknown, this function will directly return";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_4;
        }
    }

    @api
    @noboilerplate
    @seealso(value={x_new_thread.class})
    @SelfStatement
    public static class _synchronized
    extends AbstractFunction
    implements VariableScope,
    BranchStatement {
        private static final Map<Object, Integer> SYNC_OBJECT_MAP = new HashMap<Object, Integer>();

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENullPointerException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return false;
        }

        @Override
        public boolean preResolveVariables() {
            return false;
        }

        @Override
        public boolean useSpecialExec() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
            Map<Object, Integer> map;
            ParseTree syncObjectTree = nodes[0];
            ParseTree code = nodes[1];
            Mixed cSyncObject = parent.seval(syncObjectTree, env);
            if (cSyncObject instanceof CNull) {
                throw new CRENullPointerException("Synchronization object may not be null in " + this.getName() + "().", t);
            }
            Object syncObject = cSyncObject.isInstanceOf(CArray.TYPE) ? cSyncObject : cSyncObject.val();
            if (syncObject instanceof String) {
                map = SYNC_OBJECT_MAP;
                synchronized (map) {
                    block24: {
                        for (Map.Entry<Object, Integer> entry : SYNC_OBJECT_MAP.entrySet()) {
                            Object key = entry.getKey();
                            if (!(key instanceof String) || !key.equals(syncObject)) continue;
                            syncObject = key;
                            entry.setValue(entry.getValue() + 1);
                            break block24;
                        }
                        SYNC_OBJECT_MAP.put(syncObject, 1);
                    }
                }
            }
            try {
                map = syncObject;
                synchronized (map) {
                    parent.eval(code, env);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            finally {
                if (syncObject instanceof String) {
                    Map<Object, Integer> map2 = SYNC_OBJECT_MAP;
                    synchronized (map2) {
                        int count = SYNC_OBJECT_MAP.get(syncObject);
                        if (count <= 1) {
                            SYNC_OBJECT_MAP.remove(syncObject);
                        } else {
                            for (Map.Entry<Object, Integer> entry : SYNC_OBJECT_MAP.entrySet()) {
                                if (entry.getKey() != syncObject) continue;
                                entry.setValue(count - 1);
                                break;
                            }
                        }
                    }
                }
            }
            return CVoid.VOID;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args2) throws ConfigRuntimeException {
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "synchronized";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "void {syncObject, code} Synchronizes access to the code block for all calls (from different threads) with the same syncObject argument. This means that if two threads will call " + this.getName() + "('example', &lt;code&gt;), the second call will hang the thread until the passed code of the first call has finished executing. If you call this function from within this function on the same thread using the same syncObject, the code will simply be executed. For more information about synchronization, see: https://en.wikipedia.org/wiki/Synchronization_(computer_science)";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Demonstrates two threads possibly overwriting each other", "export('log', '');\nx_new_thread('Thread1', closure() {\n\t@log = import('log');\n\t@log = @log.'Some new log message from Thread1.\n'\n\texport('log', @log);\n});\nx_new_thread('Thread2', closure() {\n\t@log = import('log');\n\t@log = @log.'Some new log message from Thread2.\n'\n\texport('log', @log);\n});\nsleep(0.1);\nmsg(import('log'));", "Some new log message from Thread1.\n\nOR\nSome new log message from Thread2.\n\nOR\nSome new log message from Thread1.\nSome new log message from Thread2.\n\nOR\nSome new log message from Thread2.\nSome new log message from Thread1.\n"), new ExampleScript("Demonstrates two threads modifying the same variable without the possibility of overwriting each other because they are synchronized.", "export('log', '');\nx_new_thread('Thread1', closure() {\n\tsynchronized('syncLog') {\n\t\t@log = import('log');\n\t\t@log = @log.'Some new log message from Thread1.\n'\n\t\texport('log', @log);\n\t}\n});\nx_new_thread('Thread2', closure() {\n\tsynchronized('syncLog') {\n\t\t@log = import('log');\n\t\t@log = @log.'Some new log message from Thread2.\n'\n\t\texport('log', @log);\n\t}\n});\nsleep(0.1);\nmsg(import('log'));", "Some new log message from Thread1.\nSome new log message from Thread2.\n\nOR\nSome new log message from Thread2.\nSome new log message from Thread1.\n")};
        }

        @Override
        public List<Boolean> isScope(List<ParseTree> children) {
            ArrayList<Boolean> ret = new ArrayList<Boolean>(2);
            ret.add(false);
            ret.add(true);
            return ret;
        }

        @Override
        public List<Boolean> isBranch(List<ParseTree> children) {
            ArrayList<Boolean> ret = new ArrayList<Boolean>(2);
            ret.add(false);
            ret.add(true);
            return ret;
        }
    }

    @api
    @noboilerplate
    @seealso(value={x_run_on_main_thread_later.class})
    public static class x_run_on_main_thread_now
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            Object ret;
            final CClosure closure2 = ArgumentValidation.getObject(args2[0], t, CClosure.class);
            try {
                ret = StaticLayer.GetConvertor().runOnMainThreadAndWait(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        try {
                            return closure2.executeCallable(new Mixed[0]);
                        }
                        catch (ConfigRuntimeException | ProgramFlowManipulationException e) {
                            return e;
                        }
                    }
                });
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (ret instanceof RuntimeException) {
                throw (RuntimeException)ret;
            }
            return (Mixed)ret;
        }

        @Override
        public String getName() {
            return "x_run_on_main_thread_now";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "mixed {closure} Runs the closure on the main thread now, blocking the current thread until it is finished. If the function call is itself being run from the main thread, then the function still will block as expected; it is not an error to call this from the main thread. Unlike running on the main thread later, if the underlying code throws an exception, it is thrown as a normal part of the execution. If the closure returns a value, it is returned by " + this.getName() + ".";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    @noboilerplate
    @seealso(value={x_run_on_main_thread_now.class})
    public static class x_run_on_main_thread_later
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, final Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            final CClosure closure2 = ArgumentValidation.getObject(args2[0], t, CClosure.class);
            StaticLayer.GetConvertor().runOnMainThreadLater(environment.getEnv(StaticRuntimeEnv.class).GetDaemonManager(), new Runnable(){

                @Override
                public void run() {
                    try {
                        closure2.executeCallable(new Mixed[0]);
                    }
                    catch (ConfigRuntimeException e) {
                        ConfigRuntimeException.HandleUncaughtException(e, environment);
                    }
                    catch (ProgramFlowManipulationException programFlowManipulationException) {
                        // empty catch block
                    }
                }
            });
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "x_run_on_main_thread_later";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "void {closure} Runs the closure on the main thread later. If the function call is itself being run from the main thread, then the function still will not block, but it is not an error to call this from the main thread. If an exception is thrown from the closure, it is handled using the uncaught exception handler.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class x_get_current_thread
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            return new CString(Thread.currentThread().getName(), t);
        }

        @Override
        public String getName() {
            return "x_get_current_thread";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0};
        }

        @Override
        public String docs() {
            return "string {} Returns the thread id (thread name) of the currently running thread.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", this.getName() + "()", "MainThread")};
        }
    }

    @api
    @noboilerplate
    @seealso(value={x_run_on_main_thread_later.class, x_run_on_main_thread_now.class})
    public static class x_new_thread
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Mixed exec(final Target t, final Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            final String threadId = args2[0].val();
            if (!args2[1].isInstanceOf(CClosure.TYPE)) {
                throw new CRECastException("Expected closure for arg 2", t);
            }
            final CClosure closure2 = (CClosure)args2[1];
            Thread th = new Thread("(" + Implementation.GetServerType().getBranding() + ") " + threadId){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DaemonManager dm = environment.getEnv(StaticRuntimeEnv.class).GetDaemonManager();
                    dm.activateThread(Thread.currentThread());
                    try {
                        closure2.executeCallable(new Mixed[0]);
                    }
                    catch (LoopManipulationException ex) {
                        ConfigRuntimeException.HandleUncaughtException(ConfigRuntimeException.CreateUncatchableException("Unexpected loop manipulation operation was triggered inside the closure.", t), environment);
                    }
                    catch (ConfigRuntimeException ex) {
                        ConfigRuntimeException.HandleUncaughtException(ex, environment);
                    }
                    catch (CancelCommandException ex) {
                        if (ex.getMessage() != null) {
                            new Echoes.console().exec(t, environment, new CString(ex.getMessage(), t), CBoolean.FALSE);
                        }
                    }
                    finally {
                        dm.deactivateThread(Thread.currentThread());
                        Map<String, Thread> ex = THREAD_ID_MAP;
                        synchronized (ex) {
                            if (THREAD_ID_MAP.get(threadId) == this) {
                                THREAD_ID_MAP.remove(threadId);
                            }
                        }
                    }
                }
            };
            th.start();
            Map<String, Thread> map = THREAD_ID_MAP;
            synchronized (map) {
                THREAD_ID_MAP.put(threadId, th);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "x_new_thread";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "void {id, closure} Creates a new thread, named id, and runs the closure on that thread. Note that many operations are not advisable to be run on other threads, and unless otherwise stated, functions are generally not thread safe. You can use " + new x_run_on_main_thread_later().getName() + "() and " + new x_run_on_main_thread_now().getName() + "() to ensure operations will be run correctly, however.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            String get_current_thread = new x_get_current_thread().getName();
            String new_thread = this.getName();
            return new ExampleScript[]{new ExampleScript("Basic usage", "msg(" + get_current_thread + "());\n" + new_thread + "('myThread', closure(){\n\tsleep(5); // Sleep here, to allow the main thread to get well past us, for demonstration purposes\n\tmsg(" + get_current_thread + "());\n});\nmsg('End of main thread');", "MainThread\nEnd of main thread\nmyThread")};
        }
    }
}

