/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.profiler;

import com.laytonsmith.PureUtilities.Common.DateUtils;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.ExecutionQueue;
import com.laytonsmith.PureUtilities.ExecutionQueueImpl;
import com.laytonsmith.PureUtilities.Preferences;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.profiler.GarbageCollectionDetector;
import com.laytonsmith.core.profiler.ProfilePoint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class Profiler {
    Map<ProfilePoint, Long> operations;
    long queuedProfilePoints = 0L;
    private LogLevel configGranularity;
    private boolean profilerOn;
    private String logFile;
    private boolean writeToFile;
    private boolean writeToScreen;
    private Preferences prefs;
    private File initFile;
    private double logThreshold;
    private static ExecutionQueue outputQueue;
    private final ProfilePoint NULL_OP = new ProfilePoint("NULL_OP", this);
    private static final Map<Long, String> INDENTS;
    private static final String GC_STRING = " (however, the garbage collector was run during this profile point)";

    public static Profiler FakeProfiler() {
        Profiler p2 = new Profiler();
        p2.profilerOn = false;
        return p2;
    }

    public static void Install(File initFile) throws IOException {
        Profiler.GetPrefs(initFile);
    }

    private static Preferences GetPrefs(File initFile) throws IOException {
        ArrayList<Preferences.Preference> defaults = new ArrayList<Preferences.Preference>(Arrays.asList(new Preferences.Preference("profiler-on", "false", Preferences.Type.BOOLEAN, "Turns the profiler on or off. The profiler can cause a slight amount of lag, so generally speaking you don't leave it on during normal operation."), new Preferences.Preference("profiler-granularity", "1", Preferences.Type.INT, "Sets the granularity of the profiler. 1 logs some things, while 5 logs everything possible."), new Preferences.Preference("profiler-log", "logs/profiling/internal/%Y-%M-%D-profiler.log", Preferences.Type.STRING, "The location of the profiler output log. The following macros are supported and will expand to the specified values: %Y - Year, %M - Month, %D - Day, %h - Hour, %m - Minute, %s - Second"), new Preferences.Preference("write-to-file", "true", Preferences.Type.BOOLEAN, "If true, will write results out to file."), new Preferences.Preference("write-to-screen", "false", Preferences.Type.BOOLEAN, "If true, will write results out to screen."), new Preferences.Preference("profile-log-threshold", "0.005", Preferences.Type.DOUBLE, "If a profile point took less than this amount of time (in ms) to run, it won't be logged. This is good for reducing data blindness caused by too much data being displayed. Normally you only care about things that took longer than a certain amount, not things that took less than a certain amount. Setting this to 0 will trigger everything.")));
        Preferences prefs = new Preferences("CommandHelper", Static.getLogger(), defaults, "These settings control the integrated profiler");
        prefs.init(initFile);
        return prefs;
    }

    private Profiler() {
        if (outputQueue == null) {
            outputQueue = new ExecutionQueueImpl("CommandHelper-Profiler", "default");
        }
    }

    public Profiler(File initFile) throws IOException {
        this();
        this.prefs = Profiler.GetPrefs(initFile);
        this.operations = new HashMap<ProfilePoint, Long>(1024, 0.25f);
        this.initFile = initFile;
        this.configGranularity = LogLevel.getEnum(this.prefs.getIntegerPreference("profiler-granularity"));
        if (this.configGranularity == null) {
            this.configGranularity = LogLevel.ERROR;
        }
        this.profilerOn = this.prefs.getBooleanPreference("profiler-on");
        this.logFile = this.prefs.getStringPreference("profiler-log");
        this.writeToFile = this.prefs.getBooleanPreference("write-to-file");
        this.writeToScreen = this.prefs.getBooleanPreference("write-to-screen");
        this.logThreshold = this.prefs.getDoublePreference("profile-log-threshold");
        new GarbageCollectionDetector(this);
        ProfilePoint warmupPoint = this.start("Warming up the profiler", LogLevel.VERBOSE);
        this.stop(warmupPoint);
    }

    public ProfilePoint start(String name, LogLevel granularity) {
        if (!this.isLoggable(granularity)) {
            return this.NULL_OP;
        }
        ProfilePoint p2 = new ProfilePoint(name, this);
        this.start0(p2, granularity);
        return p2;
    }

    private void start0(ProfilePoint operationName, LogLevel granularity) {
        if (this.operations.containsKey(operationName)) {
            throw new RuntimeException("Cannot queue the same profile point multiple times!");
        }
        ++this.queuedProfilePoints;
        operationName.setGranularity(granularity);
        this.operations.put(operationName, System.nanoTime());
    }

    private static String getIndent(long count) {
        if (!INDENTS.containsKey(count)) {
            StringBuilder b = new StringBuilder();
            int i = 0;
            while ((long)i < count) {
                b.append(" ");
                ++i;
            }
            INDENTS.put(count, b.toString());
        }
        return INDENTS.get(count);
    }

    public void stop(ProfilePoint operationName) {
        long stop = System.nanoTime();
        if (operationName == this.NULL_OP) {
            return;
        }
        if (!this.operations.containsKey(operationName)) {
            return;
        }
        long total = stop - this.operations.get(operationName);
        double time2 = (double)(total / 1000L) / 1000.0;
        if (time2 >= this.logThreshold) {
            Object stringTime = Double.toString(time2);
            if (((String)stringTime).length() < 6 && ((String)stringTime).contains(".")) {
                while (((String)stringTime).length() < 6) {
                    stringTime = (String)stringTime + "0";
                }
            }
            stringTime = (String)stringTime + "ms";
            if (time2 > 1000.0) {
                stringTime = Double.toString((double)((long)time2) / 1000.0) + "sec";
            }
            String operationMessage = operationName.getMessage() != null ? " Message: " + operationName.getMessage() : "";
            this.doLog("[" + (String)stringTime + "][Lvl:" + operationName.getGranularity().getLevel() + "]:" + Profiler.getIndent(this.queuedProfilePoints) + operationName.toString() + operationMessage + (operationName.wasGCd() ? GC_STRING : ""));
        }
        --this.queuedProfilePoints;
    }

    public boolean isLoggable(LogLevel granularity) {
        if (!this.profilerOn || granularity == null) {
            return false;
        }
        return granularity.getLevel() <= this.configGranularity.getLevel();
    }

    public void doLog(String message) {
        outputQueue.push(null, null, () -> {
            if (this.writeToScreen) {
                StreamUtils.GetSystemOut().println(message);
            }
            if (this.writeToFile) {
                File file = new File(this.initFile.getParentFile(), DateUtils.ParseCalendarNotation(this.logFile));
                try {
                    FileUtil.write(DateUtils.ParseCalendarNotation("%Y-%M-%D %h:%m.%s") + ": " + message + Static.LF(), file, 1, true);
                }
                catch (IOException ex) {
                    StreamUtils.GetSystemErr().println("While trying to write to the profiler log file (" + file.getAbsolutePath() + "), received an IOException: " + ex.getMessage());
                }
            }
        });
    }

    static {
        INDENTS = new TreeMap<Long, String>();
        for (int i = 0; i < 10; ++i) {
            Profiler.getIndent(i);
        }
    }
}

