/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.TermColors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ArgumentParser {
    String description = "";
    String extendedDescription = "";
    List<Argument> argumentModel = new ArrayList<Argument>();
    boolean errorOnUnknown = true;

    private Argument getArgument() {
        for (Argument a : this.argumentModel) {
            if (a.shortArg != null || a.longArg != null) continue;
            return a;
        }
        return null;
    }

    private Argument getArgument(Character c) {
        for (Argument a : this.argumentModel) {
            if (a.shortArg == null || !a.shortArg.equals(c)) continue;
            return a;
        }
        return null;
    }

    private Argument getArgument(String s) {
        for (Argument a : this.argumentModel) {
            if (a.longArg == null || !a.longArg.equals(s)) continue;
            return a;
        }
        return null;
    }

    private ArgumentParser() {
    }

    public static ArgumentParser GetParser() {
        return new ArgumentParser();
    }

    public ArgumentParser addArgument(ArgumentBuilder.ArgumentBuilderFinal arg) {
        Argument arg0 = arg.build();
        for (Argument a : this.argumentModel) {
            if (a.shortArg == null && a.longArg == null && arg0.shortArg == null && arg0.longArg == null) {
                throw new IllegalArgumentException("Only 1 default argument may be provided.");
            }
            if (a.shortArg != null && arg0.shortArg != null && a.shortArg.equals(arg0.shortArg)) {
                throw new IllegalArgumentException("A new argument with short arg '" + arg0.shortArg + "' was provided, but a previous argument with the same short arg was already provided.");
            }
            if (a.longArg == null || arg0.longArg == null || !a.longArg.equals(arg0.longArg)) continue;
            throw new IllegalArgumentException("A new argument with long arg \"" + arg0.longArg + "\" was provided, but a previous argument with the same long arg was already provided.");
        }
        this.argumentModel.add(arg0);
        return this;
    }

    public ArgumentParser addDescription(String description) {
        this.description = description;
        return this;
    }

    public ArgumentParser addExtendedDescription(String extendedDescription) {
        this.extendedDescription = extendedDescription;
        return this;
    }

    public ArgumentParser setErrorOnUnknownArgs(boolean errorOnUnknown) {
        this.errorOnUnknown = errorOnUnknown;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public String getBuiltDescription() {
        StringBuilder b = new StringBuilder();
        b.append("\t").append(this.description).append("\n\n");
        if (!this.extendedDescription.equals("")) {
            b.append("\t").append(this.extendedDescription).append("\n\n");
        }
        ArrayList<Character> shortCodes = new ArrayList<Character>();
        ArrayList<String> longCodes = new ArrayList<String>();
        ArrayList<Character> shortCodesDone = new ArrayList<Character>();
        ArrayList<String> longCodesDone = new ArrayList<String>();
        ArrayList<String> aliases = new ArrayList<String>();
        for (Argument arg : this.argumentModel) {
            if (arg.shortArg != null) {
                shortCodes.add(arg.shortArg);
            }
            if (arg.longArg != null) {
                longCodes.add(arg.longArg);
            }
            if (arg.shortArg == null || arg.longArg == null) continue;
            aliases.add(arg.longArg);
        }
        Collections.sort(shortCodes);
        Collections.sort(longCodes);
        boolean hasShortCodeFlags = false;
        StringBuilder flags = new StringBuilder();
        ArrayList<Character> shortFlags = new ArrayList<Character>();
        ArrayList<String> longFlags = new ArrayList<String>();
        ArrayList<Character> shortArguments = new ArrayList<Character>();
        ArrayList<String> longArguments = new ArrayList<String>();
        for (Character c : shortCodes) {
            Argument argument = this.getArgument(c);
            if (argument.isFlag()) {
                shortCodesDone.add(c);
                flags.append(argument.generateDescription(true));
                hasShortCodeFlags = true;
                shortFlags.add(c);
                continue;
            }
            shortArguments.add(c);
        }
        for (String s : longCodes) {
            Argument argument = this.getArgument(s);
            if (argument.isFlag()) {
                longCodesDone.add(s);
                flags.append(argument.generateDescription(false));
                if (aliases.contains(s)) continue;
                longFlags.add(s);
                continue;
            }
            if (aliases.contains(s)) continue;
            longArguments.add(s);
        }
        b.append(TermColors.BOLD).append("Usage:\n\t").append(TermColors.RESET);
        ArrayList<Object> parts = new ArrayList<Object>();
        if (!shortFlags.isEmpty()) {
            StringBuilder usage = new StringBuilder();
            usage.append("[").append("-");
            for (Character c : shortFlags) {
                usage.append(c);
            }
            usage.append("]");
            parts.add(usage.toString());
        }
        for (String string : longFlags) {
            parts.add("[--" + string + "]");
        }
        ArrayList<Argument> usageList = new ArrayList<Argument>();
        for (Character c : shortArguments) {
            usageList.add(this.getArgument(c));
        }
        for (String s : longArguments) {
            usageList.add(this.getArgument(s));
        }
        for (Argument a2 : usageList) {
            StringBuilder usage = new StringBuilder();
            if (!a2.required) {
                usage.append("[");
            }
            if (a2.shortArg != null) {
                usage.append("-").append(a2.shortArg);
            } else {
                usage.append("--").append(a2.longArg);
            }
            usage.append(" <");
            if (a2.isNumeric()) {
                usage.append("#");
            }
            usage.append(a2.usageName);
            if (a2.isArray()) {
                usage.append(", ...");
            }
            usage.append(">");
            if (a2.defaultVal != null && !"".equals(a2.defaultVal)) {
                usage.append(" (default ");
                if (a2.argType == Type.STRING) {
                    usage.append("\"");
                }
                usage.append(a2.defaultVal);
                if (a2.argType == Type.STRING) {
                    usage.append("\"");
                }
                usage.append(")");
            }
            if (!a2.required) {
                usage.append("]");
            }
            parts.add(usage.toString());
        }
        if (this.getArgument() != null) {
            void var15_31;
            void var15_28;
            String string = "<";
            if (this.getArgument().isNumeric()) {
                String string2 = string + "#";
            }
            String string3 = (String)var15_28 + this.getArgument().usageName;
            if (this.getArgument().isArray()) {
                String string4 = string3 + ", ...";
            }
            String string5 = (String)var15_31 + ">";
            parts.add(string5);
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (String string : parts) {
            if (!first) {
                b.append(" ");
            }
            first = false;
            b.append(string);
        }
        if (parts.isEmpty()) {
            stringBuilder.append("No arguments.");
        }
        b.append(stringBuilder.toString());
        b.append("\n\n");
        Argument argument = this.getArgument();
        if (argument != null && argument.description != null) {
            b.append(argument.generateDescription(false));
        }
        if (flags.length() != 0) {
            b.append(TermColors.BOLD).append("Flags").append(TermColors.RESET);
            if (hasShortCodeFlags) {
                b.append(" (Short flags may be combined)");
            }
            b.append(":\n");
            b.append(flags.toString());
            b.append("\n");
        }
        if (shortCodes.isEmpty() && longCodes.isEmpty() && argument == null && flags.length() == 0) {
            b.append("\tNo flags or options.\n");
        } else if (shortCodes.isEmpty() && longCodes.isEmpty() && argument == null) {
            b.append("\tNo options.\n");
        } else if (flags.length() == 0) {
            b.append("\tNo flags.\n");
        } else {
            b.append(TermColors.BOLD).append("Options:\n").append(TermColors.RESET);
        }
        for (Character c : shortCodes) {
            if (shortCodesDone.contains(c)) continue;
            b.append(this.getArgument(c).generateDescription(true));
        }
        for (String s : longCodes) {
            if (longCodesDone.contains(s)) continue;
            b.append(this.getArgument(s).generateDescription(false));
        }
        return b.toString();
    }

    public String getDescription() {
        return this.description;
    }

    public ArgumentParserResults match(String args2) throws ValidationException {
        return this.parse(ArgumentParser.lex(args2));
    }

    public ArgumentParserResults match(String[] args2) throws ValidationException {
        return this.parse(Arrays.asList(args2));
    }

    static List<String> lex(String args2) {
        ArrayList<String> arguments = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        boolean stateInSingleQuote = false;
        boolean stateInDoubleQuote = false;
        for (int i = 0; i < args2.length(); ++i) {
            Character c1;
            Character c0 = Character.valueOf(args2.charAt(i));
            Character c = c1 = i + 1 < args2.length() ? Character.valueOf(args2.charAt(i + 1)) : null;
            if (c0.charValue() == '\\' && (c1.charValue() == '\'' && stateInSingleQuote || c1.charValue() == '\"' && stateInDoubleQuote || c1.charValue() == ' ' && !stateInDoubleQuote && !stateInSingleQuote || c1.charValue() == '\\' && (stateInDoubleQuote || stateInSingleQuote))) {
                buf.append(c1);
                ++i;
                continue;
            }
            if (c0.charValue() == ' ' && !stateInDoubleQuote && !stateInSingleQuote) {
                if (buf.length() == 0) continue;
                arguments.add(buf.toString());
                buf = new StringBuilder();
                continue;
            }
            if (c0.charValue() == '\'' && !stateInDoubleQuote) {
                if (stateInSingleQuote) {
                    stateInSingleQuote = false;
                    arguments.add(buf.toString());
                    buf = new StringBuilder();
                    continue;
                }
                if (buf.length() != 0) {
                    arguments.add(buf.toString());
                    buf = new StringBuilder();
                }
                stateInSingleQuote = true;
                continue;
            }
            if (c0.charValue() == '\"' && !stateInSingleQuote) {
                if (stateInDoubleQuote) {
                    stateInDoubleQuote = false;
                    arguments.add(buf.toString());
                    buf = new StringBuilder();
                    continue;
                }
                if (buf.length() != 0) {
                    arguments.add(buf.toString());
                    buf = new StringBuilder();
                }
                stateInDoubleQuote = true;
                continue;
            }
            buf.append(c0);
        }
        if (buf.length() != 0) {
            arguments.add(buf.toString());
        }
        return arguments;
    }

    private ArgumentParserResults parse(List<String> args2) throws ValidationException {
        ArgumentParserResults results = new ArgumentParserResults(args2);
        for (Argument arg : this.argumentModel) {
            if (arg.defaultVal == null || arg.isFlag() && (!arg.isFlag() || arg.defaultVal == null)) continue;
            Argument newArg = new Argument(arg);
            newArg.setValue(arg.defaultVal);
            results.updateArgument(newArg);
        }
        ArrayList<String> looseArgs = new ArrayList<String>();
        Argument lastArg = null;
        for (String arg : args2) {
            if (arg.matches("^[\\\\]+-.*$")) {
                looseArgs.add(arg.substring(1));
                continue;
            }
            if (arg.matches("--[a-zA-Z0-9\\-]*")) {
                results.updateArgument(this.validateArgument(lastArg, looseArgs));
                arg = arg.substring(2);
                if (this.errorOnUnknown && this.getArgument(arg) == null) {
                    throw new ValidationException("Unrecognized argument: " + arg);
                }
                lastArg = this.getArgument(arg);
                continue;
            }
            if (arg.matches("-[a-zA-Z0-9]*")) {
                results.updateArgument(this.validateArgument(lastArg, looseArgs));
                boolean hasNonFlagArg = false;
                char lastNonFlag = ' ';
                for (int i = 1; i < arg.length(); ++i) {
                    Character c = Character.valueOf(arg.charAt(i));
                    Argument vArg = this.getArgument(c);
                    if (vArg == null) {
                        if (this.errorOnUnknown) {
                            throw new ValidationException("Unrecognized flag: " + c);
                        }
                        results.updateUnclassifiedArgument("-" + c.toString());
                        continue;
                    }
                    if (!vArg.isFlag() && hasNonFlagArg) {
                        throw new ValidationException("Cannot combine multiple non-flag arguments using the short form. Found '" + c + "' but had already found '" + lastNonFlag + "'. You must split these into multiple arguments, even if they do not have any parameters, for instance, -" + c + " -" + lastNonFlag);
                    }
                    if (!vArg.isFlag()) {
                        hasNonFlagArg = true;
                        lastNonFlag = c.charValue();
                        lastArg = vArg;
                        continue;
                    }
                    results.updateArgument(vArg);
                }
                continue;
            }
            looseArgs.add(arg);
        }
        results.updateArgument(this.validateArgument(lastArg, looseArgs));
        if (looseArgs.size() > 0) {
            results.updateArgument(this.validateArgument(null, looseArgs));
        }
        ArrayList<Object> missing = new ArrayList<Object>();
        block3: for (Argument model : this.argumentModel) {
            if (!model.required) continue;
            for (Argument r : results.arguments) {
                if (!r.modelEquals(model)) continue;
                continue block3;
            }
            if (model.shortArg != null && model.longArg == null) {
                missing.add(model.shortArg.toString());
                continue;
            }
            if (model.shortArg == null && model.longArg != null) {
                missing.add(model.longArg);
                continue;
            }
            if (model.shortArg != null && model.longArg != null) {
                missing.add(model.shortArg + "/" + model.longArg);
                continue;
            }
            missing.add("<default argument>");
        }
        if (!missing.isEmpty()) {
            throw new ValidationException("Missing required argument(s): " + StringUtils.Join(missing, ", "));
        }
        return results;
    }

    private Argument validateArgument(Argument arg, List<String> looseArgs) throws ValidationException {
        if (arg == null) {
            if (!looseArgs.isEmpty()) {
                Argument a = new Argument(this.getArgument());
                a.setValue(looseArgs);
                looseArgs.clear();
                return a;
            }
            return null;
        }
        Argument finishedArgument = new Argument(arg);
        if (arg.isSingle()) {
            if (looseArgs.size() > 0) {
                String looseArg = looseArgs.get(0);
                looseArgs.remove(0);
                finishedArgument.setValue(looseArg);
                if (arg.isNumeric()) {
                    try {
                        Double.parseDouble(looseArg);
                    }
                    catch (NumberFormatException e) {
                        throw new ValidationException("Expecting a numeric value, but \"" + looseArg + "\" was encountered.");
                    }
                }
            } else {
                finishedArgument.setValue("");
            }
        } else if (arg.isArray()) {
            finishedArgument.setValue(looseArgs);
            if (arg.isNumeric()) {
                for (String val : looseArgs) {
                    try {
                        Double.parseDouble(val);
                    }
                    catch (NumberFormatException e) {
                        throw new ValidationException("Expecting a numeric value, but \"" + val + "\" was encountered.");
                    }
                }
            }
            looseArgs.clear();
        }
        return finishedArgument;
    }

    private static final class Argument {
        Character shortArg;
        String longArg;
        Type argType;
        String defaultVal;
        List<String> defaultList;
        String description;
        String usageName;
        boolean required;
        String singleVal;
        List<String> arrayVal;

        private Argument(Argument arg) {
            if (arg == null) {
                return;
            }
            this.shortArg = arg.shortArg;
            this.longArg = arg.longArg;
            this.argType = arg.argType;
            this.defaultVal = arg.defaultVal;
            this.description = arg.description;
            this.usageName = arg.usageName;
            this.required = arg.required;
        }

        private Argument(Character shortArg, String longArg, Type argType, String defaultVal, String description, String usageName, boolean required) {
            this.shortArg = shortArg;
            this.longArg = longArg;
            this.argType = argType;
            this.description = description;
            this.defaultVal = defaultVal;
            if (this.isArray() && defaultVal != null) {
                this.defaultList = ArgumentParser.lex(defaultVal);
            }
            this.usageName = usageName;
            this.required = required;
        }

        public final boolean isFlag() {
            return this.argType == Type.BOOLEAN;
        }

        public final boolean isArray() {
            return this.argType == Type.ARRAY_OF_NUMBERS || this.argType == Type.ARRAY_OF_STRINGS;
        }

        public final boolean isSingle() {
            return this.argType == Type.NUMBER || this.argType == Type.STRING;
        }

        public final boolean isNumeric() {
            return this.argType == Type.NUMBER || this.argType == Type.ARRAY_OF_NUMBERS;
        }

        private void setValue(String val) {
            if (this.isArray()) {
                this.arrayVal = ArgumentParser.lex(val);
            } else {
                this.singleVal = val;
            }
        }

        private void setValue(List<String> val) {
            this.arrayVal = new ArrayList<String>(val);
        }

        public boolean modelEquals(Argument obj) {
            if (this.shortArg != null) {
                return this.shortArg.equals(obj.shortArg);
            }
            if (this.longArg != null) {
                return this.longArg.equals(obj.longArg);
            }
            return obj.shortArg == null && obj.longArg == null;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            if (this.longArg != null && this.shortArg != null) {
                b.append("--").append(this.longArg).append("/").append("-").append(this.shortArg);
            } else if (this.longArg != null) {
                b.append("--").append(this.longArg);
            } else if (this.shortArg != null) {
                b.append("-").append(this.shortArg);
            }
            b.append(": ");
            if (this.isSingle()) {
                b.append(this.singleVal);
            } else if (this.isArray()) {
                boolean first = true;
                b.append("[");
                for (String s : this.arrayVal) {
                    if (!first) {
                        b.append(", ");
                    }
                    first = false;
                    b.append("\"").append(s.replaceAll("\"", "\\\"")).append("\"");
                }
                b.append("]");
            }
            b.append("\n");
            return b.toString();
        }

        private String generateDescription(boolean shortCode) {
            StringBuilder b = new StringBuilder();
            b.append("\t");
            if (this.shortArg == null && this.longArg == null) {
                b.append("<").append(this.usageName).append(">: ").append(this.description).append("\n");
            } else {
                if (shortCode) {
                    b.append(TermColors.GREEN).append("-").append(this.shortArg).append(TermColors.RESET);
                } else {
                    b.append(TermColors.GREEN).append("--").append(this.longArg).append(TermColors.RESET);
                }
                b.append(": ");
                if (!shortCode && this.shortArg != null) {
                    b.append("Alias to -").append(this.shortArg);
                } else {
                    if (this.argType != Type.BOOLEAN) {
                        if (this.required) {
                            b.append("Required. ");
                        } else {
                            b.append("Optional. ");
                        }
                    }
                    if (this.argType == Type.NUMBER) {
                        b.append("A numeric value. ");
                    }
                    if (this.argType == Type.ARRAY_OF_NUMBERS) {
                        b.append("A list of numbers. ");
                    }
                    if (this.argType == Type.ARRAY_OF_STRINGS) {
                        b.append("A list. ");
                    }
                    b.append(this.description.replaceAll("\n", "\n\t\t"));
                }
                b.append("\n");
            }
            return b.toString();
        }
    }

    public static class ArgumentBuilder {
        Mode mode;
        char shortArg;
        String longArg;
        String description;
        String usageName;
        boolean required;
        Type argType = Type.ARRAY_OF_STRINGS;
        String defaultValue;

        public ArgumentBuilderRequired2 setDescription(String description) {
            Objects.requireNonNull(description, "description may not be null");
            this.description = description;
            return new ArgumentBuilderRequired2();
        }

        public class ArgumentBuilderRequired2 {
            ArgumentBuilderRequired2() {
            }

            public ArgumentBuilderRequired3 setUsageName(String usageName) {
                Objects.requireNonNull(usageName, "usageName may not be null");
                ArgumentBuilder.this.usageName = usageName;
                return new ArgumentBuilderRequired3();
            }

            public FlagBuilderMode asFlag() {
                return new FlagBuilderMode();
            }
        }

        public final class RequiredArgumentBuilderOptional
        extends ArgumentBuilderFinal {
            RequiredArgumentBuilderOptional() {
            }

            public RequiredArgumentBuilderOptional setArgType(BuilderTypeNonFlag argType) {
                Objects.requireNonNull(argType, "argType cannot be null");
                ArgumentBuilder.this.argType = argType.getType();
                return this;
            }

            @Override
            Argument build() {
                return new OptionalArgumentBuilderOptional().build();
            }
        }

        public final class OptionalArgumentBuilderOptional
        extends ArgumentBuilderFinal {
            OptionalArgumentBuilderOptional() {
            }

            public OptionalArgumentBuilderOptional setArgType(BuilderTypeNonFlag argType) {
                Objects.requireNonNull(argType, "argType cannot be null");
                ArgumentBuilder.this.argType = argType.getType();
                return this;
            }

            public OptionalArgumentBuilderOptional setDefaultVal(String defaultVal) {
                if (ArgumentBuilder.this.required) {
                    throw new IllegalArgumentException("Required arguments cannot have a default value provided");
                }
                ArgumentBuilder.this.defaultValue = defaultVal;
                return this;
            }

            @Override
            Argument build() {
                return new Argument(ArgumentBuilder.this.shortArg == '\u0000' ? null : Character.valueOf(ArgumentBuilder.this.shortArg), ArgumentBuilder.this.longArg, ArgumentBuilder.this.argType, ArgumentBuilder.this.defaultValue, ArgumentBuilder.this.description, ArgumentBuilder.this.usageName, ArgumentBuilder.this.required);
            }
        }

        public final class ArgumentBuilderFlag
        extends ArgumentBuilderFinal {
            private ArgumentBuilderFlag() {
            }

            @Override
            Argument build() {
                return new OptionalArgumentBuilderOptional().build();
            }
        }

        public abstract class ArgumentBuilderFinal {
            private ArgumentBuilderFinal() {
            }

            abstract Argument build();
        }

        public static enum BuilderTypeNonFlag {
            STRING(Type.STRING),
            ARRAY_OF_STRINGS(Type.ARRAY_OF_STRINGS),
            NUMBER(Type.NUMBER),
            ARRAY_OF_NUMBERS(Type.ARRAY_OF_NUMBERS);

            Type type;

            private BuilderTypeNonFlag(Type type) {
                this.type = type;
            }

            Type getType() {
                return this.type;
            }
        }

        public class RequiredArgumentBuilderMode {
            public RequiredArgumentBuilderOptional setName(char shortArg) {
                if (shortArg == '\u0000') {
                    throw new NullPointerException("shortArg may not be the null character");
                }
                if (!Character.isAlphabetic(shortArg)) {
                    throw new IllegalArgumentException("shortArg must be a alphabetical character");
                }
                ArgumentBuilder.this.mode = Mode.SHORT;
                ArgumentBuilder.this.shortArg = shortArg;
                return new RequiredArgumentBuilderOptional();
            }

            public RequiredArgumentBuilderOptional setName(String longArg) {
                Objects.requireNonNull(longArg, "longArg must not be null");
                ArgumentBuilder.this.mode = Mode.LONG;
                ArgumentBuilder.this.longArg = longArg;
                return new RequiredArgumentBuilderOptional();
            }

            public RequiredArgumentBuilderOptional setName(char shortArg, String longArg) {
                this.setName(shortArg);
                this.setName(longArg);
                ArgumentBuilder.this.mode = Mode.BOTH;
                return new RequiredArgumentBuilderOptional();
            }

            public RequiredArgumentBuilderOptional asDefault() {
                ArgumentBuilder.this.mode = Mode.DEFAULT;
                return new RequiredArgumentBuilderOptional();
            }
        }

        public class OptionalArgumentBuilderMode {
            public OptionalArgumentBuilderOptional setName(char shortArg) {
                if (shortArg == '\u0000') {
                    throw new NullPointerException("shortArg may not be the null character");
                }
                if (!Character.isAlphabetic(shortArg)) {
                    throw new IllegalArgumentException("shortArg must be a alphabetical character");
                }
                ArgumentBuilder.this.mode = Mode.SHORT;
                ArgumentBuilder.this.shortArg = shortArg;
                return new OptionalArgumentBuilderOptional();
            }

            public OptionalArgumentBuilderOptional setName(String longArg) {
                Objects.requireNonNull(longArg, "longArg must not be null");
                ArgumentBuilder.this.mode = Mode.LONG;
                ArgumentBuilder.this.longArg = longArg;
                return new OptionalArgumentBuilderOptional();
            }

            public OptionalArgumentBuilderOptional setName(char shortArg, String longArg) {
                this.setName(shortArg);
                this.setName(longArg);
                ArgumentBuilder.this.mode = Mode.BOTH;
                return new OptionalArgumentBuilderOptional();
            }

            public OptionalArgumentBuilderOptional asDefault() {
                ArgumentBuilder.this.mode = Mode.DEFAULT;
                return new OptionalArgumentBuilderOptional();
            }
        }

        public class FlagBuilderMode {
            public ArgumentBuilderFlag setName(char shortArg) {
                new OptionalArgumentBuilderMode().setName(shortArg);
                ArgumentBuilder.this.argType = Type.BOOLEAN;
                return new ArgumentBuilderFlag();
            }

            public ArgumentBuilderFlag setName(String longArg) {
                new OptionalArgumentBuilderMode().setName(longArg);
                ArgumentBuilder.this.argType = Type.BOOLEAN;
                return new ArgumentBuilderFlag();
            }

            public ArgumentBuilderFlag setName(char shortArg, String longArg) {
                new OptionalArgumentBuilderMode().setName(shortArg, longArg);
                ArgumentBuilder.this.argType = Type.BOOLEAN;
                return new ArgumentBuilderFlag();
            }
        }

        public class ArgumentBuilderRequired3 {
            ArgumentBuilderRequired3() {
            }

            public RequiredArgumentBuilderMode setRequired() {
                ArgumentBuilder.this.required = true;
                return new RequiredArgumentBuilderMode();
            }

            public RequiredArgumentBuilderOptional setRequiredAndDefault() {
                return this.setRequired().asDefault();
            }

            public OptionalArgumentBuilderMode setOptional() {
                ArgumentBuilder.this.required = false;
                return new OptionalArgumentBuilderMode();
            }

            public OptionalArgumentBuilderOptional setOptionalAndDefault() {
                return this.setOptional().asDefault();
            }
        }

        static enum Mode {
            SHORT,
            LONG,
            BOTH,
            DEFAULT;

        }
    }

    static enum Type {
        STRING,
        NUMBER,
        ARRAY_OF_STRINGS,
        ARRAY_OF_NUMBERS,
        BOOLEAN;

    }

    public final class ArgumentParserResults {
        List<Argument> arguments = new ArrayList<Argument>();
        List<String> unclassified = new ArrayList<String>();
        List<String> rawArgs;

        private ArgumentParserResults(List<String> rawArgs) {
            this.rawArgs = new ArrayList<String>(rawArgs);
        }

        private void updateArgument(Argument a) {
            if (a == null) {
                return;
            }
            ArrayList<Argument> toRemove = new ArrayList<Argument>();
            for (Argument arg : this.arguments) {
                if (!arg.modelEquals(a)) continue;
                toRemove.add(arg);
            }
            for (Argument arg : toRemove) {
                this.arguments.remove(arg);
            }
            this.arguments.add(a);
        }

        private void updateUnclassifiedArgument(String a) {
            this.unclassified.add(a);
        }

        public boolean isFlagSet(Character flag) {
            return this.getArg(flag) != null;
        }

        public boolean isFlagSet(String flag) {
            return this.getArg(flag) != null;
        }

        public String getStringArgument() {
            try {
                Argument a = this.getArg();
                if (a.arrayVal == null) {
                    return "";
                }
                StringBuilder b = new StringBuilder();
                boolean first = true;
                for (String val : a.arrayVal) {
                    if (!first) {
                        b.append(" ");
                    }
                    first = false;
                    b.append(val);
                }
                return b.toString();
            }
            catch (ResultUseException e) {
                return "";
            }
        }

        public String getStringArgument(Character flag) throws ResultUseException {
            return this.getStringArgument(this.getArg(flag));
        }

        public String getStringArgument(String flag) throws ResultUseException {
            return this.getStringArgument(this.getArg(flag));
        }

        private String getStringArgument(Argument arg) {
            if (arg == null) {
                return null;
            }
            if (arg.argType != Type.STRING) {
                throw new ClassCastException("Argument type not set to " + Type.STRING.name() + ". Cannot return a string.");
            }
            return arg.singleVal;
        }

        public Double getNumberArgument(Character flag) throws ResultUseException {
            return this.getNumberArgument(this.getArg(flag));
        }

        public Double getNumberArgument(String flag) throws ResultUseException {
            return this.getNumberArgument(this.getArg(flag));
        }

        private Double getNumberArgument(Argument arg) {
            if (arg == null) {
                return null;
            }
            if (arg.argType != Type.NUMBER) {
                throw new ClassCastException("Argument type not set to " + Type.NUMBER.name() + ". Cannot return a number.");
            }
            return Double.parseDouble(arg.singleVal);
        }

        public List<String> getStringListArgument() {
            try {
                Argument a = this.getArg();
                if (a.arrayVal == null) {
                    return new ArrayList<String>();
                }
                return new ArrayList<String>(a.arrayVal);
            }
            catch (ResultUseException e) {
                return new ArrayList<String>();
            }
        }

        public List<String> getStringListArgument(Character flag) throws ResultUseException {
            return this.getStringListArgument(this.getArg(flag));
        }

        public List<String> getStringListArgument(Character flag, List<String> defaultReturn) throws ResultUseException {
            List<String> d = this.getStringListArgument(flag);
            if (d == null) {
                return defaultReturn;
            }
            return d;
        }

        public List<String> getStringListArgument(String flag) throws ResultUseException {
            return this.getStringListArgument(this.getArg(flag));
        }

        public List<String> getStringListArgument(String flag, List<String> defaultReturn) throws ResultUseException {
            List<String> d = this.getStringListArgument(flag);
            if (d == null) {
                return defaultReturn;
            }
            return d;
        }

        private List<String> getStringListArgument(Argument arg) {
            if (arg == null) {
                return null;
            }
            if (arg.argType != Type.ARRAY_OF_STRINGS) {
                throw new ClassCastException("Argument type not set to " + Type.ARRAY_OF_STRINGS.name() + ". Cannot return a string list.");
            }
            return new ArrayList<String>(arg.arrayVal);
        }

        public List<Double> getNumberListArgument(Character flag) throws ResultUseException {
            return this.getNumberListArgument(this.getArg(flag));
        }

        public List<Double> getNumberListArgument(String flag) throws ResultUseException {
            return this.getNumberListArgument(this.getArg(flag));
        }

        private List<Double> getNumberListArgument(Argument arg) {
            if (arg == null) {
                return null;
            }
            if (arg.argType != Type.ARRAY_OF_NUMBERS) {
                throw new ClassCastException("Argument type not set to " + Type.ARRAY_OF_NUMBERS.name() + ". Cannot return a number list.");
            }
            ArrayList<Double> list = new ArrayList<Double>();
            for (String s : arg.arrayVal) {
                list.add(Double.parseDouble(s));
            }
            return list;
        }

        private Argument getArg() {
            for (Argument a : this.arguments) {
                if (a.shortArg != null || a.longArg != null) continue;
                return a;
            }
            return new Argument(ArgumentParser.this.getArgument());
        }

        private Argument getArg(Character flag) throws ResultUseException {
            for (Argument a : this.arguments) {
                if (a.shortArg == null || !a.shortArg.equals(flag)) continue;
                return a;
            }
            return null;
        }

        private Argument getArg(String flag) throws ResultUseException {
            for (Argument a : this.arguments) {
                if (a.longArg == null || !a.longArg.equals(flag)) continue;
                return a;
            }
            return null;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            for (Argument arg : this.arguments) {
                if (arg.isFlag()) {
                    b.append("Flag ");
                    if (arg.longArg != null && arg.shortArg != null) {
                        b.append("--").append(arg.longArg).append("/").append("-").append(arg.shortArg);
                    } else if (arg.longArg != null) {
                        b.append("--").append(arg.longArg);
                    } else if (arg.shortArg != null) {
                        b.append("-").append(arg.shortArg);
                    }
                    b.append(" is set.\n");
                    continue;
                }
                b.append(arg.toString());
            }
            return b.toString();
        }

        public List<String> getRawArguments() {
            return new ArrayList<String>(this.rawArgs);
        }
    }

    public static final class ValidationException
    extends Exception {
        private ValidationException(String string) {
            super(string);
        }
    }

    public static class ResultUseException
    extends RuntimeException {
        ResultUseException(String string) {
            super(string);
        }
    }
}

