/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Common.MutableObject;
import com.laytonsmith.PureUtilities.Common.Range;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.core;
import com.laytonsmith.annotations.hide;
import com.laytonsmith.annotations.noboilerplate;
import com.laytonsmith.annotations.seealso;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.Optimizable;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.compiler.signature.FunctionSignatures;
import com.laytonsmith.core.compiler.signature.SignatureBuilder;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.environments.StaticRuntimeEnv;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREInsufficientArgumentsException;
import com.laytonsmith.core.exceptions.CRE.CREInterruptedException;
import com.laytonsmith.core.exceptions.CRE.CRENullPointerException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.ProgramFlowManipulationException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.functions.ExampleScript;
import com.laytonsmith.core.functions.Meta;
import com.laytonsmith.core.functions.Threading;
import com.laytonsmith.core.natives.interfaces.Callable;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.profiler.ProfilePoint;
import com.laytonsmith.core.taskmanager.CoreTaskType;
import com.laytonsmith.core.taskmanager.TaskHandler;
import com.laytonsmith.core.taskmanager.TaskManager;
import com.laytonsmith.core.taskmanager.TaskState;
import com.laytonsmith.core.taskmanager.TimeoutTaskHandler;
import com.laytonsmith.tools.docgen.DocGenTemplates;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@core
public class Scheduling {
    public static void ClearScheduledRunners() {
        StaticLayer.ClearAllRunnables();
    }

    public static String docs() {
        return "This class contains methods for dealing with time and server scheduling.";
    }

    @api
    public static class clear_cron
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRERangeException.class, CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            Integer id = (Integer)environment.getEnv(GlobalEnv.class).GetCustom("cron-task-id");
            if (args2.length == 1) {
                id = (int)ArgumentValidation.getInt(args2[0], t);
            }
            if (id == null) {
                throw new CRERangeException("No task ID provided, and not running from within a cron task.", t);
            }
            if (!set_cron.stopJob(id)) {
                throw new CRERangeException("Task ID invalid", t);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "clear_cron";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        @Override
        public String docs() {
            return "void {[cronID]} Clears the previously registered cron job from the registered list. This will prevent the task from running again in the future. If run from within a cron task, the id is optional, and the current task will be prevented from running again in the future. If the ID provided is invalid, a RangeException is thrown.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class set_cron
    extends AbstractFunction
    implements Optimizable {
        private static Thread cronThread = null;
        private static final Object CRON_THREAD_LOCK = new Object();
        private static final Map<Integer, CronFormat> CRON_JOBS = new HashMap<Integer, CronFormat>();
        private static final AtomicInteger JOB_IDS = new AtomicInteger(1);
        private static final Map<String, Integer> MONTHS = new HashMap<String, Integer>();
        private static final Map<String, Integer> DAYS = new HashMap<String, Integer>();
        private static final Map<String, Integer> HOURS = new HashMap<String, Integer>();
        private static final Pattern RANGE = Pattern.compile("(\\d+)-(\\d+)");
        private static final Pattern EVERY = Pattern.compile("\\*/(\\d+)");
        private static final List<Range> RANGES = Arrays.asList(new Range(0, 59), new Range(0, 23), new Range(1, 31), new Range(1, 12), new Range(0, 6));

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean stopJob(int jobID) {
            Map<Integer, CronFormat> map = CRON_JOBS;
            synchronized (map) {
                if (CRON_JOBS.containsKey(jobID)) {
                    CRON_JOBS.remove(jobID);
                    return true;
                }
                return false;
            }
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CREFormatException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            if (!args2[0].isInstanceOf(CString.TYPE)) {
                throw new CRECastException("Expected string for argument 1 in " + this.getName(), t);
            }
            if (!args2[1].isInstanceOf(CClosure.TYPE)) {
                throw new CRECastException("Expected closure for argument 2 in " + this.getName(), t);
            }
            CronFormat format = this.validateFormat(args2[0].val(), t);
            format.job = (CClosure)args2[1];
            Object object = CRON_THREAD_LOCK;
            synchronized (object) {
                if (cronThread == null) {
                    DaemonManager dm = environment.getEnv(StaticRuntimeEnv.class).GetDaemonManager();
                    MutableObject<Boolean> stopCron = new MutableObject<Boolean>(false);
                    StaticLayer.GetConvertor().addShutdownHook(() -> {
                        cronThread = null;
                        stopCron.setObject(true);
                        Object object = CRON_JOBS;
                        synchronized (object) {
                            CRON_JOBS.clear();
                        }
                        object = CRON_THREAD_LOCK;
                        synchronized (object) {
                            CRON_THREAD_LOCK.notifyAll();
                        }
                    });
                    cronThread = new Thread(() -> {
                        long lastMinute = 0L;
                        while (!((Boolean)stopCron.getObject()).booleanValue()) {
                            Map<Integer, CronFormat> map;
                            if (System.currentTimeMillis() / 1000L / 60L > lastMinute) {
                                lastMinute = System.currentTimeMillis() / 1000L / 60L;
                                map = CRON_JOBS;
                                synchronized (map) {
                                    Calendar c = Calendar.getInstance();
                                    for (CronFormat f : CRON_JOBS.values()) {
                                        if (!f.min.contains(c.get(12)) || !f.hour.contains(c.get(11)) || !f.day.contains(c.get(5)) || !f.month.contains(c.get(2) + 1) || !f.dayOfWeek.contains(c.get(7) - 1)) continue;
                                        StaticLayer.GetConvertor().runOnMainThreadLater(dm, () -> {
                                            try {
                                                f.job.executeCallable(new Mixed[0]);
                                            }
                                            catch (ConfigRuntimeException ex) {
                                                ConfigRuntimeException.HandleUncaughtException(ex, f.job.getEnv());
                                            }
                                        });
                                    }
                                }
                            }
                            map = CRON_THREAD_LOCK;
                            synchronized (map) {
                                try {
                                    CRON_THREAD_LOCK.wait(1000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                        dm.deactivateThread(cronThread);
                    }, Implementation.GetServerType().getBranding() + "-CronDaemon");
                    dm.activateThread(cronThread);
                    cronThread.start();
                }
            }
            int jobID = JOB_IDS.getAndIncrement();
            Map<Integer, CronFormat> map = CRON_JOBS;
            synchronized (map) {
                CRON_JOBS.put(jobID, format);
                format.job.getEnv().getEnv(GlobalEnv.class).SetCustom("cron-task-id", jobID);
            }
            return new CInt(jobID, t);
        }

        private CronFormat validateFormat(String format, Target t) {
            Range range2;
            format = format.trim();
            format = format.replace("\t", " ");
            format = format.replaceAll("( )+", " ");
            if ("@yearly".equals(format = format.toLowerCase()) || "@annually".equals(format)) {
                format = "0 0 1 1 *";
            }
            if ("@monthly".equals(format)) {
                format = "0 0 1 * *";
            }
            if ("@weekly".equals(format)) {
                format = "0 0 * * 0";
            }
            if ("@daily".equals(format)) {
                format = "0 0 * * *";
            }
            if ("@hourly".equals(format)) {
                format = "0 * * * *";
            }
            if (format.matches("[^a-z0-9\\*\\-,@/]")) {
                throw new CREFormatException("Invalid characters found in format for " + this.getName() + ": \"" + format + "\". Check your format and try again.", t);
            }
            String[] sformat = format.split(" ");
            if (sformat.length != 5) {
                throw new CREFormatException("Expected 5 segments in " + this.getName() + ", but " + StringUtils.PluralTemplateHelper(sformat.length, "%d was", "%d were") + " found.", t);
            }
            String min2 = sformat[0];
            String hour = sformat[1];
            String day = sformat[2];
            String month = sformat[3];
            String dayOfWeek = sformat[4];
            for (String key : MONTHS.keySet()) {
                month = month.replace(key, Integer.toString(MONTHS.get(key)));
            }
            for (String key : DAYS.keySet()) {
                dayOfWeek = dayOfWeek.replace(key, Integer.toString(DAYS.get(key)));
            }
            for (String key : HOURS.keySet()) {
                hour = hour.replace(key, Integer.toString(HOURS.get(key)));
            }
            ArrayList<String> minList = new ArrayList<String>(Arrays.asList(min2.split(",")));
            ArrayList<String> hourList = new ArrayList<String>(Arrays.asList(hour.split(",")));
            ArrayList<String> dayList = new ArrayList<String>(Arrays.asList(day.split(",")));
            ArrayList<String> monthList = new ArrayList<String>(Arrays.asList(month.split(",")));
            ArrayList<String> dayOfWeekList = new ArrayList<String>(Arrays.asList(dayOfWeek.split(",")));
            List<List> segments = Arrays.asList(minList, hourList, dayList, monthList, dayOfWeekList);
            for (int i = 0; i < segments.size(); ++i) {
                List segment = segments.get(i);
                Iterator it = segment.iterator();
                ArrayList<String> addAll = new ArrayList<String>();
                range2 = RANGES.get(i);
                while (it.hasNext()) {
                    String part = (String)it.next();
                    Matcher rangeMatcher = RANGE.matcher(part);
                    if (rangeMatcher.find()) {
                        it.remove();
                        Integer minRange = Integer.parseInt(rangeMatcher.group(1));
                        Integer maxRange = Integer.parseInt(rangeMatcher.group(2));
                        Range r = new Range(minRange, maxRange);
                        if (!r.isAscending()) {
                            throw new CREFormatException("Ranges must be min to max, and not the same value in format for " + this.getName(), t);
                        }
                        List<Integer> rr = r.getRange();
                        for (int j = 0; j < rr.size(); ++j) {
                            addAll.add(Integer.toString(rr.get(j)));
                        }
                        continue;
                    }
                    Matcher everyMatcher = EVERY.matcher(part);
                    if (everyMatcher.find()) {
                        it.remove();
                        Integer every = Integer.parseInt(everyMatcher.group(1));
                        for (int j = range2.getMin(); j <= range2.getMax(); j += every.intValue()) {
                            addAll.add(Integer.toString(j));
                        }
                    }
                    if (!"*".equals(part)) continue;
                    it.remove();
                    for (int j = range2.getMin(); j <= range2.getMax(); ++j) {
                        addAll.add(Integer.toString(j));
                    }
                }
                segment.addAll(addAll);
                Collections.sort(segment);
            }
            CronFormat f = new CronFormat();
            block17: for (int i = 0; i < 5; ++i) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                List segment = segments.get(i);
                range2 = RANGES.get(i);
                for (String s : segment) {
                    try {
                        list.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException ex) {
                        throw new CREFormatException("Unknown string passed in format for " + this.getName() + " \"" + s + "\"", t);
                    }
                }
                Collections.sort(list);
                if (!range2.contains((Integer)list.get(0))) {
                    throw new CREFormatException("Expecting value to be within the range " + String.valueOf(range2) + " in format for " + this.getName() + ", but the value was " + String.valueOf(list.get(0)), t);
                }
                if (!range2.contains((Integer)list.get(list.size() - 1))) {
                    throw new CREFormatException("Expecting value to be within the range " + String.valueOf(range2) + " in format for " + this.getName() + ", but the value was " + String.valueOf(list.get(list.size() - 1)), t);
                }
                TreeSet<Integer> set = new TreeSet<Integer>(list);
                switch (i) {
                    case 0: {
                        f.min = set;
                        continue block17;
                    }
                    case 1: {
                        f.hour = set;
                        continue block17;
                    }
                    case 2: {
                        f.day = set;
                        continue block17;
                    }
                    case 3: {
                        f.month = set;
                        continue block17;
                    }
                    case 4: {
                        f.dayOfWeek = set;
                    }
                }
            }
            return f;
        }

        @Override
        public String getName() {
            return "set_cron";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return this.getBundledDocs();
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            if (children.get(0).isConst() && children.get(0).getData().isInstanceOf(CString.TYPE)) {
                this.validateFormat(children.get(0).getData().val(), t);
            }
            return null;
        }

        static {
            MONTHS.put("jan", 1);
            MONTHS.put("feb", 2);
            MONTHS.put("mar", 3);
            MONTHS.put("apr", 4);
            MONTHS.put("may", 5);
            MONTHS.put("jun", 6);
            MONTHS.put("jul", 7);
            MONTHS.put("aug", 8);
            MONTHS.put("sep", 9);
            MONTHS.put("oct", 10);
            MONTHS.put("nov", 11);
            MONTHS.put("dec", 12);
            MONTHS.put("january", 1);
            MONTHS.put("february", 2);
            MONTHS.put("febuary", 2);
            MONTHS.put("march", 3);
            MONTHS.put("april", 4);
            MONTHS.put("may", 5);
            MONTHS.put("june", 6);
            MONTHS.put("july", 7);
            MONTHS.put("august", 8);
            MONTHS.put("september", 9);
            MONTHS.put("october", 10);
            MONTHS.put("november", 11);
            MONTHS.put("december", 12);
            DAYS.put("sun", 0);
            DAYS.put("mon", 1);
            DAYS.put("tue", 2);
            DAYS.put("wed", 3);
            DAYS.put("thu", 4);
            DAYS.put("fri", 5);
            DAYS.put("sat", 6);
            DAYS.put("sunday", 0);
            DAYS.put("monday", 1);
            DAYS.put("tuesday", 2);
            DAYS.put("wednesday", 3);
            DAYS.put("thursday", 4);
            DAYS.put("friday", 5);
            DAYS.put("saturday", 6);
            HOURS.put("midnight", 0);
            HOURS.put("noon", 12);
        }

        private static class CronFormat {
            public Set<Integer> min = new HashSet<Integer>();
            public Set<Integer> hour = new HashSet<Integer>();
            public Set<Integer> day = new HashSet<Integer>();
            public Set<Integer> month = new HashSet<Integer>();
            public Set<Integer> dayOfWeek = new HashSet<Integer>();
            public CClosure job;

            private CronFormat() {
            }

            public String toString() {
                return String.valueOf(this.min) + "\n" + String.valueOf(this.hour) + "\n" + String.valueOf(this.day) + "\n" + String.valueOf(this.month) + "\n" + String.valueOf(this.dayOfWeek);
            }
        }
    }

    @api
    public static class get_system_timezones
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            String[] timezones = ArrayUtils.EMPTY_STRING_ARRAY;
            try {
                timezones = TimeZone.getAvailableIDs();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            ArrayList<String> tz = new ArrayList<String>(Arrays.asList(timezones));
            Collections.sort(tz);
            CArray ret = new CArray(t);
            for (String s : tz) {
                ret.push(new CString(s, t), t);
            }
            return ret;
        }

        @Override
        public String getName() {
            return "get_system_timezones";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0};
        }

        @Override
        public String docs() {
            return "array&lt;string&gt; {} Returns a list of time zones registered on this system.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api
    @seealso(value={simple_date.class})
    public static class parse_date
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREFormatException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            String countryCode;
            Locale locale = Locale.getDefault();
            if (args2.length >= 3 && (locale = (countryCode = Construct.nval(args2[2])) == null ? Locale.getDefault() : Static.GetLocale(countryCode)) == null) {
                throw new CREFormatException("The given locale was not found on your system: " + countryCode, t);
            }
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(args2[0].toString(), locale);
                Date d = dateFormat.parse(args2[1].val());
                return new CInt(d.getTime(), t);
            }
            catch (IllegalArgumentException | ParseException ex) {
                throw new CREFormatException(ex.getMessage(), t);
            }
        }

        @Override
        public String getName() {
            return "parse_date";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        @Override
        public String docs() {
            return "int {dateFormat, dateString, [locale]} Parses a date string, and returns an integer timestamp representing that time. This essentially works in reverse of {{function|simple_date}}. The dateFormat string is the same as simple_date, see the documentation for that function to see full details on that. The dateString is the actual date to be parsed. The dateFormat should be the equivalent format that was used to generate the dateString. In general, this function is fairly lenient, and will still try to parse a dateString that doesn't necessarily conform to the given format, but it shouldn't be relied on to work with malformed data. Various portions of the date may be left off, in which case the missing portions will be assumed, for instance, if the time is left off completely, it is assumed to be midnight, and if the minutes are left off,  it is assumed to be on the hour, if the date is left off, it is assumed to be today, etc.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Simple example", "parse_date('yyMMddHHmmssZ', '130605114256-0500')"), new ExampleScript("Using the results of simple_date", "@format = 'EEE, d MMM yyyy HH:mm:ss Z';\nmsg(parse_date(@format, simple_date(@format, 1)));")};
        }
    }

    @api
    @seealso(value={Meta.get_locales.class})
    public static class simple_date
    extends AbstractFunction {
        @Override
        public String getName() {
            return "simple_date";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3, 4};
        }

        @Override
        public String docs() {
            HashMap<String, DocGenTemplates.Generator> map = new HashMap<String, DocGenTemplates.Generator>();
            map.put("timezoneValues", args2 -> {
                String[] timezones = ArrayUtils.EMPTY_STRING_ARRAY;
                try {
                    timezones = TimeZone.getAvailableIDs();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ArrayList<String> tz = new ArrayList<String>(Arrays.asList(timezones));
                Collections.sort(tz);
                return StringUtils.Join(tz, ", ", " or ", " or ", "Couldn't retrieve the list of timezones!");
            });
            try {
                return this.getBundledDocs(map);
            }
            catch (DocGenTemplates.Generator.GenerateException ex) {
                Logger.getLogger(Scheduling.class.getName()).log(Level.SEVERE, null, ex);
                return this.getBundledDocs();
            }
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CREFormatException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public CString exec(Target t, Environment env, Mixed ... args2) {
            SimpleDateFormat dateFormat;
            String countryCode;
            Date now = new Date();
            if (args2.length >= 2 && !(args2[1] instanceof CNull)) {
                now = new Date(ArgumentValidation.getInt(args2[1], t));
            }
            TimeZone timezone = TimeZone.getDefault();
            if (args2.length >= 3 && Construct.nval(args2[2]) != null) {
                timezone = TimeZone.getTimeZone(args2[2].val());
            }
            Locale locale = Locale.getDefault();
            if (args2.length >= 4 && (locale = (countryCode = Construct.nval(args2[3])) == null ? Locale.getDefault() : Static.GetLocale(countryCode)) == null) {
                throw new CREFormatException("The given locale was not found on your system: " + countryCode, t);
            }
            try {
                dateFormat = new SimpleDateFormat(args2[0].toString(), locale);
            }
            catch (IllegalArgumentException ex) {
                throw new CREFormatException(ex.getMessage(), t);
            }
            dateFormat.setTimeZone(timezone);
            return new CString(dateFormat.format(now), t);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "simple_date('h:mm a')", ":11:36 AM"), new ExampleScript("Usage with quoted letters", "simple_date('yyyy.MM.dd G \\'at\\' HH:mm:ss z')", ":2013.06.13 AD at 11:36:46 CDT"), new ExampleScript("Adding a single quote", "simple_date('EEE, MMM d, \\'\\'yy')", ":Wed, Jun 5, '13"), new ExampleScript("Specifying alternate time", "simple_date('EEE, MMM d, \\'\\'yy', 0)"), new ExampleScript("With timezone", "simple_date('hh \\'o\\'\\'clock\\' a, zzzz')", ":11 o'clock AM, Central Daylight Time"), new ExampleScript("With timezone", "simple_date('hh \\'o\\'\\'clock\\' a, zzzz')", ":11 o'clock AM, Central Daylight Time"), new ExampleScript("With simple timezone", "simple_date('K:mm a, z')", ":11:42 AM, CDT"), new ExampleScript("With alternate timezone", "simple_date('K:mm a, z', time(), 'GMT')", ":4:42 PM, GMT"), new ExampleScript("With 5 digit year", "simple_date('yyyyy.MMMMM.dd GGG hh:mm aaa')", ":02013.June.05 AD 11:42 AM"), new ExampleScript("Long format", "simple_date('EEE, d MMM yyyy HH:mm:ss Z')", ":Wed, 5 Jun 2013 11:42:56 -0500"), new ExampleScript("Long format with alternate locale", "simple_date('EEE, d MMM yyyy HH:mm:ss Z', 1444418254496, 'CET', 'no_NO')"), new ExampleScript("Computer readable format", "simple_date('yyMMddHHmmssZ')", ":130605114256-0500"), new ExampleScript("With milliseconds", "simple_date('yyyy-MM-dd\\'T\\'HH:mm:ss.SSSZ')", ":2013-06-05T11:42:56.799-0500")};
        }
    }

    @api(environments={GlobalEnv.class})
    public static class clear_task
    extends AbstractFunction {
        @Override
        public String getName() {
            return "clear_task";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        @Override
        public String docs() {
            return "void {[id]} Stops the interval or timeout that is specified. The id can be gotten by storing the integer returned from either set_timeout or set_interval. An invalid id is simply ignored. The clear_task function is more useful for set_timeout, where you may queue up some task to happen in the far future, yet have some trigger to prevent it from happening. ID is optional, but only if called from within a set_interval or set_timeout closure, in which case it defaults to the id of that particular task.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CREInsufficientArgumentsException.class, CRENullPointerException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            if (args2.length == 0 && environment.getEnv(GlobalEnv.class).GetCustom("timeout-id") != null) {
                StaticLayer.ClearFutureRunnable((Integer)environment.getEnv(GlobalEnv.class).GetCustom("timeout-id"));
            } else if (args2.length == 1) {
                if (args2[0] instanceof CNull) {
                    throw new CRENullPointerException("Null value sent to " + this.getName() + "(). Did you mean " + this.getName() + "(0)?", t);
                }
                int id = ArgumentValidation.getInt32(args2[0], t);
                TaskManager taskManager = environment.getEnv(StaticRuntimeEnv.class).GetTaskManager();
                TaskHandler task = taskManager.getTask(CoreTaskType.TIMEOUT, id);
                if (task == null) {
                    StaticLayer.ClearFutureRunnable(id);
                } else {
                    task.kill();
                }
            } else {
                throw new CREInsufficientArgumentsException("No id was passed to clear_task, and it's not running inside a task either.", t);
            }
            return CVoid.VOID;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Use from within an interval", "set_interval(1000, closure(){\n\tif(rand(0, 10) == 9){\n\t\tclear_task();\n\t}\n\tmsg('Hello World!');\n});", "<Messages the user until the random number generator produces a 9, at which point the interval is stopped>"), new ExampleScript("Using the id returned from set_timeout", "@id = set_timeout(5000, closure(){\n\tmsg('Hello World!');\n});\nclear_task(@id);", "<Nothing happens, as the timeout is cancelled before it runs>")};
        }

        @Override
        public FunctionSignatures getSignatures() {
            return new SignatureBuilder(CVoid.TYPE).param(CInt.TYPE, "id", "The id of the task. Optional if called from within a task.", true).build();
        }
    }

    @api(environments={GlobalEnv.class})
    public static class set_timeout
    extends AbstractFunction {
        @Override
        public String getName() {
            return "set_timeout";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "int {timeInMS, closure} Sets a task to run in the specified number of ms in the future. The task will only run once. Note that the resolution of the time is in ms, however, the server will only have a resolution of up to 50 ms, meaning that a time of 1-50ms is essentially the same as 50ms.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CRERangeException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return false;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            TaskManager taskManager = environment.getEnv(StaticRuntimeEnv.class).GetTaskManager();
            long time2 = ArgumentValidation.getInt(args2[0], t);
            if (time2 < 0L) {
                throw new CRERangeException("Negative delay", t);
            }
            if (!args2[1].isInstanceOf(Callable.TYPE)) {
                throw new CRECastException(this.getName() + " expects a Callable to be sent as the second argument", t);
            }
            Callable c = (Callable)args2[1];
            AtomicInteger ret = new AtomicInteger(-1);
            ret.set(StaticLayer.SetFutureRunnable(environment.getEnv(StaticRuntimeEnv.class).GetDaemonManager(), time2, () -> {
                c.getEnv().getEnv(GlobalEnv.class).SetCustom("timeout-id", ret.get());
                TaskHandler task = taskManager.getTask(CoreTaskType.TIMEOUT, ret.get());
                if (task == null) {
                    return;
                }
                task.changeState(TaskState.RUNNING);
                try {
                    ProfilePoint p2 = c.getEnv().getEnv(StaticRuntimeEnv.class).GetProfiler().start("Executing timeout with id " + ret.get() + " (defined at " + t.toString() + ")", LogLevel.ERROR);
                    try {
                        c.executeCallable(environment, t, new Mixed[0]);
                    }
                    finally {
                        p2.stop();
                    }
                }
                catch (ConfigRuntimeException e) {
                    ConfigRuntimeException.HandleUncaughtException(e, c.getEnv());
                }
                catch (CancelCommandException e) {
                }
                catch (ProgramFlowManipulationException e) {
                    ConfigRuntimeException.DoWarning("Using a program flow manipulation construct improperly! " + e.getClass().getSimpleName());
                }
                finally {
                    if (!task.getState().isFinalized()) {
                        task.changeState(TaskState.FINISHED);
                    }
                }
            }));
            taskManager.addTask(new TimeoutTaskHandler(ret.get(), t, () -> {
                StaticLayer.ClearFutureRunnable(ret.get());
                taskManager.getTask(CoreTaskType.TIMEOUT, ret.get()).changeState(TaskState.KILLED);
            }));
            taskManager.getTask(CoreTaskType.TIMEOUT, ret.get()).changeState(TaskState.IDLE);
            return new CInt(ret.get(), t);
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "set_timeout(10000, closure(){\n\tmsg('Hello World!');\n});", "<Would wait 10 seconds, then message the user \"Hello World!\">")};
        }

        @Override
        public FunctionSignatures getSignatures() {
            return new SignatureBuilder(CInt.TYPE).param(CInt.TYPE, "timeInMS", "The delay before the task runs, in milliseconds.").param(Callable.TYPE, "callable", "The task to execute.").build();
        }
    }

    @api(environments={GlobalEnv.class})
    public static class set_interval
    extends AbstractFunction {
        @Override
        public String getName() {
            return "set_interval";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        @Override
        public String docs() {
            return "int {int timeInMS, [int initialDelayInMS,] Callable task} Sets a task to run every so often. This works similarly to set_timeout, except the task will automatically re-register itself to run again. Note that the resolution of the time is in ms, however, the server will only have a resolution of up to 50 ms, meaning that a time of 1-50ms is essentially the same as 50ms. The initial delay defaults to the same thing as timeInMS, that is, there will be a pause between registration and initial firing. However, this can be set to 0 (or some other number) to adjust how long of a delay there is before it begins.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CRERangeException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return false;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            long time2 = ArgumentValidation.getInt(args2[0], t);
            int offset = 0;
            long delay = time2;
            if (args2.length == 3) {
                offset = 1;
                delay = ArgumentValidation.getInt(args2[1], t);
                if (delay < 0L) {
                    throw new CRERangeException("Negative initial delay", t);
                }
            }
            if (time2 < 0L) {
                throw new CRERangeException("Negative repeating delay", t);
            }
            if (!args2[1 + offset].isInstanceOf(Callable.TYPE)) {
                throw new CRECastException(this.getName() + " expects a Callable to be sent as the second argument", t);
            }
            Callable c = (Callable)args2[1 + offset];
            AtomicInteger ret = new AtomicInteger(-1);
            ret.set(StaticLayer.SetFutureRepeater(environment.getEnv(StaticRuntimeEnv.class).GetDaemonManager(), time2, delay, () -> {
                c.getEnv().getEnv(GlobalEnv.class).SetCustom("timeout-id", ret.get());
                try {
                    ProfilePoint p2 = environment.getEnv(StaticRuntimeEnv.class).GetProfiler().start("Executing timeout with id " + ret.get() + " (defined at " + t.toString() + ")", LogLevel.ERROR);
                    try {
                        c.executeCallable(environment, t, new Mixed[0]);
                    }
                    finally {
                        p2.stop();
                    }
                }
                catch (ConfigRuntimeException e) {
                    ConfigRuntimeException.HandleUncaughtException(e, environment);
                }
                catch (CancelCommandException e) {
                }
                catch (ProgramFlowManipulationException e) {
                    ConfigRuntimeException.DoWarning("Using a program flow manipulation construct improperly! " + e.getClass().getSimpleName());
                }
            }));
            return new CInt(ret.get(), t);
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "set_interval(1000, closure(){\n\tmsg('Hello World!');\n});", "<Would message the user \"Hello World!\" every second>"), new ExampleScript("Usage with initial delay", "set_interval(1000, 5000, closure(){\n\tmsg('Hello World!');\n});", "<Would message the user \"Hello World!\" every second, however there would be an initial delay of 5 seconds>")};
        }

        @Override
        public FunctionSignatures getSignatures() {
            return new SignatureBuilder(CInt.TYPE).param(CInt.TYPE, "timeInMS", "The delay between runs, in milliseconds.").param(CInt.TYPE, "initialDelayInMS", "The delay before the first execution, in milliseconds. By default, the same as timeInMS.", true).param(Callable.TYPE, "callable", "The task to execute.").build();
        }
    }

    @api
    @hide(value="Only meant for cmdline/testing")
    @noboilerplate
    @seealso(value={Threading.x_interrupt.class})
    public static class sleep
    extends AbstractFunction {
        @Override
        public String getName() {
            return "sleep";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "void {seconds} Sleeps the script for the specified number of seconds, up to the maximum time limit defined in the preferences file. Seconds may be a double value, so 0.5 would be half a second. If the \"interrupt status\" is true then throw InterruptedException PLEASE NOTE: Sleep times are NOT very accurate, and should not be relied on for preciseness.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CREInterruptedException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_1_0;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args2) throws CancelCommandException, ConfigRuntimeException {
            Mixed x = args2[0];
            double time2 = ArgumentValidation.getNumber(x, t);
            try {
                Thread.sleep((int)(time2 * 1000.0));
            }
            catch (InterruptedException ex) {
                throw new CREInterruptedException(ex, t);
            }
            return CVoid.VOID;
        }

        @Override
        public Boolean runAsync() {
            return true;
        }
    }

    @api
    public static class nano_time
    extends AbstractFunction {
        @Override
        public String getName() {
            return "nano_time";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0};
        }

        @Override
        public String docs() {
            return "int {} Returns an arbitrary number based on the most accurate clock available on this system. Only useful when compared to other calls to nano_time(). The return is in nano seconds. See the Java API on System.nanoTime() for more information on the usage of this function.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_1_0;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args2) throws CancelCommandException, ConfigRuntimeException {
            return new CInt(System.nanoTime(), t);
        }
    }

    @api
    public static class time
    extends AbstractFunction {
        @Override
        public String getName() {
            return "time";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0};
        }

        @Override
        public String docs() {
            return "int {} Returns the current unix time stamp, in milliseconds. The resolution of this is not guaranteed to be extremely accurate. If you need extreme accuracy, use nano_time()";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_1_0;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args2) throws CancelCommandException, ConfigRuntimeException {
            return new CInt(System.currentTimeMillis(), t);
        }
    }
}

