/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.core.v3;

import com.laytonsmith.libs.org.postgresql.core.ParameterList;
import com.laytonsmith.libs.org.postgresql.core.v3.CompositeParameterList;
import com.laytonsmith.libs.org.postgresql.core.v3.SimpleParameterList;
import com.laytonsmith.libs.org.postgresql.core.v3.SimpleQuery;
import com.laytonsmith.libs.org.postgresql.core.v3.V3Query;

class CompositeQuery
implements V3Query {
    private final SimpleQuery[] subqueries;
    private final int[] offsets;

    CompositeQuery(SimpleQuery[] subqueries, int[] offsets) {
        this.subqueries = subqueries;
        this.offsets = offsets;
    }

    @Override
    public ParameterList createParameterList() {
        SimpleParameterList[] subparams = new SimpleParameterList[this.subqueries.length];
        for (int i = 0; i < this.subqueries.length; ++i) {
            subparams[i] = (SimpleParameterList)this.subqueries[i].createParameterList();
        }
        return new CompositeParameterList(subparams, this.offsets);
    }

    @Override
    public String toString(ParameterList parameters) {
        StringBuffer sbuf = new StringBuffer(this.subqueries[0].toString());
        for (int i = 1; i < this.subqueries.length; ++i) {
            sbuf.append(';');
            sbuf.append(this.subqueries[i]);
        }
        return sbuf.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public void close() {
        for (int i = 0; i < this.subqueries.length; ++i) {
            this.subqueries[i].close();
        }
    }

    @Override
    public SimpleQuery[] getSubqueries() {
        return this.subqueries;
    }
}

