/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREIndexOverflowException;
import com.laytonsmith.core.exceptions.CRE.CREUnsupportedOperationException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Booleanish;
import com.laytonsmith.core.natives.interfaces.Iterable;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

@typeof(value="ms.lang.fixed_array")
public class CFixedArray
extends Construct
implements java.lang.Iterable<Mixed>,
Booleanish,
Iterable {
    public static final CClassType TYPE = CClassType.get(CFixedArray.class);
    private Mixed[] data;
    private CClassType allowedType;

    public CFixedArray(Target t, CClassType type, int size) {
        super(type.getSimpleName() + "[" + size + "]", Construct.ConstructType.ARRAY, t);
        this.data = new Mixed[size];
        this.allowedType = type;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public Mixed get(String index, Target t) throws ConfigRuntimeException {
        return null;
    }

    @Override
    public Mixed get(int index, Target t) throws ConfigRuntimeException {
        if (index < 0 || index >= this.data.length) {
            throw new CREIndexOverflowException("Index overflows array size", t);
        }
        Mixed d = this.data[index];
        if (d == null) {
            return CNull.NULL;
        }
        return d;
    }

    @Override
    public Mixed get(Mixed index, Target t) throws ConfigRuntimeException {
        return this.get(ArgumentValidation.getInt32(index, t), t);
    }

    @Override
    public Set<Mixed> keySet() {
        LinkedHashSet<Mixed> set = new LinkedHashSet<Mixed>(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            set.add(new CInt(i, Target.UNKNOWN));
        }
        return set;
    }

    private void validateSet(Mixed value, Target t) {
        if (!value.typeof().doesExtend(this.allowedType)) {
            throw new CRECastException("Cannot set value of type " + value.typeof().toString() + " into fixed_array of type " + this.allowedType.toString(), t);
        }
    }

    public void set(int index, Mixed value, Target t) {
        this.validateSet(value, t);
        if (index >= this.data.length || index < 0) {
            throw new CREIndexOverflowException("Index under/overflow in fixed_array", t);
        }
        this.data[index] = value;
    }

    @Override
    public boolean isAssociative() {
        return false;
    }

    @Override
    public boolean canBeAssociative() {
        return false;
    }

    @Override
    public Mixed slice(int begin, int end, Target t) {
        throw new CREUnsupportedOperationException("slices are not yet implemented on fixed_array", t);
    }

    @Override
    public boolean getBooleanValue(Target t) {
        return this.size() > 0L;
    }

    @Override
    public long size() {
        return this.data.length;
    }

    public void fill(Mixed value, Target t) {
        this.validateSet(value, t);
        ArrayUtils.fill(this.data, value);
    }

    @Override
    public Iterator<Mixed> iterator() {
        return Arrays.stream(this.data).iterator();
    }

    @Override
    public CClassType[] getInterfaces() {
        return new CClassType[]{Booleanish.TYPE, Iterable.TYPE};
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{Mixed.TYPE};
    }

    @Override
    public String docs() {
        return "An fixed_array is a data type, which contains any number of other values. Unlike a normal array however, it cannot be associative, nor can the size be changed later. Additionally, values must be of the initially given type. In general normal arrays should be used instead of this, but fixed_array maps more precisely onto the underlying system array type. All values in the array are initialized initially to null.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_5;
    }
}

