/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.federation;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.core.federation.FederationCommunication;
import com.laytonsmith.core.federation.FederationVersion;
import com.laytonsmith.core.functions.Federation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FederationServer {
    private final String serverName;
    private final String password;
    private final File authorizedKeys;
    private final String allowFrom;
    private final int masterPort;
    private final Map<Socket, Long> subSockets = new HashMap<Socket, Long>();
    private ServerSocket serverSocket;
    private boolean closed = false;

    public FederationServer(String serverName, String password, File authorizedKeys, String allowFrom, int masterPort) {
        this.serverName = serverName;
        this.password = password;
        this.authorizedKeys = authorizedKeys;
        this.allowFrom = allowFrom;
        this.masterPort = masterPort;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getPassword() {
        return this.password;
    }

    public File getAuthorizedKeys() {
        return this.authorizedKeys;
    }

    public String getAllowFrom() {
        return this.allowFrom;
    }

    public int getMasterPort() {
        return this.masterPort;
    }

    public void addSubSocket(Socket s) {
        this.subSockets.put(s, System.currentTimeMillis());
    }

    public void removeSubSocket(Socket s) {
        this.subSockets.remove(s);
    }

    public void listenForConnections() throws IOException {
        while (!this.serverSocket.isClosed()) {
            final Socket s = this.serverSocket.accept();
            this.addSubSocket(s);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        FederationVersion version;
                        FederationCommunication communicator = new FederationCommunication(new BufferedInputStream(s.getInputStream()), new BufferedOutputStream(s.getOutputStream()));
                        Thread connectionWatcher = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(1000L);
                                    try {
                                        if (s.isConnected()) {
                                            s.close();
                                        }
                                    }
                                    catch (IOException ex) {
                                        Logger.getLogger(FederationServer.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }, "FederationServerConnectionWatcher-" + s.hashCode());
                        connectionWatcher.start();
                        String hello = communicator.readUnencryptedLine();
                        if (!"HELLO".equals(hello)) {
                            s.close();
                            connectionWatcher.interrupt();
                            return;
                        }
                        String sVersion = communicator.readUnencryptedLine();
                        try {
                            version = FederationVersion.fromVersion(sVersion);
                            communicator.writeUnencryptedLine("VERSION OK");
                        }
                        catch (IllegalArgumentException ex) {
                            communicator.writeUnencryptedLine("VERSION BAD");
                            byte[] errorMsg = ("The server does not support the version of this client (" + sVersion + ")!").getBytes("UTF-8");
                            communicator.writeUnencryptedLine(Integer.toString(errorMsg.length));
                            communicator.writeUnencrypted(errorMsg);
                            s.close();
                            connectionWatcher.interrupt();
                            return;
                        }
                        if (version == FederationVersion.V1_0_0) {
                            boolean isEncrypted = "1".equals(communicator.readUnencryptedLine());
                            String clientPassword = communicator.readLine();
                            if (FederationServer.this.password != null && !FederationServer.this.password.equals(clientPassword)) {
                                communicator.writeLine("ERROR");
                                byte[] errorMsg = "Wrong password".getBytes("UTF-8");
                                communicator.writeLine(Integer.toString(errorMsg.length));
                                communicator.writeBytes(errorMsg);
                                s.close();
                                connectionWatcher.interrupt();
                                return;
                            }
                            communicator.writeLine("OK");
                            connectionWatcher.interrupt();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(FederationServer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }, "FederationServer-" + this.serverName + "-Connection " + this.subSockets.size()).start();
        }
    }

    public void checkSocketTimeouts(long inactiveMS) {
        Iterator<Socket> it = this.subSockets.keySet().iterator();
        while (it.hasNext()) {
            Socket s = it.next();
            if (this.subSockets.get(s) >= System.currentTimeMillis() - inactiveMS) continue;
            try {
                s.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Federation.class.getName()).log(Level.SEVERE, null, ex);
            }
            it.remove();
        }
    }

    public void updateSocketActivity(Socket s) {
        if (this.subSockets.containsKey(s)) {
            this.subSockets.put(s, System.currentTimeMillis());
        }
    }

    public void closeAllSockets() {
        try {
            this.serverSocket.close();
        }
        catch (IOException ex) {
            Logger.getLogger(FederationServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (Socket sub : this.subSockets.keySet()) {
            try {
                sub.close();
            }
            catch (IOException ex) {
                Logger.getLogger(FederationServer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            StreamUtils.GetSystemErr().println("FederationServer was not closed properly, and cleanup is having to be done in the finalize method!");
            this.closeAllSockets();
        }
    }
}

