/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.events;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.events.MCPlayerEvent;
import com.laytonsmith.annotations.core;
import com.laytonsmith.annotations.hide;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.StaticRuntimeEnv;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.BoundEvent;
import com.laytonsmith.core.events.Event;
import com.laytonsmith.core.events.EventMixinInterface;
import com.laytonsmith.core.events.prefilters.Prefilter;
import com.laytonsmith.core.events.prefilters.PrefilterBuilder;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.exceptions.FunctionReturnException;
import com.laytonsmith.core.exceptions.PrefilterNonMatchException;
import com.laytonsmith.core.exceptions.ProgramFlowManipulationException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.profiler.ProfilePoint;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractGenericEvent<TBindableEvent extends BindableEvent>
implements Event<TBindableEvent>,
Comparable<Event<TBindableEvent>> {
    private EventMixinInterface mixin;
    private static final Class[] EMPTY_CLASS = new Class[0];
    private Map<String, Prefilter<? extends TBindableEvent>> prefilterCache = null;
    private volatile boolean isCacheSaturated = false;

    public final void setAbstractEventMixin(EventMixinInterface mixin) {
        this.mixin = mixin;
    }

    public boolean shouldFire(TBindableEvent e) {
        return this.mixin.shouldFire((BindableEvent)e);
    }

    @Override
    public void bind(BoundEvent event) {
    }

    @Override
    public void unbind(BoundEvent event) {
    }

    @Override
    public void hook() {
    }

    @Override
    public boolean matches(Map<String, Mixed> prefilter, TBindableEvent e) throws PrefilterNonMatchException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void execute(ParseTree tree, BoundEvent b, Environment env, BoundEvent.ActiveEvent activeEvent) throws ConfigRuntimeException {
        this.preExecution(env, activeEvent);
        BindableEvent bindableEvent = activeEvent.getUnderlyingEvent();
        if (bindableEvent instanceof MCPlayerEvent) {
            MCPlayerEvent playerEvent = (MCPlayerEvent)bindableEvent;
            env.getEnv(CommandHelperEnvironment.class).SetPlayer(playerEvent.getPlayer());
        } else {
            Mixed c = activeEvent.getParsedEvent().get("player");
            if (c != null) {
                if (c instanceof CNull) {
                    if (env.getEnv(CommandHelperEnvironment.class).GetPlayer() != null) {
                        env.getEnv(CommandHelperEnvironment.class).SetPlayer(null);
                    }
                } else {
                    MCCommandSender p2 = Static.getServer().getPlayer(c.val());
                    if (p2 == null) {
                        p2 = Static.GetInjectedPlayer(c.val());
                    }
                    if (p2 != null) {
                        env.getEnv(CommandHelperEnvironment.class).SetPlayer((MCPlayer)p2);
                    } else {
                        MSLog.GetLogger().w(MSLog.Tags.GENERAL, c.val() + " offline for " + b.getEventName(), tree.getTarget());
                        if (env.getEnv(CommandHelperEnvironment.class).GetPlayer() != null) {
                            env.getEnv(CommandHelperEnvironment.class).SetPlayer(null);
                        }
                    }
                }
            }
        }
        ProfilePoint event = null;
        if (env.getEnv(StaticRuntimeEnv.class).GetProfiler() != null) {
            event = env.getEnv(StaticRuntimeEnv.class).GetProfiler().start("Event " + b.getEventName() + " (defined at " + b.getTarget().toString() + ")", LogLevel.ERROR);
        }
        try {
            try {
                MethodScriptCompiler.execute(tree, env, null, null);
            }
            catch (CancelCommandException ex) {
                if (ex.getMessage() != null && !ex.getMessage().isEmpty()) {
                    StreamUtils.GetSystemOut().println(ex.getMessage());
                }
            }
            catch (FunctionReturnException ex) {
            }
            catch (ProgramFlowManipulationException ex) {
                ConfigRuntimeException.HandleUncaughtException(new CREFormatException("Unexpected control flow operation used.", ex.getTarget()), env);
            }
        }
        finally {
            if (event != null) {
                event.stop();
            }
            this.postExecution(env, activeEvent);
        }
    }

    public void preExecution(Environment env, BoundEvent.ActiveEvent activeEvent) {
    }

    public void postExecution(Environment env, BoundEvent.ActiveEvent activeEvent) {
    }

    @Override
    public int compareTo(Event o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    public boolean supportsExternal() {
        return true;
    }

    public static Object DoConvert(CArray manualObject) {
        HashMap<String, Mixed> map = new HashMap<String, Mixed>();
        for (String key : manualObject.stringKeySet()) {
            map.put(key, manualObject.get(key, Target.UNKNOWN));
        }
        return map;
    }

    public Map<String, Mixed> evaluate_helper(TBindableEvent e) throws EventException {
        return this.mixin.evaluate_helper((BindableEvent)e);
    }

    @Override
    public void manualTrigger(TBindableEvent o) {
        this.mixin.manualTrigger((BindableEvent)o);
    }

    @Override
    public void cancel(TBindableEvent o, boolean state) {
        this.mixin.cancel((BindableEvent)o, state);
    }

    @Override
    public boolean isCancellable(TBindableEvent o) {
        return this.mixin.isCancellable((BindableEvent)o);
    }

    @Override
    public boolean isCancelled(TBindableEvent o) {
        return this.mixin.isCancelled((BindableEvent)o);
    }

    @Override
    public URL getSourceJar() {
        return ClassDiscovery.GetClassContainer(this.getClass());
    }

    @Override
    public final boolean appearInDocumentation() {
        return this.getClass().getAnnotation(hide.class) != null;
    }

    @Override
    public Class<? extends Documentation>[] seeAlso() {
        return EMPTY_CLASS;
    }

    @Override
    public boolean addCounter() {
        return true;
    }

    @Override
    public final boolean isCore() {
        Class<?> c = this.getClass();
        do {
            if (c.getAnnotation(core.class) == null) continue;
            return true;
        } while ((c = c.getDeclaringClass()) != null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, Prefilter<? extends TBindableEvent>> getPrefilters() {
        if (!this.isCacheSaturated) {
            AbstractGenericEvent abstractGenericEvent = this;
            synchronized (abstractGenericEvent) {
                if (!this.isCacheSaturated) {
                    PrefilterBuilder builder = this.getPrefilterBuilder();
                    if (builder != null) {
                        this.prefilterCache = builder.build();
                    }
                    this.isCacheSaturated = true;
                }
            }
        }
        return this.prefilterCache;
    }

    protected PrefilterBuilder getPrefilterBuilder() {
        return null;
    }

    @Override
    public void validatePrefilters(Map<Prefilter<TBindableEvent>, ParseTree> prefilters, Environment env) throws ConfigCompileException, ConfigCompileGroupException {
    }
}

