/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.extensions;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.ClassLoading.DynamicClassLoader;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.events.AbstractGenericEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.Event;
import com.laytonsmith.core.events.EventMixinInterface;
import com.laytonsmith.core.extensions.Extension;
import com.laytonsmith.core.functions.FunctionBase;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ExtensionTracker {
    String identifier;
    Version version;
    List<Extension> allExtensions;
    private final DynamicClassLoader dcl;
    private final ClassDiscovery cd;
    final Map<api.Platforms, Map<String, FunctionBase>> functions = new EnumMap<api.Platforms, Map<String, FunctionBase>>(api.Platforms.class);
    final Map<String, Set<api.Platforms>> supportedPlatforms = new HashMap<String, Set<api.Platforms>>();
    final Map<Driver, Set<Event>> events;
    final URL container;
    boolean isShutdown;

    public ExtensionTracker(URL container, ClassDiscovery cd2, DynamicClassLoader dcl) {
        for (api.Platforms p2 : api.Platforms.values()) {
            this.functions.put(p2, new HashMap());
        }
        this.events = new EnumMap<Driver, Set<Event>>(Driver.class);
        this.allExtensions = new ArrayList<Extension>();
        this.version = MSVersion.V0_0_0;
        this.container = container;
        this.cd = cd2;
        this.dcl = dcl;
    }

    public void shutdownTracker() {
        if (this.isShutdown) {
            return;
        }
        this.cd.removeDiscoveryLocation(this.container);
        this.cd.removePreCache(this.container);
        this.dcl.removeJar(this.container);
        this.isShutdown = true;
    }

    public List<Extension> getExtensions() {
        return Collections.unmodifiableList(this.allExtensions);
    }

    public Set<FunctionBase> getFunctions() {
        HashSet<FunctionBase> retn = new HashSet<FunctionBase>();
        for (Map<String, FunctionBase> function : this.functions.values()) {
            retn.addAll(function.values());
        }
        return retn;
    }

    public synchronized void registerFunction(FunctionBase f) {
        api api2 = f.getClass().getAnnotation(api.class);
        api.Platforms[] platforms = api2.platform();
        if (!api2.enabled()) {
            return;
        }
        if (this.supportedPlatforms.get(f.getName()) == null) {
            this.supportedPlatforms.put(f.getName(), EnumSet.noneOf(api.Platforms.class));
        }
        this.supportedPlatforms.get(f.getName()).addAll(Arrays.asList(platforms));
        for (api.Platforms platform : platforms) {
            try {
                this.functions.get((Object)platform).put(f.getName(), f);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    public Set<Event> getEvents() {
        HashSet<Event> retn = new HashSet<Event>();
        for (Set<Event> set : this.events.values()) {
            retn.addAll(set);
        }
        return retn;
    }

    public Set<Event> getEvents(Driver type) {
        Set<Event> retn = this.events.get((Object)type);
        if (retn == null) {
            return Collections.emptySet();
        }
        return retn;
    }

    public synchronized void registerEvent(Event e) {
        if (e instanceof AbstractGenericEvent) {
            AbstractGenericEvent ae = (AbstractGenericEvent)e;
            Class<?> mixinClass = StaticLayer.GetServerEventMixin();
            try {
                Constructor<?> mixinConstructor = mixinClass.getConstructor(AbstractGenericEvent.class);
                EventMixinInterface mixin = (EventMixinInterface)mixinConstructor.newInstance(e);
                ae.setAbstractEventMixin(mixin);
            }
            catch (Exception ex) {
                throw new Error("Could not properly instantiate the mixin class. The constructor with the signature \"public " + mixinClass.getSimpleName() + "(AbstractGenericEvent e)\" is missing from " + mixinClass.getName());
            }
        }
        if (!this.events.containsKey((Object)e.driver())) {
            this.events.put(e.driver(), new TreeSet());
        }
        this.events.get((Object)e.driver()).add(e);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Version getVersion() {
        return this.version;
    }
}

