/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.telemetry.ApplicationInsights;

import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.core.functions.Meta;
import com.laytonsmith.core.telemetry.ApplicationInsights.Data;
import com.laytonsmith.core.telemetry.ApplicationInsights.Envelope;
import com.laytonsmith.core.telemetry.ApplicationInsights.EventData;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TelemetryUtil {
    private final String instrumentationKey;
    private final String iKeyDashless;
    private String sessionName = "untracked";
    private boolean newSession = false;

    public TelemetryUtil(String instrumentationKey) {
        this.instrumentationKey = instrumentationKey;
        this.iKeyDashless = instrumentationKey.replace("-", "");
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setNewSession(boolean newSession) {
        this.newSession = newSession;
    }

    public Envelope newEvent(String metricName, Map<String, String> properties, Map<String, Double> measurements) {
        Envelope env = new Envelope();
        env.setVer(1);
        env.setName("Microsoft.ApplicationInsights." + this.iKeyDashless + ".Event");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        env.setTime(sdf.format(new Date()));
        env.setSampleRate(100.0);
        env.setIKey(this.instrumentationKey);
        ConcurrentMap<String, String> tags = this.generateStandardTags();
        tags.put("ai.internal.nodeName", this.sessionName);
        tags.put("ai.session.id", this.sessionName);
        tags.put("ai.session.isNew", Boolean.toString(this.newSession));
        env.setTags(tags);
        EventData eventData = new EventData();
        eventData.setVer(2);
        eventData.setName(metricName);
        if (properties != null && !properties.isEmpty()) {
            eventData.setProperties(properties);
        }
        if (measurements != null && !measurements.isEmpty()) {
            eventData.setMeasurements(measurements);
        }
        Data<EventData> data = new Data<EventData>();
        data.setBaseType("EventData");
        data.setBaseData(eventData);
        env.setData(data);
        return env;
    }

    private ConcurrentMap<String, String> generateStandardTags() {
        ConcurrentHashMap<String, String> tags = new ConcurrentHashMap<String, String>();
        tags.put("ai.application.ver", Long.toString(Meta.engine_build_date.GetEngineBuildDate()));
        tags.put("ai.device.locale", Locale.getDefault().toString());
        tags.put("ai.device.osVersion", OSUtils.GetOS().name());
        tags.put("ai.location.country", "Untracked");
        tags.put("ai.location.province", "Untracked");
        tags.put("ai.location.city", "Untracked");
        return tags;
    }
}

