/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.apache.oltu.oauth2.client.response;

import com.laytonsmith.libs.org.apache.oltu.oauth2.client.response.OAuthClientResponse;
import com.laytonsmith.libs.org.apache.oltu.oauth2.client.validator.ResourceValidator;
import com.laytonsmith.libs.org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import com.laytonsmith.libs.org.apache.oltu.oauth2.common.utils.OAuthUtils;
import com.laytonsmith.libs.org.slf4j.Logger;
import com.laytonsmith.libs.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class OAuthResourceResponse
extends OAuthClientResponse {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthResourceResponse.class);
    private InputStream inputStream;
    private boolean bodyRetrieved = false;

    public OAuthResourceResponse() {
        this.validator = new ResourceValidator();
    }

    public String getBody() {
        if (this.bodyRetrieved && this.body == null) {
            throw new IllegalStateException("Cannot call getBody() after getBodyAsInputStream()");
        }
        if (this.body == null) {
            try {
                this.body = OAuthUtils.saveStreamAsString(this.getBodyAsInputStream());
                this.inputStream = null;
            }
            catch (IOException e) {
                LOG.error("Failed to convert InputStream to String", e);
            }
        }
        return this.body;
    }

    @Override
    public int getResponseCode() {
        return this.responseCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    protected void setBody(InputStream body) throws OAuthProblemException {
        this.inputStream = body;
    }

    @Override
    protected void setBody(String body) throws OAuthProblemException {
        this.body = body;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public InputStream getBodyAsInputStream() {
        if (this.bodyRetrieved && this.inputStream == null) {
            throw new IllegalStateException("Cannot call getBodyAsInputStream() after getBody()");
        }
        this.bodyRetrieved = true;
        return this.inputStream;
    }

    @Override
    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    protected void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    @Override
    protected void init(InputStream body, String contentType, int responseCode, Map<String, List<String>> headers) throws OAuthProblemException {
        this.setBody(body);
        this.setContentType(contentType);
        this.setResponseCode(responseCode);
        this.setHeaders(headers);
    }
}

