/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.io.gsonfire.postprocessors.methodinvoker;

import com.laytonsmith.libs.com.google.gson.Gson;
import com.laytonsmith.libs.com.google.gson.JsonElement;
import com.laytonsmith.libs.com.google.gson.JsonObject;
import com.laytonsmith.libs.io.gsonfire.PostProcessor;
import com.laytonsmith.libs.io.gsonfire.annotations.ExposeMethodResult;
import com.laytonsmith.libs.io.gsonfire.gson.FireExclusionStrategy;
import com.laytonsmith.libs.io.gsonfire.gson.FireExclusionStrategyComposite;
import com.laytonsmith.libs.io.gsonfire.postprocessors.methodinvoker.MappedMethod;
import com.laytonsmith.libs.io.gsonfire.postprocessors.methodinvoker.MappedMethodInspector;
import java.lang.reflect.InvocationTargetException;

public final class MethodInvokerPostProcessor<T>
implements PostProcessor<T> {
    private static MappedMethodInspector methodInspector = new MappedMethodInspector();
    private final FireExclusionStrategy serializationExclusionStrategy;

    public MethodInvokerPostProcessor() {
        this(new FireExclusionStrategyComposite(new FireExclusionStrategy[0]));
    }

    public MethodInvokerPostProcessor(FireExclusionStrategy serializationExclusionStrategy) {
        this.serializationExclusionStrategy = serializationExclusionStrategy;
    }

    @Override
    public void postDeserialize(T result, JsonElement src, Gson gson) {
    }

    @Override
    public void postSerialize(JsonElement result, T src, Gson gson) {
        if (result.isJsonObject()) {
            JsonObject jsonObject = result.getAsJsonObject();
            for (MappedMethod m : methodInspector.getAnnotatedMembers(src.getClass(), ExposeMethodResult.class)) {
                if (this.serializationExclusionStrategy.shouldSkipMethod(m)) continue;
                try {
                    if (m.getConflictResolutionStrategy() != ExposeMethodResult.ConflictResolutionStrategy.OVERWRITE && (m.getConflictResolutionStrategy() != ExposeMethodResult.ConflictResolutionStrategy.SKIP || jsonObject.has(m.getSerializedName()))) continue;
                    Object value = m.getMethod().invoke(src, new Object[0]);
                    jsonObject.add(m.getSerializedName(), gson.toJsonTree(value));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

