/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SmartComment {
    private static final Pattern ANNOTATION = Pattern.compile("@[a-zA-Z][a-zA-Z0-9]*");
    private static final Pattern EMBEDDED_ANNOTATION = Pattern.compile("\\{@([a-zA-Z][a-zA-Z0-9]*) +(.*?)\\}");
    private static final String LINE_START = "[\\t ]*\\* ?";
    private String unprocessed;
    private String raw;
    private String body;
    private final Map<String, List<String>> annotations = new HashMap<String, List<String>>();
    private final Map<String, Replacement> rplcmnt = new HashMap<String, Replacement>();

    public SmartComment(String comment) {
        this(comment, null);
    }

    public SmartComment(SmartComment comment, Map<String, Replacement> replacements) {
        this(comment.unprocessed, replacements);
    }

    public SmartComment(String comment, Map<String, Replacement> replacements) {
        if (replacements == null) {
            replacements = new HashMap<String, Replacement>();
        }
        this.unprocessed = comment;
        for (String key : replacements.keySet()) {
            this.rplcmnt.put(key.replaceFirst("@", ""), replacements.get(key));
        }
        if ((comment = comment.trim()).startsWith("/**")) {
            comment = comment.substring(3);
        }
        if (comment.endsWith("*/")) {
            comment = comment.substring(0, comment.length() - 2);
        }
        String[] lines = comment.split("\n|\r\n|\n\r");
        StringBuilder b = new StringBuilder();
        for (String line : lines) {
            line = line.replaceFirst(LINE_START, "");
            b.append("\n").append(line);
        }
        this.raw = this.replaceEmbedded(b.toString().trim());
        String[] words = this.raw.split(" |\n");
        StringBuilder buffer = new StringBuilder();
        String lastAnnotation = null;
        int annotationIndex = -1;
        for (String word : words) {
            if (ANNOTATION.matcher(word).matches()) {
                if (annotationIndex == -1) {
                    Matcher m = ANNOTATION.matcher(this.raw);
                    m.find();
                    annotationIndex = m.start();
                }
                this.processBuffer(lastAnnotation, buffer.toString());
                lastAnnotation = word;
                buffer = new StringBuilder();
                continue;
            }
            buffer.append(" ").append(word);
        }
        this.processBuffer(lastAnnotation, buffer.toString());
        this.body = annotationIndex == -1 ? this.raw : this.raw.substring(0, annotationIndex).trim();
    }

    private String replaceEmbedded(String string) {
        Matcher embedded = EMBEDDED_ANNOTATION.matcher(string);
        while (embedded.find()) {
            String key = embedded.group(1);
            String data = embedded.group(2);
            if (this.rplcmnt.containsKey(key)) {
                string = string.replaceAll(Pattern.quote(embedded.group(0)), this.rplcmnt.get(key).replace(data));
                continue;
            }
            string = string.replaceAll(Pattern.quote(embedded.group(0)), data);
        }
        return string;
    }

    private void processBuffer(String lastAnnotation, String buffer) {
        if (lastAnnotation != null) {
            this.addAnnotation(lastAnnotation, buffer.trim());
        }
    }

    private void addAnnotation(String name, String value) {
        if (!this.annotations.containsKey(name)) {
            this.annotations.put(name, new ArrayList());
        }
        this.annotations.get(name).add(value);
    }

    public String getBody() {
        return this.body;
    }

    public List<String> getAnnotations(String annotation) {
        List<String> ann;
        if (!((String)annotation).startsWith("@")) {
            annotation = "@" + (String)annotation;
        }
        if ((ann = this.annotations.get(annotation)) == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(ann);
    }

    public Map<String, List<String>> getAnnotations() {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (String key : this.annotations.keySet()) {
            ret.put(key, this.getAnnotations(key));
        }
        return ret;
    }

    public static interface Replacement {
        public String replace(String var1);
    }
}

