/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Web;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Web.HTTPHeader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTTPHeaders
implements Iterable<HTTPHeader> {
    private final List<HTTPHeader> model;

    public HTTPHeaders(List<HTTPHeader> model) {
        this.model = model;
    }

    public int size() {
        return this.model.size();
    }

    @Override
    public Iterator<HTTPHeader> iterator() {
        return this.model.iterator();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (HTTPHeader h : this.model) {
            b.append(h.getHeader()).append(": ").append(h.getValue()).append("\n");
        }
        return b.toString();
    }

    public String getCombinedHeader(String key) {
        return StringUtils.Join(this.getHeaders(key), ",").trim();
    }

    public String getFirstHeader(String key) {
        for (HTTPHeader header : this.model) {
            if (key == null && header.getHeader() == null) {
                return header.getValue();
            }
            if (key == null || !key.equalsIgnoreCase(header.getHeader())) continue;
            return header.getValue();
        }
        return null;
    }

    public Set<String> getHeaderNames() {
        HashSet<String> set = new HashSet<String>();
        for (HTTPHeader h : this.model) {
            if (h.getHeader() == null) continue;
            set.add(h.getHeader());
        }
        return set;
    }

    public List<String> getHeaders(String key) {
        ArrayList<String> list = new ArrayList<String>();
        for (HTTPHeader header : this.model) {
            if ((header.getHeader() != null || key != null) && (header.getHeader() == null || !header.getHeader().equalsIgnoreCase(key))) continue;
            list.add(header.getValue());
        }
        return list;
    }

    public ContentType getContentType() {
        String header = this.getFirstHeader("Content-Type");
        if (header == null) {
            return null;
        }
        return new ContentType(header);
    }

    public String getLink(String rel) {
        String links = this.getCombinedHeader("link");
        if (links.isEmpty()) {
            return null;
        }
        List<String> headers = Arrays.asList(links.split(","));
        for (String link : headers) {
            if (!(link = link.trim()).contains("rel=\"" + rel + "\"")) continue;
            return link.replaceAll("<(.*)>.*", "$1");
        }
        return null;
    }

    public static class ContentType {
        public final MIMEType mimeType;
        public final String charset;
        public final String boundary;
        private static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("^(.*?)(?:;\\s*(.*?))?$");

        public ContentType(String contentType) {
            Matcher m = CONTENT_TYPE_PATTERN.matcher(contentType);
            m.find();
            this.mimeType = new MIMEType(m.group(1));
            if (m.group(2) != null) {
                String parameter = m.group(2);
                String[] parts = parameter.split("=");
                if ("charset".equalsIgnoreCase(parts[0])) {
                    this.charset = parts[1];
                    this.boundary = null;
                } else if ("boundary".equalsIgnoreCase(parts[0])) {
                    this.boundary = parts[1];
                    this.charset = null;
                } else {
                    this.charset = null;
                    this.boundary = null;
                }
            } else {
                this.charset = null;
                this.boundary = null;
            }
        }
    }

    public static class MIMEType {
        public final String mediaType;
        public final String type;
        public final String subtype;

        public MIMEType(String mediaType) {
            this.mediaType = mediaType;
            String[] parts = mediaType.split("/");
            this.type = parts[0];
            this.subtype = parts[1];
        }
    }
}

