/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.com.google.common.cache;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.laytonsmith.libs.com.google.common.annotations.GwtIncompatible;
import com.laytonsmith.libs.com.google.common.cache.AbstractCache;
import com.laytonsmith.libs.com.google.common.cache.ElementTypesAreNonnullByDefault;
import com.laytonsmith.libs.com.google.common.cache.LoadingCache;
import com.laytonsmith.libs.com.google.common.util.concurrent.UncheckedExecutionException;
import com.laytonsmith.libs.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class AbstractLoadingCache<K, V>
extends AbstractCache<K, V>
implements LoadingCache<K, V> {
    protected AbstractLoadingCache() {
    }

    @Override
    @CanIgnoreReturnValue
    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys2) throws ExecutionException {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (K key : keys2) {
            if (result.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return ImmutableMap.copyOf((Map)result);
    }

    @Override
    public final V apply(K key) {
        return this.getUnchecked(key);
    }

    @Override
    public void refresh(K key) {
        throw new UnsupportedOperationException();
    }
}

