/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;

public class ArrayUtils {
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Character[] EMPTY_CHAR_OBJ_ARRAY = new Character[0];
    public static final Byte[] EMPTY_BYTE_OBJ_ARRAY = new Byte[0];
    public static final Short[] EMPTY_SHORT_OBJ_ARRAY = new Short[0];
    public static final Integer[] EMPTY_INT_OBJ_ARRAY = new Integer[0];
    public static final Long[] EMPTY_LONG_OBJ_ARRAY = new Long[0];
    public static final Float[] EMPTY_FLOAT_OBJ_ARRAY = new Float[0];
    public static final Double[] EMPTY_DOUBLE_OBJ_ARRAY = new Double[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJ_ARRAY = new Boolean[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static <T> T[] slice(T[] array2, int start, int finish) {
        int size = Math.abs(start - finish) + 1;
        Object newArray = Array.newInstance(array2.getClass().getComponentType(), size);
        if (start <= finish) {
            int counter = 0;
            for (int i = start; i <= finish; ++i) {
                Array.set(newArray, counter++, array2[i]);
            }
        } else {
            int counter = 0;
            for (int i = start; i >= finish; --i) {
                Array.set(newArray, counter++, array2[i]);
            }
        }
        return (Object[])newArray;
    }

    public static char[] slice(char[] array2, int start, int finish) {
        int size = Math.abs(start - finish) + 1;
        char[] newArray = new char[size];
        if (start <= finish) {
            int counter = 0;
            for (int i = start; i <= finish; ++i) {
                newArray[counter++] = array2[i];
            }
        } else {
            int counter = 0;
            for (int i = start; i >= finish; --i) {
                newArray[counter++] = array2[i];
            }
        }
        return newArray;
    }

    public static byte[] slice(byte[] array2, int start, int finish) {
        int size = Math.abs(start - finish) + 1;
        byte[] newArray = new byte[size];
        if (start <= finish) {
            int counter = 0;
            for (int i = start; i <= finish; ++i) {
                newArray[counter++] = array2[i];
            }
        } else {
            int counter = 0;
            for (int i = start; i >= finish; --i) {
                newArray[counter++] = array2[i];
            }
        }
        return newArray;
    }

    public static short[] slice(short[] array2, int start, int finish) {
        int size = Math.abs(start - finish) + 1;
        short[] newArray = new short[size];
        if (start <= finish) {
            int counter = 0;
            for (int i = start; i <= finish; ++i) {
                newArray[counter++] = array2[i];
            }
        } else {
            int counter = 0;
            for (int i = start; i >= finish; --i) {
                newArray[counter++] = array2[i];
            }
        }
        return newArray;
    }

    public static int[] slice(int[] array2, int start, int finish) {
        int size = Math.abs(start - finish) + 1;
        int[] newArray = new int[size];
        if (start <= finish) {
            int counter = 0;
            for (int i = start; i <= finish; ++i) {
                newArray[counter++] = array2[i];
            }
        } else {
            int counter = 0;
            for (int i = start; i >= finish; --i) {
                newArray[counter++] = array2[i];
            }
        }
        return newArray;
    }

    public static long[] slice(long[] array2, int start, int finish) {
        int size = Math.abs(start - finish) + 1;
        long[] newArray = new long[size];
        if (start <= finish) {
            int counter = 0;
            for (int i = start; i <= finish; ++i) {
                newArray[counter++] = array2[i];
            }
        } else {
            int counter = 0;
            for (int i = start; i >= finish; --i) {
                newArray[counter++] = array2[i];
            }
        }
        return newArray;
    }

    public static float[] slice(float[] array2, int start, int finish) {
        int size = Math.abs(start - finish) + 1;
        float[] newArray = new float[size];
        if (start <= finish) {
            int counter = 0;
            for (int i = start; i <= finish; ++i) {
                newArray[counter++] = array2[i];
            }
        } else {
            int counter = 0;
            for (int i = start; i >= finish; --i) {
                newArray[counter++] = array2[i];
            }
        }
        return newArray;
    }

    public static double[] slice(double[] array2, int start, int finish) {
        int size = Math.abs(start - finish) + 1;
        double[] newArray = new double[size];
        if (start <= finish) {
            int counter = 0;
            for (int i = start; i <= finish; ++i) {
                newArray[counter++] = array2[i];
            }
        } else {
            int counter = 0;
            for (int i = start; i >= finish; --i) {
                newArray[counter++] = array2[i];
            }
        }
        return newArray;
    }

    public static boolean[] slice(boolean[] array2, int start, int finish) {
        int size = Math.abs(start - finish) + 1;
        boolean[] newArray = new boolean[size];
        if (start <= finish) {
            int counter = 0;
            for (int i = start; i <= finish; ++i) {
                newArray[counter++] = array2[i];
            }
        } else {
            int counter = 0;
            for (int i = start; i >= finish; --i) {
                newArray[counter++] = array2[i];
            }
        }
        return newArray;
    }

    public static char[] unbox(Character[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] newArray = new char[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            newArray[i] = array2[i].charValue();
        }
        return newArray;
    }

    public static byte[] unbox(Byte[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] newArray = new byte[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            newArray[i] = array2[i];
        }
        return newArray;
    }

    public static short[] unbox(Short[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] newArray = new short[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            newArray[i] = array2[i];
        }
        return newArray;
    }

    public static int[] unbox(Integer[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] newArray = new int[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            newArray[i] = array2[i];
        }
        return newArray;
    }

    public static long[] unbox(Long[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] newArray = new long[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            newArray[i] = array2[i];
        }
        return newArray;
    }

    public static float[] unbox(Float[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] newArray = new float[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            newArray[i] = array2[i].floatValue();
        }
        return newArray;
    }

    public static double[] unbox(Double[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] newArray = new double[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            newArray[i] = array2[i];
        }
        return newArray;
    }

    public static boolean[] unbox(Boolean[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] newArray = new boolean[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            newArray[i] = array2[i];
        }
        return newArray;
    }

    public static Character[] box(char[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_CHAR_OBJ_ARRAY;
        }
        Character[] newArray = new Character[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            newArray[i] = Character.valueOf(array2[i]);
        }
        return newArray;
    }

    public static Byte[] box(byte[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_BYTE_OBJ_ARRAY;
        }
        Byte[] newArray = new Byte[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            newArray[i] = array2[i];
        }
        return newArray;
    }

    public static Short[] box(short[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_SHORT_OBJ_ARRAY;
        }
        Short[] newArray = new Short[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            newArray[i] = array2[i];
        }
        return newArray;
    }

    public static Integer[] box(int[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_INT_OBJ_ARRAY;
        }
        Integer[] newArray = new Integer[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            newArray[i] = array2[i];
        }
        return newArray;
    }

    public static Long[] box(long[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_LONG_OBJ_ARRAY;
        }
        Long[] newArray = new Long[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            newArray[i] = array2[i];
        }
        return newArray;
    }

    public static Float[] box(float[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_FLOAT_OBJ_ARRAY;
        }
        Float[] newArray = new Float[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            newArray[i] = Float.valueOf(array2[i]);
        }
        return newArray;
    }

    public static Double[] box(double[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_DOUBLE_OBJ_ARRAY;
        }
        Double[] newArray = new Double[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            newArray[i] = array2[i];
        }
        return newArray;
    }

    public static Boolean[] box(boolean[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_BOOLEAN_OBJ_ARRAY;
        }
        Boolean[] newArray = new Boolean[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            newArray[i] = array2[i];
        }
        return newArray;
    }

    public static <T> T[] asArray(Class<T> clazz, List<T> list) {
        Object[] obj = (Object[])Array.newInstance(clazz, list.size());
        for (int i = 0; i < list.size(); ++i) {
            obj[i] = list.get(i);
        }
        return obj;
    }

    public static <T> T cast(Object array2, Class<T> toArrayClass) {
        if (!array2.getClass().isArray()) {
            throw new ClassCastException();
        }
        Class<?> toClass = toArrayClass.getComponentType();
        T obj = toArrayClass.cast(Array.newInstance(toClass, Array.getLength(array2)));
        for (int i = 0; i < Array.getLength(array2); ++i) {
            ArrayUtils.doSet(obj, i, Array.get(array2, i));
        }
        return obj;
    }

    private static void doSet(Object array2, int index, Object o) {
        Class<?> componentType = array2.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            if (componentType == Character.TYPE) {
                Array.setChar(array2, index, ((Character)o).charValue());
            } else if (componentType == Byte.TYPE) {
                Array.setByte(array2, index, ((Number)o).byteValue());
            } else if (componentType == Short.TYPE) {
                Array.setShort(array2, index, ((Number)o).shortValue());
            } else if (componentType == Integer.TYPE) {
                Array.setInt(array2, index, ((Number)o).intValue());
            } else if (componentType == Long.TYPE) {
                Array.setLong(array2, index, ((Number)o).longValue());
            } else if (componentType == Float.TYPE) {
                Array.setFloat(array2, index, ((Number)o).floatValue());
            } else if (componentType == Double.TYPE) {
                Array.setDouble(array2, index, ((Number)o).doubleValue());
            } else if (componentType == Boolean.TYPE) {
                Array.setBoolean(array2, index, (Boolean)o);
            }
        } else {
            Array.set(array2, index, o);
        }
    }

    public static byte[] charToBytes(char[] chars) {
        return ArrayUtils.charToBytes(chars, "UTF-8");
    }

    public static byte[] charToBytes(char[] chars, String encoding) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = Charset.forName(encoding).encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(charBuffer.array(), '\u0000');
        Arrays.fill(byteBuffer.array(), (byte)0);
        charBuffer = null;
        byteBuffer = null;
        System.gc();
        return bytes;
    }

    public static char[] bytesToChar(byte[] bytes) {
        return ArrayUtils.bytesToChar(bytes, "UTF-8");
    }

    public static char[] bytesToChar(byte[] bytes, String encoding) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        CharBuffer charBuffer = Charset.forName(encoding).decode(byteBuffer);
        char[] chars = Arrays.copyOfRange(charBuffer.array(), charBuffer.position(), charBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        Arrays.fill(charBuffer.array(), '\u0000');
        charBuffer = null;
        byteBuffer = null;
        System.gc();
        return chars;
    }

    public static <T> void fill(T[] array2, T with) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = with;
        }
    }

    public static void fill(char[] array2, char with) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = with;
        }
    }

    public static void fill(byte[] array2, byte with) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = with;
        }
    }

    public static void fill(short[] array2, short with) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = with;
        }
    }

    public static void fill(int[] array2, int with) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = with;
        }
    }

    public static void fill(long[] array2, long with) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = with;
        }
    }

    public static void fill(float[] array2, float with) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = with;
        }
    }

    public static void fill(double[] array2, double with) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = with;
        }
    }

    public static void fill(boolean[] array2, boolean with) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = with;
        }
    }
}

