/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.events.prefilters;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Prefilters;
import com.laytonsmith.core.events.prefilters.AbstractPrefilterMatcher;
import com.laytonsmith.core.events.prefilters.PrefilterMatcher;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Mixed;

public abstract class MacroPrefilterMatcher<T extends BindableEvent>
extends AbstractPrefilterMatcher<T> {
    @Override
    public PrefilterMatcher.PrefilterDocs getDocsObject() {
        return new MacroPrefilterDocs();
    }

    @Override
    public void validate(ParseTree node, CClassType nodeType, Environment env) throws ConfigCompileException, ConfigCompileGroupException, ConfigRuntimeException {
        if (node.isConst() && node.getData().val().isEmpty()) {
            env.getEnv(CompilerEnvironment.class).addCompilerWarning(node.getFileOptions(), new CompilerWarning("Hardcoded empty string, this will never match.", node.getTarget(), null));
        }
    }

    @Override
    public boolean matches(String key, Mixed value, T event, Target t) {
        String expression = value.val();
        Object javaObject = this.getProperty(event);
        if (expression.isEmpty()) {
            return false;
        }
        if (expression.charAt(0) == '(' && expression.charAt(expression.length() - 1) == ')') {
            try {
                return Prefilters.FastExpressionMatch(expression, key, (Double)javaObject, t);
            }
            catch (ClassCastException ex) {
                throw new RuntimeException("Unexpected class type, please report this bug to the developers.", ex);
            }
        }
        if (expression.charAt(0) == '/' && expression.charAt(expression.length() - 1) == '/') {
            return Prefilters.FastRegexMatch(expression, javaObject.toString());
        }
        return Prefilters.FastStringMatch(expression, javaObject.toString());
    }

    protected abstract Object getProperty(T var1);

    @Override
    public int getPriority() {
        return -1;
    }

    @api
    public static class MacroPrefilterDocs
    implements PrefilterMatcher.PrefilterDocs {
        @Override
        public String getName() {
            return "macro match";
        }

        @Override
        public String getNameWiki() {
            return "[[Prefilters#macro match|Macro]]";
        }

        @Override
        public String docs() {
            return "A macro prefilter is a combination of three other prefilter types, expression, regex, and string. Depending on the type of prefilter, only some of these may make sense. In general, the matcher used is determined by the surrounding characters of the prefilter string. If the prefilter is surrounded by parenthesis, it is an expression, if it is surrounded by forward slash (/) it is considered a regex, and if it isn't either of these, then it is considered a string match. For instance, array(prefilter: \"/myRegex/\") will use a regex match, and array(prefilter: \"myString\") will use a string match. Please see the other prefilter types for more information on the specific types.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }
}

