/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Vector3D;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.MCBlockCommandSender;
import com.laytonsmith.abstraction.MCChunk;
import com.laytonsmith.abstraction.MCColor;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCFireworkEffect;
import com.laytonsmith.abstraction.MCFireworkMeta;
import com.laytonsmith.abstraction.MCHumanEntity;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCLivingEntity;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.MCPotionData;
import com.laytonsmith.abstraction.MCProjectileSource;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.abstraction.blocks.MCBlock;
import com.laytonsmith.abstraction.blocks.MCBlockData;
import com.laytonsmith.abstraction.blocks.MCBlockFace;
import com.laytonsmith.abstraction.blocks.MCBlockProjectileSource;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.entities.MCAbstractHorse;
import com.laytonsmith.abstraction.entities.MCAreaEffectCloud;
import com.laytonsmith.abstraction.entities.MCArmorStand;
import com.laytonsmith.abstraction.entities.MCArrow;
import com.laytonsmith.abstraction.entities.MCAxolotl;
import com.laytonsmith.abstraction.entities.MCBee;
import com.laytonsmith.abstraction.entities.MCBlockDisplay;
import com.laytonsmith.abstraction.entities.MCBoat;
import com.laytonsmith.abstraction.entities.MCCat;
import com.laytonsmith.abstraction.entities.MCChestedHorse;
import com.laytonsmith.abstraction.entities.MCCommandMinecart;
import com.laytonsmith.abstraction.entities.MCCreeper;
import com.laytonsmith.abstraction.entities.MCDisplay;
import com.laytonsmith.abstraction.entities.MCEnderCrystal;
import com.laytonsmith.abstraction.entities.MCEnderDragon;
import com.laytonsmith.abstraction.entities.MCEnderSignal;
import com.laytonsmith.abstraction.entities.MCEnderman;
import com.laytonsmith.abstraction.entities.MCEvokerFangs;
import com.laytonsmith.abstraction.entities.MCExperienceOrb;
import com.laytonsmith.abstraction.entities.MCFallingBlock;
import com.laytonsmith.abstraction.entities.MCFireball;
import com.laytonsmith.abstraction.entities.MCFirework;
import com.laytonsmith.abstraction.entities.MCFox;
import com.laytonsmith.abstraction.entities.MCFrog;
import com.laytonsmith.abstraction.entities.MCGoat;
import com.laytonsmith.abstraction.entities.MCHanging;
import com.laytonsmith.abstraction.entities.MCHorse;
import com.laytonsmith.abstraction.entities.MCInteraction;
import com.laytonsmith.abstraction.entities.MCIronGolem;
import com.laytonsmith.abstraction.entities.MCItem;
import com.laytonsmith.abstraction.entities.MCItemDisplay;
import com.laytonsmith.abstraction.entities.MCItemFrame;
import com.laytonsmith.abstraction.entities.MCItemProjectile;
import com.laytonsmith.abstraction.entities.MCLightningStrike;
import com.laytonsmith.abstraction.entities.MCLlama;
import com.laytonsmith.abstraction.entities.MCMannequin;
import com.laytonsmith.abstraction.entities.MCMinecart;
import com.laytonsmith.abstraction.entities.MCMushroomCow;
import com.laytonsmith.abstraction.entities.MCOminousItemSpawner;
import com.laytonsmith.abstraction.entities.MCPainting;
import com.laytonsmith.abstraction.entities.MCPanda;
import com.laytonsmith.abstraction.entities.MCParrot;
import com.laytonsmith.abstraction.entities.MCPhantom;
import com.laytonsmith.abstraction.entities.MCPig;
import com.laytonsmith.abstraction.entities.MCPigZombie;
import com.laytonsmith.abstraction.entities.MCPiglin;
import com.laytonsmith.abstraction.entities.MCProjectile;
import com.laytonsmith.abstraction.entities.MCPufferfish;
import com.laytonsmith.abstraction.entities.MCRabbit;
import com.laytonsmith.abstraction.entities.MCSheep;
import com.laytonsmith.abstraction.entities.MCShulker;
import com.laytonsmith.abstraction.entities.MCShulkerBullet;
import com.laytonsmith.abstraction.entities.MCSlime;
import com.laytonsmith.abstraction.entities.MCSnowman;
import com.laytonsmith.abstraction.entities.MCSpectralArrow;
import com.laytonsmith.abstraction.entities.MCStrider;
import com.laytonsmith.abstraction.entities.MCTNT;
import com.laytonsmith.abstraction.entities.MCTextDisplay;
import com.laytonsmith.abstraction.entities.MCThrownPotion;
import com.laytonsmith.abstraction.entities.MCTransformation;
import com.laytonsmith.abstraction.entities.MCTrident;
import com.laytonsmith.abstraction.entities.MCTropicalFish;
import com.laytonsmith.abstraction.entities.MCVex;
import com.laytonsmith.abstraction.entities.MCVillager;
import com.laytonsmith.abstraction.entities.MCWitherSkull;
import com.laytonsmith.abstraction.entities.MCWolf;
import com.laytonsmith.abstraction.entities.MCZoglin;
import com.laytonsmith.abstraction.entities.MCZombie;
import com.laytonsmith.abstraction.entities.MCZombieVillager;
import com.laytonsmith.abstraction.enums.MCArt;
import com.laytonsmith.abstraction.enums.MCAxolotlType;
import com.laytonsmith.abstraction.enums.MCBodyPart;
import com.laytonsmith.abstraction.enums.MCCatType;
import com.laytonsmith.abstraction.enums.MCDyeColor;
import com.laytonsmith.abstraction.enums.MCEnderDragonPhase;
import com.laytonsmith.abstraction.enums.MCEntityEffect;
import com.laytonsmith.abstraction.enums.MCEntityType;
import com.laytonsmith.abstraction.enums.MCFireworkType;
import com.laytonsmith.abstraction.enums.MCFoxType;
import com.laytonsmith.abstraction.enums.MCMushroomCowType;
import com.laytonsmith.abstraction.enums.MCParrotType;
import com.laytonsmith.abstraction.enums.MCParticle;
import com.laytonsmith.abstraction.enums.MCPose;
import com.laytonsmith.abstraction.enums.MCPotionType;
import com.laytonsmith.abstraction.enums.MCProfession;
import com.laytonsmith.abstraction.enums.MCRabbitType;
import com.laytonsmith.abstraction.enums.MCRotation;
import com.laytonsmith.abstraction.enums.MCTreeSpecies;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.seealso;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.Optimizable;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREBadEntityException;
import com.laytonsmith.core.exceptions.CRE.CREBadEntityTypeException;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CREIndexOverflowException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidWorldException;
import com.laytonsmith.core.exceptions.CRE.CRELengthException;
import com.laytonsmith.core.exceptions.CRE.CREPlayerOfflineException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.CRE.CREUnsupportedOperationException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.functions.ExampleScript;
import com.laytonsmith.core.functions.Minecraft;
import com.laytonsmith.core.functions.MobManagement;
import com.laytonsmith.core.functions.PlayerManagement;
import com.laytonsmith.core.functions.World;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class EntityManagement {
    public static String docs() {
        return "This class of functions allow entities to be managed.";
    }

    public static CArray GetArrayFromTransformation(MCTransformation tr) {
        Target t = Target.UNKNOWN;
        Quaternionf leftRotationT = tr.getLeftRotation();
        Quaternionf rightRotationT = tr.getRightRotation();
        Vector3f scaleT = tr.getScale();
        Vector3f translationT = tr.getTranslation();
        CArray leftRotation = CArray.GetAssociativeArray(t);
        leftRotation.set("w", leftRotationT.w);
        leftRotation.set("x", leftRotationT.x);
        leftRotation.set("y", leftRotationT.y);
        leftRotation.set("z", leftRotationT.z);
        CArray rightRotation = CArray.GetAssociativeArray(t);
        rightRotation.set("w", rightRotationT.w);
        rightRotation.set("x", rightRotationT.x);
        rightRotation.set("y", rightRotationT.y);
        rightRotation.set("z", rightRotationT.z);
        CArray scale = CArray.GetAssociativeArray(t);
        scale.set("x", scaleT.x);
        scale.set("y", scaleT.y);
        scale.set("z", scaleT.z);
        CArray translation = CArray.GetAssociativeArray(t);
        translation.set("x", translationT.x);
        translation.set("y", translationT.y);
        translation.set("z", translationT.z);
        CArray transformation = CArray.GetAssociativeArray(t);
        transformation.set("leftRotation", (Mixed)leftRotation, t);
        transformation.set("rightRotation", (Mixed)rightRotation, t);
        transformation.set("scale", (Mixed)scale, t);
        transformation.set("translation", (Mixed)translation, t);
        return transformation;
    }

    public static MCTransformation GetTransformationFromMatrix(float[] f) {
        Matrix4f matrix4f = new Matrix4f(f[0], f[1], f[2], f[3], f[4], f[5], f[6], f[7], f[8], f[9], f[10], f[11], f[12], f[13], f[14], f[15]);
        matrix4f.transpose();
        Matrix3f matrix3f = new Matrix3f(matrix4f);
        Vector3f translation = matrix4f.getTranslation(new Vector3f());
        float multiplier = 1.0f / matrix4f.m33();
        if (multiplier != 1.0f) {
            matrix3f.scale(multiplier);
            translation.mul(multiplier);
        }
        Triple triple = null;
        Class MatrixUtil = ReflectionUtils.forName("com.mojang.math.MatrixUtil");
        for (String method : new String[]{"svdDecompose", "a"}) {
            if (!ReflectionUtils.hasMethod(MatrixUtil, method, Triple.class, Matrix3f.class)) continue;
            triple = (Triple)ReflectionUtils.invokeMethod(MatrixUtil, null, method, new Class[]{Matrix3f.class}, new Object[]{matrix3f});
            break;
        }
        if (triple == null) {
            throw new Error("Cannot find svdDecompose method.");
        }
        Vector3f scale = (Vector3f)triple.getMiddle();
        Quaternionf leftRotation = ((Quaternionf)triple.getLeft()).rotateY((float)Math.PI);
        Quaternionf rightRotation = (Quaternionf)triple.getRight();
        MCTransformation tr = StaticLayer.GetTransformation(leftRotation, rightRotation, scale, translation);
        return tr;
    }

    @api
    @seealso(value={get_entity_pose.class})
    public static class set_entity_pose
    extends EntitySetterFunction {
        @Override
        public String getName() {
            return "set_entity_pose";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        @Override
        public String docs() {
            return "void {entityUUID, pose, [fixed]} Sets an entity's pose. (only Mannequins on Spigot, 1.20.1+ on Paper)\nThe fixed argument is a boolean for whether the pose should stay unless manually changed.\n(defaults to false) While in most cases you can set any pose to any entity,\nonly certain poses will result in a noticable change for a particular entity type.\nPoses can affect entity hitboxes but do not otherwise change entity state.\nSee {{function|get_entity_pose}} for a list of poses.\n";
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            try {
                MCPose pose = MCPose.valueOf(args[1].val().toUpperCase());
                boolean fixed = false;
                if (args.length == 3) {
                    fixed = ArgumentValidation.getBooleanObject(args[2], t);
                }
                entity.setPose(pose, fixed);
            }
            catch (IllegalArgumentException ex) {
                throw new CREFormatException("Invalid pose for this entity: " + args[1].val(), t);
            }
            return CVoid.VOID;
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }

    @api
    @seealso(value={set_entity_pose.class})
    public static class get_entity_pose
    extends EntityGetterFunction {
        @Override
        public String getName() {
            return "get_entity_pose";
        }

        @Override
        public String docs() {
            return "string {entityUUID} Returns the pose of an entity. Poses are desynchronized from entity state,\nas the pose is set at the end of a tick and can be set to anything by a plugin.\n----\nKnown poses:\n{| class=\"wikitable\"\n|-\n! scope=\"col\" width=\"20%\" | Entity Types\n! scope=\"col\" width=\"80%\" | Poses\n|-\n! All Entities\n| STANDING (default pose)\n|-\n! Living Entities\n| DYING, SLEEPING\n|-\n! Most Humanoid Entities\n| SNEAKING, SWIMMING, FALL_FLYING\n|-\n! Breeze\n| INHALING, LONG_JUMPING, SHOOTING, SLIDING\n|-\n! Camel\n| SITTING\n|-\n! Cat/Ocelot\n| SNEAKING\n|-\n! Frog\n| CROAKING, LONG_JUMPING, USING_TONGUE\n|-\n! Goat\n| LONG_JUMPING\n|-\n! Mannequin\n| Only FALL_FLYING, SLEEPING, SNEAKING, STANDING, SWIMMING\n|-\n! Player\n| SPIN_ATTACK\n|-\n! Warden\n| DIGGING, EMERGING, ROARING, SNIFFING\n|}\n";
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            return new CString(entity.getPose().name(), t);
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }

    @api
    @seealso(value={PlayerManagement.pshow_entity.class, PlayerManagement.phide_entity.class, PlayerManagement.pcan_see_entity.class, is_entity_hidden_by_default.class})
    public static class set_entity_hidden_by_default
    extends EntitySetterFunction {
        @Override
        public String getName() {
            return "set_entity_hidden_by_default";
        }

        @Override
        public String docs() {
            return "void {entityUUID, hidden} Sets whether an entity's is hidden by default to clients. (MC 1.19.3+) If set to true, pshow_entity() must be used before a player's client can see this entity. Unrelated to the invisibility potion effect.";
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            entity.setVisibleByDefault(!ArgumentValidation.getBooleanObject(args[1], t));
            return CVoid.VOID;
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }

    @api
    @seealso(value={PlayerManagement.pshow_entity.class, PlayerManagement.phide_entity.class, PlayerManagement.pcan_see_entity.class, set_entity_hidden_by_default.class})
    public static class is_entity_hidden_by_default
    extends EntityGetterFunction {
        @Override
        public String getName() {
            return "is_entity_hidden_by_default";
        }

        @Override
        public String docs() {
            return "boolean {entityUUID} Returns whether an entity is hidden by default to clients. (MC 1.19.3+) If true, pshow_entity() must be used before a player's client can see this entity. Unrelated to the invisibility potion effect.";
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            return CBoolean.get(!entity.isVisibleByDefault());
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }

    @api
    @seealso(value={get_entity_killer.class})
    public static class set_entity_killer
    extends EntitySetterFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREFormatException.class, CRELengthException.class, CREBadEntityException.class};
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCLivingEntity entity = Static.getLivingEntity(args[0], t);
            if (args[1] instanceof CNull) {
                entity.setKiller(null);
            } else {
                MCPlayer killer = Static.GetPlayer(args[1], t);
                entity.setKiller(killer);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "set_entity_killer";
        }

        @Override
        public String docs() {
            return "void {entityUUID, player} Sets the player killer of a living entity. (Paper only) Can be set at any time before the entity dies to change kill attribution for the next five seconds or until it's changed again. Can be set to null.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }

    @api
    @seealso(value={set_entity_killer.class})
    public static class get_entity_killer
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCLivingEntity entity = Static.getLivingEntity(args[0], t);
            MCPlayer killer = entity.getKiller();
            if (killer == null) {
                return CNull.NULL;
            }
            return new CString(killer.getName(), t);
        }

        @Override
        public String getName() {
            return "get_entity_killer";
        }

        @Override
        public String docs() {
            return "string {entityUUID} Gets the player killer of a living entity. Can be null. Usually indicates the last player that damaged the entity within the last five seconds.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }

    @api
    public static class set_entity_rotation
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREUnsupportedOperationException.class, CRELengthException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return false;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            float yaw = (float)ArgumentValidation.getDouble(args[1], t);
            float pitch = args.length == 3 ? (float)ArgumentValidation.getDouble(args[2], t) : entity.getLocation().getPitch();
            try {
                entity.setRotation(yaw, pitch);
            }
            catch (UnsupportedOperationException ex) {
                throw new CREUnsupportedOperationException(this.getName() + " cannot be used on players.", t);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "set_entity_rotation";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        @Override
        public String docs() {
            return "void {entityUUID, yaw, [pitch]} Sets an entity's yaw and pitch without teleporting or ejecting. Can only be used on players when on Paper 1.19 or above, otherwise will throw an UnsupportedOperationException.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }

    @api
    public static class entity_in_water
    extends EntityGetterFunction {
        @Override
        public String getName() {
            return "entity_in_water";
        }

        @Override
        public String docs() {
            return "boolean {entityUUID} Returns whether an entity is colliding with water. This accounts for waterlogged blocks, bubble columns, and fluid height. It does not account for water cauldrons.";
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            return CBoolean.get(entity.isInWater());
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }

    @api
    public static class get_entity_transient_id
    extends EntityGetterFunction {
        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            return new CInt(entity.getEntityId(), t);
        }

        @Override
        public String getName() {
            return "get_entity_transient_id";
        }

        @Override
        public String docs() {
            return "int {uuid} Given a permanent entity uuid, returns the transient entity id. This should not be stored, as it is reset every restart, and is only useful for dealing with low level packets.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_display_entity.class})
    public static class set_display_entity
    extends EntitySetterFunction {
        @Override
        public String getName() {
            return "set_display_entity";
        }

        @Override
        public String docs() {
            return "void {entityUUID, array} Sets the data for a display entity. See {{function|get_display_entity}} for details about the array format. ----  Note that there a couple additional points for setting the data that is unique to the set function:\n\nThe '''transformation''' property can be provided in the same format as received (i.e. with the leftRotation, rightRotation, scale, and translation properties) but you can also provide it as a length 16 array of floats. These are accepted in the same order that the /data command would accept them. Regardless of how they are input, the function will always return the complex object. Sub-properties of the transformation property are optional - missing values will not be changed.\n\nThe '''startinterpolation''' (int) property, if given, interpolates from the current values on the client to any changed values the server sent this tick. It halts existing interpolations, then starts interpolating on the current tick plus the given number of ticks (can be negative), and finishes after 'interpolationduration' ticks. The following values are interpolated if changed: transformation, shadow radius, shadow strength, text background, and text opacity. If none of those values are changed, it will use the last set again for interpolation. If the values are changed but 'startinterpolation' isn't sent, it will continue interpolation for the remaining duration but with the new values.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Mixed m;
            MCEntity entity = Static.getEntity(args[0], t);
            if (!(entity instanceof MCDisplay)) {
                throw new CREBadEntityException("Not a display entity.", t);
            }
            MCDisplay display = (MCDisplay)entity;
            CArray info = ArgumentValidation.getArray(args[1], t);
            if (!info.isAssociative()) {
                throw new CREIllegalArgumentException("Expected an associative array but found a normal array.", t);
            }
            if (info.containsKey("billboard")) {
                try {
                    MCDisplay.Billboard billboard = MCDisplay.Billboard.valueOf(info.get("billboard", t).val());
                    display.setBillboard(billboard);
                }
                catch (IllegalArgumentException ex) {
                    throw new CREFormatException("Invalid billboard type for display entity.", t);
                }
            }
            if (info.containsKey("brightness")) {
                m = info.get("brightness", t);
                if (m instanceof CNull) {
                    display.setBrightness(null);
                } else {
                    MCDisplay.Brightness brightness;
                    if (m.isInstanceOf(CArray.TYPE)) {
                        CArray brightnessArray = (CArray)m;
                        if (!brightnessArray.isAssociative()) {
                            throw new CREIllegalArgumentException("Expected an associative array for brightness but found a normal array.", t);
                        }
                        int blockBrightness = ArgumentValidation.getInt32(brightnessArray.get("block", t), t);
                        int skyBrightness = ArgumentValidation.getInt32(brightnessArray.get("sky", t), t);
                        brightness = new MCDisplay.Brightness(blockBrightness, skyBrightness);
                    } else {
                        int level = ArgumentValidation.getInt32(m, t);
                        brightness = new MCDisplay.Brightness(level, level);
                    }
                    try {
                        display.setBrightness(brightness);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new CREIllegalArgumentException(ex.getMessage(), t);
                    }
                }
            }
            if (info.containsKey("glowcolor") && !((m = info.get("glowcolor", t)) instanceof CNull)) {
                MCColor color2 = ObjectGenerator.GetGenerator().color(ArgumentValidation.getArray(m, t), t);
                display.setGlowColorOverride(color2);
            }
            if (info.containsKey("height")) {
                display.setDisplayHeight((float)ArgumentValidation.getDouble(info.get("height", t), t));
            }
            if (info.containsKey("width")) {
                display.setDisplayWidth((float)ArgumentValidation.getDouble(info.get("width", t), t));
            }
            if (info.containsKey("viewrange")) {
                display.setViewRange((float)ArgumentValidation.getDouble(info.get("viewrange", t), t));
            }
            if (info.containsKey("shadowradius")) {
                display.setShadowRadius((float)ArgumentValidation.getDouble(info.get("shadowradius", t), t));
            }
            if (info.containsKey("shadowstrength")) {
                display.setShadowStrength((float)ArgumentValidation.getDouble(info.get("shadowstrength", t), t));
            }
            if (info.containsKey("teleportduration") && Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_2)) {
                int ticks = ArgumentValidation.getInt32(info.get("teleportduration", t), t);
                if (ticks < 0 || ticks > 59) {
                    throw new CRERangeException("Teleport duration must be from 0 - 59, but got " + ticks, t);
                }
                display.setTeleportDuration(ticks);
            }
            if (info.containsKey("interpolationduration")) {
                display.setInterpolationDurationTicks(ArgumentValidation.getInt32(info.get("interpolationduration", t), t));
            }
            if (info.containsKey("startinterpolation")) {
                display.setInterpolationDelayTicks(ArgumentValidation.getInt32(info.get("startinterpolation", t), t));
            }
            if (info.containsKey("transformation")) {
                CArray transformation = ArgumentValidation.getArray(info.get("transformation", t), t);
                if (transformation.size() == 16L) {
                    float[] f = new float[16];
                    for (int i = 0; i < 16; ++i) {
                        f[i] = ArgumentValidation.getDouble32(transformation.get(i, t), t);
                    }
                    MCTransformation tr = EntityManagement.GetTransformationFromMatrix(f);
                    display.setTransformation(tr);
                } else {
                    Vector3f translation;
                    Vector3f scale;
                    Quaternionf rightRotation;
                    Quaternionf leftRotation;
                    MCTransformation existingTransformation = display.getTransformation();
                    if (transformation.containsKey("leftRotation")) {
                        CArray leftRotationC = ArgumentValidation.getArray(transformation.get("leftRotation", t), t);
                        leftRotation = new Quaternionf(ArgumentValidation.getDouble(leftRotationC.get("x", t), t), ArgumentValidation.getDouble(leftRotationC.get("y", t), t), ArgumentValidation.getDouble(leftRotationC.get("z", t), t), ArgumentValidation.getDouble(leftRotationC.get("w", t), t));
                    } else {
                        leftRotation = existingTransformation.getLeftRotation();
                    }
                    if (transformation.containsKey("rightRotation")) {
                        CArray rightRotationC = ArgumentValidation.getArray(transformation.get("rightRotation", t), t);
                        rightRotation = new Quaternionf(ArgumentValidation.getDouble(rightRotationC.get("x", t), t), ArgumentValidation.getDouble(rightRotationC.get("y", t), t), ArgumentValidation.getDouble(rightRotationC.get("z", t), t), ArgumentValidation.getDouble(rightRotationC.get("w", t), t));
                    } else {
                        rightRotation = existingTransformation.getRightRotation();
                    }
                    if (transformation.containsKey("scale")) {
                        CArray scaleC = ArgumentValidation.getArray(transformation.get("scale", t), t);
                        scale = new Vector3f(ArgumentValidation.getDouble32(scaleC.get("x", t), t), ArgumentValidation.getDouble32(scaleC.get("y", t), t), ArgumentValidation.getDouble32(scaleC.get("z", t), t));
                    } else {
                        scale = existingTransformation.getScale();
                    }
                    if (transformation.containsKey("translation")) {
                        CArray translationC = ArgumentValidation.getArray(transformation.get("translation", t), t);
                        translation = new Vector3f(ArgumentValidation.getDouble32(translationC.get("x", t), t), ArgumentValidation.getDouble32(translationC.get("y", t), t), ArgumentValidation.getDouble32(translationC.get("z", t), t));
                    } else {
                        translation = existingTransformation.getTranslation();
                    }
                    MCTransformation tr = StaticLayer.GetTransformation(leftRotation, rightRotation, scale, translation);
                    display.setTransformation(tr);
                }
            }
            return CVoid.VOID;
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREBadEntityException.class, CRELengthException.class, CREFormatException.class, CREIllegalArgumentException.class, CRECastException.class, CRERangeException.class};
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class get_transformation_from_matrix
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRELengthException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            float[] f = new float[16];
            if (args.length == 1) {
                CArray array2 = ArgumentValidation.getArray(args[0], t);
                if (array2.size() != 16L) {
                    throw new CRELengthException("Input array expected to have length 16", t);
                }
                for (int i = 0; i < 16; ++i) {
                    f[i] = ArgumentValidation.getDouble32(array2.get(i, t), t);
                }
            } else {
                for (int i = 0; i < 16; ++i) {
                    f[i] = ArgumentValidation.getDouble32(args[i], t);
                }
            }
            MCTransformation tr = EntityManagement.GetTransformationFromMatrix(f);
            return EntityManagement.GetArrayFromTransformation(tr);
        }

        @Override
        public String getName() {
            return "get_transformation_from_matrix";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 16};
        }

        @Override
        public String docs() {
            return "array {array matrix | float f0, float f1, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15} Converts a Minecraft transformation matrix into a transformation object. This is the same underlying algorithm that set_display_entity uses when accepting a transformation matrix.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_display_entity.class})
    public static class get_display_entity
    extends EntityGetterFunction {
        @Override
        public String getName() {
            return "get_display_entity";
        }

        @Override
        public String docs() {
            return "array {entityUUID} Returns an associative array of display entity data. Array keys are: 'billboard', 'brightness', 'glowcolor', 'height', 'width', 'viewrange', 'shadowradius', 'shadowstrength', 'teleportduration', and 'transformation'. ----  The following values are common to all display entity types. Data about specific display entity types (block, text, and item display entities) can be found in {{function|entity_spec}}.\n\n* '''billboard''' (string) : Controls which axes the rendered entity rotates around the entity location when the viewing player's position or facing changes. FIXED (default) will not rotate. HORIZONTAL or VERTICAL rotate on their respective axes. CENTER rotates on both axes.\n* '''brightness''' (array) : Controls the brightness when rendering the display entity. A null value (default) will render the entity based on the environment. An array with int values for the keys '''\"block\"''' and '''\"sky\"''' simulate the rendering brightness from those respective light sources. Each must be from 0 - 15. Optionally a single int can be provided and will be used for both sky and block sources.\n* '''glowcolor''' (array) : An RGB array for the entity glow color. If null (default), the entity will use its scoreboard team color, if it has one.\n* '''height''' (double) : The maximum height of the entity's bounding box. (default: 0.0) Spans vertically from the entity's y location to (y+height), and is used for culling. If the client's field of view does not include this box, the entity will not be rendered. If either width or height is 0.0, culling is disabled.\n* '''width''' (double) : The maximum width of the entity's bounding box. (default: 0.0) Spans horizontally (width/2) from entity location.\n* '''viewrange''' (double) : The relative distance the entity will be viewable. The default is 1.0, which is 64 meters multiplied by the player's entity distance scaling. This can also be limited by the world's entity-tracking-range for display entities.\n* '''shadowradius''' (double) : The visible radius in meters of the entity's shadow. Effective range is from 0.0 (default) to 64.0.\n* '''shadowstrength''' (double) : The opacity of the entity's shadow as a function of distance to a block below the entity within shadowradius. (default: 1.0)\n* '''teleportduration''' (int) : The duration in ticks a teleport is interpolated on the client. Range is strictly from 0 - 59. (default: 0) (MC 1.20.2+)\n* '''interpolationduration''' (int) : The duration in ticks of interpolations. (non-teleport)\n* '''transformation''' (array) : An associative array that includes 4 values, leftRotation, rightRotation, scale, and translation. Both leftRotation and rightRotation have x, y, z, and w values, and scale and translation have x, y, and z values. All are 32 bit floats.\n\n";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            if (!(entity instanceof MCDisplay)) {
                throw new CREBadEntityException("Not a display entity.", t);
            }
            MCDisplay display = (MCDisplay)entity;
            CArray info = CArray.GetAssociativeArray(t);
            info.set("billboard", display.getBillboard().name());
            MCDisplay.Brightness brightness = display.getBrightness();
            if (brightness != null) {
                CArray brightnessArray = CArray.GetAssociativeArray(t);
                brightnessArray.set("block", (Mixed)new CInt(brightness.block(), t), t);
                brightnessArray.set("sky", (Mixed)new CInt(brightness.block(), t), t);
                info.set("brightness", (Mixed)brightnessArray, t);
            } else {
                info.set("brightness", (Mixed)CNull.NULL, t);
            }
            MCColor color2 = display.getGlowColorOverride();
            if (color2 != null) {
                info.set("glowcolor", (Mixed)ObjectGenerator.GetGenerator().color(color2, t), t);
            } else {
                info.set("glowcolor", (Mixed)CNull.NULL, t);
            }
            info.set("height", (Mixed)new CDouble(display.getDisplayHeight(), t), t);
            info.set("width", (Mixed)new CDouble(display.getDisplayWidth(), t), t);
            info.set("viewrange", (Mixed)new CDouble(display.getViewRange(), t), t);
            info.set("shadowradius", (Mixed)new CDouble(display.getShadowRadius(), t), t);
            info.set("shadowstrength", (Mixed)new CDouble(display.getShadowStrength(), t), t);
            if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_2)) {
                info.set("teleportduration", (Mixed)new CInt(display.getTeleportDuration(), t), t);
            }
            info.set("interpolationduration", (Mixed)new CInt(display.getInterpolationDurationTicks(), t), t);
            MCTransformation tr = display.getTransformation();
            CArray transformation = EntityManagement.GetArrayFromTransformation(tr);
            info.set("transformation", (Mixed)transformation, t);
            return info;
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_hanging_direction.class})
    public static class set_hanging_direction
    extends AbstractFunction
    implements Optimizable {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREBadEntityException.class, CRELengthException.class, CREFormatException.class, CREIllegalArgumentException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return false;
        }

        @Override
        public CClassType getReturnType(Target t, List<CClassType> argTypes, List<Target> argTargets, Environment env, Set<ConfigCompileException> exceptions) {
            return CVoid.TYPE;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            if (entity instanceof MCHanging) {
                MCHanging hanging = (MCHanging)entity;
                try {
                    MCBlockFace face = MCBlockFace.valueOf(args[1].val());
                    boolean force = false;
                    if (args.length == 3) {
                        force = ArgumentValidation.getBooleanObject(args[2], t);
                    }
                    hanging.setFacingDirection(face, force);
                    return CVoid.VOID;
                }
                catch (IllegalArgumentException ex) {
                    throw new CREIllegalArgumentException("Invalid direction for " + entity.getType().name() + ": " + args[1].val(), t);
                }
            }
            throw new CREBadEntityException("Not a hanging entity.", t);
        }

        @Override
        public String getName() {
            return "set_hanging_direction";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        @Override
        public String docs() {
            return "void {entityUUID, direction, [force]} Sets the direction a hanging entity is facing. Valid directions are NORTH, SOUTH, EAST, and WEST. UP and DOWN are also valid for item frames. A hanging will not change direction if there's no supporting block in the new position. However, the 'force' parameter can be set to true to override this behavior. While leash hitches are technically hangings, they don't support different directions.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            if (children.size() < 2) {
                return null;
            }
            Mixed data = children.get(1).getData();
            if (data instanceof CString) {
                try {
                    MCBlockFace.valueOf(data.val());
                    if (!data.val().contains("_") && !data.val().equals("SELF")) {
                        return null;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                throw new CREIllegalArgumentException("Invalid direction. Must be one of UP, DOWN, NORTH, SOUTH, EAST or WEST", data.getTarget());
            }
            return null;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_hanging_direction.class})
    public static class get_hanging_direction
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            if (entity instanceof MCHanging) {
                MCHanging hanging = (MCHanging)entity;
                return new CString(hanging.getFacing().name(), t);
            }
            throw new CREBadEntityException("Not a hanging entity.", t);
        }

        @Override
        public String getName() {
            return "get_hanging_direction";
        }

        @Override
        public CClassType getReturnType(Target t, List<CClassType> argTypes, List<Target> argTargets, Environment env, Set<ConfigCompileException> exceptions) {
            return CString.TYPE;
        }

        @Override
        public String docs() {
            return "string {entityUUID} Returns the direction a hanging entity is facing.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class launch_firework
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREFormatException.class, CRERangeException.class, CREInvalidWorldException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCPlayer p2 = environment.getEnv(CommandHelperEnvironment.class).GetPlayer();
            MCWorld w = null;
            if (p2 != null) {
                w = p2.getWorld();
            }
            MCLocation loc = ObjectGenerator.GetGenerator().location(args[0], w, t);
            CArray options = args.length == 2 ? ArgumentValidation.getArray(args[1], t) : CArray.GetAssociativeArray(t);
            int strength = 2;
            if (options.containsKey("strength") && (strength = ArgumentValidation.getInt32(options.get("strength", t), t)) > 127) {
                throw new CRERangeException("Strength cannot be higher than 127", t);
            }
            ArrayList<MCFireworkEffect> effects = new ArrayList<MCFireworkEffect>();
            if (options.containsKey("effects")) {
                Mixed cEffects = options.get("effects", t);
                if (!cEffects.isInstanceOf(CArray.TYPE)) throw new CREFormatException("Firework effects must be an array.", t);
                for (Mixed c : ((CArray)cEffects).asList()) {
                    effects.add(ObjectGenerator.GetGenerator().fireworkEffect((CArray)c, t));
                }
            } else {
                effects.add(ObjectGenerator.GetGenerator().fireworkEffect(options, t));
            }
            MCFirework firework = loc.getWorld().launchFirework(loc, strength, effects);
            return new CString(firework.getUniqueId().toString(), t);
        }

        @Override
        public String getName() {
            return "launch_firework";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        @Override
        public String docs() {
            Class<?> c;
            try {
                c = Class.forName(MCColor.class.getName(), false, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(Minecraft.class.getName()).log(Level.SEVERE, null, ex);
                return "";
            }
            ArrayList<String> names = new ArrayList<String>();
            for (Field f : c.getFields()) {
                if (f.getType() != MCColor.class) continue;
                names.add(f.getName());
            }
            return "string {locationArray, [optionsArray]} Launches a firework rocket. The location array specifies where it is launched from, and the options array is an associative array described below. All parameters in the array are optional, and default to the specified values if not set. The default options being set will make it look like a normal firework, with a white explosion. Returns the firework rocket entity's UUID. ---- The options array may have the following keys:\n{| cellspacing=\"1\" cellpadding=\"1\" border=\"1\" class=\"wikitable\"\n! Key !! Description !! Default\n|-\n| strength || A number indicating the flight duration of the rocket equal to the amount of gunpowder used to craft a rocket. (negative numbers detonate immediately) || 2\n|-\n| flicker || A boolean, determining if the firework will flicker || false\n|-\n| trail || A boolean, determining if the firework will leave a trail || true\n|-\n| colors || An array of colors, or a pipe separated string of color names for instance: array('WHITE') or 'WHITE<nowiki>|</nowiki>BLUE'. If you want custom colors, you must use an array, though you can still use color names as an item in the array, for instance: array('ORANGE', array(30, 45, 150)). These colors are used as the primary colors. || 'WHITE'\n|-\n| fade || An array of colors to be used as the fade colors. This parameter should be formatted the same as the colors parameter || array()\n|-\n| type || An enum value of one of the firework types, one of: " + StringUtils.Join(MCFireworkType.values(), ", ", " or ") + " || " + MCFireworkType.BALL.name() + "\n|}\nThe \"named colors\" can be one of: " + StringUtils.Join(names, ", ", " or ");
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class drop_item
    extends AbstractFunction {
        @Override
        public String getName() {
            return "drop_item";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3};
        }

        @Override
        public String docs() {
            return "string {[player/LocationArray], itemArray, [spawnNaturally]} Drops the specified item stack at the specified player's feet (or at an arbitrary Location, if an array is given), and returns its entity UUID. spawnNaturally takes a boolean, which forces the way the item will be spawned. If true, the item will be dropped with a random velocity.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CREFormatException.class, CREPlayerOfflineException.class, CREInvalidWorldException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_2_0;
        }

        @Override
        public Boolean runAsync() {
            return false;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCItemStack is;
            boolean natural;
            MCLocation l;
            if (args.length == 1) {
                if (env.getEnv(CommandHelperEnvironment.class).GetPlayer() == null) {
                    throw new CREPlayerOfflineException("Invalid sender!", t);
                }
                l = env.getEnv(CommandHelperEnvironment.class).GetPlayer().getEyeLocation();
                natural = false;
                is = ObjectGenerator.GetGenerator().item(args[0], t);
            } else {
                if (args[0].isInstanceOf(CArray.TYPE)) {
                    p = env.getEnv(CommandHelperEnvironment.class).GetPlayer();
                    l = ObjectGenerator.GetGenerator().location(args[0], p != null ? p.getWorld() : null, t);
                    natural = true;
                } else {
                    p = Static.GetPlayer(args[0].val(), t);
                    l = p.getEyeLocation();
                    natural = false;
                }
                is = ObjectGenerator.GetGenerator().item(args[1], t);
            }
            if (is.isEmpty()) {
                return CNull.NULL;
            }
            if (args.length == 3) {
                natural = ArgumentValidation.getBoolean(args[2], t);
            }
            MCItem item = natural ? l.getWorld().dropItemNaturally(l, is) : l.getWorld().dropItem(l, is);
            return new CString(item.getUniqueId().toString(), t);
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={add_scoreboard_tag.class, has_scoreboard_tag.class, get_scoreboard_tags.class})
    public static class remove_scoreboard_tag
    extends EntitySetterFunction {
        @Override
        public String getName() {
            return "remove_scoreboard_tag";
        }

        @Override
        public String docs() {
            return "boolean {entityUUID, tag} Removes a tag from the entity. Returns whether or not it was successful.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e = Static.getEntity(args[0], t);
            return CBoolean.get(e.removeScoreboardTag(args[1].val()));
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={remove_scoreboard_tag.class, has_scoreboard_tag.class, get_scoreboard_tags.class})
    public static class add_scoreboard_tag
    extends EntitySetterFunction {
        @Override
        public String getName() {
            return "add_scoreboard_tag";
        }

        @Override
        public String docs() {
            return "boolean {entityUUID, tag} Adds a tag to the entity. Returns whether or not it was successful.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e = Static.getEntity(args[0], t);
            return CBoolean.get(e.addScoreboardTag(args[1].val()));
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_scoreboard_tags.class, add_scoreboard_tag.class, remove_scoreboard_tag.class})
    public static class has_scoreboard_tag
    extends EntityFunction {
        @Override
        public String getName() {
            return "has_scoreboard_tag";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "boolean {entityUUID, tag} Returns whether this entity has a specific tag.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e = Static.getEntity(args[0], t);
            return CBoolean.get(e.hasScoreboardTag(args[1].val()));
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={add_scoreboard_tag.class, has_scoreboard_tag.class, remove_scoreboard_tag.class})
    public static class get_scoreboard_tags
    extends EntityGetterFunction {
        @Override
        public String getName() {
            return "get_scoreboard_tags";
        }

        @Override
        public String docs() {
            return "array {entityUUID} Returns an array of scoreboard tags for this entity.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e = Static.getEntity(args[0], t);
            CArray tags = new CArray(t);
            for (String tag : e.getScoreboardTags()) {
                tags.push(new CString(tag, t), t);
            }
            return tags;
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_entity_freezing.class})
    public static class set_entity_freezing
    extends EntitySetterFunction {
        @Override
        public String getName() {
            return "set_entity_freezing";
        }

        @Override
        public String docs() {
            return "void {entityUUID, int} Sets how many server ticks the entity has been freezing. (MC 1.17+) Must be above zero, and will clamp to the maximum the server allows.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREFormatException.class, CRELengthException.class, CREBadEntityException.class, CRERangeException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            int ticks = ArgumentValidation.getInt32(args[1], t);
            if (ticks < 0) {
                throw new CRERangeException("Freezing ticks must not be below zero.", t);
            }
            entity.setFreezingTicks(ticks);
            return CVoid.VOID;
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_entity_freezing.class})
    public static class get_entity_freezing
    extends EntityGetterFunction {
        @Override
        public String getName() {
            return "get_entity_freezing";
        }

        @Override
        public String docs() {
            return "int {entityUUID} Returns the number of ticks the entity has been freezing in powdered snow. (MC 1.17+) Counts down by 2 every tick when entity is thawing.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e = Static.getEntity(args[0], t);
            return new CInt(e.getFreezingTicks(), t);
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_entity_invulnerable.class})
    public static class set_entity_invulnerable
    extends EntitySetterFunction {
        @Override
        public String getName() {
            return "set_entity_invulnerable";
        }

        @Override
        public String docs() {
            return "void {entityUUID, boolean} If set to true the entity cannot be damaged, except by players in creative mode";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e = Static.getEntity(args[0], t);
            e.setInvulnerable(ArgumentValidation.getBoolean(args[1], t));
            return CVoid.VOID;
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_entity_invulnerable.class})
    public static class get_entity_invulnerable
    extends EntityGetterFunction {
        @Override
        public String getName() {
            return "get_entity_invulnerable";
        }

        @Override
        public String docs() {
            return "boolean {entityUUID} Returns true if the entity cannot be damaged";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.GenerateCBoolean(Static.getEntity(args[0], t).isInvulnerable(), t);
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_entity_gravity.class})
    public static class set_entity_gravity
    extends EntitySetterFunction {
        @Override
        public String getName() {
            return "set_entity_gravity";
        }

        @Override
        public String docs() {
            return "void {entityUUID, boolean} Sets whether or not gravity applies to the entity.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e = Static.getEntity(args[0], t);
            e.setHasGravity(ArgumentValidation.getBoolean(args[1], t));
            return CVoid.VOID;
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_entity_gravity.class})
    public static class get_entity_gravity
    extends EntityGetterFunction {
        @Override
        public String getName() {
            return "get_entity_gravity";
        }

        @Override
        public String docs() {
            return "boolean {entityUUID} Returns true if gravity applies to the entity.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.GenerateCBoolean(Static.getEntity(args[0], t).hasGravity(), t);
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_entity_silent.class})
    public static class set_entity_silent
    extends EntitySetterFunction {
        @Override
        public String getName() {
            return "set_entity_silent";
        }

        @Override
        public String docs() {
            return "void {entityUUID, boolean} Sets whether or not entity produces sounds";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e = Static.getEntity(args[0], t);
            e.setSilent(ArgumentValidation.getBoolean(args[1], t));
            return CVoid.VOID;
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_entity_silent.class})
    public static class get_entity_silent
    extends EntityGetterFunction {
        @Override
        public String getName() {
            return "get_entity_silent";
        }

        @Override
        public String docs() {
            return "boolean {entityUUID} Returns true if the entity produces sounds";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.GenerateCBoolean(Static.getEntity(args[0], t).isSilent(), t);
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_entity_glowing.class})
    public static class get_entity_glowing
    extends EntityGetterFunction {
        @Override
        public String getName() {
            return "get_entity_glowing";
        }

        @Override
        public String docs() {
            return "boolean {entityUUID} Returns true if the entity is glowing";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e = Static.getEntity(args[0], t);
            return CBoolean.GenerateCBoolean(e.isGlowing(), t);
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_entity_glowing.class})
    public static class set_entity_glowing
    extends EntitySetterFunction {
        @Override
        public String getName() {
            return "set_entity_glowing";
        }

        @Override
        public String docs() {
            return "void {entityUUID, boolean} If true, applies glowing effect to the entity";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Static.getEntity(args[0], t).setGlowing(ArgumentValidation.getBoolean(args[1], t));
            return CVoid.VOID;
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={entity_fall_distance.class})
    public static class set_entity_fall_distance
    extends EntitySetterFunction {
        @Override
        public String getName() {
            return "set_entity_fall_distance";
        }

        @Override
        public String docs() {
            return "void {entityUUID, double} Sets the distance the entity has fallen.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Static.getEntity(args[0], t).setFallDistance(ArgumentValidation.getDouble32(args[1], t));
            return CVoid.VOID;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_entity_fall_distance.class})
    public static class entity_fall_distance
    extends EntityGetterFunction {
        @Override
        public String getName() {
            return "entity_fall_distance";
        }

        @Override
        public String docs() {
            return "double {entityUUID} Returns the distance the entity has fallen.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CDouble(Static.getEntity(args[0], t).getFallDistance(), t);
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_projectile_item.class})
    public static class set_projectile_item
    extends EntitySetterFunction {
        @Override
        public String getName() {
            return "set_projectile_item";
        }

        @Override
        public String docs() {
            return "void {entityUUID, itemArray} Sets the displayed item for some projectiles. This can be used on throwable projectiles (snowballs, eggs, exp bottles, enderpearls) as well as large and small fireballs.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            if (!(entity instanceof MCItemProjectile)) {
                throw new CREBadEntityException("The given entity does not have a display item.", t);
            }
            ((MCItemProjectile)entity).setItem(ObjectGenerator.GetGenerator().item(args[1], t));
            return CVoid.VOID;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_4;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_projectile_item.class})
    public static class get_projectile_item
    extends EntityGetterFunction {
        @Override
        public String getName() {
            return "get_projectile_item";
        }

        @Override
        public String docs() {
            return "array {entityUUID} Returns the displayed item for some projectiles. This can be used on throwable projectiles (snowballs, eggs, exp bottles, enderpearls) as well as large and small fireballs.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            if (entity instanceof MCItemProjectile) {
                return ObjectGenerator.GetGenerator().item(((MCItemProjectile)entity).getItem(), t);
            }
            throw new CREBadEntityException("The given entity does not have a display item.", t);
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_4;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_projectile_bounce.class})
    public static class set_projectile_bounce
    extends EntitySetterFunction {
        @Override
        public String getName() {
            return "set_projectile_bounce";
        }

        @Override
        public String docs() {
            return "void {entityUUID, boolean} Sets if the given projectile should bounce when it hits something. (deprecated)";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            if (!(entity instanceof MCProjectile)) {
                throw new CREBadEntityException("The given entity is not a projectile.", t);
            }
            ((MCProjectile)entity).setBounce(ArgumentValidation.getBoolean(args[1], t));
            return CVoid.VOID;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_projectile_bounce.class})
    public static class get_projectile_bounce
    extends EntityGetterFunction {
        @Override
        public String getName() {
            return "get_projectile_bounce";
        }

        @Override
        public String docs() {
            return "boolean {entityUUID} Returns if the given projectile should bounce when it hits something. (deprecated)";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            if (entity instanceof MCProjectile) {
                return CBoolean.get(((MCProjectile)entity).doesBounce());
            }
            throw new CREBadEntityException("The given entity is not a projectile.", t);
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_projectile_shooter.class})
    public static class set_projectile_shooter
    extends EntitySetterFunction {
        @Override
        public String getName() {
            return "set_projectile_shooter";
        }

        @Override
        public String docs() {
            return "void {entityUUID, shooter} Sets the shooter of the given projectile. This can be an entity UUID, dispenser location array (throws CastException if not a dispenser), or null.";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            if (!(entity instanceof MCProjectile)) throw new CREBadEntityException("The given entity is not a projectile.", t);
            if (args[1] instanceof CNull) {
                ((MCProjectile)entity).setShooter(null);
                return CVoid.VOID;
            } else if (args[1].isInstanceOf(CArray.TYPE)) {
                MCBlock b = ObjectGenerator.GetGenerator().location(args[1], entity.getWorld(), t).getBlock();
                if (!b.isDispenser()) throw new CRECastException("Given block location is not a dispenser.", t);
                ((MCProjectile)entity).setShooter(b.getDispenser().getBlockProjectileSource());
                return CVoid.VOID;
            } else {
                ((MCProjectile)entity).setShooter(Static.getLivingEntity(args[1], t));
            }
            return CVoid.VOID;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_projectile_shooter.class})
    public static class get_projectile_shooter
    extends EntityGetterFunction {
        @Override
        public String getName() {
            return "get_projectile_shooter";
        }

        @Override
        public String docs() {
            return "mixed {entityUUID} Returns the shooter of the given projectile, can be null. If the shooter is an entity, that entity's ID will be return, but if it is a block, that block's location will be returned.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            if (entity instanceof MCProjectile) {
                MCProjectileSource shooter = ((MCProjectile)entity).getShooter();
                if (shooter instanceof MCBlockProjectileSource) {
                    return ObjectGenerator.GetGenerator().location(((MCBlockProjectileSource)shooter).getBlock().getLocation(), false);
                }
                if (shooter instanceof MCEntity) {
                    return new CString(((MCEntity)((Object)shooter)).getUniqueId().toString(), t);
                }
                return CNull.NULL;
            }
            throw new CREBadEntityException("The given entity is not a projectile.", t);
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={entity_spec.class})
    public static class set_entity_spec
    extends EntitySetterFunction {
        @Override
        public String getName() {
            return "set_entity_spec";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CREBadEntityException.class, CREIndexOverflowException.class, CREIndexOverflowException.class, CRERangeException.class, CREFormatException.class, CRELengthException.class, CREInvalidWorldException.class};
        }

        @Override
        public String docs() {
            return "void {entityUUID, specArray} Sets the data in the specArray to the given entity. The specArray must follow the same format as entity_spec(). See the documentation for that function for info on available options. All indices in the specArray are optional.";
        }

        private static void throwException(String index, Target t) throws ConfigRuntimeException {
            throw new CREIndexOverflowException("Unknown or uneditable specification: " + index, t);
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            CArray specArray = ArgumentValidation.getArray(args[1], t);
            switch (entity.getType().getAbstracted()) {
                case AREA_EFFECT_CLOUD: {
                    MCAreaEffectCloud cloud = (MCAreaEffectCloud)entity;
                    block754: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "color": {
                                Mixed colorMixed = specArray.get(index, t);
                                if (colorMixed.isInstanceOf(CArray.TYPE)) {
                                    CArray color2 = (CArray)colorMixed;
                                    cloud.setColor(ObjectGenerator.GetGenerator().color(color2, t));
                                    break;
                                }
                                throw new CRECastException("AreaEffectCloud color must be an array", t);
                            }
                            case "duration": {
                                cloud.setDuration(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                break;
                            }
                            case "durationonuse": {
                                cloud.setDurationOnUse(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                break;
                            }
                            case "particle": {
                                Mixed particleMixed = specArray.get(index, t);
                                if (particleMixed.isInstanceOf(CArray.TYPE)) {
                                    MCParticle p2;
                                    CArray pa = (CArray)particleMixed;
                                    try {
                                        p2 = MCParticle.valueOf(pa.get("particle", t).val().toUpperCase());
                                    }
                                    catch (IllegalArgumentException ex) {
                                        throw new CREIllegalArgumentException("Particle name '" + pa.get("particle", t).val() + "' is invalid.", t);
                                    }
                                    try {
                                        cloud.setParticle(p2, ObjectGenerator.GetGenerator().particleData(p2, cloud.getLocation(), pa, t));
                                        break;
                                    }
                                    catch (IllegalArgumentException ex) {
                                        throw new CREFormatException("Invalid particle data for " + p2.name(), t);
                                    }
                                }
                                String particleName = particleMixed.val();
                                try {
                                    cloud.setParticle(MCParticle.valueOf(particleName), null);
                                    break;
                                }
                                catch (IllegalArgumentException ex) {
                                    throw new CREFormatException("Invalid particle data: " + particleName, t);
                                }
                            }
                            case "potionmeta": {
                                Mixed c = specArray.get(index, t);
                                if (c.isInstanceOf(CArray.TYPE)) {
                                    Mixed base;
                                    CArray meta = (CArray)c;
                                    if (meta.containsKey("potiontype") && Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
                                        Mixed potiontype = meta.get("potiontype", t);
                                        if (potiontype instanceof CNull) {
                                            cloud.setBasePotionType(null);
                                        } else {
                                            cloud.setBasePotionType(MCPotionType.valueOf(potiontype.val()));
                                        }
                                    } else if (meta.containsKey("base") && (base = meta.get("base", t)).isInstanceOf(CArray.TYPE)) {
                                        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
                                            MCPotionType type = ObjectGenerator.GetGenerator().legacyPotionData((CArray)base, t);
                                            cloud.setBasePotionType(type);
                                        } else {
                                            MCPotionData pd = ObjectGenerator.GetGenerator().potionData((CArray)base, t);
                                            cloud.setBasePotionData(pd);
                                        }
                                    }
                                    if (!meta.containsKey("potions")) continue block754;
                                    cloud.clearCustomEffects();
                                    Mixed potions = meta.get("potions", t);
                                    if (!potions.isInstanceOf(CArray.TYPE)) continue block754;
                                    List<MCLivingEntity.MCEffect> list = ObjectGenerator.GetGenerator().potions((CArray)potions, t);
                                    for (MCLivingEntity.MCEffect effect : list) {
                                        cloud.addCustomEffect(effect);
                                    }
                                    continue block754;
                                }
                                throw new CRECastException("AreaEffectCloud potion meta must be an array", t);
                            }
                            case "radius": {
                                cloud.setRadius(ArgumentValidation.getDouble32(specArray.get(index, t), t));
                                break;
                            }
                            case "radiusonuse": {
                                cloud.setRadiusOnUse(ArgumentValidation.getDouble32(specArray.get(index, t), t));
                                break;
                            }
                            case "radiuspertick": {
                                cloud.setRadiusPerTick(ArgumentValidation.getDouble32(specArray.get(index, t), t));
                                break;
                            }
                            case "reapplicationdelay": {
                                cloud.setReapplicationDelay(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                break;
                            }
                            case "source": {
                                Mixed cloudSource = specArray.get(index, t);
                                if (cloudSource instanceof CNull) {
                                    cloud.setSource(null);
                                    break;
                                }
                                if (cloudSource.isInstanceOf(CArray.TYPE)) {
                                    MCBlock b = ObjectGenerator.GetGenerator().location(cloudSource, cloud.getWorld(), t).getBlock();
                                    if (b.isDispenser()) {
                                        cloud.setSource(b.getDispenser().getBlockProjectileSource());
                                        break;
                                    }
                                    throw new CRECastException("AreaEffectCloud block source must be a dispenser", t);
                                }
                                cloud.setSource(Static.getLivingEntity(cloudSource, t));
                                break;
                            }
                            case "waittime": {
                                cloud.setWaitTime(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                break;
                            }
                            default: {
                                set_entity_spec.throwException(index, t);
                            }
                        }
                    }
                    break;
                }
                case ARROW: {
                    MCArrow arrow = (MCArrow)entity;
                    block756: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "critical": {
                                arrow.setCritical(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                break;
                            }
                            case "knockback": {
                                int k = ArgumentValidation.getInt32(specArray.get(index, t), t);
                                if (k < 0) {
                                    throw new CRERangeException("Knockback can not be negative.", t);
                                }
                                arrow.setKnockbackStrength(k);
                                break;
                            }
                            case "damage": {
                                double d = ArgumentValidation.getDouble(specArray.get(index, t), t);
                                if (d < 0.0) {
                                    throw new CRERangeException("Damage cannot be negative.", t);
                                }
                                arrow.setDamage(d);
                                break;
                            }
                            case "piercelevel": {
                                int level = ArgumentValidation.getInt32(specArray.get(index, t), t);
                                if (level < 0 || level > 127) {
                                    throw new CRERangeException("Pierce level must be 0 to 127.", t);
                                }
                                arrow.setPierceLevel(level);
                                break;
                            }
                            case "pickup": {
                                try {
                                    arrow.setPickupStatus(MCArrow.PickupStatus.valueOf(specArray.get(index, t).val()));
                                    break;
                                }
                                catch (IllegalArgumentException ex) {
                                    throw new CREFormatException("Invalid arrow pickup status: " + specArray.get(index, t).val(), t);
                                }
                            }
                            case "potionmeta": {
                                Mixed c = specArray.get(index, t);
                                if (c.isInstanceOf(CArray.TYPE)) {
                                    Mixed base;
                                    CArray meta = (CArray)c;
                                    if (meta.containsKey("potiontype") && Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
                                        Mixed potiontype = meta.get("potiontype", t);
                                        if (potiontype instanceof CNull) {
                                            arrow.setBasePotionType(null);
                                        } else {
                                            arrow.setBasePotionType(MCPotionType.valueOf(potiontype.val()));
                                        }
                                    } else if (meta.containsKey("base") && (base = meta.get("base", t)).isInstanceOf(CArray.TYPE)) {
                                        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
                                            MCPotionType type = ObjectGenerator.GetGenerator().legacyPotionData((CArray)base, t);
                                            arrow.setBasePotionType(type);
                                        } else {
                                            MCPotionData pd = ObjectGenerator.GetGenerator().potionData((CArray)base, t);
                                            arrow.setBasePotionData(pd);
                                        }
                                    }
                                    if (!meta.containsKey("potions")) continue block756;
                                    arrow.clearCustomEffects();
                                    Mixed potions = meta.get("potions", t);
                                    if (!potions.isInstanceOf(CArray.TYPE)) continue block756;
                                    List<MCLivingEntity.MCEffect> list = ObjectGenerator.GetGenerator().potions((CArray)potions, t);
                                    for (MCLivingEntity.MCEffect effect : list) {
                                        arrow.addCustomEffect(effect);
                                    }
                                    continue block756;
                                }
                                throw new CRECastException("TippedArrow potion meta must be an array", t);
                            }
                            default: {
                                set_entity_spec.throwException(index, t);
                            }
                        }
                    }
                    break;
                }
                case ARMOR_STAND: {
                    MCArmorStand stand = (MCArmorStand)((Object)entity);
                    block758: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "arms": {
                                stand.setHasArms(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block758;
                            }
                            case "baseplate": {
                                stand.setHasBasePlate(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block758;
                            }
                            case "gravity": {
                                stand.setHasGravity(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block758;
                            }
                            case "marker": {
                                stand.setMarker(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block758;
                            }
                            case "small": {
                                stand.setSmall(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block758;
                            }
                            case "visible": {
                                stand.setVisible(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block758;
                            }
                            case "poses": {
                                Map<MCBodyPart, Vector3D> poseMap = stand.getAllPoses();
                                Mixed posesMixed = specArray.get(index, t);
                                if (posesMixed.isInstanceOf(CArray.TYPE)) {
                                    CArray poseArray = (CArray)posesMixed;
                                    for (MCBodyPart key : poseMap.keySet()) {
                                        try {
                                            poseMap.put(key, ObjectGenerator.GetGenerator().vector(poseMap.get((Object)key), poseArray.get("pose" + key.name(), t), t));
                                        }
                                        catch (ConfigRuntimeException potions) {}
                                    }
                                }
                                if (posesMixed instanceof CNull) {
                                    for (MCBodyPart key : poseMap.keySet()) {
                                        poseMap.put(key, Vector3D.ZERO);
                                    }
                                }
                                stand.setAllPoses(poseMap);
                                continue block758;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case AXOLOTL: {
                    MCAxolotl axolotl = (MCAxolotl)entity;
                    block761: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "type": {
                                try {
                                    axolotl.setAxolotlType(MCAxolotlType.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block761;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid axolotl type: " + specArray.get(index, t).val(), t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case BEE: {
                    MCBee bee = (MCBee)entity;
                    block762: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "anger": {
                                bee.setAnger(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block762;
                            }
                            case "nector": {
                                bee.setHasNectar(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block762;
                            }
                            case "stung": {
                                bee.setHasStung(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block762;
                            }
                            case "flowerlocation": {
                                Mixed flower = specArray.get(index, t);
                                if (flower instanceof CNull) {
                                    bee.setFlowerLocation(null);
                                    continue block762;
                                }
                                bee.setFlowerLocation(ObjectGenerator.GetGenerator().location(flower, null, t));
                                continue block762;
                            }
                            case "hivelocation": {
                                Mixed hive = specArray.get(index, t);
                                if (hive instanceof CNull) {
                                    bee.setHiveLocation(null);
                                    continue block762;
                                }
                                bee.setHiveLocation(ObjectGenerator.GetGenerator().location(hive, null, t));
                                continue block762;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case BLOCK_DISPLAY: {
                    MCBlockDisplay bDisplay = (MCBlockDisplay)entity;
                    block763: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "blockdata": {
                                MCBlockData bd;
                                Mixed m = specArray.get(index, t);
                                try {
                                    bd = m.isInstanceOf(CArray.TYPE) ? ObjectGenerator.GetGenerator().blockData((CArray)m, t) : Static.getServer().createBlockData(m.val().toLowerCase());
                                }
                                catch (IllegalArgumentException ex) {
                                    throw new CREFormatException("Cannot create block data from: " + m.val(), t);
                                }
                                bDisplay.setBlockData(bd);
                                continue block763;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case BOAT: {
                    MCBoat boat = (MCBoat)entity;
                    block764: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "type": {
                                try {
                                    boat.setWoodType(MCTreeSpecies.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block764;
                                }
                                catch (IllegalArgumentException ex) {
                                    throw new CREFormatException("Invalid boat type: " + specArray.get(index, t).val(), t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case CAT: {
                    MCCat cat = (MCCat)entity;
                    block765: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "type": {
                                try {
                                    cat.setCatType(MCCatType.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block765;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid cat type: " + specArray.get(index, t).val(), t);
                                }
                            }
                            case "sitting": {
                                cat.setSitting(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block765;
                            }
                            case "color": {
                                try {
                                    cat.setCollarColor(MCDyeColor.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block765;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid collar color: " + specArray.get(index, t).val(), t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case CREEPER: {
                    MCCreeper creeper = (MCCreeper)((Object)entity);
                    block766: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "powered": {
                                creeper.setPowered(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block766;
                            }
                            case "maxfuseticks": {
                                try {
                                    creeper.setMaxFuseTicks(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                    continue block766;
                                }
                                catch (IllegalArgumentException ex) {
                                    throw new CRERangeException("Ticks must not be negative.", t);
                                }
                            }
                            case "fuseticks": {
                                try {
                                    creeper.setFuseTicks(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                    continue block766;
                                }
                                catch (IllegalArgumentException ex) {
                                    throw new CRERangeException(ex.getMessage(), t);
                                }
                            }
                            case "explosionradius": {
                                try {
                                    creeper.setExplosionRadius(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                    continue block766;
                                }
                                catch (IllegalArgumentException ex) {
                                    throw new CRERangeException("Radius must not be negative.", t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case DONKEY: 
                case MULE: {
                    MCChestedHorse chestedhorse = (MCChestedHorse)entity;
                    block767: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "chest": {
                                chestedhorse.setHasChest(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block767;
                            }
                            case "jump": {
                                try {
                                    chestedhorse.setJumpStrength(ArgumentValidation.getDouble(specArray.get(index, t), t));
                                    continue block767;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CRERangeException("The jump strength must be between 0.0 and 2.0", t);
                                }
                            }
                            case "domestication": {
                                try {
                                    chestedhorse.setDomestication(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                    continue block767;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CRERangeException("The domestication level can not be higher than the max domestication level.", t);
                                }
                            }
                            case "maxdomestication": {
                                chestedhorse.setMaxDomestication(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block767;
                            }
                            case "saddle": {
                                chestedhorse.setSaddle(ObjectGenerator.GetGenerator().item(specArray.get(index, t), t));
                                continue block767;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case DROPPED_ITEM: {
                    MCItem item = (MCItem)entity;
                    block768: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "itemstack": {
                                item.setItemStack(ObjectGenerator.GetGenerator().item(specArray.get(index, t), t));
                                continue block768;
                            }
                            case "pickupdelay": {
                                item.setPickupDelay(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block768;
                            }
                            case "owner": {
                                Mixed owner = specArray.get(index, t);
                                if (owner instanceof CNull) {
                                    item.setOwner(null);
                                    continue block768;
                                }
                                item.setOwner(Static.GetUUID(owner, t));
                                continue block768;
                            }
                            case "thrower": {
                                Mixed thrower = specArray.get(index, t);
                                if (thrower instanceof CNull) {
                                    item.setThrower(null);
                                    continue block768;
                                }
                                item.setThrower(Static.GetUUID(thrower, t));
                                continue block768;
                            }
                            case "despawn": {
                                if (!Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_18_X)) continue block768;
                                item.setWillDespawn(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block768;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case ENDER_CRYSTAL: {
                    MCEnderCrystal endercrystal = (MCEnderCrystal)entity;
                    block769: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "base": {
                                endercrystal.setShowingBottom(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block769;
                            }
                            case "beamtarget": {
                                Mixed c = specArray.get(index, t);
                                if (c instanceof CNull) {
                                    endercrystal.setBeamTarget(null);
                                    continue block769;
                                }
                                if (c.isInstanceOf(CArray.TYPE)) {
                                    MCLocation l = ObjectGenerator.GetGenerator().location((CArray)c, endercrystal.getWorld(), t);
                                    endercrystal.setBeamTarget(l);
                                    continue block769;
                                }
                                throw new CRECastException("EnderCrystal beam target must be an array or null", t);
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case ENDER_DRAGON: {
                    MCEnderDragon enderdragon = (MCEnderDragon)entity;
                    block770: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "phase": {
                                try {
                                    enderdragon.setPhase(MCEnderDragonPhase.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block770;
                                }
                                catch (IllegalArgumentException ex) {
                                    throw new CREFormatException("Invalid EnderDragon phase: " + specArray.get(index, t).val(), t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case ENDER_EYE: {
                    MCEnderSignal endereye = (MCEnderSignal)entity;
                    if (specArray.containsKey("target")) {
                        Mixed targetLoc = specArray.get("target", t);
                        try {
                            endereye.setTargetLocation(ObjectGenerator.GetGenerator().location(targetLoc, null, t));
                        }
                        catch (IllegalArgumentException ex) {
                            throw new CREInvalidWorldException("An EnderEye cannot target a location in another world.", t);
                        }
                    }
                    block771: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "despawnticks": {
                                endereye.setDespawnTicks(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block771;
                            }
                            case "drop": {
                                endereye.setDropItem(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block771;
                            }
                            case "item": {
                                Mixed enderItem = specArray.get(index, t);
                                if (enderItem instanceof CNull) {
                                    endereye.setItem(null);
                                    continue block771;
                                }
                                endereye.setItem(ObjectGenerator.GetGenerator().item(enderItem, t));
                                continue block771;
                            }
                            case "target": {
                                continue block771;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case ENDERMAN: {
                    MCEnderman enderman = (MCEnderman)entity;
                    block772: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "carried": {
                                MCMaterial mat = ObjectGenerator.GetGenerator().material(specArray.get(index, t), t);
                                enderman.setCarriedMaterial(mat.createBlockData());
                                continue block772;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case EVOKER_FANGS: {
                    MCEvokerFangs fangs = (MCEvokerFangs)entity;
                    block773: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "source": {
                                Mixed source2 = specArray.get(index, t);
                                if (source2 instanceof CNull) {
                                    fangs.setOwner(null);
                                    continue block773;
                                }
                                fangs.setOwner(Static.getLivingEntity(source2, t));
                                continue block773;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case EXPERIENCE_ORB: {
                    MCExperienceOrb orb = (MCExperienceOrb)entity;
                    block774: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "amount": {
                                orb.setExperience(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block774;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case FALLING_BLOCK: {
                    MCFallingBlock block = (MCFallingBlock)entity;
                    block775: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "dropitem": {
                                block.setDropItem(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block775;
                            }
                            case "damage": {
                                block.setHurtEntities(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block775;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case FIREBALL: 
                case SMALL_FIREBALL: 
                case DRAGON_FIREBALL: {
                    MCFireball ball = (MCFireball)entity;
                    block776: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "direction": {
                                ball.setDirection(ObjectGenerator.GetGenerator().vector(specArray.get(index, t), t));
                                continue block776;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case FIREWORK: {
                    MCFirework firework = (MCFirework)entity;
                    MCFireworkMeta fm = firework.getFireWorkMeta();
                    block777: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "strength": {
                                fm.setStrength(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                break;
                            }
                            case "effects": {
                                fm.clearEffects();
                                CArray effects = ArgumentValidation.getArray(specArray.get(index, t), t);
                                for (Mixed eff : effects.asList()) {
                                    if (eff.isInstanceOf(CArray.TYPE)) {
                                        fm.addEffect(ObjectGenerator.GetGenerator().fireworkEffect((CArray)eff, t));
                                        continue;
                                    }
                                    throw new CRECastException("Firework effect expected to be an array.", t);
                                }
                                continue block777;
                            }
                            case "angled": {
                                firework.setShotAtAngle(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                break;
                            }
                            default: {
                                set_entity_spec.throwException(index, t);
                            }
                        }
                    }
                    firework.setFireWorkMeta(fm);
                    break;
                }
                case FOX: {
                    MCFox fox = (MCFox)entity;
                    block779: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "sitting": {
                                fox.setSitting(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block779;
                            }
                            case "crouching": {
                                fox.setCrouching(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block779;
                            }
                            case "type": {
                                try {
                                    fox.setVariant(MCFoxType.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block779;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid fox type: " + specArray.get(index, t).val(), t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case FROG: {
                    MCFrog frog = (MCFrog)entity;
                    block780: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "type": {
                                try {
                                    frog.setFrogType(MCFrog.MCFrogType.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block780;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid frog type: " + specArray.get(index, t).val(), t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case GOAT: {
                    MCGoat goat = (MCGoat)entity;
                    block781: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "screaming": {
                                goat.setScreaming(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block781;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case HORSE: {
                    MCHorse horse = (MCHorse)entity;
                    block782: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "color": {
                                try {
                                    horse.setColor(MCHorse.MCHorseColor.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block782;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid horse color: " + specArray.get(index, t).val(), t);
                                }
                            }
                            case "style": {
                                try {
                                    horse.setPattern(MCHorse.MCHorsePattern.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block782;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid horse style: " + specArray.get(index, t).val(), t);
                                }
                            }
                            case "jump": {
                                try {
                                    horse.setJumpStrength(ArgumentValidation.getDouble(specArray.get(index, t), t));
                                    continue block782;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CRERangeException("The jump strength must be between 0.0 and 2.0", t);
                                }
                            }
                            case "domestication": {
                                try {
                                    horse.setDomestication(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                    continue block782;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CRERangeException("The domestication level can not be higher than the max domestication level.", t);
                                }
                            }
                            case "maxdomestication": {
                                horse.setMaxDomestication(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block782;
                            }
                            case "saddle": {
                                horse.setSaddle(ObjectGenerator.GetGenerator().item(specArray.get(index, t), t));
                                continue block782;
                            }
                            case "armor": {
                                horse.setArmor(ObjectGenerator.GetGenerator().item(specArray.get(index, t), t));
                                continue block782;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case INTERACTION: {
                    MCInteraction interaction = (MCInteraction)entity;
                    block783: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "height": {
                                interaction.setHeight(ArgumentValidation.getDouble(specArray.get(index, t), t));
                                continue block783;
                            }
                            case "width": {
                                interaction.setWidth(ArgumentValidation.getDouble(specArray.get(index, t), t));
                                continue block783;
                            }
                            case "response": {
                                interaction.setResponsive(ArgumentValidation.getBooleanish(specArray.get(index, t), t));
                                continue block783;
                            }
                            case "lastattack": 
                            case "lastinteraction": {
                                continue block783;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case IRON_GOLEM: {
                    MCIronGolem golem = (MCIronGolem)entity;
                    block784: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "playercreated": {
                                golem.setPlayerCreated(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block784;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case ITEM_DISPLAY: {
                    MCItemDisplay itemDisplay = (MCItemDisplay)entity;
                    block785: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "item": {
                                itemDisplay.setItem(ObjectGenerator.GetGenerator().item(specArray.get(index, t), t));
                                continue block785;
                            }
                            case "itemdisplay": {
                                try {
                                    itemDisplay.setItemModelTransform(MCItemDisplay.ModelTransform.valueOf(specArray.get(index, t).val()));
                                    continue block785;
                                }
                                catch (IllegalArgumentException ex) {
                                    throw new CREFormatException("Invalid display item model transform: " + specArray.get(index, t).val(), t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case ITEM_FRAME: 
                case GLOW_ITEM_FRAME: {
                    MCItemFrame frame = (MCItemFrame)entity;
                    block786: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "fixed": {
                                frame.setFixed(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block786;
                            }
                            case "item": {
                                frame.setItem(ObjectGenerator.GetGenerator().item(specArray.get(index, t), t));
                                continue block786;
                            }
                            case "rotation": {
                                try {
                                    frame.setRotation(MCRotation.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block786;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid rotation type: " + specArray.get(index, t).val(), t);
                                }
                            }
                            case "visible": {
                                frame.setVisible(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block786;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case LLAMA: {
                    MCLlama llama = (MCLlama)entity;
                    block787: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "color": {
                                try {
                                    llama.setLlamaColor(MCLlama.MCLlamaColor.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block787;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid llama color: " + specArray.get(index, t).val(), t);
                                }
                            }
                            case "chest": {
                                llama.setHasChest(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block787;
                            }
                            case "domestication": {
                                try {
                                    llama.setDomestication(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                    continue block787;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CRERangeException("The domestication level can not be higher than the max domestication level.", t);
                                }
                            }
                            case "maxdomestication": {
                                llama.setMaxDomestication(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block787;
                            }
                            case "saddle": {
                                llama.setSaddle(ObjectGenerator.GetGenerator().item(specArray.get(index, t), t));
                                continue block787;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case MAGMA_CUBE: 
                case SLIME: {
                    MCSlime cube = (MCSlime)entity;
                    block788: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "size": {
                                cube.setSize(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block788;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case MANNEQUIN: {
                    MCMannequin mannequin = (MCMannequin)entity;
                    block789: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "immovable": {
                                mannequin.setImmovable(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block789;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case MINECART: 
                case MINECART_FURNACE: 
                case MINECART_HOPPER: 
                case MINECART_MOB_SPAWNER: 
                case MINECART_TNT: {
                    MCMinecart minecart = (MCMinecart)entity;
                    block790: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "block": {
                                MCMaterial mat = ObjectGenerator.GetGenerator().material(specArray.get(index, t), t);
                                minecart.setDisplayBlock(mat.createBlockData());
                                continue block790;
                            }
                            case "offset": {
                                minecart.setDisplayBlockOffset(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block790;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case MINECART_COMMAND: {
                    MCCommandMinecart commandminecart = (MCCommandMinecart)entity;
                    block791: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "customname": {
                                Mixed customName = specArray.get(index, t);
                                if (customName instanceof CNull) {
                                    commandminecart.setName(null);
                                    continue block791;
                                }
                                commandminecart.setName(customName.val());
                                continue block791;
                            }
                            case "command": {
                                Mixed command = specArray.get(index, t);
                                if (command instanceof CNull) {
                                    commandminecart.setCommand(null);
                                    continue block791;
                                }
                                commandminecart.setCommand(command.val());
                                continue block791;
                            }
                            case "block": {
                                MCMaterial mat = ObjectGenerator.GetGenerator().material(specArray.get(index, t), t);
                                commandminecart.setDisplayBlock(mat.createBlockData());
                                continue block791;
                            }
                            case "offset": {
                                commandminecart.setDisplayBlockOffset(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block791;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case MUSHROOM_COW: {
                    MCMushroomCow cow = (MCMushroomCow)entity;
                    block792: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "type": {
                                try {
                                    cow.setVariant(MCMushroomCowType.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block792;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid mushroom cow type: " + specArray.get(index, t).val(), t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case OMINOUS_ITEM_SPAWNER: {
                    MCOminousItemSpawner spawner = (MCOminousItemSpawner)entity;
                    block793: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "item": {
                                spawner.setItem(ObjectGenerator.GetGenerator().item(specArray.get(index, t), t));
                                continue block793;
                            }
                            case "delay": {
                                spawner.setDelay(ArgumentValidation.getInt(specArray.get(index, t), t));
                                continue block793;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case PAINTING: {
                    MCPainting painting = (MCPainting)entity;
                    block794: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "type": {
                                try {
                                    painting.setArt(MCArt.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block794;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid art type: " + specArray.get(index, t).val(), t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case PANDA: {
                    MCPanda panda = (MCPanda)entity;
                    block795: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "maingene": {
                                try {
                                    panda.setMainGene(MCPanda.Gene.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block795;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid panda gene: " + specArray.get(index, t).val(), t);
                                }
                            }
                            case "hiddengene": {
                                try {
                                    panda.setHiddenGene(MCPanda.Gene.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block795;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid panda gene: " + specArray.get(index, t).val(), t);
                                }
                            }
                            case "eating": {
                                panda.setEating(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block795;
                            }
                            case "onback": {
                                panda.setOnBack(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block795;
                            }
                            case "rolling": {
                                panda.setRolling(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block795;
                            }
                            case "sneezing": {
                                panda.setSneezing(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block795;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case PARROT: {
                    MCParrot parrot = (MCParrot)entity;
                    block796: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "sitting": {
                                parrot.setSitting(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block796;
                            }
                            case "type": {
                                try {
                                    parrot.setVariant(MCParrotType.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block796;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid parrot type: " + specArray.get(index, t).val(), t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case PHANTOM: {
                    MCPhantom phantom = (MCPhantom)entity;
                    block797: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "size": {
                                phantom.setSize(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block797;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case PIG: {
                    MCPig pig = (MCPig)entity;
                    block798: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "saddled": {
                                pig.setSaddled(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block798;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case PIGLIN: {
                    MCPiglin piglin = (MCPiglin)entity;
                    block799: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "baby": {
                                if (ArgumentValidation.getBooleanObject(specArray.get(index, t), t)) {
                                    piglin.setBaby();
                                    continue block799;
                                }
                                piglin.setAdult();
                                continue block799;
                            }
                            case "zombificationimmune": {
                                piglin.setImmuneToZombification(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block799;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case PRIMED_TNT: {
                    MCTNT tnt = (MCTNT)entity;
                    block800: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "fuseticks": {
                                tnt.setFuseTicks(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block800;
                            }
                            case "source": {
                                Mixed source3 = specArray.get(index, t);
                                if (source3 instanceof CNull) {
                                    tnt.setSource(null);
                                    continue block800;
                                }
                                tnt.setSource(Static.getLivingEntity(specArray.get(index, t), t));
                                continue block800;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case RABBIT: {
                    MCRabbit rabbit = (MCRabbit)entity;
                    block801: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "type": {
                                try {
                                    rabbit.setRabbitType(MCRabbitType.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block801;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid rabbit type: " + specArray.get(index, t).val(), t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case PUFFERFISH: {
                    MCPufferfish puffer = (MCPufferfish)((Object)entity);
                    block802: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "size": {
                                puffer.setPuffState(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block802;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case SHEEP: {
                    MCSheep sheep = (MCSheep)entity;
                    block803: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "color": {
                                try {
                                    sheep.setColor(MCDyeColor.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block803;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid sheep color: " + specArray.get(index, t).val(), t);
                                }
                            }
                            case "sheared": {
                                sheep.setSheared(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block803;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case SHULKER: {
                    MCShulker shulker = (MCShulker)entity;
                    block804: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "color": {
                                Mixed value = specArray.get(index, t);
                                if (value instanceof CNull) {
                                    shulker.setColor(null);
                                    continue block804;
                                }
                                try {
                                    shulker.setColor(MCDyeColor.valueOf(value.val().toUpperCase()));
                                    continue block804;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid shulker color: " + specArray.get(index, t).val(), t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case SHULKER_BULLET: {
                    MCShulkerBullet bullet = (MCShulkerBullet)entity;
                    block805: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "target": {
                                Mixed c = specArray.get(index, t);
                                if (c instanceof CNull) {
                                    bullet.setTarget(null);
                                    continue block805;
                                }
                                bullet.setTarget(Static.getEntity(c, t));
                                continue block805;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case SKELETON_HORSE: 
                case ZOMBIE_HORSE: {
                    MCAbstractHorse undeadhorse = (MCAbstractHorse)entity;
                    block806: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "jump": {
                                try {
                                    undeadhorse.setJumpStrength(ArgumentValidation.getDouble(specArray.get(index, t), t));
                                    continue block806;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CRERangeException("The jump strength must be between 0.0 and 2.0", t);
                                }
                            }
                            case "domestication": {
                                try {
                                    undeadhorse.setDomestication(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                    continue block806;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CRERangeException("The domestication level can not be higher than the max domestication level.", t);
                                }
                            }
                            case "maxdomestication": {
                                undeadhorse.setMaxDomestication(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block806;
                            }
                            case "saddle": {
                                undeadhorse.setSaddle(ObjectGenerator.GetGenerator().item(specArray.get(index, t), t));
                                continue block806;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case SNOWMAN: {
                    MCSnowman snowman = (MCSnowman)entity;
                    block807: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "derp": {
                                snowman.setDerp(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block807;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case SPECTRAL_ARROW: {
                    MCSpectralArrow spectral = (MCSpectralArrow)entity;
                    block808: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "critical": {
                                spectral.setCritical(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block808;
                            }
                            case "knockback": {
                                int k = ArgumentValidation.getInt32(specArray.get(index, t), t);
                                if (k < 0) {
                                    throw new CRERangeException("Knockback can not be negative.", t);
                                }
                                spectral.setKnockbackStrength(k);
                                continue block808;
                            }
                            case "damage": {
                                double d = ArgumentValidation.getDouble(specArray.get(index, t), t);
                                if (d < 0.0) {
                                    throw new CRERangeException("Damage cannot be negative.", t);
                                }
                                spectral.setDamage(d);
                                continue block808;
                            }
                            case "glowingticks": {
                                spectral.setGlowingTicks(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block808;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case LINGERING_POTION: 
                case SPLASH_POTION: {
                    MCThrownPotion potion = (MCThrownPotion)entity;
                    block809: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "item": {
                                MCItemStack potionItem = ObjectGenerator.GetGenerator().item(specArray.get(index, t), t);
                                try {
                                    potion.setItem(potionItem);
                                    continue block809;
                                }
                                catch (IllegalArgumentException ex) {
                                    throw new CREFormatException("Invalid potion type: " + potionItem.getType().getName(), t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case STRIDER: {
                    MCStrider strider = (MCStrider)entity;
                    block810: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "saddled": {
                                strider.setSaddled(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block810;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case TEXT_DISPLAY: {
                    MCTextDisplay tDisplay = (MCTextDisplay)entity;
                    block811: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "text": {
                                tDisplay.setText(specArray.get(index, t).val());
                                continue block811;
                            }
                            case "alignment": {
                                try {
                                    tDisplay.setAlignment(MCTextDisplay.Alignment.valueOf(specArray.get(index, t).val()));
                                    continue block811;
                                }
                                catch (IllegalArgumentException ex) {
                                    throw new CREFormatException("Invalid text alignment: " + specArray.get(index, t).val(), t);
                                }
                            }
                            case "linewidth": {
                                tDisplay.setLineWidth(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block811;
                            }
                            case "seethrough": {
                                tDisplay.setVisibleThroughBlocks(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block811;
                            }
                            case "shadow": {
                                tDisplay.setHasShadow(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block811;
                            }
                            case "bgcolor": {
                                Mixed color3 = specArray.get(index, t);
                                if (color3.isInstanceOf(CArray.TYPE)) {
                                    tDisplay.setBackgroundColor(ObjectGenerator.GetGenerator().color((CArray)color3, t));
                                    continue block811;
                                }
                                if (color3 instanceof CNull) {
                                    tDisplay.setBackgroundColor(null);
                                    continue block811;
                                }
                                throw new CRECastException("Expected a color array for text display background color.", t);
                            }
                            case "opacity": {
                                long opacity = ArgumentValidation.getInt(specArray.get(index, t), t);
                                if (opacity < 0L || opacity > 255L) {
                                    throw new CRERangeException("Text opacity outside valid range.", t);
                                }
                                tDisplay.setOpacity((byte)opacity);
                                continue block811;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case TRIDENT: {
                    MCTrident trident = (MCTrident)entity;
                    block812: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "critical": {
                                trident.setCritical(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block812;
                            }
                            case "knockback": {
                                int k = ArgumentValidation.getInt32(specArray.get(index, t), t);
                                if (k < 0) {
                                    throw new CRERangeException("Knockback can not be negative.", t);
                                }
                                trident.setKnockbackStrength(k);
                                continue block812;
                            }
                            case "damage": {
                                double d = ArgumentValidation.getDouble(specArray.get(index, t), t);
                                if (d < 0.0) {
                                    throw new CRERangeException("Damage cannot be negative.", t);
                                }
                                trident.setDamage(d);
                                continue block812;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case TROPICAL_FISH: {
                    MCTropicalFish fish = (MCTropicalFish)entity;
                    block813: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "color": {
                                try {
                                    fish.setBodyColor(MCDyeColor.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block813;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid fish color: " + specArray.get(index, t).val(), t);
                                }
                            }
                            case "patterncolor": {
                                try {
                                    fish.setPatternColor(MCDyeColor.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block813;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid fish pattern color: " + specArray.get(index, t).val(), t);
                                }
                            }
                            case "pattern": {
                                try {
                                    fish.setPattern(MCTropicalFish.MCPattern.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block813;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid fish pattern: " + specArray.get(index, t).val(), t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case VEX: {
                    MCVex vex = (MCVex)entity;
                    block814: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "charging": {
                                vex.setCharging(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block814;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case VILLAGER: {
                    MCVillager villager = (MCVillager)entity;
                    block815: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "profession": {
                                try {
                                    villager.setProfession(MCProfession.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block815;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid profession: " + specArray.get(index, t).val(), t);
                                }
                            }
                            case "level": {
                                try {
                                    villager.setLevel(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                    continue block815;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CRERangeException("Expected profession level to be 1-5, but got " + specArray.get(index, t).val(), t);
                                }
                            }
                            case "experience": {
                                try {
                                    villager.setExperience(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                    continue block815;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CRERangeException("Expected experience to be a positive number, but got " + specArray.get(index, t).val(), t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case WITHER_SKULL: {
                    MCWitherSkull skull = (MCWitherSkull)entity;
                    block816: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "charged": {
                                skull.setCharged(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block816;
                            }
                            case "direction": {
                                skull.setDirection(ObjectGenerator.GetGenerator().vector(specArray.get(index, t), t));
                                continue block816;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case WOLF: {
                    MCWolf wolf = (MCWolf)entity;
                    block817: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "angry": {
                                wolf.setAngry(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block817;
                            }
                            case "color": {
                                try {
                                    wolf.setCollarColor(MCDyeColor.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block817;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid collar color: " + specArray.get(index, t).val(), t);
                                }
                            }
                            case "sitting": {
                                wolf.setSitting(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block817;
                            }
                            case "interested": {
                                if (!Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) continue block817;
                                wolf.setInterested(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block817;
                            }
                            case "type": {
                                if (!Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) continue block817;
                                try {
                                    MCWolf.Variant type = MCWolf.Variant.valueOf(specArray.get(index, t).val());
                                    wolf.setWolfVariant(type);
                                    continue block817;
                                }
                                catch (IllegalArgumentException ex) {
                                    throw new CREFormatException("Invalid wolf type: " + specArray.get(index, t).val(), t);
                                }
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case ZOGLIN: {
                    MCZoglin zoglin = (MCZoglin)entity;
                    block818: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "baby": {
                                if (ArgumentValidation.getBooleanObject(specArray.get(index, t), t)) {
                                    zoglin.setBaby();
                                    continue block818;
                                }
                                zoglin.setAdult();
                                continue block818;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case ZOMBIE: 
                case DROWNED: 
                case HUSK: {
                    MCZombie zombie = (MCZombie)entity;
                    block819: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "baby": {
                                if (ArgumentValidation.getBooleanObject(specArray.get(index, t), t)) {
                                    zombie.setBaby();
                                    continue block819;
                                }
                                zombie.setAdult();
                                continue block819;
                            }
                            case "breakdoors": {
                                zombie.setCanBreakDoors(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block819;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case ZOMBIE_VILLAGER: {
                    MCZombieVillager zombievillager = (MCZombieVillager)entity;
                    block820: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "baby": {
                                if (ArgumentValidation.getBooleanObject(specArray.get(index, t), t)) {
                                    zombievillager.setBaby();
                                    continue block820;
                                }
                                zombievillager.setAdult();
                                continue block820;
                            }
                            case "profession": {
                                try {
                                    zombievillager.setProfession(MCProfession.valueOf(specArray.get(index, t).val().toUpperCase()));
                                    continue block820;
                                }
                                catch (IllegalArgumentException exception) {
                                    throw new CREFormatException("Invalid profession: " + specArray.get(index, t).val(), t);
                                }
                            }
                            case "breakdoors": {
                                zombievillager.setCanBreakDoors(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block820;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                case ZOMBIFIED_PIGLIN: {
                    MCPigZombie pigZombie = (MCPigZombie)entity;
                    block821: for (String index : specArray.stringKeySet()) {
                        switch (index.toLowerCase()) {
                            case "baby": {
                                if (ArgumentValidation.getBooleanObject(specArray.get(index, t), t)) {
                                    pigZombie.setBaby();
                                    continue block821;
                                }
                                pigZombie.setAdult();
                                continue block821;
                            }
                            case "angry": {
                                pigZombie.setAngry(ArgumentValidation.getBoolean(specArray.get(index, t), t));
                                continue block821;
                            }
                            case "anger": {
                                pigZombie.setAnger(ArgumentValidation.getInt32(specArray.get(index, t), t));
                                continue block821;
                            }
                            case "breakdoors": {
                                pigZombie.setCanBreakDoors(ArgumentValidation.getBooleanObject(specArray.get(index, t), t));
                                continue block821;
                            }
                        }
                        set_entity_spec.throwException(index, t);
                    }
                    break;
                }
                default: {
                    for (String index : specArray.stringKeySet()) {
                        set_entity_spec.throwException(index, t);
                    }
                }
            }
            return CVoid.VOID;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_entity_spec.class})
    public static class entity_spec
    extends EntityGetterFunction {
        private static final String KEY_GENERIC_SITTING = "sitting";
        private static final String KEY_GENERIC_BABY = "baby";
        private static final String KEY_AREAEFFECTCLOUD_COLOR = "color";
        private static final String KEY_AREAEFFECTCLOUD_DURATION = "duration";
        private static final String KEY_AREAEFFECTCLOUD_DURATIONONUSE = "durationonuse";
        private static final String KEY_AREAEFFECTCLOUD_PARTICLE = "particle";
        private static final String KEY_AREAEFFECTCLOUD_POTIONMETA = "potionmeta";
        private static final String KEY_AREAEFFECTCLOUD_RADIUS = "radius";
        private static final String KEY_AREAEFFECTCLOUD_RADIUSONUSE = "radiusonuse";
        private static final String KEY_AREAEFFECTCLOUD_RADIUSPERTICK = "radiuspertick";
        private static final String KEY_AREAEFFECTCLOUD_REAPPLICATIONDELAY = "reapplicationdelay";
        private static final String KEY_AREAEFFECTCLOUD_SOURCE = "source";
        private static final String KEY_AREAEFFECTCLOUD_WAITTIME = "waittime";
        private static final String KEY_ARROW_CRITICAL = "critical";
        private static final String KEY_ARROW_KNOCKBACK = "knockback";
        private static final String KEY_ARROW_DAMAGE = "damage";
        private static final String KEY_ARROW_PIERCE_LEVEL = "piercelevel";
        private static final String KEY_ARROW_PICKUP = "pickup";
        private static final String KEY_ARMORSTAND_ARMS = "arms";
        private static final String KEY_ARMORSTAND_BASEPLATE = "baseplate";
        private static final String KEY_ARMORSTAND_GRAVITY = "gravity";
        private static final String KEY_ARMORSTAND_MARKER = "marker";
        private static final String KEY_ARMORSTAND_POSES = "poses";
        private static final String KEY_ARMORSTAND_SMALLSIZE = "small";
        private static final String KEY_ARMORSTAND_VISIBLE = "visible";
        private static final String KEY_AXOLOTL_TYPE = "type";
        private static final String KEY_BEE_HIVE_LOCATION = "hivelocation";
        private static final String KEY_BEE_FLOWER_LOCATION = "flowerlocation";
        private static final String KEY_BEE_NECTAR = "nector";
        private static final String KEY_BEE_STUNG = "stung";
        private static final String KEY_BEE_ANGER = "anger";
        private static final String KEY_BOAT_TYPE = "type";
        private static final String KEY_CAT_TYPE = "type";
        private static final String KEY_CAT_COLOR = "color";
        private static final String KEY_CREEPER_POWERED = "powered";
        private static final String KEY_CREEPER_FUSETICKS = "fuseticks";
        private static final String KEY_CREEPER_MAXFUSETICKS = "maxfuseticks";
        private static final String KEY_CREEPER_EXPLOSIONRADIUS = "explosionradius";
        private static final String KEY_DISPLAY_BLOCK = "blockdata";
        private static final String KEY_DISPLAY_ITEM = "item";
        private static final String KEY_DISPLAY_ITEM_DISPLAY = "itemdisplay";
        private static final String KEY_DISPLAY_TEXT = "text";
        private static final String KEY_DISPLAY_TEXT_ALIGNMENT = "alignment";
        private static final String KEY_DISPLAY_TEXT_LINE_WIDTH = "linewidth";
        private static final String KEY_DISPLAY_TEXT_SEE_THROUGH = "seethrough";
        private static final String KEY_DISPLAY_TEXT_SHADOW = "shadow";
        private static final String KEY_DISPLAY_TEXT_BACKGROUND_COLOR = "bgcolor";
        private static final String KEY_DISPLAY_TEXT_OPACITY = "opacity";
        private static final String KEY_DROPPED_ITEM_ITEMSTACK = "itemstack";
        private static final String KEY_DROPPED_ITEM_PICKUPDELAY = "pickupdelay";
        private static final String KEY_DROPPED_ITEM_OWNER = "owner";
        private static final String KEY_DROPPED_ITEM_THROWER = "thrower";
        private static final String KEY_DROPPED_ITEM_DESPAWN = "despawn";
        private static final String KEY_ENDERCRYSTAL_BASE = "base";
        private static final String KEY_ENDERCRYSTAL_BEAMTARGET = "beamtarget";
        private static final String KEY_ENDEREYE_DESPAWNTICKS = "despawnticks";
        private static final String KEY_ENDEREYE_DROP = "drop";
        private static final String KEY_ENDEREYE_ITEM = "item";
        private static final String KEY_ENDEREYE_TARGET = "target";
        private static final String KEY_ENDERDRAGON_PHASE = "phase";
        private static final String KEY_ENDERMAN_CARRIED = "carried";
        private static final String KEY_EXPERIENCE_ORB_AMOUNT = "amount";
        private static final String KEY_EVOKERFANGS_SOURCE = "source";
        private static final String KEY_FALLING_BLOCK_BLOCK = "block";
        private static final String KEY_FALLING_BLOCK_DROPITEM = "dropitem";
        private static final String KEY_FALLING_BLOCK_DAMAGE = "damage";
        private static final String KEY_FIREBALL_DIRECTION = "direction";
        private static final String KEY_FIREWORK_STRENGTH = "strength";
        private static final String KEY_FIREWORK_EFFECTS = "effects";
        private static final String KEY_FIREWORK_ANGLED = "angled";
        private static final String KEY_FOX_CROUCHING = "crouching";
        private static final String KEY_FOX_TYPE = "type";
        private static final String KEY_FROG_TYPE = "type";
        private static final String KEY_GOAT_SCREAMING = "screaming";
        private static final String KEY_HORSE_COLOR = "color";
        private static final String KEY_HORSE_STYLE = "style";
        private static final String KEY_HORSE_CHEST = "chest";
        private static final String KEY_HORSE_JUMP = "jump";
        private static final String KEY_HORSE_DOMESTICATION = "domestication";
        private static final String KEY_HORSE_MAXDOMESTICATION = "maxdomestication";
        private static final String KEY_HORSE_ARMOR = "armor";
        private static final String KEY_HORSE_SADDLE = "saddle";
        private static final String KEY_INTERACTION_WIDTH = "width";
        private static final String KEY_INTERACTION_HEIGHT = "height";
        private static final String KEY_INTERACTION_RESPONSE = "response";
        private static final String KEY_INTERACTION_ATTACK = "lastattack";
        private static final String KEY_INTERACTION_INTERACTION = "lastinteraction";
        private static final String KEY_IRON_GOLEM_PLAYERCREATED = "playercreated";
        private static final String KEY_ITEM_FRAME_FIXED = "fixed";
        private static final String KEY_ITEM_FRAME_ITEM = "item";
        private static final String KEY_ITEM_FRAME_ROTATION = "rotation";
        private static final String KEY_ITEM_FRAME_VISIBLE = "visible";
        private static final String KEY_LIGHTNING_EFFECT = "effect";
        private static final String KEY_MANNEQUIN_IMMOVABLE = "immovable";
        private static final String KEY_MINECART_BLOCK = "block";
        private static final String KEY_MINECART_OFFSET = "offset";
        private static final String KEY_MINECART_COMMAND_COMMAND = "command";
        private static final String KEY_MINECART_COMMAND_CUSTOMNAME = "customname";
        private static final String KEY_MUSHROOM_COW_TYPE = "type";
        private static final String KEY_OMINOUS_SPAWNER_ITEM = "item";
        private static final String KEY_OMINOUS_SPAWNER_DELAY = "delay";
        private static final String KEY_PAINTING_ART = "type";
        private static final String KEY_PANDA_MAINGENE = "maingene";
        private static final String KEY_PANDA_HIDDENGENE = "hiddengene";
        private static final String KEY_PANDA_EATING = "eating";
        private static final String KEY_PANDA_ONBACK = "onback";
        private static final String KEY_PANDA_ROLLING = "rolling";
        private static final String KEY_PANDA_SNEEZING = "sneezing";
        private static final String KEY_PARROT_TYPE = "type";
        private static final String KEY_PHANTOM_SIZE = "size";
        private static final String KEY_PIGLIN_ZOMBIFICATION_IMMUNE = "zombificationimmune";
        private static final String KEY_PUFFERFISH_SIZE = "size";
        private static final String KEY_ZOMBIFIED_PIGLIN_ANGRY = "angry";
        private static final String KEY_ZOMBIFIED_PIGLIN_ANGER = "anger";
        private static final String KEY_RABBIT_TYPE = "type";
        private static final String KEY_PRIMED_TNT_FUSETICKS = "fuseticks";
        private static final String KEY_PRIMED_TNT_SOURCE = "source";
        private static final String KEY_SHEEP_COLOR = "color";
        private static final String KEY_SHEEP_SHEARED = "sheared";
        private static final String KEY_SHULKER_COLOR = "color";
        private static final String KEY_SHULKERBULLET_TARGET = "target";
        private static final String KEY_SLIME_SIZE = "size";
        private static final String KEY_SNOWMAN_DERP = "derp";
        private static final String KEY_SPECTRAL_ARROW_GLOWING_TICKS = "glowingticks";
        private static final String KEY_SPLASH_POTION_ITEM = "item";
        private static final String KEY_STEERABLE_SADDLED = "saddled";
        private static final String KEY_TIPPEDARROW_POTIONMETA = "potionmeta";
        private static final String KEY_TROPICALFISH_COLOR = "color";
        private static final String KEY_TROPICALFISH_PATTERN = "pattern";
        private static final String KEY_TROPICALFISH_PATTERNCOLOR = "patterncolor";
        private static final String KEY_VEX_CHARGING = "charging";
        private static final String KEY_VILLAGER_PROFESSION = "profession";
        private static final String KEY_VILLAGER_LEVEL = "level";
        private static final String KEY_VILLAGER_EXPERIENCE = "experience";
        private static final String KEY_WITHER_SKULL_CHARGED = "charged";
        private static final String KEY_WOLF_ANGRY = "angry";
        private static final String KEY_WOLF_COLOR = "color";
        private static final String KEY_WOLF_INTERESTED = "interested";
        private static final String KEY_WOLF_TYPE = "type";
        private static final String KEY_ZOMBIE_BREAK_DOORS = "breakdoors";

        @Override
        public String getName() {
            return "entity_spec";
        }

        @Override
        public String docs() {
            String docs = this.getBundledDocs();
            docs = docs.replace("%BODY_PART%", "pose" + StringUtils.Join(MCBodyPart.humanoidParts(), ", pose", ", or pose", " or pose"));
            docs = docs.replace("%HORSE_COLOR%", StringUtils.Join(MCHorse.MCHorseColor.values(), ", ", ", or ", " or "));
            docs = docs.replace("%HORSE_STYLE%", StringUtils.Join(MCHorse.MCHorsePattern.values(), ", ", ", or ", " or "));
            docs = docs.replace("%LLAMA_COLOR%", StringUtils.Join(MCLlama.MCLlamaColor.values(), ", ", ", or ", " or "));
            docs = docs.replace("%ROTATION%", StringUtils.Join(MCRotation.values(), ", ", ", or ", " or "));
            docs = docs.replace("%PARROT_TYPE%", StringUtils.Join(MCParrotType.values(), ", ", ", or ", " or "));
            docs = docs.replace("%ART%", StringUtils.Join(MCArt.values(), ", ", ", or ", " or "));
            docs = docs.replace("%DYE_COLOR%", StringUtils.Join(MCDyeColor.values(), ", ", ", or ", " or "));
            docs = docs.replace("%PROFESSION%", StringUtils.Join(MCProfession.values(), ", ", ", or ", " or "));
            docs = docs.replace("%RABBIT_TYPE%", StringUtils.Join(MCRabbitType.values(), ", ", ", or ", " or "));
            docs = docs.replace("%PARTICLE%", StringUtils.Join(MCParticle.types(), ", ", ", or ", " or "));
            docs = docs.replace("%ENDERDRAGON_PHASE%", StringUtils.Join(MCEnderDragonPhase.values(), ", ", ", or ", " or "));
            docs = docs.replace("%FISH_PATTERN%", StringUtils.Join(MCTropicalFish.MCPattern.values(), ", ", ", or ", " or "));
            docs = docs.replace("%CAT_TYPE%", StringUtils.Join(MCCatType.values(), ", ", ", or ", " or "));
            docs = docs.replace("%FOX_TYPE%", StringUtils.Join(MCFoxType.values(), ", ", ", or ", " or "));
            docs = docs.replace("%MUSHROOM_COW_TYPE%", StringUtils.Join(MCMushroomCowType.values(), ", ", ", or ", " or "));
            docs = docs.replace("%PANDA_GENE%", StringUtils.Join(MCPanda.Gene.values(), ", ", ", or ", " or "));
            docs = docs.replace("%AXOLOTL_TYPE%", StringUtils.Join(MCAxolotlType.values(), ", ", ", or ", " or "));
            docs = docs.replace("%FROG_TYPE%", StringUtils.Join(MCFrog.MCFrogType.values(), ", ", ", or ", " or "));
            docs = docs.replace("%ITEM_DISPLAY%", StringUtils.Join(MCItemDisplay.ModelTransform.values(), ", ", ", or "));
            docs = docs.replace("%WOLF_TYPE%", StringUtils.Join(MCWolf.Variant.values(), ", ", ", or "));
            for (Field field : entity_spec.class.getDeclaredFields()) {
                try {
                    String name = field.getName();
                    if (!name.startsWith("KEY_")) continue;
                    docs = docs.replace("%" + name + "%", (String)field.get(null));
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
            }
            return docs;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity entity = Static.getEntity(args[0], t);
            CArray specArray = CArray.GetAssociativeArray(t);
            switch (entity.getType().getAbstracted()) {
                case AREA_EFFECT_CLOUD: {
                    MCAreaEffectCloud cloud = (MCAreaEffectCloud)entity;
                    specArray.set("color", (Mixed)ObjectGenerator.GetGenerator().color(cloud.getColor(), t), t);
                    specArray.set(KEY_AREAEFFECTCLOUD_DURATION, (Mixed)new CInt(cloud.getDuration(), t), t);
                    specArray.set(KEY_AREAEFFECTCLOUD_DURATIONONUSE, (Mixed)new CInt(cloud.getDurationOnUse(), t), t);
                    specArray.set(KEY_AREAEFFECTCLOUD_PARTICLE, (Mixed)new CString(cloud.getParticle().name(), t), t);
                    CArray meta = CArray.GetAssociativeArray(t);
                    CArray effects = ObjectGenerator.GetGenerator().potions(cloud.getCustomEffects(), t);
                    meta.set("potions", (Mixed)effects, t);
                    if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
                        MCPotionType potionType = cloud.getBasePotionType();
                        if (potionType == null) {
                            meta.set("potiontype", (Mixed)CNull.NULL, t);
                        } else {
                            meta.set("potiontype", potionType.name());
                        }
                    } else {
                        meta.set(KEY_ENDERCRYSTAL_BASE, (Mixed)ObjectGenerator.GetGenerator().potionData(cloud.getBasePotionData(), t), t);
                    }
                    specArray.set("potionmeta", (Mixed)meta, t);
                    specArray.set(KEY_AREAEFFECTCLOUD_RADIUS, (Mixed)new CDouble(cloud.getRadius(), t), t);
                    specArray.set(KEY_AREAEFFECTCLOUD_RADIUSONUSE, (Mixed)new CDouble(cloud.getRadiusOnUse(), t), t);
                    specArray.set(KEY_AREAEFFECTCLOUD_RADIUSPERTICK, (Mixed)new CDouble(cloud.getRadiusPerTick(), t), t);
                    specArray.set(KEY_AREAEFFECTCLOUD_REAPPLICATIONDELAY, (Mixed)new CInt(cloud.getReapplicationDelay(), t), t);
                    MCProjectileSource cloudSource = cloud.getSource();
                    if (cloudSource instanceof MCBlockProjectileSource) {
                        MCLocation blockLocation = ((MCBlockProjectileSource)cloudSource).getBlock().getLocation();
                        CArray locationArray = ObjectGenerator.GetGenerator().location(blockLocation, false);
                        specArray.set("source", (Mixed)locationArray, t);
                    } else if (cloudSource instanceof MCEntity) {
                        String entityUUID = ((MCEntity)((Object)cloudSource)).getUniqueId().toString();
                        specArray.set("source", (Mixed)new CString(entityUUID, t), t);
                    } else {
                        specArray.set("source", (Mixed)CNull.NULL, t);
                    }
                    specArray.set(KEY_AREAEFFECTCLOUD_WAITTIME, (Mixed)new CInt(cloud.getWaitTime(), t), t);
                    break;
                }
                case ARROW: {
                    MCArrow arrow = (MCArrow)entity;
                    specArray.set(KEY_ARROW_CRITICAL, (Mixed)CBoolean.get(arrow.isCritical()), t);
                    specArray.set(KEY_ARROW_KNOCKBACK, (Mixed)new CInt(arrow.getKnockbackStrength(), t), t);
                    specArray.set("damage", (Mixed)new CDouble(arrow.getDamage(), t), t);
                    specArray.set(KEY_ARROW_PIERCE_LEVEL, (Mixed)new CInt(arrow.getPierceLevel(), t), t);
                    specArray.set(KEY_ARROW_PICKUP, (Mixed)new CString(arrow.getPickupStatus().name(), t), t);
                    CArray tippedmeta = CArray.GetAssociativeArray(t);
                    CArray tippedeffects = ObjectGenerator.GetGenerator().potions(arrow.getCustomEffects(), t);
                    tippedmeta.set("potions", (Mixed)tippedeffects, t);
                    if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
                        MCPotionType potionType = arrow.getBasePotionType();
                        if (potionType == null) {
                            tippedmeta.set("potiontype", (Mixed)CNull.NULL, t);
                        } else {
                            tippedmeta.set("potiontype", potionType.name());
                        }
                    } else {
                        tippedmeta.set(KEY_ENDERCRYSTAL_BASE, (Mixed)ObjectGenerator.GetGenerator().potionData(arrow.getBasePotionData(), t), t);
                    }
                    specArray.set("potionmeta", (Mixed)tippedmeta, t);
                    break;
                }
                case ARMOR_STAND: {
                    MCArmorStand stand = (MCArmorStand)((Object)entity);
                    specArray.set(KEY_ARMORSTAND_ARMS, (Mixed)CBoolean.get(stand.hasArms()), t);
                    specArray.set(KEY_ARMORSTAND_BASEPLATE, (Mixed)CBoolean.get(stand.hasBasePlate()), t);
                    specArray.set(KEY_ARMORSTAND_GRAVITY, (Mixed)CBoolean.get(stand.hasGravity()), t);
                    specArray.set(KEY_ARMORSTAND_MARKER, (Mixed)CBoolean.get(stand.isMarker()), t);
                    specArray.set(KEY_ARMORSTAND_SMALLSIZE, (Mixed)CBoolean.get(stand.isSmall()), t);
                    specArray.set("visible", (Mixed)CBoolean.get(stand.isVisible()), t);
                    CArray poses = CArray.GetAssociativeArray(t);
                    Map<MCBodyPart, Vector3D> poseMap = stand.getAllPoses();
                    for (MCBodyPart key : poseMap.keySet()) {
                        poses.set("pose" + key.name(), (Mixed)ObjectGenerator.GetGenerator().vector(poseMap.get((Object)key), t), t);
                    }
                    specArray.set(KEY_ARMORSTAND_POSES, (Mixed)poses, t);
                    break;
                }
                case AXOLOTL: {
                    MCAxolotl axolotl = (MCAxolotl)entity;
                    specArray.set("type", (Mixed)new CString(axolotl.getAxolotlType().name(), t), t);
                    break;
                }
                case BEE: {
                    MCBee bee = (MCBee)entity;
                    specArray.set("anger", (Mixed)new CInt(bee.getAnger(), t), t);
                    specArray.set(KEY_BEE_NECTAR, (Mixed)CBoolean.get(bee.hasNectar()), t);
                    specArray.set(KEY_BEE_STUNG, (Mixed)CBoolean.get(bee.hasStung()), t);
                    MCLocation flower = bee.getFlowerLocation();
                    if (flower == null) {
                        specArray.set(KEY_BEE_FLOWER_LOCATION, (Mixed)CNull.NULL, t);
                    } else {
                        specArray.set(KEY_BEE_FLOWER_LOCATION, (Mixed)ObjectGenerator.GetGenerator().location(flower), t);
                    }
                    MCLocation hive = bee.getHiveLocation();
                    if (hive == null) {
                        specArray.set(KEY_BEE_HIVE_LOCATION, (Mixed)CNull.NULL, t);
                        break;
                    }
                    specArray.set(KEY_BEE_HIVE_LOCATION, (Mixed)ObjectGenerator.GetGenerator().location(hive), t);
                    break;
                }
                case BLOCK_DISPLAY: {
                    MCBlockDisplay blockDisplay = (MCBlockDisplay)entity;
                    specArray.set(KEY_DISPLAY_BLOCK, (Mixed)ObjectGenerator.GetGenerator().blockData(blockDisplay.getBlockData(), t), t);
                    break;
                }
                case BOAT: {
                    MCBoat boat = (MCBoat)entity;
                    specArray.set("type", (Mixed)new CString(boat.getWoodType().name(), t), t);
                    break;
                }
                case CAT: {
                    MCCat cat = (MCCat)entity;
                    specArray.set("type", (Mixed)new CString(cat.getCatType().name(), t), t);
                    specArray.set(KEY_GENERIC_SITTING, (Mixed)CBoolean.get(cat.isSitting()), t);
                    specArray.set("color", (Mixed)new CString(cat.getCollarColor().name(), t), t);
                    break;
                }
                case CREEPER: {
                    MCCreeper creeper = (MCCreeper)((Object)entity);
                    specArray.set(KEY_CREEPER_POWERED, (Mixed)CBoolean.get(creeper.isPowered()), t);
                    specArray.set("fuseticks", (Mixed)new CInt(creeper.getFuseTicks(), t), t);
                    specArray.set(KEY_CREEPER_MAXFUSETICKS, (Mixed)new CInt(creeper.getMaxFuseTicks(), t), t);
                    specArray.set(KEY_CREEPER_EXPLOSIONRADIUS, (Mixed)new CInt(creeper.getExplosionRadius(), t), t);
                    break;
                }
                case DONKEY: 
                case MULE: {
                    MCChestedHorse chestedhorse = (MCChestedHorse)entity;
                    specArray.set(KEY_HORSE_CHEST, (Mixed)CBoolean.get(chestedhorse.hasChest()), t);
                    specArray.set(KEY_HORSE_JUMP, (Mixed)new CDouble(chestedhorse.getJumpStrength(), t), t);
                    specArray.set(KEY_HORSE_DOMESTICATION, (Mixed)new CInt(chestedhorse.getDomestication(), t), t);
                    specArray.set(KEY_HORSE_MAXDOMESTICATION, (Mixed)new CInt(chestedhorse.getMaxDomestication(), t), t);
                    specArray.set(KEY_HORSE_SADDLE, (Mixed)ObjectGenerator.GetGenerator().item(chestedhorse.getSaddle(), t), t);
                    break;
                }
                case DROPPED_ITEM: {
                    MCItem item = (MCItem)entity;
                    specArray.set(KEY_DROPPED_ITEM_ITEMSTACK, (Mixed)ObjectGenerator.GetGenerator().item(item.getItemStack(), t), t);
                    specArray.set(KEY_DROPPED_ITEM_PICKUPDELAY, (Mixed)new CInt(item.getPickupDelay(), t), t);
                    UUID owner = item.getOwner();
                    if (owner == null) {
                        specArray.set(KEY_DROPPED_ITEM_OWNER, (Mixed)CNull.NULL, t);
                    } else {
                        specArray.set(KEY_DROPPED_ITEM_OWNER, (Mixed)new CString(owner.toString(), t), t);
                    }
                    UUID thrower = item.getThrower();
                    if (thrower == null) {
                        specArray.set(KEY_DROPPED_ITEM_THROWER, (Mixed)CNull.NULL, t);
                    } else {
                        specArray.set(KEY_DROPPED_ITEM_THROWER, (Mixed)new CString(thrower.toString(), t), t);
                    }
                    if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_18_X)) {
                        specArray.set(KEY_DROPPED_ITEM_DESPAWN, (Mixed)CBoolean.get(item.willDespawn()), t);
                        break;
                    }
                    specArray.set(KEY_DROPPED_ITEM_DESPAWN, (Mixed)CBoolean.TRUE, t);
                    break;
                }
                case ENDER_CRYSTAL: {
                    MCEnderCrystal endercrystal = (MCEnderCrystal)entity;
                    specArray.set(KEY_ENDERCRYSTAL_BASE, (Mixed)CBoolean.get(endercrystal.isShowingBottom()), t);
                    MCLocation location = endercrystal.getBeamTarget();
                    if (location == null) {
                        specArray.set(KEY_ENDERCRYSTAL_BEAMTARGET, (Mixed)CNull.NULL, t);
                        break;
                    }
                    specArray.set(KEY_ENDERCRYSTAL_BEAMTARGET, (Mixed)ObjectGenerator.GetGenerator().location(location, false), t);
                    break;
                }
                case ENDER_EYE: {
                    MCEnderSignal endereye = (MCEnderSignal)entity;
                    specArray.set(KEY_ENDEREYE_DESPAWNTICKS, (Mixed)new CInt(endereye.getDespawnTicks(), t), t);
                    specArray.set(KEY_ENDEREYE_DROP, (Mixed)CBoolean.get(endereye.getDropItem()), t);
                    specArray.set("item", (Mixed)ObjectGenerator.GetGenerator().item(endereye.getItem(), t), t);
                    specArray.set("target", (Mixed)ObjectGenerator.GetGenerator().location(endereye.getTargetLocation(), false), t);
                    break;
                }
                case ENDER_DRAGON: {
                    MCEnderDragon enderdragon = (MCEnderDragon)entity;
                    specArray.set(KEY_ENDERDRAGON_PHASE, (Mixed)new CString(enderdragon.getPhase().name(), t), t);
                    break;
                }
                case ENDERMAN: {
                    MCEnderman enderman = (MCEnderman)entity;
                    MCBlockData carried = enderman.getCarriedMaterial();
                    specArray.set(KEY_ENDERMAN_CARRIED, (Mixed)(carried == null ? CNull.NULL : new CString(carried.getMaterial().getName(), t)), t);
                    break;
                }
                case EVOKER_FANGS: {
                    MCEvokerFangs fangs = (MCEvokerFangs)entity;
                    MCLivingEntity fangsource = fangs.getOwner();
                    if (fangsource == null) {
                        specArray.set("source", (Mixed)CNull.NULL, t);
                        break;
                    }
                    specArray.set("source", (Mixed)new CString(fangsource.getUniqueId().toString(), t), t);
                    break;
                }
                case EXPERIENCE_ORB: {
                    MCExperienceOrb orb = (MCExperienceOrb)entity;
                    specArray.set(KEY_EXPERIENCE_ORB_AMOUNT, (Mixed)new CInt(orb.getExperience(), t), t);
                    break;
                }
                case FALLING_BLOCK: {
                    MCFallingBlock block = (MCFallingBlock)entity;
                    specArray.set("block", (Mixed)new CString(block.getMaterial().getName(), t), t);
                    specArray.set(KEY_FALLING_BLOCK_DROPITEM, (Mixed)CBoolean.get(block.getDropItem()), t);
                    specArray.set("damage", (Mixed)CBoolean.get(block.canHurtEntities()), t);
                    break;
                }
                case FIREBALL: 
                case SMALL_FIREBALL: {
                    MCFireball ball = (MCFireball)entity;
                    specArray.set(KEY_FIREBALL_DIRECTION, (Mixed)ObjectGenerator.GetGenerator().vector(ball.getDirection(), t), t);
                    break;
                }
                case FIREWORK: {
                    MCFirework firework = (MCFirework)entity;
                    MCFireworkMeta fmeta = firework.getFireWorkMeta();
                    specArray.set(KEY_FIREWORK_STRENGTH, (Mixed)new CInt(fmeta.getStrength(), t), t);
                    CArray fe = new CArray(t);
                    for (MCFireworkEffect effect : fmeta.getEffects()) {
                        fe.push(ObjectGenerator.GetGenerator().fireworkEffect(effect, t), t);
                    }
                    specArray.set(KEY_FIREWORK_EFFECTS, (Mixed)fe, t);
                    specArray.set(KEY_FIREWORK_ANGLED, (Mixed)CBoolean.get(firework.isShotAtAngle()), t);
                    break;
                }
                case FOX: {
                    MCFox fox = (MCFox)entity;
                    specArray.set(KEY_GENERIC_SITTING, (Mixed)CBoolean.get(fox.isSitting()), t);
                    specArray.set(KEY_FOX_CROUCHING, (Mixed)CBoolean.get(fox.isCrouching()), t);
                    specArray.set("type", fox.getVariant().name(), t);
                    break;
                }
                case FROG: {
                    MCFrog frog = (MCFrog)entity;
                    specArray.set("type", frog.getFrogType().name(), t);
                    break;
                }
                case GOAT: {
                    MCGoat goat = (MCGoat)entity;
                    specArray.set(KEY_GOAT_SCREAMING, (Mixed)CBoolean.get(goat.isScreaming()), t);
                    break;
                }
                case HORSE: {
                    MCHorse horse = (MCHorse)entity;
                    specArray.set("color", (Mixed)new CString(horse.getColor().name(), t), t);
                    specArray.set(KEY_HORSE_STYLE, (Mixed)new CString(horse.getPattern().name(), t), t);
                    specArray.set(KEY_HORSE_JUMP, (Mixed)new CDouble(horse.getJumpStrength(), t), t);
                    specArray.set(KEY_HORSE_DOMESTICATION, (Mixed)new CInt(horse.getDomestication(), t), t);
                    specArray.set(KEY_HORSE_MAXDOMESTICATION, (Mixed)new CInt(horse.getMaxDomestication(), t), t);
                    specArray.set(KEY_HORSE_ARMOR, (Mixed)ObjectGenerator.GetGenerator().item(horse.getArmor(), t), t);
                    specArray.set(KEY_HORSE_SADDLE, (Mixed)ObjectGenerator.GetGenerator().item(horse.getSaddle(), t), t);
                    break;
                }
                case INTERACTION: {
                    MCInteraction interaction = (MCInteraction)entity;
                    specArray.set(KEY_INTERACTION_WIDTH, (Mixed)new CDouble(interaction.getWidth(), t), t);
                    specArray.set(KEY_INTERACTION_HEIGHT, (Mixed)new CDouble(interaction.getHeight(), t), t);
                    specArray.set(KEY_INTERACTION_RESPONSE, (Mixed)CBoolean.get(interaction.isResponsive()), t);
                    MCInteraction.MCPreviousInteraction attack = interaction.getLastAttack();
                    if (attack != null) {
                        CArray attackArray = CArray.GetAssociativeArray(t);
                        attackArray.set("puuid", attack.getUuid().toString());
                        attackArray.set("timestamp", (Mixed)new CInt(attack.getTimestamp(), t), t);
                        specArray.set(KEY_INTERACTION_ATTACK, (Mixed)attackArray, t);
                    } else {
                        specArray.set(KEY_INTERACTION_ATTACK, (Mixed)CNull.NULL, t);
                    }
                    MCInteraction.MCPreviousInteraction interact = interaction.getLastInteraction();
                    if (interact != null) {
                        CArray interactionArray = CArray.GetAssociativeArray(t);
                        interactionArray.set("puuid", interact.getUuid().toString());
                        interactionArray.set("timestamp", (Mixed)new CInt(interact.getTimestamp(), t), t);
                        specArray.set(KEY_INTERACTION_INTERACTION, (Mixed)interactionArray, t);
                        break;
                    }
                    specArray.set(KEY_INTERACTION_INTERACTION, (Mixed)CNull.NULL, t);
                    break;
                }
                case IRON_GOLEM: {
                    MCIronGolem golem = (MCIronGolem)entity;
                    specArray.set(KEY_IRON_GOLEM_PLAYERCREATED, (Mixed)CBoolean.get(golem.isPlayerCreated()), t);
                    break;
                }
                case ITEM_DISPLAY: {
                    MCItemDisplay itemDisplay = (MCItemDisplay)entity;
                    specArray.set("item", (Mixed)ObjectGenerator.GetGenerator().item(itemDisplay.getItem(), t), t);
                    specArray.set(KEY_DISPLAY_ITEM_DISPLAY, itemDisplay.getItemModelTransform().name(), t);
                    break;
                }
                case ITEM_FRAME: 
                case GLOW_ITEM_FRAME: {
                    MCItemFrame frame = (MCItemFrame)entity;
                    specArray.set(KEY_ITEM_FRAME_FIXED, (Mixed)CBoolean.get(frame.isFixed()), t);
                    specArray.set("item", (Mixed)ObjectGenerator.GetGenerator().item(frame.getItem(), t), t);
                    specArray.set(KEY_ITEM_FRAME_ROTATION, (Mixed)new CString(frame.getRotation().name(), t), t);
                    specArray.set("visible", (Mixed)CBoolean.get(frame.isVisible()), t);
                    break;
                }
                case LIGHTNING: {
                    MCLightningStrike lightning2 = (MCLightningStrike)entity;
                    specArray.set(KEY_LIGHTNING_EFFECT, (Mixed)CBoolean.get(lightning2.isEffect()), t);
                    break;
                }
                case LLAMA: 
                case TRADER_LLAMA: {
                    MCLlama llama = (MCLlama)entity;
                    specArray.set("color", (Mixed)new CString(llama.getLlamaColor().name(), t), t);
                    specArray.set(KEY_HORSE_CHEST, (Mixed)CBoolean.get(llama.hasChest()), t);
                    specArray.set(KEY_HORSE_DOMESTICATION, (Mixed)new CInt(llama.getDomestication(), t), t);
                    specArray.set(KEY_HORSE_MAXDOMESTICATION, (Mixed)new CInt(llama.getMaxDomestication(), t), t);
                    specArray.set(KEY_HORSE_SADDLE, (Mixed)ObjectGenerator.GetGenerator().item(llama.getSaddle(), t), t);
                    break;
                }
                case MAGMA_CUBE: 
                case SLIME: {
                    MCSlime cube = (MCSlime)entity;
                    specArray.set("size", (Mixed)new CInt(cube.getSize(), t), t);
                    break;
                }
                case MANNEQUIN: {
                    MCMannequin mannequin = (MCMannequin)entity;
                    specArray.set(KEY_MANNEQUIN_IMMOVABLE, (Mixed)CBoolean.get(mannequin.isImmovable()), t);
                    break;
                }
                case MINECART: 
                case MINECART_FURNACE: 
                case MINECART_HOPPER: 
                case MINECART_MOB_SPAWNER: 
                case MINECART_TNT: {
                    MCMinecart minecart = (MCMinecart)entity;
                    specArray.set("block", (Mixed)new CString(minecart.getDisplayBlock().getMaterial().getName(), t), t);
                    specArray.set(KEY_MINECART_OFFSET, (Mixed)new CInt(minecart.getDisplayBlockOffset(), t), t);
                    break;
                }
                case MINECART_COMMAND: {
                    MCCommandMinecart commandminecart = (MCCommandMinecart)entity;
                    specArray.set(KEY_MINECART_COMMAND_COMMAND, (Mixed)new CString(commandminecart.getCommand(), t), t);
                    specArray.set(KEY_MINECART_COMMAND_CUSTOMNAME, (Mixed)new CString(commandminecart.getName(), t), t);
                    specArray.set("block", (Mixed)new CString(commandminecart.getDisplayBlock().getMaterial().getName(), t), t);
                    specArray.set(KEY_MINECART_OFFSET, (Mixed)new CInt(commandminecart.getDisplayBlockOffset(), t), t);
                    break;
                }
                case MUSHROOM_COW: {
                    MCMushroomCow cow = (MCMushroomCow)entity;
                    specArray.set("type", cow.getVariant().name(), t);
                    break;
                }
                case OMINOUS_ITEM_SPAWNER: {
                    MCOminousItemSpawner spawner = (MCOminousItemSpawner)entity;
                    specArray.set("item", (Mixed)ObjectGenerator.GetGenerator().item(spawner.getItem(), t), t);
                    specArray.set(KEY_OMINOUS_SPAWNER_DELAY, (Mixed)new CInt(spawner.getDelay(), t), t);
                    break;
                }
                case PAINTING: {
                    MCPainting painting = (MCPainting)entity;
                    specArray.set("type", (Mixed)new CString(painting.getArt().name(), t), t);
                    break;
                }
                case PANDA: {
                    MCPanda panda = (MCPanda)entity;
                    specArray.set(KEY_PANDA_MAINGENE, (Mixed)new CString(panda.getMainGene().name(), t), t);
                    specArray.set(KEY_PANDA_HIDDENGENE, (Mixed)new CString(panda.getHiddenGene().name(), t), t);
                    if (!Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_19)) break;
                    specArray.set(KEY_PANDA_EATING, (Mixed)CBoolean.get(panda.isEating()), t);
                    specArray.set(KEY_PANDA_ONBACK, (Mixed)CBoolean.get(panda.isOnBack()), t);
                    specArray.set(KEY_PANDA_ROLLING, (Mixed)CBoolean.get(panda.isRolling()), t);
                    specArray.set(KEY_PANDA_SNEEZING, (Mixed)CBoolean.get(panda.isSneezing()), t);
                    break;
                }
                case PARROT: {
                    MCParrot parrot = (MCParrot)entity;
                    specArray.set(KEY_GENERIC_SITTING, (Mixed)CBoolean.get(parrot.isSitting()), t);
                    specArray.set("type", (Mixed)new CString(parrot.getVariant().name(), t), t);
                    break;
                }
                case PHANTOM: {
                    MCPhantom phantom = (MCPhantom)entity;
                    specArray.set("size", (Mixed)new CInt(phantom.getSize(), t), t);
                    break;
                }
                case PIG: {
                    MCPig pig = (MCPig)entity;
                    specArray.set(KEY_STEERABLE_SADDLED, (Mixed)CBoolean.get(pig.isSaddled()), t);
                    break;
                }
                case PIGLIN: {
                    MCPiglin piglin = (MCPiglin)entity;
                    specArray.set(KEY_GENERIC_BABY, (Mixed)CBoolean.get(piglin.isBaby()), t);
                    specArray.set(KEY_PIGLIN_ZOMBIFICATION_IMMUNE, (Mixed)CBoolean.get(piglin.isImmuneToZombification()), t);
                    break;
                }
                case PRIMED_TNT: {
                    MCTNT tnt = (MCTNT)entity;
                    specArray.set("fuseticks", (Mixed)new CInt(tnt.getFuseTicks(), t), t);
                    MCEntity source2 = tnt.getSource();
                    if (source2 != null) {
                        specArray.set("source", (Mixed)new CString(source2.getUniqueId().toString(), t), t);
                        break;
                    }
                    specArray.set("source", (Mixed)CNull.NULL, t);
                    break;
                }
                case PUFFERFISH: {
                    MCPufferfish puffer = (MCPufferfish)((Object)entity);
                    specArray.set("size", (Mixed)new CInt(puffer.getPuffState(), t), t);
                    break;
                }
                case RABBIT: {
                    MCRabbit rabbit = (MCRabbit)entity;
                    specArray.set("type", (Mixed)new CString(rabbit.getRabbitType().name(), t), t);
                    break;
                }
                case SHEEP: {
                    MCSheep sheep = (MCSheep)entity;
                    specArray.set("color", (Mixed)new CString(sheep.getColor().name(), t), t);
                    specArray.set(KEY_SHEEP_SHEARED, (Mixed)CBoolean.get(sheep.isSheared()), t);
                    break;
                }
                case SHULKER: {
                    MCShulker shulker = (MCShulker)entity;
                    MCDyeColor shulkerColor = shulker.getColor();
                    if (shulkerColor == null) {
                        specArray.set("color", (Mixed)CNull.NULL, t);
                        break;
                    }
                    specArray.set("color", (Mixed)new CString(shulker.getColor().name(), t), t);
                    break;
                }
                case SHULKER_BULLET: {
                    MCShulkerBullet bullet = (MCShulkerBullet)entity;
                    MCEntity target = bullet.getTarget();
                    if (target == null) {
                        specArray.set("target", (Mixed)CNull.NULL, t);
                        break;
                    }
                    specArray.set("target", (Mixed)new CString(target.getUniqueId().toString(), t), t);
                    break;
                }
                case SKELETON_HORSE: 
                case ZOMBIE_HORSE: {
                    MCAbstractHorse undeadhorse = (MCAbstractHorse)entity;
                    specArray.set(KEY_HORSE_JUMP, (Mixed)new CDouble(undeadhorse.getJumpStrength(), t), t);
                    specArray.set(KEY_HORSE_DOMESTICATION, (Mixed)new CInt(undeadhorse.getDomestication(), t), t);
                    specArray.set(KEY_HORSE_MAXDOMESTICATION, (Mixed)new CInt(undeadhorse.getMaxDomestication(), t), t);
                    specArray.set(KEY_HORSE_SADDLE, (Mixed)ObjectGenerator.GetGenerator().item(undeadhorse.getSaddle(), t), t);
                    break;
                }
                case SNOWMAN: {
                    MCSnowman snowman = (MCSnowman)entity;
                    specArray.set(KEY_SNOWMAN_DERP, (Mixed)CBoolean.GenerateCBoolean(snowman.isDerp(), t), t);
                    break;
                }
                case SPECTRAL_ARROW: {
                    MCSpectralArrow spectral = (MCSpectralArrow)entity;
                    specArray.set(KEY_ARROW_CRITICAL, (Mixed)CBoolean.get(spectral.isCritical()), t);
                    specArray.set(KEY_ARROW_KNOCKBACK, (Mixed)new CInt(spectral.getKnockbackStrength(), t), t);
                    specArray.set("damage", (Mixed)new CDouble(spectral.getDamage(), t), t);
                    specArray.set(KEY_SPECTRAL_ARROW_GLOWING_TICKS, (Mixed)new CInt(spectral.getGlowingTicks(), t), t);
                    break;
                }
                case LINGERING_POTION: 
                case SPLASH_POTION: {
                    MCThrownPotion potion = (MCThrownPotion)entity;
                    specArray.set("item", (Mixed)ObjectGenerator.GetGenerator().item(potion.getItem(), t), t);
                    break;
                }
                case STRIDER: {
                    MCStrider strider = (MCStrider)entity;
                    specArray.set(KEY_STEERABLE_SADDLED, (Mixed)CBoolean.get(strider.isSaddled()), t);
                    break;
                }
                case TEXT_DISPLAY: {
                    MCTextDisplay tDisplay = (MCTextDisplay)entity;
                    specArray.set(KEY_DISPLAY_TEXT, tDisplay.getText());
                    specArray.set(KEY_DISPLAY_TEXT_ALIGNMENT, tDisplay.getAlignment().name());
                    specArray.set(KEY_DISPLAY_TEXT_LINE_WIDTH, (Mixed)new CInt(tDisplay.getLineWidth(), t), t);
                    specArray.set(KEY_DISPLAY_TEXT_SEE_THROUGH, (Mixed)CBoolean.get(tDisplay.isVisibleThroughBlocks()), t);
                    specArray.set(KEY_DISPLAY_TEXT_SHADOW, (Mixed)CBoolean.get(tDisplay.hasShadow()), t);
                    MCColor color2 = tDisplay.getBackgroundColor();
                    if (color2 == null) {
                        specArray.set(KEY_DISPLAY_TEXT_BACKGROUND_COLOR, (Mixed)CNull.NULL, t);
                    } else {
                        specArray.set(KEY_DISPLAY_TEXT_BACKGROUND_COLOR, (Mixed)ObjectGenerator.GetGenerator().transparentColor(color2, t), t);
                    }
                    long opacity = tDisplay.getOpacity();
                    if (opacity < 0L) {
                        opacity += 256L;
                    }
                    specArray.set(KEY_DISPLAY_TEXT_OPACITY, (Mixed)new CInt(opacity, t), t);
                    break;
                }
                case TRIDENT: {
                    MCTrident trident = (MCTrident)entity;
                    specArray.set(KEY_ARROW_CRITICAL, (Mixed)CBoolean.get(trident.isCritical()), t);
                    specArray.set(KEY_ARROW_KNOCKBACK, (Mixed)new CInt(trident.getKnockbackStrength(), t), t);
                    specArray.set("damage", (Mixed)new CDouble(trident.getDamage(), t), t);
                    break;
                }
                case TROPICAL_FISH: {
                    MCTropicalFish fish = (MCTropicalFish)entity;
                    specArray.set("color", (Mixed)new CString(fish.getBodyColor().name(), t), t);
                    specArray.set(KEY_TROPICALFISH_PATTERN, (Mixed)new CString(fish.getPattern().name(), t), t);
                    specArray.set(KEY_TROPICALFISH_PATTERNCOLOR, (Mixed)new CString(fish.getPatternColor().name(), t), t);
                    break;
                }
                case VEX: {
                    MCVex vex = (MCVex)entity;
                    specArray.set(KEY_VEX_CHARGING, (Mixed)CBoolean.get(vex.isCharging()), t);
                    break;
                }
                case VILLAGER: {
                    MCVillager villager = (MCVillager)entity;
                    specArray.set(KEY_VILLAGER_PROFESSION, (Mixed)new CString(villager.getProfession().name(), t), t);
                    specArray.set(KEY_VILLAGER_LEVEL, (Mixed)new CInt(villager.getLevel(), t), t);
                    specArray.set(KEY_VILLAGER_EXPERIENCE, (Mixed)new CInt(villager.getExperience(), t), t);
                    break;
                }
                case WITHER_SKULL: {
                    MCWitherSkull skull = (MCWitherSkull)entity;
                    specArray.set(KEY_WITHER_SKULL_CHARGED, (Mixed)CBoolean.get(skull.isCharged()), t);
                    specArray.set(KEY_FIREBALL_DIRECTION, (Mixed)ObjectGenerator.GetGenerator().vector(skull.getDirection(), t), t);
                    break;
                }
                case WOLF: {
                    MCWolf wolf = (MCWolf)entity;
                    specArray.set("angry", (Mixed)CBoolean.get(wolf.isAngry()), t);
                    specArray.set("color", (Mixed)new CString(wolf.getCollarColor().name(), t), t);
                    specArray.set(KEY_GENERIC_SITTING, (Mixed)CBoolean.get(wolf.isSitting()), t);
                    if (!Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_19)) break;
                    specArray.set(KEY_WOLF_INTERESTED, (Mixed)CBoolean.get(wolf.isInterested()), t);
                    if (!Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) break;
                    specArray.set("type", (Mixed)new CString(wolf.getWolfVariant().name(), t), t);
                    break;
                }
                case ZOGLIN: {
                    MCZoglin zoglin = (MCZoglin)entity;
                    specArray.set(KEY_GENERIC_BABY, (Mixed)CBoolean.get(zoglin.isBaby()), t);
                    break;
                }
                case ZOMBIE: 
                case DROWNED: 
                case HUSK: {
                    MCZombie zombie = (MCZombie)entity;
                    specArray.set(KEY_GENERIC_BABY, (Mixed)CBoolean.get(zombie.isBaby()), t);
                    if (!Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_19)) break;
                    specArray.set(KEY_ZOMBIE_BREAK_DOORS, (Mixed)CBoolean.get(zombie.canBreakDoors()), t);
                    break;
                }
                case ZOMBIE_VILLAGER: {
                    MCZombieVillager zombievillager = (MCZombieVillager)entity;
                    specArray.set(KEY_GENERIC_BABY, (Mixed)CBoolean.get(zombievillager.isBaby()), t);
                    specArray.set(KEY_VILLAGER_PROFESSION, (Mixed)new CString(zombievillager.getProfession().name(), t), t);
                    if (!Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_19)) break;
                    specArray.set(KEY_ZOMBIE_BREAK_DOORS, (Mixed)CBoolean.get(zombievillager.canBreakDoors()), t);
                    break;
                }
                case ZOMBIFIED_PIGLIN: {
                    MCPigZombie pigZombie = (MCPigZombie)entity;
                    specArray.set("angry", (Mixed)CBoolean.get(pigZombie.isAngry()), t);
                    specArray.set("anger", (Mixed)new CInt(pigZombie.getAnger(), t), t);
                    specArray.set(KEY_GENERIC_BABY, (Mixed)CBoolean.get(pigZombie.isBaby()), t);
                    if (!Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_19)) break;
                    specArray.set(KEY_ZOMBIE_BREAK_DOORS, (Mixed)CBoolean.get(pigZombie.canBreakDoors()), t);
                }
            }
            return specArray;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class entity_grounded
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CBoolean.get(Static.getEntity(args[0], t).isOnGround());
        }

        @Override
        public String getName() {
            return "entity_grounded";
        }

        @Override
        public String docs() {
            return "boolean {entityUUID} returns whether the entity is touching the ground";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_art_at.class})
    public static class set_art_at
    extends EntitySetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            boolean worked;
            MCArt art;
            MCWorld w = null;
            if (environment.getEnv(CommandHelperEnvironment.class).GetPlayer() != null) {
                w = environment.getEnv(CommandHelperEnvironment.class).GetPlayer().getWorld();
            }
            MCLocation loc = ObjectGenerator.GetGenerator().location(args[0], w, t);
            try {
                art = MCArt.valueOf(args[1].val());
            }
            catch (IllegalArgumentException e) {
                throw new CREFormatException("Invalid type: " + args[1].val(), t);
            }
            MCPainting p2 = null;
            for (MCEntity e : StaticLayer.GetConvertor().GetEntitiesAt(loc, 1.0)) {
                if (!(e instanceof MCPainting)) continue;
                p2 = (MCPainting)e;
                break;
            }
            if (p2 == null) {
                p2 = (MCPainting)loc.getWorld().spawn(loc, MCEntityType.MCVanillaEntityType.PAINTING);
            }
            if (!(worked = p2.setArt(art))) {
                p2.remove();
            }
            return CBoolean.get(worked);
        }

        @Override
        public String getName() {
            return "set_art_at";
        }

        @Override
        public String docs() {
            return "boolean {locationArray, art} Sets the art at the specified location. If the art doesn't fit, nothing happens, and false is returned. Otherwise, true is returned. ---- Art may be one of the following: " + StringUtils.Join(MCArt.values(), ", ");
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_art_at.class})
    public static class get_art_at
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCWorld w = null;
            if (environment.getEnv(CommandHelperEnvironment.class).GetPlayer() != null) {
                w = environment.getEnv(CommandHelperEnvironment.class).GetPlayer().getWorld();
            }
            List<MCEntity> es = StaticLayer.GetConvertor().GetEntitiesAt(ObjectGenerator.GetGenerator().location(args[0], w, t), 1.0);
            for (MCEntity e : es) {
                if (!(e instanceof MCPainting)) continue;
                return new CString(((MCPainting)e).getArt().name(), t);
            }
            throw new CREBadEntityException("There is no painting at the specified location", t);
        }

        @Override
        public String getName() {
            return "get_art_at";
        }

        @Override
        public String docs() {
            return "string {locationArray} Gets the specified art at the given location. If the item at the specified location isn't a painting, an ---- Will be one of the following: " + StringUtils.Join(MCArt.values(), ", ") + ".";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_name_visible.class})
    public static class set_name_visible
    extends EntitySetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            try {
                Static.getEntity(args[0], t).setCustomNameVisible(ArgumentValidation.getBoolean(args[1], t));
            }
            catch (IllegalArgumentException e) {
                throw new CRECastException(e.getMessage(), t);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "set_name_visible";
        }

        @Override
        public String docs() {
            return "void {entityUUID, boolean} Sets the visibility of a mob's custom name. True means it will be visible from a distance, like a playername. False means it will only be visible when near the mob.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_name_visible.class})
    public static class get_name_visible
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            try {
                return CBoolean.get(Static.getEntity(args[0], t).isCustomNameVisible());
            }
            catch (IllegalArgumentException e) {
                throw new CRECastException(e.getMessage(), t);
            }
        }

        @Override
        public String getName() {
            return "get_name_visible";
        }

        @Override
        public String docs() {
            return "boolean {entityUUID} Returns whether or not a mob's custom name is always visible. If this is true it will be as visible as player names, otherwise it will only be visible when near the mob.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_entity_max_speed.class})
    public static class set_entity_max_speed
    extends EntitySetterFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREBadEntityException.class, CREBadEntityTypeException.class, CRECastException.class, CRELengthException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e = Static.getEntity(args[0], t);
            double speed = ArgumentValidation.getDouble(args[1], t);
            if (!(e instanceof MCMinecart)) {
                throw new CREBadEntityTypeException("Given entity must be a minecart.", t);
            }
            ((MCMinecart)e).setMaxSpeed(speed);
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "set_entity_max_speed";
        }

        @Override
        public String docs() {
            return "void {entityUUID} Sets a max speed for a minecart.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_entity_max_speed.class})
    public static class get_entity_max_speed
    extends EntityGetterFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREBadEntityException.class, CREBadEntityTypeException.class, CRELengthException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e = Static.getEntity(args[0], t);
            if (e instanceof MCMinecart) {
                return new CDouble(((MCMinecart)e).getMaxSpeed(), t);
            }
            throw new CREBadEntityTypeException("Given entity must be a minecart.", t);
        }

        @Override
        public String getName() {
            return "get_entity_max_speed";
        }

        @Override
        public String docs() {
            return "double {entityUUID} Returns a max speed for a minecart.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_entity_rider.class, get_entity_riders.class, get_entity_rider.class})
    public static class get_entity_vehicle
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity ent = Static.getEntity(args[0], t);
            if (ent.isInsideVehicle()) {
                return new CString(ent.getVehicle().getUniqueId().toString(), t);
            }
            return CNull.NULL;
        }

        @Override
        public String getName() {
            return "get_entity_vehicle";
        }

        @Override
        public String docs() {
            return "string {entityUUID} Returns the UUID of the given entity's vehicle, or null if none exists.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_entity_rider.class, get_entity_rider.class, get_entity_vehicle.class})
    public static class get_entity_riders
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity ent = Static.getEntity(args[0], t);
            List<MCEntity> riders = ent.getPassengers();
            CArray ret = new CArray(t);
            for (MCEntity rider : riders) {
                ret.push(new CString(rider.getUniqueId().toString(), t), t);
            }
            return ret;
        }

        @Override
        public String getName() {
            return "get_entity_riders";
        }

        @Override
        public String docs() {
            return "array {entityUUID} Returns an array of UUIDs for the given entity's riders.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_3;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_entity_riders.class, set_entity_rider.class, get_entity_vehicle.class})
    public static class get_entity_rider
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity ent = Static.getEntity(args[0], t);
            List<MCEntity> passengers = ent.getPassengers();
            if (!passengers.isEmpty()) {
                return new CString(passengers.get(0).getUniqueId().toString(), t);
            }
            return CNull.NULL;
        }

        @Override
        public String getName() {
            return "get_entity_rider";
        }

        @Override
        public String docs() {
            return "string {entityUUID} Returns the UUID of the given entity's rider, or null if it doesn't have one. If there are multiple riders, only the first is returned.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_entity_rider.class, get_entity_riders.class, get_entity_vehicle.class})
    public static class set_entity_rider
    extends EntitySetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            boolean success;
            MCEntity horse = args[0] instanceof CNull ? null : Static.getEntity(args[0], t);
            MCEntity rider = args[1] instanceof CNull ? null : Static.getEntity(args[1], t);
            if (horse == null && rider == null || args[0].val().equals(args[1].val())) {
                throw new CREFormatException("Horse and rider cannot be the same entity", t);
            }
            if (horse == null) {
                success = rider.leaveVehicle();
            } else if (rider == null) {
                success = horse.eject();
            } else {
                try {
                    success = horse.setPassenger(rider);
                }
                catch (IllegalStateException ex) {
                    throw new CREFormatException("Circular entity riding! One entity is already a passenger of the other.", t);
                }
            }
            return CBoolean.get(success);
        }

        @Override
        public String getName() {
            return "set_entity_rider";
        }

        @Override
        public String docs() {
            return "boolean {horse, rider} Sets the way two entities are stacked. Horse and rider are entity ids. If rider is null, horse will eject its current rider, if it has one. If horse is null, rider will leave whatever it is riding. If horse and rider are both valid entities, rider will ride horse. The function returns the success of whatever operation is done. If horse and rider are both null, or otherwise the same, a FormatException is thrown. If a horse already has a rider, this will add the new rider without ejecting the existing one.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={World.spawn_falling_block.class, launch_firework.class, drop_item.class, shoot_projectile.class})
    public static class spawn_entity
    extends EntityFunction
    implements Optimizable {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CREFormatException.class, CREBadEntityException.class, CREInvalidWorldException.class, CREPlayerOfflineException.class, CREIllegalArgumentException.class};
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntityType entType;
            MCLocation l;
            MCCommandSender cs = environment.getEnv(CommandHelperEnvironment.class).GetCommandSender();
            int qty = 1;
            CArray ret = new CArray(t);
            CClosure consumer = null;
            if (args.length >= 3) {
                l = ObjectGenerator.GetGenerator().location(args[2], null, t);
                if (args.length == 4) {
                    if (!args[3].isInstanceOf(CClosure.TYPE)) throw new CREIllegalArgumentException("Expected a closure as last argument for spawn_entity().", t);
                    consumer = (CClosure)args[3];
                }
            } else if (cs instanceof MCPlayer) {
                l = ((MCPlayer)cs).getLocation();
            } else if (cs instanceof MCBlockCommandSender) {
                l = ((MCBlockCommandSender)cs).getBlock().getRelative(MCBlockFace.UP).getLocation();
            } else {
                if (!(cs instanceof MCCommandMinecart)) throw new CREPlayerOfflineException("A physical commandsender must exist or location must be explicit.", t);
                l = ((MCCommandMinecart)cs).getLocation().add(0.0, 1.0, 0.0);
            }
            if (args.length >= 2) {
                qty = ArgumentValidation.getInt32(args[1], t);
            }
            try {
                entType = MCEntityType.valueOf(args[0].val().toUpperCase());
                if (!entType.isSpawnable()) {
                    throw new CREFormatException("spawn_entity() cannot spawn this entity type: " + args[0].val(), t);
                }
            }
            catch (IllegalArgumentException iae) {
                throw new CREFormatException("Unknown entity type: " + args[0].val(), t);
            }
            for (int i = 0; i < qty; ++i) {
                MCEntity ent;
                switch (entType.getAbstracted()) {
                    case DROPPED_ITEM: {
                        int itemQty = Math.min(qty - i, 64);
                        ent = l.getWorld().dropItem(l, StaticLayer.GetItemStack("STONE", itemQty));
                        i += itemQty - 1;
                        break;
                    }
                    case FALLING_BLOCK: {
                        ent = l.getWorld().spawnFallingBlock(l, StaticLayer.GetMaterial("SAND").createBlockData());
                        break;
                    }
                    case ITEM_FRAME: 
                    case LEASH_HITCH: 
                    case PAINTING: {
                        try {
                            if (consumer != null) {
                                ent = l.getWorld().spawn(l.getBlock().getLocation(), entType, consumer);
                                break;
                            }
                            ent = l.getWorld().spawn(l.getBlock().getLocation(), entType);
                            break;
                        }
                        catch (IllegalArgumentException | IllegalStateException | NullPointerException ex) {
                            throw new CREFormatException("Unspawnable location for " + entType.getAbstracted().name(), t);
                        }
                    }
                    default: {
                        try {
                            if (consumer != null) {
                                ent = l.getWorld().spawn(l, entType, consumer);
                                break;
                            }
                            ent = l.getWorld().spawn(l, entType);
                            break;
                        }
                        catch (IllegalArgumentException ex) {
                            throw new CREFormatException(ex.getMessage(), t);
                        }
                    }
                }
                ret.push(new CString(ent.getUniqueId().toString(), t), t);
            }
            return ret;
        }

        @Override
        public String getName() {
            return "spawn_entity";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3, 4};
        }

        @Override
        public String docs() {
            ArrayList<String> spawnable = new ArrayList<String>();
            for (MCEntityType type : MCEntityType.values()) {
                if (!type.isSpawnable()) continue;
                spawnable.add(type.name());
            }
            return "array {entityType, [qty], [location], [closure]} Spawns the specified number of entities of the given type at the given location. Returns an array of entity UUIDs of what is spawned. Qty defaults to 1 and location defaults to the location of the commandsender, if it is a block or player. If the commandsender is console, location must be supplied. ---- Entitytype can be one of " + StringUtils.Join(spawnable, ", ", " or ", ", or ") + ". FALLING_BLOCK will be SAND (can use {{function|spawn_falling_block}} instead). DROPPED_ITEM will be STONE (can use {{function|drop_item}} instead). If not FALLING_BLOCK or DROPPED_ITEM, a closure can be used as the last argument to modify the entity before adding it to the world. The entity's UUID is passed to the closure.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Applying entity attributes before adding it to the world.", "spawn_entity('ZOMBIE', 1, ptarget_space(), closure(@id){ set_entity_spec(@id, array('baby': true)); set_entity_ai(@id, false); })", "Creates a zombie, changes it to a baby zombie without AI, then adds it to the world.")};
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            if (children.size() < 1) {
                return null;
            }
            Mixed c = children.get(0).getData();
            if (c.isInstanceOf(CString.TYPE)) {
                try {
                    MCEntityType.MCVanillaEntityType type = MCEntityType.MCVanillaEntityType.valueOf(c.val().toUpperCase());
                    if (!type.isSpawnable()) {
                        env.getEnv(CompilerEnvironment.class).addCompilerWarning(fileOptions, new CompilerWarning("The entity type " + c.val() + " cannot be spawned by " + this.getName(), c.getTarget(), null));
                    }
                }
                catch (IllegalArgumentException ex) {
                    env.getEnv(CompilerEnvironment.class).addCompilerWarning(fileOptions, new CompilerWarning(c.val() + " is not a valid enum in com.commandhelper.EntityType", c.getTarget(), null));
                }
            }
            return null;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_mob_name.class})
    public static class set_mob_name
    extends EntitySetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity le = Static.getEntity(args[0], t);
            try {
                le.setCustomName(args[1].val());
            }
            catch (IllegalArgumentException e) {
                throw new CRECastException(e.getMessage(), t);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "set_mob_name";
        }

        @Override
        public String docs() {
            return "void {entityUUID, name} Sets the name of the given mob. This automatically truncates if it is more than 64 characters.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_mob_name.class})
    public static class get_mob_name
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity le = Static.getEntity(args[0], t);
            try {
                return new CString(le.getCustomName(), t);
            }
            catch (IllegalArgumentException e) {
                throw new CRECastException(e.getMessage(), t);
            }
        }

        @Override
        public String getName() {
            return "get_mob_name";
        }

        @Override
        public String docs() {
            return "string {entityUUID} Returns the name of the given mob.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class play_entity_effect
    extends EntitySetterFunction
    implements Optimizable {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity ent = Static.getEntity(args[0], t);
            try {
                MCEntityEffect mee = MCEntityEffect.valueOf(args[1].val().toUpperCase());
                ent.playEffect(mee);
            }
            catch (IllegalArgumentException iae) {
                MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Invalid EntityEffect: " + args[1].val(), t);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "play_entity_effect";
        }

        @Override
        public String docs() {
            return "void {entityUUID, effect} Plays the given visual effect on the entity. Non-applicable effects simply won't happen. Note: the death effect makes the mob invisible to players and immune to melee attacks. When used on players, they are shown the respawn menu, but because they are not actually dead, they can only log out. ---- Possible effects are: " + StringUtils.Join(MCEntityEffect.values(), ", ", ", or ", " or ");
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            if (children.size() < 2) {
                return null;
            }
            Mixed c = children.get(1).getData();
            if (c.isInstanceOf(CString.TYPE)) {
                try {
                    MCEntityEffect.valueOf(c.val().toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    env.getEnv(CompilerEnvironment.class).addCompilerWarning(fileOptions, new CompilerWarning(c.val() + " is not a valid enum in com.commandhelper.EntityEffect", c.getTarget(), null));
                }
            }
            return null;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={entity_onfire.class})
    public static class set_entity_onfire
    extends EntitySetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity ent = Static.getEntity(args[0], t);
            int seconds = ArgumentValidation.getInt32(args[1], t);
            if (seconds < 0) {
                throw new CRERangeException("Seconds cannot be less than 0", t);
            }
            if (seconds > 0x6666666) {
                throw new CRERangeException("Seconds cannot be greater than 107374182", t);
            }
            ent.setFireTicks(seconds * 20);
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "set_entity_onfire";
        }

        @Override
        public String docs() {
            return "void {entityUUID, seconds} Sets the entity on fire for the given number of seconds. Throws a RangeException if seconds is less than 0 or greater than 107374182.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_entity_onfire.class})
    public static class entity_onfire
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity ent = Static.getEntity(args[0], t);
            return new CInt(ent.getFireTicks() / 20, t);
        }

        @Override
        public String getName() {
            return "entity_onfire";
        }

        @Override
        public String docs() {
            return "int {entityUUID} Returns the number of seconds until this entity stops being on fire, 0 if it already isn't.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class entities_in_radius
    extends EntityFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "entities_in_radius";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCPlayer p2 = env.getEnv(CommandHelperEnvironment.class).GetPlayer();
            List<String> types = new ArrayList<String>();
            if (!args[0].isInstanceOf(CArray.TYPE)) {
                throw new CREBadEntityException("Expecting an array at parameter 1 of entities_in_radius", t);
            }
            MCLocation loc = ObjectGenerator.GetGenerator().location(args[0], p2 != null ? p2.getWorld() : null, t);
            int dist = ArgumentValidation.getInt32(args[1], t);
            if (dist < 0) {
                throw new CRERangeException("Distance cannot be negative.", t);
            }
            if (args.length == 3) {
                if (args[2].isInstanceOf(CArray.TYPE)) {
                    CArray ta = (CArray)args[2];
                    int i = 0;
                    while ((long)i < ta.size()) {
                        types.add(ta.get(i, t).val());
                        ++i;
                    }
                } else {
                    types.add(args[2].val());
                }
                types = this.prepareTypes(t, types);
            }
            MCWorld world = loc.getWorld();
            int chunkRadius = (dist + 16) / 16;
            int distanceSquared = dist * dist;
            int centerX = loc.getBlockX() >> 4;
            int centerZ = loc.getBlockZ() >> 4;
            CArray entities = new CArray(t);
            for (int offsetX = 0 - chunkRadius; offsetX <= chunkRadius; ++offsetX) {
                for (int offsetZ = 0 - chunkRadius; offsetZ <= chunkRadius; ++offsetZ) {
                    if (!world.isChunkLoaded(centerX + offsetX, centerZ + offsetZ)) continue;
                    for (MCEntity e : world.getChunkAt(centerX + offsetX, centerZ + offsetZ).getEntities()) {
                        if (!(e.getLocation().distanceSquared(loc) <= (double)distanceSquared) || !types.isEmpty() && !types.contains(e.getType().name())) continue;
                        entities.push(new CString(e.getUniqueId().toString(), t), t);
                    }
                }
            }
            return entities;
        }

        private List<String> prepareTypes(Target t, List<String> types) {
            ArrayList<String> newTypes = new ArrayList<String>();
            for (String type : types) {
                MCEntityType entityType;
                try {
                    entityType = MCEntityType.valueOf(type.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new CREBadEntityException(String.format("Wrong entity type: %s", type), t);
                }
                newTypes.add(entityType.name());
            }
            return newTypes;
        }

        @Override
        public String docs() {
            return "array {locationArray, distance, [type] | locationArray, distance, [arrayTypes]} Returns an array of all entities within the given distance from the location. Set type argument to filter entities to a specific entity type. You can pass an array of types. ---- Valid types: " + StringUtils.Join(MCEntityType.types(), ", ", ", or ", " or ");
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CREBadEntityException.class, CREFormatException.class, CRERangeException.class};
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            if (children.size() < 3) {
                return null;
            }
            Mixed c = children.get(children.size() - 1).getData();
            if (c.isInstanceOf(CString.TYPE)) {
                try {
                    MCEntityType.MCVanillaEntityType.valueOf(c.val().toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    env.getEnv(CompilerEnvironment.class).addCompilerWarning(fileOptions, new CompilerWarning(c.val() + " is not a valid enum in com.commandhelper.EntityType", c.getTarget(), null));
                }
            } else if (c instanceof CFunction && c.val().equals("array")) {
                for (ParseTree node : children.get(children.size() - 1).getChildren()) {
                    if (!node.getData().isInstanceOf(CString.TYPE)) continue;
                    try {
                        MCEntityType.MCVanillaEntityType.valueOf(node.getData().val().toUpperCase());
                    }
                    catch (IllegalArgumentException ex) {
                        env.getEnv(CompilerEnvironment.class).addCompilerWarning(fileOptions, new CompilerWarning(node.getData().val() + " is not a valid enum in com.commandhelper.EntityType", node.getTarget(), null));
                    }
                }
            }
            return null;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class shoot_projectile
    extends EntityFunction
    implements Optimizable {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREBadEntityException.class, CREBadEntityTypeException.class, CREFormatException.class, CREPlayerOfflineException.class};
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            MCPlayer p2 = env.getEnv(CommandHelperEnvironment.class).GetPlayer();
            MCLivingEntity shooter = null;
            MCLivingEntity target = null;
            MCLocation from = null;
            MCLocation to = null;
            MCEntityType projectile = null;
            double speed = 0.0;
            if (args.length >= 1) {
                if (args[0] instanceof CArray) {
                    from = ObjectGenerator.GetGenerator().location(args[0], p2 != null ? p2.getWorld() : null, t);
                } else {
                    shooter = args[0].val().length() > 16 ? Static.getLivingEntity(args[0], t) : Static.GetPlayer(args[0], t);
                }
                if (args.length >= 2) {
                    try {
                        projectile = MCEntityType.valueOf(args[1].val().toUpperCase());
                    }
                    catch (IllegalArgumentException ex) {
                        throw new CREBadEntityTypeException(String.valueOf(args[1]) + " is not a valid entity type", t);
                    }
                    if (args.length >= 3) {
                        if (args[2] instanceof CArray) {
                            to = ObjectGenerator.GetGenerator().location(args[2], p2 != null ? p2.getWorld() : null, t);
                        } else {
                            target = args[2].val().length() > 16 ? Static.getLivingEntity(args[2], t) : Static.GetPlayer(args[2], t);
                        }
                        if (args.length == 4) {
                            speed = ArgumentValidation.getDouble(args[3], t);
                        }
                    }
                }
            } else {
                Static.AssertPlayerNonNull(p2, t);
                shooter = p2;
            }
            if (projectile == null && (projectile = MCEntityType.valueOfVanillaType(MCEntityType.MCVanillaEntityType.FIREBALL)) == null) {
                throw new CREBadEntityTypeException("Default projectile is invalid.", t);
            }
            if (shooter != null && projectile.isProjectile() && args.length < 3) {
                return new CString(shooter.launchProjectile(projectile).getUniqueId().toString(), t);
            }
            if (from == null) {
                if (shooter == null) {
                    throw new CREIllegalArgumentException("Invalid shooter.", t);
                }
                from = shooter.getEyeLocation();
            }
            Vector3D velocity = to == null ? (target != null ? target.getEyeLocation().toVector().subtract(from.toVector()).normalize() : from.getDirection()) : to.toVector().subtract(from.toVector()).normalize();
            if (shooter != null) {
                from = from.add(velocity);
            }
            MCEntity entity = from.getWorld().spawn(from, projectile);
            if (speed == 0.0) {
                entity.setVelocity(velocity);
            } else {
                entity.setVelocity(velocity.multiply(speed));
            }
            if (shooter != null && entity instanceof MCProjectile) {
                ((MCProjectile)entity).setShooter(shooter);
            }
            return new CString(entity.getUniqueId().toString(), t);
        }

        @Override
        public String getName() {
            return "shoot_projectile";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0, 1, 2, 3, 4};
        }

        @Override
        public String docs() {
            return "string {[entity[, projectile]] | player, projectile, target[, speed]} Shoots an entity from the specified location (can be an entity UUID, player name or location array), or the current player if no arguments are passed. If no entity type is specified, it defaults to a fireball. If provide three arguments, with target (entity UUID, player name or location array), entity will shoot to target location. Last, fourth argument, is double and specifies the speed of projectile. Returns the UUID of the entity.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            if (children.size() < 2) {
                return null;
            }
            Mixed c = children.get(1).getData();
            if (c.isInstanceOf(CString.TYPE)) {
                try {
                    MCEntityType.MCVanillaEntityType.valueOf(c.val().toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    env.getEnv(CompilerEnvironment.class).addCompilerWarning(fileOptions, new CompilerWarning(c.val() + " is not a valid enum in com.commandhelper.EntityType", c.getTarget(), null));
                }
            }
            return null;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_entity_age.class})
    public static class set_entity_age
    extends EntitySetterFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CREBadEntityException.class, CRERangeException.class, CRELengthException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            int age = ArgumentValidation.getInt32(args[1], t);
            MCEntity ent = Static.getEntity(args[0], t);
            try {
                ent.setTicksLived(age);
            }
            catch (IllegalArgumentException ex) {
                throw new CRERangeException(ex.getMessage(), t);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "set_entity_age";
        }

        @Override
        public String docs() {
            return "void {entityUUID, int} Sets the age of the entity to the specified int, represented by server ticks. Entity age cannot be less than 1 server tick,";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_entity_age.class})
    public static class get_entity_age
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CInt(Static.getEntity(args[0], t).getTicksLived(), t);
        }

        @Override
        public String getName() {
            return "get_entity_age";
        }

        @Override
        public String docs() {
            return "int {entityUUID} Returns the entity age as an integer, represented by server ticks.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class entity_type
    extends EntityGetterFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity ent;
            try {
                ent = Static.getEntity(args[0], t);
            }
            catch (ConfigRuntimeException cre) {
                return CNull.NULL;
            }
            return new CString(ent.getType().name(), t);
        }

        @Override
        public String getName() {
            return "entity_type";
        }

        @Override
        public String docs() {
            return "string {entityUUID} Returns the EntityType of the entity with the specified ID. Returns null if the entity does not exist.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={get_entity_saves_on_unload.class})
    public static class set_entity_saves_on_unload
    extends EntitySetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity ent = Static.getEntity(args[0], t);
            ent.setSavesOnUnload(ArgumentValidation.getBooleanObject(args[1], t));
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "set_entity_saves_on_unload";
        }

        @Override
        public String docs() {
            return "void {entityUUID, boolean} Sets whether the entity is saved to disk when it is unloaded. By default an entity is saved. Setting this to false disables that. Can be used on players to disable player data saving on quit.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_5;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_entity_saves_on_unload.class})
    public static class get_entity_saves_on_unload
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity ent = Static.getEntity(args[0], t);
            return CBoolean.get(ent.savesOnUnload());
        }

        @Override
        public String getName() {
            return "get_entity_saves_on_unload";
        }

        @Override
        public String docs() {
            return "void {entityUUID} Gets whether the entity will be saved to disk when it is unloaded.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_5;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class entity_remove
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity ent = Static.getEntity(args[0], t);
            if (ent instanceof MCHumanEntity) {
                throw new CREBadEntityException("Cannot remove human entity (" + String.valueOf(ent.getUniqueId()) + ")!", t);
            }
            ent.remove();
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "entity_remove";
        }

        @Override
        public String docs() {
            return "void {entityUUID} Removes the specified entity from the world, without any drops or animations. Note: you can't remove players. As a safety measure for working with NPC plugins, it will not work on anything human, even if it is not a player.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={entity_velocity.class})
    public static class set_entity_velocity
    extends EntitySetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e = Static.getEntity(args[0], t);
            try {
                e.setVelocity(ObjectGenerator.GetGenerator().vector(args[1], t));
            }
            catch (IllegalArgumentException ex) {
                throw new CREIllegalArgumentException(ex.getMessage(), t);
            }
            return CVoid.VOID;
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREFormatException.class, CRELengthException.class, CREBadEntityException.class, CREIllegalArgumentException.class};
        }

        @Override
        public String getName() {
            return "set_entity_velocity";
        }

        @Override
        public String docs() {
            return "void {entityUUID, array} Sets the velocity of this entity according to the supplied xyz array. All 3 values default to 0, so an empty array will simply stop the entity's motion. Both normal and associative arrays are accepted.";
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Setting a bounce with a normal array", "set_entity_velocity('091a595d-3d2f-4df4-b493-951dc4bed7f2', array(0, 0.5, 0))", "The entity just hopped, unless it was an item frame or painting."), new ExampleScript("Setting a bounce with an associative array", "set_entity_velocity('091a595d-3d2f-4df4-b493-951dc4bed7f2', array(y: 0.5))", "The entity just hopped, unless it was an item frame or painting.")};
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_entity_velocity.class})
    public static class entity_velocity
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e = Static.getEntity(args[0], t);
            CArray va = ObjectGenerator.GetGenerator().vector(e.getVelocity(), t);
            va.set("magnitude", (Mixed)new CDouble(e.getVelocity().length(), t), t);
            return va;
        }

        @Override
        public String getName() {
            return "entity_velocity";
        }

        @Override
        public String docs() {
            return "array {entityUUID} Returns an entity's motion vector represented as an associative array with the the keys x, y, and z. As a convenience, the magnitude is also included.";
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("A stationary entity", "msg(entity_velocity('091a595d-3d2f-4df4-b493-951dc4bed7f2'))", "{magnitude: 0.0, x: 0.0, y: 0.0, z: 0.0}")};
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={entity_loc.class})
    public static class set_entity_loc
    extends EntitySetterFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREBadEntityException.class, CREFormatException.class, CRECastException.class, CREInvalidWorldException.class, CRELengthException.class, CREIllegalArgumentException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e = Static.getEntity(args[0], t);
            if (!args[1].isInstanceOf(CArray.TYPE)) {
                throw new CREFormatException("An array was expected but received " + String.valueOf(args[1]), t);
            }
            MCLocation l = ObjectGenerator.GetGenerator().location(args[1], e.getWorld(), t);
            try {
                if (!Float.isFinite(l.getPitch())) {
                    throw new CREIllegalArgumentException("pitch not finite", t);
                }
                return CBoolean.get(e.teleport(l));
            }
            catch (IllegalArgumentException ex) {
                throw new CREIllegalArgumentException(ex.getMessage(), t);
            }
        }

        @Override
        public String getName() {
            return "set_entity_loc";
        }

        @Override
        public String docs() {
            return "boolean {entityUUID, locationArray} Teleports the entity to the given location and returns whether the action was successful. Note this can set both location and direction. On Paper 1.19.3+ servers, this teleports passengers along with the entity instead of canceling the teleport.";
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Teleporting an entity to you", "set_entity_loc('091a595d-3d2f-4df4-b493-951dc4bed7f2', ploc())", "The entity will teleport to the block you are standing on."), new ExampleScript("Teleporting an entity to another", "set_entity_loc('091a595d-3d2f-4df4-b493-951dc4bed7f2', entity_loc('82ed3624-b86b-41ef-9cde-4f3ea818b8e5'))", "The entity will teleport to the other and face the same direction, if they both exist."), new ExampleScript("Setting location with a normal array", "set_entity_loc('82ed3624-b86b-41ef-9cde-4f3ea818b8e5', array(214, 64, 1812, 'world', -170, 10))", "This set location and direction."), new ExampleScript("Setting location with an associative array", "set_entity_loc('82ed3624-b86b-41ef-9cde-4f3ea818b8e5', array(x: 214, y: 64, z: 1812, world: 'world', yaw: -170, pitch: 10))", "This also sets location and direction")};
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={set_entity_loc.class})
    public static class entity_loc
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e = Static.getEntity(args[0], t);
            return ObjectGenerator.GetGenerator().location(e.getLocation());
        }

        @Override
        public String getName() {
            return "entity_loc";
        }

        @Override
        public String docs() {
            return "locationArray {entityUUID} Returns the location array for this entity, if it exists. This array will be compatible with any function that expects a location.";
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Sample output", "entity_loc('091a595d-3d2f-4df4-b493-951dc4bed7f2')", "{0: -3451.96, 1: 65.0, 2: 718.521, 3: world, 4: -170.9, 5: 35.5, pitch: 35.5, world: world, x: -3451.96, y: 65.0, yaw: -170.9, z: 718.521}")};
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    @seealso(value={MobManagement.set_mob_owner.class, MobManagement.get_mob_owner.class})
    public static class is_tameable
    extends EntityGetterFunction {
        @Override
        public String getName() {
            return "is_tameable";
        }

        @Override
        public String docs() {
            return "boolean {entityUUID} Returns true or false if the specified entity is tameable";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_0;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e = Static.getEntity(args[0], t);
            return CBoolean.get(e instanceof MCLivingEntity && ((MCLivingEntity)e).isTameable());
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class is_entity_living
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCEntity e;
            try {
                e = Static.getEntity(args[0], t);
            }
            catch (ConfigRuntimeException cre) {
                return CBoolean.FALSE;
            }
            return CBoolean.get(e instanceof MCLivingEntity);
        }

        @Override
        public String getName() {
            return "is_entity_living";
        }

        @Override
        public String docs() {
            return "boolean {entityUUID} Returns true if entity is living, otherwise false.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class entity_exists
    extends EntityGetterFunction {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            try {
                Static.getEntity(args[0], t);
            }
            catch (ConfigRuntimeException cre) {
                return CBoolean.FALSE;
            }
            return CBoolean.TRUE;
        }

        @Override
        public String getName() {
            return "entity_exists";
        }

        @Override
        public String docs() {
            return "boolean {entityUUID} Returns true if entity exists, otherwise false.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class all_entities
    extends EntityFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidWorldException.class, CREFormatException.class, CRECastException.class};
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CArray ret = new CArray(t);
            if (args.length == 0) {
                for (MCWorld w : Static.getServer().getWorlds()) {
                    for (MCEntity e : w.getEntities()) {
                        ret.push(new CString(e.getUniqueId().toString(), t), t);
                    }
                }
            } else if (args.length == 3) {
                MCChunk c;
                MCWorld w = Static.getServer().getWorld(args[0].val());
                if (w == null) {
                    throw new CREInvalidWorldException("Unknown world: " + args[0].val(), t);
                }
                try {
                    int x = ArgumentValidation.getInt32(args[1], t);
                    int z = ArgumentValidation.getInt32(args[2], t);
                    c = w.getChunkAt(x, z);
                }
                catch (ConfigRuntimeException cre) {
                    CArray l = CArray.GetAssociativeArray(t);
                    l.set("x", args[1], t);
                    l.set("z", args[2], t);
                    c = w.getChunkAt(ObjectGenerator.GetGenerator().location(l, w, t));
                }
                for (MCEntity e : c.getEntities()) {
                    ret.push(new CString(e.getUniqueId().toString(), t), t);
                }
            } else if (args[0].isInstanceOf(CArray.TYPE)) {
                MCChunk c = ObjectGenerator.GetGenerator().location(args[0], null, t).getChunk();
                for (MCEntity e : c.getEntities()) {
                    ret.push(new CString(e.getUniqueId().toString(), t), t);
                }
            } else {
                MCWorld w = Static.getServer().getWorld(args[0].val());
                if (w == null) {
                    throw new CREInvalidWorldException("Unknown world: " + args[0].val(), t);
                }
                for (MCEntity e : w.getEntities()) {
                    ret.push(new CString(e.getUniqueId().toString(), t), t);
                }
            }
            return ret;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public String getName() {
            return "all_entities";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0, 1, 3};
        }

        @Override
        public String docs() {
            return "array {[world, [x, z]] | [locationArray]} Returns an array of IDs for all entities in the given scope. With no args, this will return all entities loaded on the entire server. If the first argument is given and is a location, only entities in the chunk containing that location will be returned, or if it is a world only entities in that world will be returned. If all three arguments are given, only entities in the chunk with those coords will be returned. This can take chunk coords (ints) or location coords (doubles).";
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Getting all entities in a world", "msg(all_entities(pworld()))", "Sends you an array of all entities in your world."), new ExampleScript("Getting entities in a chunk", "msg(all_entities(pworld(), 5, -3))", "Sends you an array of all entities in chunk (5,-3)."), new ExampleScript("Getting entities in your chunk", "msg(all_entities(ploc()))", "Sends you an array of all entities in the chunk you are in.")};
        }
    }

    public static abstract class EntitySetterFunction
    extends EntityFunction {
        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }
    }

    public static abstract class EntityGetterFunction
    extends EntityFunction {
        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }
    }

    public static abstract class EntityFunction
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRELengthException.class, CREBadEntityException.class, CREFormatException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return false;
        }
    }
}

