/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.natives.interfaces;

import com.laytonsmith.core.natives.interfaces.Iterable;
import java.util.Arrays;

public class Iterator {
    private final Iterable array;
    private int current = 0;
    private int[] blacklist = new int[]{-1};
    private int blacklistSize = 0;

    public Iterator(Iterable array2) {
        if (array2.isAssociative()) {
            throw new RuntimeException();
        }
        this.array = array2;
    }

    public int getCurrent() {
        return this.current;
    }

    public void decrementCurrent() {
        --this.current;
    }

    public void incrementCurrent() {
        ++this.current;
    }

    public void incrementBlacklistAfter(int from) {
        for (int i = 0; i < this.blacklist.length; ++i) {
            if (this.blacklist[i] <= from) continue;
            int n = i;
            this.blacklist[n] = this.blacklist[n] + 1;
        }
    }

    public void addToBlacklist(int index) {
        if (this.blacklistSize == this.blacklist.length) {
            int[] bl = new int[this.blacklist.length * 2];
            Arrays.fill(bl, -1);
            System.arraycopy(this.blacklist, 0, bl, 0, this.blacklist.length);
            this.blacklist = bl;
        }
        this.blacklist[this.blacklistSize] = index;
        ++this.blacklistSize;
    }

    public boolean isBlacklisted(int index) {
        for (int v : this.blacklist) {
            if (v != index) continue;
            return true;
        }
        return false;
    }

    public Iterable underlyingArray() {
        return this.array;
    }
}

