/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.events.prefilters;

import com.laytonsmith.PureUtilities.MapBuilder;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.prefilters.Prefilter;
import com.laytonsmith.core.events.prefilters.PrefilterMatcher;
import com.laytonsmith.core.events.prefilters.PrefilterStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class PrefilterBuilder<T extends BindableEvent> {
    public static final PrefilterBuilder<BindableEvent> EMPTY = new PrefilterBuilder();
    private MapBuilder<String, Prefilter<T>> builder;

    public PrefilterBuilder<T> set(String prefilterName, String docs, PrefilterMatcher<T> matcher) {
        return this.set(prefilterName, docs, matcher, null);
    }

    public PrefilterBuilder<T> set(String prefilterName, String docs, PrefilterMatcher<T> matcher, int priority) {
        return this.set(prefilterName, docs, matcher, null, priority);
    }

    public PrefilterBuilder<T> set(String prefilterName, String docs, PrefilterMatcher<T> matcher, Set<PrefilterStatus> status) {
        if (this.builder == null) {
            this.builder = MapBuilder.start(prefilterName, new Prefilter<T>(prefilterName, docs, matcher, status, matcher.getPriority()));
        } else {
            this.builder.set(prefilterName, new Prefilter<T>(prefilterName, docs, matcher, status, matcher.getPriority()));
        }
        return this;
    }

    public PrefilterBuilder<T> set(String prefilterName, String docs, PrefilterMatcher<T> matcher, Set<PrefilterStatus> status, int priority) {
        if (this.builder == null) {
            this.builder = MapBuilder.start(prefilterName, new Prefilter<T>(prefilterName, docs, matcher, status, priority));
        } else {
            this.builder.set(prefilterName, new Prefilter<T>(prefilterName, docs, matcher, status, priority));
        }
        return this;
    }

    public Map<String, Prefilter<T>> build() {
        if (this.builder == null) {
            return new HashMap<String, Prefilter<T>>();
        }
        Map<String, Prefilter<T>> prefilters = this.builder.build();
        ArrayList<Map.Entry<String, Prefilter<T>>> list = new ArrayList<Map.Entry<String, Prefilter<T>>>(prefilters.entrySet());
        list.sort(Map.Entry.comparingByValue());
        LinkedHashMap<String, Prefilter<T>> sortedPrefilters = new LinkedHashMap<String, Prefilter<T>>(list.size());
        for (Map.Entry entry : list) {
            sortedPrefilters.put((String)entry.getKey(), (Prefilter)entry.getValue());
        }
        return sortedPrefilters;
    }
}

