/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.jdbc3;

import com.laytonsmith.libs.org.postgresql.jdbc2.AbstractJdbc2Connection;
import com.laytonsmith.libs.org.postgresql.jdbc3.AbstractJdbc3Statement;
import com.laytonsmith.libs.org.postgresql.jdbc3.PSQLSavepoint;
import com.laytonsmith.libs.org.postgresql.util.GT;
import com.laytonsmith.libs.org.postgresql.util.PSQLException;
import com.laytonsmith.libs.org.postgresql.util.PSQLState;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Properties;

public abstract class AbstractJdbc3Connection
extends AbstractJdbc2Connection {
    private int rsHoldability = 2;
    private int savepointId = 0;

    protected AbstractJdbc3Connection(String host, int port, String user2, String database, Properties info, String url) throws SQLException {
        super(host, port, user2, database, info, url);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        switch (holdability) {
            case 2: {
                this.rsHoldability = holdability;
                break;
            }
            case 1: {
                this.rsHoldability = holdability;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unknown ResultSet holdability setting: {0}.", new Integer(holdability)), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        if (!this.haveMinimumServerVersion("8.0")) {
            throw new PSQLException(GT.tr("Server versions prior to 8.0 do not support savepoints."), PSQLState.NOT_IMPLEMENTED);
        }
        if (this.getAutoCommit()) {
            throw new PSQLException(GT.tr("Cannot establish a savepoint in auto-commit mode."), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        PSQLSavepoint savepoint = new PSQLSavepoint(this.savepointId++);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("SAVEPOINT " + savepoint.getPGName());
        stmt.close();
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        if (!this.haveMinimumServerVersion("8.0")) {
            throw new PSQLException(GT.tr("Server versions prior to 8.0 do not support savepoints."), PSQLState.NOT_IMPLEMENTED);
        }
        if (this.getAutoCommit()) {
            throw new PSQLException(GT.tr("Cannot establish a savepoint in auto-commit mode."), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        PSQLSavepoint savepoint = new PSQLSavepoint(name);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("SAVEPOINT " + savepoint.getPGName());
        stmt.close();
        return savepoint;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (!this.haveMinimumServerVersion("8.0")) {
            throw new PSQLException(GT.tr("Server versions prior to 8.0 do not support savepoints."), PSQLState.NOT_IMPLEMENTED);
        }
        PSQLSavepoint pgSavepoint = (PSQLSavepoint)savepoint;
        this.execSQLUpdate("ROLLBACK TO SAVEPOINT " + pgSavepoint.getPGName());
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (!this.haveMinimumServerVersion("8.0")) {
            throw new PSQLException(GT.tr("Server versions prior to 8.0 do not support savepoints."), PSQLState.NOT_IMPLEMENTED);
        }
        PSQLSavepoint pgSavepoint = (PSQLSavepoint)savepoint;
        this.execSQLUpdate("RELEASE SAVEPOINT " + pgSavepoint.getPGName());
        pgSavepoint.invalidate();
    }

    @Override
    public abstract Statement createStatement(int var1, int var2, int var3) throws SQLException;

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.createStatement(resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3, int var4) throws SQLException;

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public abstract CallableStatement prepareCall(String var1, int var2, int var3, int var4) throws SQLException;

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        if (autoGeneratedKeys != 2) {
            sql = AbstractJdbc3Statement.addReturning(this, sql, new String[]{"*"}, false);
        }
        PreparedStatement ps = this.prepareStatement(sql);
        if (autoGeneratedKeys != 2) {
            ((AbstractJdbc3Statement)((Object)ps)).wantsGeneratedKeysAlways = true;
        }
        return ps;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            return this.prepareStatement(sql);
        }
        this.checkClosed();
        throw new PSQLException(GT.tr("Returning autogenerated keys is not supported."), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length != 0) {
            sql = AbstractJdbc3Statement.addReturning(this, sql, columnNames, true);
        }
        PreparedStatement ps = this.prepareStatement(sql);
        if (columnNames != null && columnNames.length != 0) {
            ((AbstractJdbc3Statement)((Object)ps)).wantsGeneratedKeysAlways = true;
        }
        return ps;
    }
}

