/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading.ClassMirror;

import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.AbstractMethodMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.AnnotationMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassReferenceMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ModifierMirror;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MethodMirror
extends AbstractMethodMirror {
    private static final long serialVersionUID = 2L;

    public MethodMirror(ClassReferenceMirror parentClass, List<AnnotationMirror> annotations, ModifierMirror modifiers, ClassReferenceMirror type, String name, List<ClassReferenceMirror> params, boolean isVararg, boolean isSynthetic, String signature) {
        super(parentClass, annotations, modifiers, type, name, params, isVararg, isSynthetic, signature);
    }

    public MethodMirror(Method method) {
        super(method);
    }

    MethodMirror(ClassReferenceMirror parentClass, ModifierMirror modifiers, ClassReferenceMirror type, String name, List<ClassReferenceMirror> params, boolean isVararg, boolean isSynthetic, String signature) {
        super(parentClass, null, modifiers, type, name, params, isVararg, isSynthetic, signature);
    }

    public Method loadMethod() throws ClassNotFoundException {
        if (this.getExecutable() != null) {
            return (Method)this.getExecutable();
        }
        return this.loadMethod(MethodMirror.class.getClassLoader(), true);
    }

    public Method loadMethod(ClassLoader loader, boolean initialize) throws ClassNotFoundException {
        if (this.getExecutable() != null) {
            return (Method)this.getExecutable();
        }
        Class parent = this.loadParentClass(loader, initialize);
        ArrayList cParams = new ArrayList();
        for (ClassReferenceMirror c : this.getParams()) {
            cParams.add(c.loadClass(loader, initialize));
        }
        NoSuchMethodException nsfe = null;
        Method method = null;
        do {
            try {
                method = parent.getDeclaredMethod(this.name, cParams.toArray(new Class[cParams.size()]));
                break;
            }
            catch (NoSuchMethodException ex) {
                nsfe = ex;
            }
            catch (SecurityException ex) {
                throw new RuntimeException(ex);
            }
        } while ((parent = parent.getSuperclass()) != null);
        try {
            method = this.loadParentClass(loader, initialize).getMethod(this.name, cParams.toArray(new Class[cParams.size()]));
        }
        catch (NoSuchMethodException ex) {
            nsfe = ex;
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        if (method == null && nsfe != null) {
            throw new RuntimeException(nsfe);
        }
        return method;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MethodMirror)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

