/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.VirtualFS;

import com.laytonsmith.PureUtilities.VirtualFS.VirtualFile;
import com.laytonsmith.PureUtilities.VirtualFS.VirtualFileSystemManifest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SystemVirtualFileSystemManifest
implements VirtualFileSystemManifest {
    private static final Map<File, VirtualFileSystemManifest> INSTANCE = new HashMap<File, VirtualFileSystemManifest>();
    private final Set<String> manifest;
    private final File manifestFile;
    private final WatchService watcher = FileSystems.getDefault().newWatchService();

    public static VirtualFileSystemManifest getInstance(File manifestFile) throws IOException {
        if (!INSTANCE.containsKey(manifestFile)) {
            INSTANCE.put(manifestFile, new SystemVirtualFileSystemManifest(manifestFile));
        }
        return INSTANCE.get(manifestFile);
    }

    private SystemVirtualFileSystemManifest(File manifestFile) throws FileNotFoundException, IOException {
        this.manifestFile = manifestFile;
        this.manifest = Collections.synchronizedSet(new TreeSet());
        if (!manifestFile.exists()) {
            this.save();
        } else {
            this.read(manifestFile, this.manifest);
        }
        Path p2 = manifestFile.getParentFile().toPath();
        WatchKey watchKey = p2.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
        new Thread(() -> {
            block4: while (true) {
                WatchKey key;
                try {
                    key = this.watcher.take();
                }
                catch (InterruptedException ex) {
                    return;
                }
                Iterator<WatchEvent<?>> iterator2 = key.pollEvents().iterator();
                while (true) {
                    WatchEvent<?> ev;
                    Path path;
                    if (!iterator2.hasNext()) continue block4;
                    WatchEvent<?> event = iterator2.next();
                    if (!event.kind().equals(StandardWatchEventKinds.ENTRY_MODIFY) || !(path = (Path)(ev = event).context()).equals(manifestFile.toPath())) continue;
                    try {
                        this.refresh();
                        continue;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SystemVirtualFileSystemManifest.class.getName()).log(Level.SEVERE, null, ex);
                        continue;
                    }
                    break;
                }
                break;
            }
        }, SystemVirtualFileSystemManifest.class.getSimpleName() + " Manifest Watcher").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(File manifestFile, Set<String> manifest) throws IOException {
        try {
            Set fileSet = (Set)new ObjectInputStream(new FileInputStream(manifestFile)).readObject();
            Set<String> set = manifest;
            synchronized (set) {
                manifest.clear();
                manifest.addAll(fileSet);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new Error(ex);
        }
    }

    private void save() throws IOException {
        new ObjectOutputStream(new FileOutputStream(this.manifestFile)).writeObject(this.manifest);
    }

    @Override
    public boolean fileInManifest(VirtualFile file) {
        String p2 = file.getPath();
        return this.manifest.contains(p2);
    }

    @Override
    public void removeFromManifest(VirtualFile file) throws IOException {
        this.manifest.remove(file.getPath());
        this.save();
    }

    @Override
    public void addToManifest(VirtualFile file) throws IOException {
        this.manifest.add(file.getPath());
        this.save();
    }

    @Override
    public void refresh() throws IOException {
        System.out.println("Refreshing file");
        this.read(this.manifestFile, this.manifest);
    }
}

