/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.annotations.DocumentLink;
import com.laytonsmith.annotations.MEnum;
import com.laytonsmith.annotations.core;
import com.laytonsmith.annotations.hide;
import com.laytonsmith.annotations.noprofile;
import com.laytonsmith.annotations.seealso;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.SimpleDocumentation;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.compiler.SelfStatement;
import com.laytonsmith.core.compiler.analysis.Scope;
import com.laytonsmith.core.compiler.analysis.StaticAnalysis;
import com.laytonsmith.core.compiler.signature.FunctionSignatures;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.IVariableList;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.DocumentLinkProvider;
import com.laytonsmith.core.functions.ExampleScript;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.snapins.PackagePermission;
import com.laytonsmith.tools.docgen.DocGenTemplates;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public abstract class AbstractFunction
implements Function {
    private boolean shouldProfile = !this.getClass().isAnnotationPresent(noprofile.class);
    private FunctionSignatures cachedFunctionSignatures = null;
    private static final Class[] EMPTY_CLASS = new Class[0];

    protected AbstractFunction() {
    }

    @Override
    public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
        return CVoid.VOID;
    }

    @Override
    public FunctionSignatures getSignatures() {
        return null;
    }

    public FunctionSignatures getCachedSignatures() {
        if (this.cachedFunctionSignatures == null) {
            this.cachedFunctionSignatures = this.getSignatures();
        }
        return this.cachedFunctionSignatures;
    }

    @Override
    public CClassType getReturnType(Target t, List<CClassType> argTypes, List<Target> argTargets, Environment env, Set<ConfigCompileException> exceptions) {
        FunctionSignatures signatures = this.getCachedSignatures();
        if (signatures != null) {
            return signatures.getReturnType(t, argTypes, argTargets, env, exceptions);
        }
        return CClassType.AUTO;
    }

    @Override
    public CClassType typecheck(StaticAnalysis analysis, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
        List<ParseTree> children = ast.getChildren();
        ArrayList<CClassType> argTypes = new ArrayList<CClassType>(children.size());
        ArrayList<Target> argTargets = new ArrayList<Target>(children.size());
        for (ParseTree child : children) {
            argTypes.add(analysis.typecheck(child, env, exceptions));
            argTargets.add(child.getTarget());
        }
        return this.getReturnType(ast.getTarget(), argTypes, argTargets, env, exceptions);
    }

    @Override
    public Scope linkScope(StaticAnalysis analysis, Scope parentScope, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
        Scope scope = parentScope;
        for (ParseTree child : ast.getChildren()) {
            scope = analysis.linkScope(scope, child, env, exceptions);
        }
        return scope;
    }

    protected Scope linkScopeLazy(StaticAnalysis analysis, Scope parentScope, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
        if (ast.numberOfChildren() >= 1) {
            String funcName = ((CFunction)ast.getData()).val();
            Stack<ParseTree> argsStack = new Stack<ParseTree>();
            for (int i = ast.numberOfChildren() - 1; i >= 0; --i) {
                argsStack.push(ast.getChildAt(i));
            }
            Scope firstArgScope = null;
            Scope lastArgScope = null;
            while (!argsStack.empty()) {
                ParseTree arg = (ParseTree)argsStack.pop();
                if (arg.getData() instanceof CFunction && ((CFunction)arg.getData()).val().equals(funcName)) {
                    for (int i = arg.numberOfChildren() - 1; i >= 0; --i) {
                        argsStack.push(arg.getChildAt(i));
                    }
                    continue;
                }
                if (firstArgScope == null) {
                    lastArgScope = firstArgScope = analysis.linkScope(parentScope, arg, env, exceptions);
                    continue;
                }
                lastArgScope = analysis.linkScope(lastArgScope, arg, env, exceptions);
            }
            return firstArgScope;
        }
        return parentScope;
    }

    @Override
    public boolean useSpecialExec() {
        return false;
    }

    @Override
    public final boolean appearInDocumentation() {
        return this.getClass().getAnnotation(hide.class) == null;
    }

    @Override
    public ParseTree postParseRewrite(ParseTree ast, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Set<ConfigCompileException> exceptions) {
        return null;
    }

    public Mixed optimize(Target t, Environment env, Mixed ... args2) throws ConfigCompileException {
        return null;
    }

    public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException, ConfigCompileGroupException {
        return null;
    }

    public void varList(IVariableList varList) {
    }

    @Override
    public boolean preResolveVariables() {
        return true;
    }

    @Override
    public ExampleScript[] examples() throws ConfigCompileException {
        return null;
    }

    @Override
    public boolean shouldProfile() {
        return this.shouldProfile;
    }

    @Override
    public LogLevel profileAt() {
        return LogLevel.VERBOSE;
    }

    @Override
    public String profileMessage(Mixed ... args2) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Mixed ccc : args2) {
            if (!first) {
                b.append(", ");
            }
            first = false;
            if (ccc.isInstanceOf(CArray.TYPE)) {
                b.append("<arrayNotShown size:").append(((CArray)ccc).size()).append(">");
                continue;
            }
            if (ccc.isInstanceOf(CClosure.TYPE)) {
                b.append("<closureNotShown>");
                continue;
            }
            if (ccc.isInstanceOf(CString.TYPE)) {
                Object val = ccc.val().replace("\\", "\\\\").replace("'", "\\'");
                int max2 = 1000;
                if (((String)val).length() > max2) {
                    val = ((String)val).substring(0, max2) + "... (" + (((String)val).length() - max2) + " more characters hidden)";
                }
                b.append("'").append((String)val).append("'");
                continue;
            }
            if (ccc instanceof IVariable) {
                b.append(((IVariable)ccc).getVariableName());
                continue;
            }
            b.append(ccc.val());
        }
        return "Executing function: " + this.getName() + "(" + b.toString() + ")";
    }

    protected String getBundledDocs() {
        try {
            return this.getBundledDocs(null);
        }
        catch (DocGenTemplates.Generator.GenerateException ex) {
            return "";
        }
    }

    protected String getBundledDocs(Map<String, DocGenTemplates.Generator> map) throws DocGenTemplates.Generator.GenerateException {
        String template = StreamUtils.GetString(AbstractFunction.class.getResourceAsStream("/functionDocs/" + this.getName()));
        if (map == null) {
            map = new HashMap<String, DocGenTemplates.Generator>();
        }
        return DocGenTemplates.DoTemplateReplacement(template, map);
    }

    protected <T extends Enum<?>> String createEnumTable(Class<T> c) {
        Enum[] elist;
        StringBuilder b = new StringBuilder();
        MEnum me = c.getAnnotation(MEnum.class);
        String title2 = me == null ? c.getSimpleName() : me.value();
        b.append("<br>'''").append(title2).append("'''<br>\n");
        b.append("{|\n");
        b.append("|-\n! Name\n! Docs\n! Since\n");
        for (Enum e : elist = (Enum[])c.getEnumConstants()) {
            SimpleDocumentation d = (SimpleDocumentation)((Object)e);
            b.append("|-\n").append("| ").append(d.getName()).append("\n").append("| ").append(d.docs()).append("\n").append("| ").append(d.since()).append("\n");
        }
        b.append("|}\n");
        return b.toString();
    }

    @Override
    public String profileMessageS(List<ParseTree> args2) {
        return "Executing function: " + this.getName() + "(<" + args2.size() + " child" + (args2.size() == 1 ? "" : "ren") + " not shown>)";
    }

    @Override
    public PackagePermission getPermission() {
        return PackagePermission.NO_PERMISSIONS_NEEDED;
    }

    @Override
    public URL getSourceJar() {
        return ClassDiscovery.GetClassContainer(this.getClass());
    }

    @Override
    public final Class<? extends Documentation>[] seeAlso() {
        seealso see = this.getClass().getAnnotation(seealso.class);
        if (see == null) {
            return EMPTY_CLASS;
        }
        return see.value();
    }

    @Override
    public final boolean isCore() {
        Class<?> c = this.getClass();
        do {
            if (c.getAnnotation(core.class) == null) continue;
            return true;
        } while ((c = c.getDeclaringClass()) != null);
        return false;
    }

    public void link(Target t, List<ParseTree> children) throws ConfigCompileException {
    }

    @Override
    public boolean isSelfStatement(Target t, Environment env, List<ParseTree> nodes, Set<Class<? extends Environment.EnvironmentImpl>> envs) throws ConfigCompileException {
        return this.getClass().getAnnotation(SelfStatement.class) != null;
    }

    protected void doAutoconcatRewrite(ParseTree node, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs) throws ConfigCompileException {
        CFunction cf;
        Mixed mixed = node.getData();
        if (mixed instanceof CFunction && (cf = (CFunction)mixed).val().equals("__autoconcat__")) {
            HashSet<ConfigCompileException> exceptions = new HashSet<ConfigCompileException>();
            MethodScriptCompiler.rewriteAutoconcats(node, env, envs, exceptions, true);
            if (!exceptions.isEmpty()) {
                throw new ArrayList<ConfigCompileException>(exceptions).get(0);
            }
        }
    }

    @Override
    public int compareTo(Function o) {
        return this.getName().compareTo(o.getName());
    }

    public Set<ParseTree> getDocumentLinks(List<ParseTree> children) {
        HashSet<ParseTree> files = new HashSet<ParseTree>();
        DocumentLink documentLink = this.getClass().getAnnotation(DocumentLink.class);
        if (documentLink != null && this instanceof DocumentLinkProvider) {
            for (int i : documentLink.value()) {
                if (children.size() < i) continue;
                files.add(children.get(i));
            }
        } else {
            throw new Error(this.getClass() + " is not tagged with the DocumentLink annotation, or does not implement DocumentLinkProvider, and this method cannot be called on it.");
        }
        return files;
    }
}

