/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.core.types;

import com.laytonsmith.libs.org.postgresql.core.types.PGBigDecimal;
import com.laytonsmith.libs.org.postgresql.core.types.PGBoolean;
import com.laytonsmith.libs.org.postgresql.core.types.PGDouble;
import com.laytonsmith.libs.org.postgresql.core.types.PGFloat;
import com.laytonsmith.libs.org.postgresql.core.types.PGInteger;
import com.laytonsmith.libs.org.postgresql.core.types.PGLong;
import com.laytonsmith.libs.org.postgresql.core.types.PGShort;
import com.laytonsmith.libs.org.postgresql.core.types.PGType;
import com.laytonsmith.libs.org.postgresql.core.types.PGUnknown;
import com.laytonsmith.libs.org.postgresql.util.GT;
import com.laytonsmith.libs.org.postgresql.util.PSQLException;
import com.laytonsmith.libs.org.postgresql.util.PSQLState;
import java.math.BigDecimal;

public class PGString
implements PGType {
    String val;

    protected PGString(String x) {
        this.val = x;
    }

    public static PGType castToServerType(String val, int targetType) throws PSQLException {
        try {
            switch (targetType) {
                case -7: {
                    if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("1") || val.equalsIgnoreCase("t")) {
                        return new PGBoolean(Boolean.TRUE);
                    }
                    if (val.equalsIgnoreCase("false") || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("f")) {
                        return new PGBoolean(Boolean.FALSE);
                    }
                    return new PGBoolean(Boolean.FALSE);
                }
                case -1: 
                case 12: {
                    return new PGString(val);
                }
                case -5: {
                    return new PGLong(new Long(Long.parseLong(val)));
                }
                case 4: {
                    return new PGInteger(new Integer(Integer.parseInt(val)));
                }
                case -6: {
                    return new PGShort(new Short(Short.parseShort(val)));
                }
                case 6: 
                case 8: {
                    return new PGDouble(new Double(Double.parseDouble(val)));
                }
                case 7: {
                    return new PGFloat(new Float(Float.parseFloat(val)));
                }
                case 2: 
                case 3: {
                    return new PGBigDecimal(new BigDecimal(val));
                }
            }
            return new PGUnknown(val);
        }
        catch (Exception ex) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{val.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        return this.val;
    }
}

