/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.abstraction.enums.MCProfession;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Villager;

public class BukkitMCProfession
extends MCProfession<Villager.Profession> {
    private static final Map<Villager.Profession, MCProfession> BUKKIT_MAP = new HashMap<Villager.Profession, MCProfession>();

    public BukkitMCProfession(MCProfession.MCVanillaProfession vanillaProfession, Villager.Profession profession) {
        super(vanillaProfession, profession);
    }

    @Override
    public String name() {
        return this.getAbstracted() == MCProfession.MCVanillaProfession.NONE ? ((Villager.Profession)this.getConcrete()).name() : ((MCProfession.MCVanillaProfession)((Object)this.getAbstracted())).name();
    }

    public static MCProfession valueOfConcrete(Villager.Profession test) {
        MCProfession profession = BUKKIT_MAP.get(test);
        if (profession == null) {
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Bukkit Villager Profession missing in BUKKIT_MAP: " + test.name(), Target.UNKNOWN);
            return new BukkitMCProfession(MCProfession.MCVanillaProfession.UNKNOWN, test);
        }
        return profession;
    }

    public static void build() {
        for (MCProfession.MCVanillaProfession mCVanillaProfession : MCProfession.MCVanillaProfession.values()) {
            Villager.Profession profession;
            if (!mCVanillaProfession.existsIn(Static.getServer().getMinecraftVersion())) continue;
            try {
                profession = BukkitMCProfession.getBukkitType(mCVanillaProfession);
            }
            catch (IllegalArgumentException | NoSuchFieldError ex) {
                MSLog.GetLogger().w(MSLog.Tags.RUNTIME, "Could not find a Bukkit villager profession type for " + mCVanillaProfession.name(), Target.UNKNOWN);
                continue;
            }
            BukkitMCProfession wrapper = new BukkitMCProfession(mCVanillaProfession, profession);
            MAP.put(mCVanillaProfession.name(), wrapper);
            BUKKIT_MAP.put(profession, wrapper);
        }
        for (MCProfession.MCVanillaProfession mCVanillaProfession : Villager.Profession.values()) {
            if (mCVanillaProfession == null || BUKKIT_MAP.containsKey((Object)mCVanillaProfession)) continue;
            MAP.put(mCVanillaProfession.name(), new BukkitMCProfession(MCProfession.MCVanillaProfession.UNKNOWN, (Villager.Profession)mCVanillaProfession));
            BUKKIT_MAP.put((Villager.Profession)mCVanillaProfession, new BukkitMCProfession(MCProfession.MCVanillaProfession.UNKNOWN, (Villager.Profession)mCVanillaProfession));
        }
    }

    private static Villager.Profession getBukkitType(MCProfession.MCVanillaProfession v) {
        return Villager.Profession.valueOf((String)v.name());
    }
}

