/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.core.GenericTreeNode;
import com.laytonsmith.core.GenericTreeTraversalOrderEnum;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GenericTree<T> {
    private GenericTreeNode<T> root;

    public GenericTreeNode<T> getRoot() {
        return this.root;
    }

    public void setRoot(GenericTreeNode<T> root) {
        this.root = root;
    }

    public int getNumberOfNodes() {
        int numberOfNodes = 0;
        if (this.root != null) {
            numberOfNodes = this.auxiliaryGetNumberOfNodes(this.root) + 1;
        }
        return numberOfNodes;
    }

    private int auxiliaryGetNumberOfNodes(GenericTreeNode<T> node) {
        int numberOfNodes = node.getNumberOfChildren();
        for (GenericTreeNode<T> child : node.getChildren()) {
            numberOfNodes += this.auxiliaryGetNumberOfNodes(child);
        }
        return numberOfNodes;
    }

    public boolean exists(GenericTreeNode<T> nodeToFind) {
        return this.find(nodeToFind) != null;
    }

    public GenericTreeNode<T> find(GenericTreeNode<T> nodeToFind) {
        GenericTreeNode<T> returnNode = null;
        if (this.root != null) {
            returnNode = this.auxiliaryFind(this.root, nodeToFind);
        }
        return returnNode;
    }

    private GenericTreeNode<T> auxiliaryFind(GenericTreeNode<T> currentNode, GenericTreeNode<T> nodeToFind) {
        GenericTreeNode<T> returnNode = null;
        if (currentNode.equals(nodeToFind)) {
            returnNode = currentNode;
        } else if (currentNode.hasChildren()) {
            for (int i = 0; returnNode == null && i < currentNode.getNumberOfChildren(); ++i) {
                returnNode = this.auxiliaryFind(currentNode.getChildAt(i), nodeToFind);
            }
        }
        return returnNode;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public List<GenericTreeNode<T>> build(GenericTreeTraversalOrderEnum traversalOrder) {
        List<GenericTreeNode<T>> returnList = null;
        if (this.root != null) {
            returnList = this.build(this.root, traversalOrder);
        }
        return returnList;
    }

    public List<GenericTreeNode<T>> build(GenericTreeNode<T> node, GenericTreeTraversalOrderEnum traversalOrder) {
        ArrayList<GenericTreeNode<T>> traversalResult = new ArrayList<GenericTreeNode<T>>();
        if (traversalOrder == GenericTreeTraversalOrderEnum.PRE_ORDER) {
            this.buildPreOrder(node, traversalResult);
        } else if (traversalOrder == GenericTreeTraversalOrderEnum.POST_ORDER) {
            this.buildPostOrder(node, traversalResult);
        }
        return traversalResult;
    }

    private synchronized void buildPreOrder(GenericTreeNode<T> node, List<GenericTreeNode<T>> traversalResult) {
        traversalResult.add(node);
        for (int i = 0; i < node.getNumberOfChildren(); ++i) {
            this.buildPreOrder(node.getChildAt(i), traversalResult);
        }
    }

    private void buildPostOrder(GenericTreeNode<T> node, List<GenericTreeNode<T>> traversalResult) {
        for (GenericTreeNode<T> child : node.getChildren()) {
            this.buildPostOrder(child, traversalResult);
        }
        traversalResult.add(node);
    }

    public Map<GenericTreeNode<T>, Integer> buildWithDepth(GenericTreeTraversalOrderEnum traversalOrder) {
        Map<GenericTreeNode<T>, Integer> returnMap = null;
        if (this.root != null) {
            returnMap = this.buildWithDepth(this.root, traversalOrder);
        }
        return returnMap;
    }

    public Map<GenericTreeNode<T>, Integer> buildWithDepth(GenericTreeNode<T> node, GenericTreeTraversalOrderEnum traversalOrder) {
        LinkedHashMap<GenericTreeNode<T>, Integer> traversalResult = new LinkedHashMap<GenericTreeNode<T>, Integer>();
        if (traversalOrder == GenericTreeTraversalOrderEnum.PRE_ORDER) {
            this.buildPreOrderWithDepth(node, traversalResult, 0);
        } else if (traversalOrder == GenericTreeTraversalOrderEnum.POST_ORDER) {
            this.buildPostOrderWithDepth(node, traversalResult, 0);
        }
        return traversalResult;
    }

    private void buildPreOrderWithDepth(GenericTreeNode<T> node, Map<GenericTreeNode<T>, Integer> traversalResult, int depth) {
        traversalResult.put(node, depth);
        for (GenericTreeNode<T> child : node.getChildren()) {
            this.buildPreOrderWithDepth(child, traversalResult, depth + 1);
        }
    }

    private void buildPostOrderWithDepth(GenericTreeNode<T> node, Map<GenericTreeNode<T>, Integer> traversalResult, int depth) {
        for (GenericTreeNode<T> child : node.getChildren()) {
            this.buildPostOrderWithDepth(child, traversalResult, depth + 1);
        }
        traversalResult.put(node, depth);
    }

    public String toString() {
        String stringRepresentation = "";
        if (this.root != null) {
            stringRepresentation = this.build(GenericTreeTraversalOrderEnum.PRE_ORDER).toString();
        }
        return stringRepresentation;
    }

    public String toStringWithDepth() {
        String stringRepresentation = "";
        if (this.root != null) {
            stringRepresentation = this.buildWithDepth(GenericTreeTraversalOrderEnum.PRE_ORDER).toString();
        }
        return stringRepresentation;
    }
}

