/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.eclipse.lsp4j.launch;

import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.Launcher;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import com.laytonsmith.libs.org.eclipse.lsp4j.services.LanguageClient;
import com.laytonsmith.libs.org.eclipse.lsp4j.services.LanguageServer;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public final class LSPLauncher {
    private LSPLauncher() {
    }

    public static Launcher<LanguageClient> createServerLauncher(LanguageServer server, InputStream in, OutputStream out) {
        return new Builder().setLocalService(server).setRemoteInterface(LanguageClient.class).setInput(in).setOutput(out).create();
    }

    public static Launcher<LanguageClient> createServerLauncher(LanguageServer server, InputStream in, OutputStream out, boolean validate, PrintWriter trace2) {
        return new Builder().setLocalService(server).setRemoteInterface(LanguageClient.class).setInput(in).setOutput(out).validateMessages(validate).traceMessages(trace2).create();
    }

    public static Launcher<LanguageClient> createServerLauncher(LanguageServer server, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) {
        return new Builder().setLocalService(server).setRemoteInterface(LanguageClient.class).setInput(in).setOutput(out).setExecutorService(executorService).wrapMessages(wrapper).create();
    }

    public static Launcher<LanguageServer> createClientLauncher(LanguageClient client, InputStream in, OutputStream out) {
        return new Builder().setLocalService(client).setRemoteInterface(LanguageServer.class).setInput(in).setOutput(out).create();
    }

    public static Launcher<LanguageServer> createClientLauncher(LanguageClient client, InputStream in, OutputStream out, boolean validate, PrintWriter trace2) {
        return new Builder().setLocalService(client).setRemoteInterface(LanguageServer.class).setInput(in).setOutput(out).validateMessages(validate).traceMessages(trace2).create();
    }

    public static Launcher<LanguageServer> createClientLauncher(LanguageClient client, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) {
        return new Builder().setLocalService(client).setRemoteInterface(LanguageServer.class).setInput(in).setOutput(out).setExecutorService(executorService).wrapMessages(wrapper).create();
    }

    public static class Builder<T>
    extends Launcher.Builder<T> {
    }
}

