/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.perf4j.helpers;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AcceptableRangeConfiguration
implements Serializable,
Cloneable {
    private String attributeName;
    private double minValue = Double.NEGATIVE_INFINITY;
    private double maxValue = Double.POSITIVE_INFINITY;
    protected static final Pattern CONFIG_STRING_PATTERN = Pattern.compile("(.+?)\\((<(.+?)|>(.+?)|(.+?)-(.+?))\\)");

    public AcceptableRangeConfiguration() {
    }

    public AcceptableRangeConfiguration(String configString) {
        Matcher matcher = CONFIG_STRING_PATTERN.matcher(configString);
        if (matcher.matches()) {
            this.attributeName = matcher.group(1).trim();
            try {
                String rangeString = matcher.group(2).trim();
                if (rangeString.startsWith("<")) {
                    this.maxValue = Double.parseDouble(matcher.group(3).trim());
                }
                if (rangeString.startsWith(">")) {
                    this.minValue = Double.parseDouble(matcher.group(4).trim());
                }
                this.minValue = Double.parseDouble(matcher.group(5).trim());
                this.maxValue = Double.parseDouble(matcher.group(6).trim());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid acceptable range config string: " + configString);
            }
        } else {
            throw new IllegalArgumentException("Invalid acceptable range config string: " + configString);
        }
    }

    public AcceptableRangeConfiguration(String attributeName, double minValue, double maxValue) {
        this.attributeName = attributeName;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public boolean isInRange(double value) {
        return value >= this.minValue && value <= this.maxValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AcceptableRangeConfiguration)) {
            return false;
        }
        AcceptableRangeConfiguration that = (AcceptableRangeConfiguration)o;
        return Double.compare(that.maxValue, this.maxValue) == 0 && Double.compare(that.minValue, this.minValue) == 0 && (this.attributeName == null ? that.attributeName == null : this.attributeName.equals(that.attributeName));
    }

    public int hashCode() {
        int result = this.attributeName != null ? this.attributeName.hashCode() : 0;
        long temp = this.minValue != 0.0 ? Double.doubleToLongBits(this.minValue) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.maxValue != 0.0 ? Double.doubleToLongBits(this.maxValue) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        if (this.minValue == Double.NEGATIVE_INFINITY) {
            return this.attributeName + "(<" + this.maxValue + ")";
        }
        if (this.maxValue == Double.POSITIVE_INFINITY) {
            return this.attributeName + "(>" + this.minValue + ")";
        }
        return this.attributeName + "(" + this.minValue + "-" + this.maxValue + ")";
    }

    public AcceptableRangeConfiguration clone() {
        try {
            return (AcceptableRangeConfiguration)super.clone();
        }
        catch (Exception e) {
            throw new Error("Unexpected CloneNotSupportedException");
        }
    }
}

