/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen.localization;

import com.laytonsmith.tools.docgen.localization.TextDirection;
import java.util.Arrays;
import java.util.List;

public enum Locale {
    ART("art", "Artificial", "\u00c5rt\u00eff\u00efc\u00ef\u00e5l", TextDirection.LTR, java.util.Locale.forLanguageTag("art-x-dummy"), Arrays.asList(new String[0])),
    KO("ko", "Korean", "\ud55c\uad6d\uc5b4", TextDirection.LTR, java.util.Locale.KOREAN, Arrays.asList("Malgun Gothic")),
    NB("nb", "Norwegian", "Norsk", TextDirection.LTR, java.util.Locale.forLanguageTag("nb"), Arrays.asList(new String[0])),
    NL("nl", "Dutch", "Nederlands", TextDirection.LTR, java.util.Locale.forLanguageTag("nl"), Arrays.asList(new String[0]));

    private final String locale;
    private final String englishName;
    private final String localName;
    private final TextDirection textDirection;
    private final List<String> useFonts;
    private final java.util.Locale javaUtilLocale;

    private Locale(String locale, String englishName, String localName, TextDirection textDirection, java.util.Locale javaUtilLocale, List<String> useFonts) {
        this.locale = locale;
        this.englishName = englishName;
        this.localName = localName;
        this.textDirection = textDirection;
        this.javaUtilLocale = javaUtilLocale;
        this.useFonts = useFonts;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public TextDirection getTextDirection() {
        return this.textDirection;
    }

    public List<String> getUseFonts() {
        return this.useFonts;
    }

    public java.util.Locale getJavaUtilLocale() {
        return this.javaUtilLocale;
    }

    public static Locale fromLocale(String locale) {
        for (Locale d : Locale.values()) {
            if (!d.getLocale().equals(locale)) continue;
            return d;
        }
        throw new IllegalArgumentException("Locale \"" + locale + "\" not supported.");
    }

    public static Locale getDummyLocale() {
        return ART;
    }
}

