/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen.localization;

import com.laytonsmith.tools.docgen.localization.ResultType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;

public class MasterSearchIndex {
    private final Map<String, IndexEntry> segments = new HashMap<String, IndexEntry>();

    void addSegment(String title2, String toLocation, ResultType type, String segment) {
        if (!this.segments.containsKey(toLocation)) {
            this.segments.put(toLocation, new IndexEntry(title2, type));
        }
        this.segments.get(toLocation).addSegment(segment);
    }

    public String getIndex() {
        HashMap index = new HashMap();
        for (Map.Entry<String, IndexEntry> entry : this.segments.entrySet()) {
            String location = entry.getKey();
            String title2 = entry.getValue().getTitle();
            for (String string : entry.getValue().getSegments()) {
                if (!index.containsKey(string)) {
                    index.put(string, new ArrayList());
                }
                HashMap<String, String> locationData = new HashMap<String, String>();
                locationData.put("location", location);
                locationData.put("title", title2);
                locationData.put("type", entry.getValue().getType().name());
                ((List)index.get(string)).add(locationData);
            }
        }
        return JSONObject.toJSONString(index);
    }

    private static class IndexEntry {
        private final List<String> segments = new ArrayList<String>();
        private final String title;
        private final ResultType type;

        public IndexEntry(String title2, ResultType type) {
            this.title = title2;
            this.type = type;
        }

        public void addSegment(String segment) {
            this.segments.add(segment);
        }

        public List<String> getSegments() {
            return this.segments;
        }

        public String getTitle() {
            return this.title;
        }

        public ResultType getType() {
            return this.type;
        }
    }
}

