/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIndexOverflowException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

@typeof(value="ms.lang.secure_string")
public class CSecureString
extends CString {
    public static final CClassType TYPE = CClassType.get(CSecureString.class);
    private byte[] encrypted;
    private Cipher decrypter;
    private int encLength;
    private int actualLength;
    private static volatile boolean initialized = false;

    public CSecureString(char[] val, Target t) {
        super("**secure string**", t);
        CSecureString.init();
        this.construct(ArrayUtils.charToBytes(val));
    }

    public CSecureString(CArray val, Target t) {
        super("**secure string**", t);
        CSecureString.init();
        this.construct(CSecureString.CArrayToByteArray(val, t));
    }

    private CSecureString(byte[] encrypted, Cipher decrypter, int encLength, int actualLength, Target t) {
        super("**secure string**", t);
        CSecureString.init();
        this.encrypted = encrypted;
        this.decrypter = decrypter;
        this.encLength = encLength;
        this.actualLength = actualLength;
    }

    private void construct(byte[] val) {
        try {
            this.actualLength = val.length;
            SecureRandom rand2 = SecureRandom.getInstanceStrong();
            byte[] keyBytes = new byte[24];
            rand2.nextBytes(keyBytes);
            byte[] ivBytes = new byte[8];
            SecretKeySpec key = new SecretKeySpec(keyBytes, "DESede");
            IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
            Cipher encrypter = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            this.decrypter = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            encrypter.init(1, (Key)key, ivSpec);
            this.decrypter.init(2, (Key)key, ivSpec);
            this.encrypted = new byte[encrypter.getOutputSize(val.length)];
            this.encLength = encrypter.update(val, 0, val.length, this.encrypted, 0);
            this.encLength += encrypter.doFinal(this.encrypted, this.encLength);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | ShortBufferException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static byte[] CArrayToByteArray(CArray val, Target t) {
        ArrayList<Byte> cval = new ArrayList<Byte>((int)val.size());
        if (val.isAssociative()) {
            throw new CREFormatException("Expected a normal array in secure string, but an associative one was passed in", t);
        }
        int i = 0;
        while ((long)i < val.size()) {
            String c = val.get(i, t).val();
            if (c.length() != 1) {
                throw new CREFormatException("The array passed in must be an array of single character strings", t);
            }
            for (byte b : c.getBytes()) {
                cval.add(b);
            }
            ++i;
        }
        return ArrayUtils.unbox(cval.toArray(new Byte[cval.size()]));
    }

    public char[] getDecryptedCharArray() {
        try {
            byte[] decrypted = new byte[this.decrypter.getOutputSize(this.encLength)];
            int decLen = this.decrypter.update(this.encrypted, 0, this.encLength, decrypted, 0);
            this.decrypter.doFinal(decrypted, decLen);
            decrypted = ArrayUtils.slice(decrypted, 0, this.actualLength - 1);
            return ArrayUtils.bytesToChar(decrypted);
        }
        catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException ex) {
            throw new RuntimeException(ex);
        }
    }

    public CArray getDecryptedCharCArray() {
        char[] array2 = this.getDecryptedCharArray();
        CArray carray = new CArray(Target.UNKNOWN, array2.length);
        for (char c : array2) {
            carray.push(new CString(c, Target.UNKNOWN), Target.UNKNOWN);
        }
        return carray;
    }

    @Override
    public String docs() {
        return "A secure_string is a string which cannot normally be toString'd, and whose underlying representation is encrypted in memory. This should be used for storing passwords or other sensitive data which should in no cases be stored in plain text. Since this extends string, it can generally be used in place of a string, and when done so, cannot accidentally be exposed (via logs or exception messages, or other accidental exposure) unless it is specifically instructed to decrypt and switch to a char array. While this cannot by itself ensure security of the value, it can help prevent most accidental exposures of data by intermediate code. When exported as a string (or imported as a string) other code must be written to ensure safety of those systems. According to length(), this string will always be 0 length. This is because the string size is considered secure information, and will not be revealed.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_2;
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{CString.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return CClassType.EMPTY_CLASS_ARRAY;
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    public CString clone() throws CloneNotSupportedException {
        return this;
    }

    @Override
    public Construct get(int index, Target t) {
        throw new CREIndexOverflowException("Secure strings cannot be iterated", t);
    }

    @Override
    public Construct slice(int begin, int end, Target t) {
        throw new CREIndexOverflowException("Secure strings cannot be sliced", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() {
        if (initialized) return;
        Class<CSecureString> clazz = CSecureString.class;
        synchronized (CSecureString.class) {
            if (initialized) return;
            CSecureString.fixKeyLength();
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void fixKeyLength() {
        int newMaxKeyLength;
        String errorString = "Failed manually overriding key-length permissions.";
        try {
            newMaxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (newMaxKeyLength < 256) {
                Class<?> c = Class.forName("javax.crypto.CryptoAllPermissionCollection");
                Constructor<?> con = c.getDeclaredConstructor(new Class[0]);
                con.setAccessible(true);
                Object allPermissionCollection = con.newInstance(new Object[0]);
                Field f = c.getDeclaredField("all_allowed");
                f.setAccessible(true);
                f.setBoolean(allPermissionCollection, true);
                c = Class.forName("javax.crypto.CryptoPermissions");
                con = c.getDeclaredConstructor(new Class[0]);
                con.setAccessible(true);
                Object allPermissions = con.newInstance(new Object[0]);
                f = c.getDeclaredField("perms");
                f.setAccessible(true);
                ((Map)f.get(allPermissions)).put("*", allPermissionCollection);
                c = Class.forName("javax.crypto.JceSecurityManager");
                f = c.getDeclaredField("defaultPolicy");
                f.setAccessible(true);
                Field mf = Field.class.getDeclaredField("modifiers");
                mf.setAccessible(true);
                mf.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                f.set(null, allPermissions);
                newMaxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(errorString, e);
        }
        if (newMaxKeyLength < 256) {
            throw new RuntimeException(errorString);
        }
    }

    @Override
    public CSecureString duplicate() {
        return new CSecureString(this.encrypted, this.decrypter, this.encLength, this.actualLength, this.getTarget());
    }
}

