/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.com.squareup.okhttp.internal.framed;

import com.laytonsmith.libs.com.squareup.okhttp.internal.framed.Header;
import com.laytonsmith.libs.com.squareup.okhttp.internal.framed.Spdy3;
import com.laytonsmith.libs.okio.Buffer;
import com.laytonsmith.libs.okio.BufferedSource;
import com.laytonsmith.libs.okio.ByteString;
import com.laytonsmith.libs.okio.ForwardingSource;
import com.laytonsmith.libs.okio.InflaterSource;
import com.laytonsmith.libs.okio.Okio;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class NameValueBlockReader {
    private final InflaterSource inflaterSource;
    private int compressedLimit;
    private final BufferedSource source;

    public NameValueBlockReader(BufferedSource source2) {
        ForwardingSource throttleSource = new ForwardingSource(source2){

            @Override
            public long read(Buffer sink2, long byteCount) throws IOException {
                if (NameValueBlockReader.this.compressedLimit == 0) {
                    return -1L;
                }
                long read2 = super.read(sink2, Math.min(byteCount, (long)NameValueBlockReader.this.compressedLimit));
                if (read2 == -1L) {
                    return -1L;
                }
                NameValueBlockReader.this.compressedLimit = (int)((long)NameValueBlockReader.this.compressedLimit - read2);
                return read2;
            }
        };
        Inflater inflater = new Inflater(){

            @Override
            public int inflate(byte[] buffer, int offset, int count) throws DataFormatException {
                int result = super.inflate(buffer, offset, count);
                if (result == 0 && this.needsDictionary()) {
                    this.setDictionary(Spdy3.DICTIONARY);
                    result = super.inflate(buffer, offset, count);
                }
                return result;
            }
        };
        this.inflaterSource = new InflaterSource(throttleSource, inflater);
        this.source = Okio.buffer(this.inflaterSource);
    }

    public List<Header> readNameValueBlock(int length2) throws IOException {
        this.compressedLimit += length2;
        int numberOfPairs = this.source.readInt();
        if (numberOfPairs < 0) {
            throw new IOException("numberOfPairs < 0: " + numberOfPairs);
        }
        if (numberOfPairs > 1024) {
            throw new IOException("numberOfPairs > 1024: " + numberOfPairs);
        }
        ArrayList<Header> entries = new ArrayList<Header>(numberOfPairs);
        for (int i = 0; i < numberOfPairs; ++i) {
            ByteString name = this.readByteString().toAsciiLowercase();
            ByteString values2 = this.readByteString();
            if (name.size() == 0) {
                throw new IOException("name.size == 0");
            }
            entries.add(new Header(name, values2));
        }
        this.doneReading();
        return entries;
    }

    private ByteString readByteString() throws IOException {
        int length2 = this.source.readInt();
        return this.source.readByteString(length2);
    }

    private void doneReading() throws IOException {
        if (this.compressedLimit > 0) {
            this.inflaterSource.refill();
            if (this.compressedLimit != 0) {
                throw new IOException("compressedLimit > 0: " + this.compressedLimit);
            }
        }
    }

    public void close() throws IOException {
        this.source.close();
    }
}

