/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client;

import com.laytonsmith.libs.com.squareup.okhttp.MediaType;
import com.laytonsmith.libs.com.squareup.okhttp.RequestBody;
import com.laytonsmith.libs.okio.Buffer;
import com.laytonsmith.libs.okio.BufferedSink;
import com.laytonsmith.libs.okio.ForwardingSink;
import com.laytonsmith.libs.okio.Okio;
import com.laytonsmith.libs.okio.Sink;
import java.io.IOException;

public class ProgressRequestBody
extends RequestBody {
    private final RequestBody requestBody;
    private final ProgressRequestListener progressListener;

    public ProgressRequestBody(RequestBody requestBody, ProgressRequestListener progressListener) {
        this.requestBody = requestBody;
        this.progressListener = progressListener;
    }

    @Override
    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    @Override
    public long contentLength() throws IOException {
        return this.requestBody.contentLength();
    }

    @Override
    public void writeTo(BufferedSink sink2) throws IOException {
        BufferedSink bufferedSink = Okio.buffer(this.sink(sink2));
        this.requestBody.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    private Sink sink(Sink sink2) {
        return new ForwardingSink(sink2){
            long bytesWritten;
            long contentLength;
            {
                this.bytesWritten = 0L;
                this.contentLength = 0L;
            }

            @Override
            public void write(Buffer source2, long byteCount) throws IOException {
                super.write(source2, byteCount);
                if (this.contentLength == 0L) {
                    this.contentLength = ProgressRequestBody.this.contentLength();
                }
                this.bytesWritten += byteCount;
                ProgressRequestBody.this.progressListener.onRequestProgress(this.bytesWritten, this.contentLength, this.bytesWritten == this.contentLength);
            }
        };
    }

    public static interface ProgressRequestListener {
        public void onRequestProgress(long var1, long var3, boolean var5);
    }
}

