/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.events;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.annotations.abstraction;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class EventBuilder {
    private static final Map<Class<BindableEvent>, Method> METHODS = new HashMap<Class<BindableEvent>, Method>();
    private static final Map<Class<BindableEvent>, Constructor<? extends BindableEvent>> CONSTRUCTORS = new HashMap<Class<BindableEvent>, Constructor<? extends BindableEvent>>();
    private static final Map<Class<BindableEvent>, Class<BindableEvent>> EVENT_IMPLEMENTATIONS = new HashMap<Class<BindableEvent>, Class<BindableEvent>>();

    private EventBuilder() {
    }

    private static void warmup(Class<? extends BindableEvent> clazz) {
        if (!METHODS.containsKey(clazz)) {
            Class<BindableEvent> implementor = EVENT_IMPLEMENTATIONS.get(clazz);
            Method method = null;
            for (Method m : implementor.getMethods()) {
                if (!m.getName().equals("_instantiate") || (m.getModifiers() & 8) == 0) continue;
                method = m;
                break;
            }
            if (method == null) {
                StreamUtils.GetSystemErr().println("UNABLE TO CACHE A CONSTRUCTOR FOR " + clazz.getSimpleName() + ". Manual triggering will be impossible, and errors will occur if an attempt is made. Did you forget to add public static <Event> _instantiate(...) to " + clazz.getSimpleName() + "?");
            }
            METHODS.put(clazz, method);
        }
    }

    public static <T extends BindableEvent> T instantiate(Class<? extends BindableEvent> clazz, Object ... params) {
        try {
            EventBuilder.warmup(clazz);
            Object o = METHODS.get(clazz).invoke(null, params);
            if (!CONSTRUCTORS.containsKey(clazz)) {
                Class<BindableEvent> bindableEvent = EVENT_IMPLEMENTATIONS.get(clazz);
                Constructor<?> constructor = null;
                for (Constructor<?> c : bindableEvent.getConstructors()) {
                    if (c.getParameterTypes().length != 1 || !c.getParameterTypes()[0].equals(o.getClass())) continue;
                    constructor = c;
                    break;
                }
                if (constructor == null) {
                    throw new CREPluginInternalException("Cannot find an acceptable constructor that follows the format: public " + bindableEvent.getClass().getSimpleName() + "(" + o.getClass().getSimpleName() + " event). Please notify the plugin author of this error.", Target.UNKNOWN);
                }
                CONSTRUCTORS.put(clazz, constructor);
            }
            Constructor<? extends BindableEvent> constructor = CONSTRUCTORS.get(clazz);
            BindableEvent be = constructor.newInstance(o);
            return (T)be;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        for (Class<?> c : ClassDiscovery.getDefaultInstance().loadClassesWithAnnotation(abstraction.class)) {
            abstraction abs2;
            if (!BindableEvent.class.isAssignableFrom(c) || !(abs2 = c.getAnnotation(abstraction.class)).type().equals((Object)Implementation.GetServerType())) continue;
            Class<?> cInterface = null;
            Class<?> bindableEventImplementorClass = c;
            block1: do {
                for (Class<?> implementor : bindableEventImplementorClass.getInterfaces()) {
                    if (!BindableEvent.class.isAssignableFrom(implementor)) continue;
                    cInterface = implementor;
                    break block1;
                }
                if (!(bindableEventImplementorClass = bindableEventImplementorClass.getSuperclass()).getClass().equals(Object.class)) continue;
                throw new InternalError("BindableEvent is assignable from some class c, but class c does not implement BindableEvent (in)directly. This is a bug in " + EventBuilder.class.getSimpleName() + "'s static code block.");
            } while (cInterface == null);
            EVENT_IMPLEMENTATIONS.put(cInterface, c);
        }
    }
}

