/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.io.gsonfire.gson;

import com.laytonsmith.libs.com.google.gson.Gson;
import com.laytonsmith.libs.com.google.gson.JsonElement;
import com.laytonsmith.libs.com.google.gson.JsonParser;
import com.laytonsmith.libs.com.google.gson.TypeAdapter;
import com.laytonsmith.libs.com.google.gson.TypeAdapterFactory;
import com.laytonsmith.libs.com.google.gson.reflect.TypeToken;
import com.laytonsmith.libs.com.google.gson.stream.JsonReader;
import com.laytonsmith.libs.com.google.gson.stream.JsonWriter;
import com.laytonsmith.libs.io.gsonfire.ClassConfig;
import com.laytonsmith.libs.io.gsonfire.TypeSelector;
import com.laytonsmith.libs.io.gsonfire.gson.NullableTypeAdapter;
import com.laytonsmith.libs.io.gsonfire.util.JsonUtils;
import java.io.IOException;
import java.util.Set;

public class TypeSelectorTypeAdapterFactory<T>
implements TypeAdapterFactory {
    private final ClassConfig<T> classConfig;
    private final Set<TypeToken> alreadyResolvedTypeTokensRegistry;

    public TypeSelectorTypeAdapterFactory(ClassConfig<T> classConfig, Set<TypeToken> alreadyResolvedTypeTokensRegistry) {
        this.classConfig = classConfig;
        this.alreadyResolvedTypeTokensRegistry = alreadyResolvedTypeTokensRegistry;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (this.alreadyResolvedTypeTokensRegistry.contains(type)) {
            return null;
        }
        if (this.classConfig.getConfiguredClass().isAssignableFrom(type.getRawType())) {
            NullableTypeAdapter fireTypeAdapter = new NullableTypeAdapter(new TypeSelectorTypeAdapter(type.getRawType(), this.classConfig.getTypeSelector(), gson));
            return fireTypeAdapter;
        }
        return null;
    }

    private class TypeSelectorTypeAdapter<T>
    extends TypeAdapter<T> {
        private final Class superClass;
        private final TypeSelector typeSelector;
        private final Gson gson;

        private TypeSelectorTypeAdapter(Class superClass, TypeSelector typeSelector, Gson gson) {
            this.superClass = superClass;
            this.typeSelector = typeSelector;
            this.gson = gson;
        }

        @Override
        public void write(JsonWriter out, T value) throws IOException {
            TypeAdapter<?> otherTypeAdapter = this.gson.getDelegateAdapter(TypeSelectorTypeAdapterFactory.this, TypeToken.get(value.getClass()));
            otherTypeAdapter.write(out, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T read(JsonReader in) throws IOException {
            TypeAdapter otherTypeAdapter;
            JsonElement json = new JsonParser().parse(in);
            Class deserialize = this.typeSelector.getClassForElement(json);
            if (deserialize == null) {
                deserialize = this.superClass;
            }
            TypeToken typeToken = TypeToken.get(deserialize);
            TypeSelectorTypeAdapterFactory.this.alreadyResolvedTypeTokensRegistry.add(typeToken);
            try {
                otherTypeAdapter = deserialize != this.superClass ? this.gson.getAdapter(typeToken) : this.gson.getDelegateAdapter(TypeSelectorTypeAdapterFactory.this, typeToken);
            }
            finally {
                TypeSelectorTypeAdapterFactory.this.alreadyResolvedTypeTokensRegistry.remove(typeToken);
            }
            return JsonUtils.fromJsonTree(otherTypeAdapter, in, json);
        }
    }
}

