/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.keywords;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.Keyword;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CKeyword;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import java.util.List;

@Keyword.keyword(value="if")
public class IfKeyword
extends Keyword {
    @Override
    public int process(List<ParseTree> list, int keywordPosition) throws ConfigCompileException {
        ParseTree node = list.get(keywordPosition);
        Target t = node.getTarget();
        if (list.size() > keywordPosition + 1) {
            if (this.isValidCodeBlock(list.get(keywordPosition + 1))) {
                if (node.getChildren().size() != 1) {
                    throw new ConfigCompileException("Unexpected parameters passed to \"if\" clause, exactly 1 argument must be provided", t);
                }
                try {
                    if (this.nodeIsElseKeyword(list.get(keywordPosition + 2)) && this.nodeIsIfFunction(list.get(keywordPosition + 3))) {
                        ParseTree newNode = new ParseTree(new CFunction("ifelse", t), node.getFileOptions());
                        newNode.setChildren(node.getChildren());
                        node = newNode;
                    }
                }
                catch (IndexOutOfBoundsException newNode) {
                    // empty catch block
                }
                node.addChild(IfKeyword.getArgumentOrNoop(list.get(keywordPosition + 1)));
                list.remove(keywordPosition + 1);
            }
            while (list.size() > keywordPosition + 1 && this.nodeIsElseKeyword(list.get(keywordPosition + 1))) {
                try {
                    if (!IfKeyword.isCodeBlock(list.get(keywordPosition + 2))) {
                        if (this.nodeIsIfFunction(list.get(keywordPosition + 2))) {
                            if (list.get(keywordPosition + 2).getChildren().size() != 1) {
                                throw new ConfigCompileException("Unexpected parameters passed to \"if\" clause, exactly 1 argument must be provided", list.get(keywordPosition + 2).getTarget());
                            }
                            if (!IfKeyword.isCodeBlock(list.get(keywordPosition + 3))) {
                                throw new ConfigCompileException("Expecting braces after \"if\" clause", list.get(keywordPosition + 3).getTarget());
                            }
                            node.addChild(list.get(keywordPosition + 2).getChildAt(0));
                            node.addChild(IfKeyword.getArgumentOrNoop(list.get(keywordPosition + 3)));
                            list.remove(keywordPosition + 1);
                            list.remove(keywordPosition + 1);
                            list.remove(keywordPosition + 1);
                            continue;
                        }
                        throw new IndexOutOfBoundsException();
                    }
                    this.validateCodeBlock(list.get(keywordPosition + 2), "");
                    node.addChild(IfKeyword.getArgumentOrNoop(list.get(keywordPosition + 2)));
                    list.remove(keywordPosition + 1);
                    list.remove(keywordPosition + 1);
                    break;
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new ConfigCompileException("Expecting either braces, or continuing if statement after \"else\" keyword", list.get(keywordPosition + 1).getTarget());
                }
            }
        }
        list.set(keywordPosition, node);
        return keywordPosition;
    }

    private boolean nodeIsElseKeyword(ParseTree node) {
        return node.getData() instanceof CKeyword && node.getData().val().equals("else");
    }

    private boolean nodeIsIfFunction(ParseTree node) {
        return node.getData() instanceof CFunction && node.getData().val().equals("if");
    }

    @Override
    public String docs() {
        return "Creates an if block. Often used in combination with else/else if chains, provides a way to conditionally execute code depending on the true or false value of the condition.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }
}

