/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.events;

import com.laytonsmith.PureUtilities.TermColors;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.events.AbstractGenericEvent;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.BoundEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.Event;
import com.laytonsmith.core.events.EventList;
import com.laytonsmith.core.events.prefilters.Prefilter;
import com.laytonsmith.core.events.prefilters.PrefilterMatcher;
import com.laytonsmith.core.exceptions.CRE.CREBindException;
import com.laytonsmith.core.exceptions.CRE.CREEventException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.exceptions.FunctionReturnException;
import com.laytonsmith.core.exceptions.PrefilterNonMatchException;
import com.laytonsmith.core.extensions.Extension;
import com.laytonsmith.core.extensions.ExtensionManager;
import com.laytonsmith.core.extensions.ExtensionTracker;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.io.File;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;

public final class EventUtils {
    private static final Map<Driver, SortedSet<BoundEvent>> EVENT_HANDLES = new EnumMap<Driver, SortedSet<BoundEvent>>(Driver.class);

    private EventUtils() {
    }

    public static void RegisterEvent(BoundEvent b) throws EventException {
        Event event = b.getEventDriver();
        if (event == null) {
            throw new EventException("The event type \"" + b.getEventName() + "\" could not be found.");
        }
        if (!EVENT_HANDLES.containsKey((Object)event.driver())) {
            EVENT_HANDLES.put(event.driver(), new TreeSet());
        }
        for (Set set : EVENT_HANDLES.values()) {
            for (BoundEvent bb : set) {
                if (!bb.getId().equals(b.getId())) continue;
                throw new CREBindException("Cannot have duplicate IDs defined. (Tried to define an event handler with id \"" + b.getId() + "\" at " + String.valueOf(b.getTarget()) + ", but it has already been defined at " + String.valueOf(bb.getTarget()) + ")", b.getTarget());
            }
        }
        SortedSet<BoundEvent> set = EVENT_HANDLES.get((Object)event.driver());
        set.add(b);
        event.bind(b);
    }

    public static void UnregisterEvent(String id) {
        for (SortedSet<BoundEvent> set : EVENT_HANDLES.values()) {
            Iterator i = set.iterator();
            while (i.hasNext()) {
                BoundEvent b = (BoundEvent)i.next();
                if (!b.getId().equals(id)) continue;
                b.getEventDriver().unbind(b);
                i.remove();
                return;
            }
        }
    }

    public static BoundEvent GetEventById(String id) {
        for (SortedSet<BoundEvent> set : EVENT_HANDLES.values()) {
            for (BoundEvent b : set) {
                if (!b.getId().equals(id)) continue;
                return b;
            }
        }
        return null;
    }

    public static void UnregisterAll(String name) {
        for (SortedSet<BoundEvent> set : EVENT_HANDLES.values()) {
            Iterator i = set.iterator();
            while (i.hasNext()) {
                BoundEvent b = (BoundEvent)i.next();
                if (!b.getEventObjName().equals(name)) continue;
                i.remove();
                return;
            }
        }
    }

    public static void UnregisterAll() {
        EVENT_HANDLES.clear();
    }

    public static SortedSet<BoundEvent> GetEvents(Driver type) {
        return EVENT_HANDLES.get((Object)type);
    }

    public static void ManualTrigger(String eventName, CArray object, Target t, boolean serverWide) {
        for (Driver type : EVENT_HANDLES.keySet()) {
            TreeSet<BoundEvent> toRun = new TreeSet<BoundEvent>();
            SortedSet<BoundEvent> bounded = EventUtils.GetEvents(type);
            Event driver = EventList.getEvent(type, eventName);
            if (bounded != null) {
                for (BoundEvent b : bounded) {
                    if (!b.getEventName().equalsIgnoreCase(eventName)) continue;
                    BindableEvent convertedEvent = null;
                    try {
                        convertedEvent = (BindableEvent)driver.convert(object, t);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                    if (convertedEvent == null) {
                        throw new CREBindException(eventName + " doesn't support the use of trigger() yet.", t);
                    }
                    if (!EventUtils.PrefilterMatches(b, convertedEvent, driver)) continue;
                    toRun.add(b);
                }
            }
            if (!toRun.isEmpty()) {
                if (!serverWide || !driver.supportsExternal()) {
                    EventUtils.FireListeners(toRun, driver, driver.convert(object, t));
                    continue;
                }
                driver.manualTrigger(driver.convert(object, t));
                continue;
            }
            ConfigRuntimeException.DoWarning(ConfigRuntimeException.CreateUncatchableException("Non existent event is being triggered: " + eventName, object.getTarget()));
        }
    }

    public static boolean PrefilterMatches(BoundEvent b, BindableEvent e, Event driver) {
        Map prefilters = driver.getPrefilters();
        Map<String, Mixed> userPrefilters = b.getPrefilter();
        if (prefilters == null) {
            try {
                return driver.matches(userPrefilters, e);
            }
            catch (PrefilterNonMatchException ex) {
                return false;
            }
        }
        for (Map.Entry prefilter : prefilters.entrySet()) {
            Prefilter pf;
            PrefilterMatcher matcher;
            String key = prefilter.getKey();
            Mixed value = userPrefilters.get(key);
            if (value == null || (matcher = (pf = prefilter.getValue()).getMatcher()).matches(key, value, e, b.getTarget())) continue;
            return false;
        }
        return true;
    }

    public static SortedSet<BoundEvent> GetMatchingEvents(SortedSet<BoundEvent> bounded, String eventName, BindableEvent e, Event driver) {
        TreeSet<BoundEvent> toRun = new TreeSet<BoundEvent>();
        bounded.stream().forEach(b -> {
            if (!b.getEventName().equals(eventName)) {
                return;
            }
            try {
                if (EventUtils.PrefilterMatches(b, e, driver)) {
                    toRun.add((BoundEvent)b);
                }
            }
            catch (ConfigRuntimeException ex) {
                ConfigRuntimeException.HandleUncaughtException(ex, b.getEnvironment());
            }
            catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError err) {
                String modVersion;
                String chBrand = Implementation.GetServerType().getBranding();
                String chVersion = Static.getVersion().toString();
                String culprit = chBrand;
                block7: for (ExtensionTracker tracker : ExtensionManager.getTrackers().values()) {
                    for (Event event : tracker.getEvents()) {
                        Iterator<Extension> iterator;
                        if (!event.getName().equals(driver.getName()) || !(iterator = tracker.getExtensions().iterator()).hasNext()) continue;
                        Extension extension = iterator.next();
                        culprit = extension.getName();
                        break block7;
                    }
                }
                try {
                    modVersion = StaticLayer.GetConvertor().GetServer().getAPIVersion();
                }
                catch (Exception ex) {
                    modVersion = Implementation.GetServerType().name();
                }
                Object extensionData = "";
                for (ExtensionTracker tracker : ExtensionManager.getTrackers().values()) {
                    for (Extension extension : tracker.getExtensions()) {
                        try {
                            extensionData = (String)extensionData + TermColors.CYAN + extension.getName() + TermColors.RED + " (" + TermColors.RESET + String.valueOf(extension.getVersion()) + TermColors.RED + ")\n";
                        }
                        catch (AbstractMethodError ex) {
                            extensionData = (String)extensionData + TermColors.CYAN + "Unknown Extension" + TermColors.RED + "\n";
                        }
                    }
                }
                if (((String)extensionData).isEmpty()) {
                    extensionData = "NONE\n";
                }
                String driverEventName = driver.getName();
                String jarName = new File(driver.getSourceJar().getFile()).getName();
                String emsg = TermColors.RED + "Uh oh! You've found an error in the eventhandler for event " + TermColors.CYAN + driverEventName + TermColors.RED + ", implemented in " + TermColors.CYAN + culprit + " (" + jarName + ")" + TermColors.RED + ".\nPlease report this to the developers, and be sure to include the version numbers:\n" + TermColors.CYAN + "Server" + TermColors.RED + " version: " + TermColors.RESET + modVersion + TermColors.RED + ";\n" + TermColors.CYAN + chBrand + TermColors.RED + " version: " + TermColors.RESET + chVersion + TermColors.RED + ";\nLoaded extensions and versions:\n" + (String)extensionData + "Here's the stacktrace:\n" + TermColors.RESET + Static.GetStacktraceString(err);
                Static.getLogger().log(Level.SEVERE, emsg);
            }
        });
        return toRun;
    }

    public static void TriggerListener(Driver type, String eventName, BindableEvent e) {
        SortedSet<BoundEvent> bounded = EventUtils.GetEvents(type);
        if (bounded == null) {
            return;
        }
        Event driver = EventList.getEvent(type, eventName);
        if (driver == null) {
            throw ConfigRuntimeException.CreateUncatchableException("Tried to fire an unknown event: " + eventName, Target.UNKNOWN);
        }
        if (!(driver instanceof AbstractGenericEvent) || ((AbstractGenericEvent)driver).shouldFire(e)) {
            EventUtils.FireListeners(EventUtils.GetMatchingEvents(bounded, eventName, e, driver), driver, e);
        }
    }

    public static void FireListeners(SortedSet<BoundEvent> toRun, Event driver, BindableEvent e) {
        BoundEvent.ActiveEvent activeEvent = new BoundEvent.ActiveEvent(e);
        for (BoundEvent b : toRun) {
            if (!activeEvent.canReceive() && !b.getPriority().equals((Object)BoundEvent.Priority.MONITOR)) continue;
            try {
                activeEvent.setBoundEvent(b);
                activeEvent.setParsedEvent(driver.evaluate(e));
                b.trigger(activeEvent);
            }
            catch (FunctionReturnException functionReturnException) {
            }
            catch (EventException ex) {
                throw new CREEventException(ex.getMessage(), b.getTarget(), ex);
            }
            catch (ConfigRuntimeException ex) {
                ConfigRuntimeException.HandleUncaughtException(ex, b.getEnvironment());
            }
        }
        for (BoundEvent b : toRun) {
            activeEvent.setBoundEvent(b);
            if (activeEvent.isCancelled()) {
                activeEvent.executeCancelled();
                continue;
            }
            activeEvent.executeTriggered();
        }
    }

    public static Construct DumpEvents() {
        CArray ca = new CArray(Target.UNKNOWN);
        for (SortedSet<BoundEvent> set : EVENT_HANDLES.values()) {
            for (BoundEvent b : set) {
                ca.push(new CString(b.toString() + ":" + String.valueOf(b.getFile()) + ":" + b.getLineNum(), Target.UNKNOWN), Target.UNKNOWN);
            }
        }
        return ca;
    }

    public static void verifyEventName(String name) throws IllegalArgumentException {
        for (Event e : EventList.GetEvents()) {
            if (!e.getName().equals(name)) continue;
            return;
        }
        throw new IllegalArgumentException("No event named \"" + name + "\" was found.");
    }
}

