/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Web;

import com.laytonsmith.PureUtilities.Common.FileWriteMode;
import com.laytonsmith.PureUtilities.Web.CookieJar;
import com.laytonsmith.PureUtilities.Web.HTTPMethod;
import java.io.File;
import java.net.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class RequestSettings {
    private HTTPMethod method = HTTPMethod.GET;
    private Map<String, List<String>> headers = null;
    private Map<String, List<String>> parameters = null;
    private Map<String, List<String>> queryParameters = null;
    private CookieJar cookieJar = null;
    private boolean followRedirects = true;
    private int timeout = 60000;
    private String username = null;
    private String password = null;
    private Proxy proxy = null;
    private byte[] rawParameter;
    private File downloadTo;
    private FileWriteMode downloadStrategy = FileWriteMode.SAFE_WRITE;
    private boolean blocking = false;
    private boolean disableCertChecking = false;
    private boolean useDefaultTrustStore = true;
    private LinkedHashMap<String, String> trustStore = new LinkedHashMap();
    private Logger logger;
    private boolean disableDecompressionHandling = false;

    public RequestSettings setMethod(HTTPMethod method) {
        this.method = method;
        return this;
    }

    public HTTPMethod getMethod() {
        return this.method;
    }

    public RequestSettings setAuthenticationDetails(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public RequestSettings setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public RequestSettings setParameters(Map<String, String> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return this;
        }
        HashMap<String, List<String>> p2 = new HashMap<String, List<String>>();
        for (String key : parameters.keySet()) {
            p2.put(key, Arrays.asList(parameters.get(key)));
        }
        return this.setComplexParameters(p2);
    }

    public RequestSettings setComplexParameters(Map<String, List<String>> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public RequestSettings setQueryParameters(Map<String, String> parameters) {
        if (parameters == null) {
            this.queryParameters = null;
            return this;
        }
        HashMap<String, List<String>> p2 = new HashMap<String, List<String>>();
        for (String key : parameters.keySet()) {
            p2.put(key, Arrays.asList(parameters.get(key)));
        }
        return this.setComplexQueryParameters(p2);
    }

    public RequestSettings setComplexQueryParameters(Map<String, List<String>> parameters) {
        this.queryParameters = parameters;
        return this;
    }

    public Map<String, List<String>> getQueryParameters() {
        return this.queryParameters;
    }

    public RequestSettings setCookieJar(CookieJar cookieJar) {
        this.cookieJar = cookieJar;
        return this;
    }

    public RequestSettings setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public CookieJar getCookieJar() {
        return this.cookieJar;
    }

    public RequestSettings setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public RequestSettings setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public byte[] getRawParameter() {
        return this.rawParameter;
    }

    public RequestSettings setRawParameter(byte[] rawParamter) {
        this.rawParameter = rawParamter;
        return this;
    }

    public RequestSettings setDownloadTo(File downloadTo) {
        this.downloadTo = downloadTo;
        return this;
    }

    public RequestSettings setDownloadStrategy(FileWriteMode downloadStrategy) {
        this.downloadStrategy = downloadStrategy;
        return this;
    }

    public File getDownloadTo() {
        return this.downloadTo;
    }

    public FileWriteMode getDownloadStrategy() {
        return this.downloadStrategy;
    }

    public RequestSettings setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public RequestSettings setBlocking(boolean blocking) {
        this.blocking = blocking;
        return this;
    }

    public boolean getBlocking() {
        return this.blocking;
    }

    public RequestSettings setDisableCertChecking(boolean check) {
        this.disableCertChecking = check;
        return this;
    }

    public boolean getDisableCertChecking() {
        return this.disableCertChecking;
    }

    public RequestSettings setUseDefaultTrustStore(boolean useDefaultTrustStore) {
        this.useDefaultTrustStore = useDefaultTrustStore;
        return this;
    }

    public boolean getUseDefaultTrustStore() {
        return this.useDefaultTrustStore;
    }

    public RequestSettings setTrustStore(LinkedHashMap<String, String> trustStore) {
        this.trustStore = new LinkedHashMap<String, String>(trustStore);
        return this;
    }

    public LinkedHashMap<String, String> getTrustStore() {
        return new LinkedHashMap<String, String>(this.trustStore);
    }

    public RequestSettings setDisableCompressionHandling(boolean disableCompressionHandling) {
        this.disableDecompressionHandling = disableCompressionHandling;
        return this;
    }

    public boolean getDisableCompressionHandling() {
        return this.disableDecompressionHandling;
    }
}

