/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;

public abstract class ThreadPump {
    private final int minHoldTime;
    private final int maxHoldTime;
    private final int waitTime;
    private final Queue<Runnable> eventPump = new LinkedList<Runnable>();
    private int startStack = 0;
    private boolean pumpStarted = false;
    private final String threadName;
    private final Object waitForStopLock = new Object();
    private final Object waitForTaskLock = new Object();
    private long lockTime;
    private long idleTime;

    protected ThreadPump(int minHoldTime, int maxHoldTime, int waitTime, String threadName) {
        this.minHoldTime = minHoldTime;
        this.maxHoldTime = maxHoldTime;
        this.waitTime = waitTime;
        this.threadName = threadName;
    }

    public synchronized void start() {
        ++this.startStack;
    }

    public synchronized void stop() {
        --this.startStack;
        if (this.startStack < 0) {
            throw new RuntimeException("stop() called too many times!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForStop() throws InterruptedException {
        if (this.startStack != 1) {
            throw new RuntimeException("waitForStop called from an inner invocation");
        }
        Object object = this.waitForStopLock;
        synchronized (object) {
            this.waitForStopLock.wait();
        }
    }

    public void invokeLater(Runnable runnable) {
        this.eventPump.add(runnable);
        this.startPump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeNow(final Callable<?> callable) throws InterruptedException {
        final Object myLock = new Object();
        final Object[] ret = new Object[1];
        this.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ret[0] = callable.call();
                    Object object = myLock;
                    synchronized (object) {
                        myLock.notifyAll();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        Object object = myLock;
        synchronized (object) {
            myLock.wait();
        }
        return ret[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPump() {
        Object object;
        if (!this.pumpStarted) {
            object = this;
            synchronized (object) {
                this.lockTime = System.currentTimeMillis();
                this.pumpStarted = true;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ThreadPump.this.doPump();
                    }
                }, this.threadName).start();
            }
        }
        object = this.waitForTaskLock;
        synchronized (object) {
            this.waitForTaskLock.notifyAll();
        }
    }

    private void doPump() {
        while (this.pumpStarted) {
            this.runOnMainThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (ThreadPump.this.eventPump.isEmpty() && ThreadPump.this.startStack == 0) {
                        ThreadPump threadPump = ThreadPump.this;
                        synchronized (threadPump) {
                            ThreadPump.this.pumpStarted = false;
                            return;
                        }
                    }
                    if (ThreadPump.this.eventPump.isEmpty() && ThreadPump.this.startStack > 0) {
                        long now = System.currentTimeMillis();
                        long waitTime = ThreadPump.this.lockTime + (long)ThreadPump.this.minHoldTime - now;
                        Object object = ThreadPump.this.waitForTaskLock;
                        synchronized (object) {
                            try {
                                ThreadPump.this.waitForTaskLock.wait(waitTime);
                                ThreadPump threadPump = ThreadPump.this;
                                synchronized (threadPump) {
                                    ThreadPump.this.pumpStarted = false;
                                    return;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                    }
                    if (!ThreadPump.this.eventPump.isEmpty()) {
                        long now;
                        Runnable task = ThreadPump.this.eventPump.poll();
                        if (task != null) {
                            task.run();
                        }
                        if ((now = System.currentTimeMillis()) > ThreadPump.this.lockTime + (long)ThreadPump.this.maxHoldTime) {
                            ThreadPump.this.idleTime = ThreadPump.this.waitTime;
                            return;
                        }
                    }
                }
            });
            if (this.idleTime <= 0L) continue;
            try {
                Thread.sleep(this.idleTime);
                this.idleTime = 0L;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected abstract void runOnMainThread(Runnable var1);
}

