/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCEntityEquipment;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCServer;
import com.laytonsmith.abstraction.enums.MCEquipmentSlot;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.core.Static;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class BukkitMCEntityEquipment
implements MCEntityEquipment {
    private final EntityEquipment ee;

    public BukkitMCEntityEquipment(EntityEquipment equipment) {
        this.ee = equipment;
    }

    @Override
    public void clearEquipment() {
        this.ee.clear();
    }

    @Override
    public MCEntity getHolder() {
        return BukkitConvertor.BukkitGetCorrectEntity(this.ee.getHolder());
    }

    @Override
    public Map<MCEquipmentSlot, MCItemStack> getAllEquipment() {
        EnumMap<MCEquipmentSlot, MCItemStack> slots = new EnumMap<MCEquipmentSlot, MCItemStack>(MCEquipmentSlot.class);
        slots.put(MCEquipmentSlot.WEAPON, this.getWeapon());
        slots.put(MCEquipmentSlot.OFF_HAND, this.getItemInOffHand());
        slots.put(MCEquipmentSlot.HELMET, this.getHelmet());
        slots.put(MCEquipmentSlot.CHESTPLATE, this.getChestplate());
        slots.put(MCEquipmentSlot.LEGGINGS, this.getLeggings());
        slots.put(MCEquipmentSlot.BOOTS, this.getBoots());
        BukkitMCServer server = (BukkitMCServer)Static.getServer();
        if (server.getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
            try {
                slots.put(MCEquipmentSlot.BODY, new BukkitMCItemStack(this.ee.getItem(EquipmentSlot.BODY)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (server.getMinecraftVersion().gte(MCVersion.MC1_21_5)) {
                try {
                    slots.put(MCEquipmentSlot.SADDLE, new BukkitMCItemStack(this.ee.getItem(EquipmentSlot.SADDLE)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return slots;
    }

    @Override
    public void setAllEquipment(Map<MCEquipmentSlot, MCItemStack> slots) {
        for (Map.Entry<MCEquipmentSlot, MCItemStack> entry : slots.entrySet()) {
            MCItemStack stack = entry.getValue();
            switch (entry.getKey()) {
                case WEAPON: {
                    this.setWeapon(stack);
                    break;
                }
                case OFF_HAND: {
                    this.setItemInOffHand(stack);
                    break;
                }
                case HELMET: {
                    this.setHelmet(stack);
                    break;
                }
                case CHESTPLATE: {
                    this.setChestplate(stack);
                    break;
                }
                case LEGGINGS: {
                    this.setLeggings(stack);
                    break;
                }
                case BOOTS: {
                    this.setBoots(stack);
                    break;
                }
                case BODY: {
                    if (!Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) break;
                    try {
                        this.ee.setItem(EquipmentSlot.BODY, (ItemStack)stack.getHandle());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
                case SADDLE: {
                    if (!Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_21_5)) break;
                    try {
                        this.ee.setItem(EquipmentSlot.SADDLE, (ItemStack)stack.getHandle());
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public Map<MCEquipmentSlot, Float> getAllDropChances() {
        EnumMap<MCEquipmentSlot, Float> slots = new EnumMap<MCEquipmentSlot, Float>(MCEquipmentSlot.class);
        slots.put(MCEquipmentSlot.WEAPON, Float.valueOf(this.getWeaponDropChance()));
        slots.put(MCEquipmentSlot.OFF_HAND, Float.valueOf(this.getOffHandDropChance()));
        slots.put(MCEquipmentSlot.HELMET, Float.valueOf(this.getHelmetDropChance()));
        slots.put(MCEquipmentSlot.CHESTPLATE, Float.valueOf(this.getChestplateDropChance()));
        slots.put(MCEquipmentSlot.LEGGINGS, Float.valueOf(this.getLeggingsDropChance()));
        slots.put(MCEquipmentSlot.BOOTS, Float.valueOf(this.getBootsDropChance()));
        BukkitMCServer server = (BukkitMCServer)Static.getServer();
        if (server.getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
            slots.put(MCEquipmentSlot.BODY, Float.valueOf(this.ee.getDropChance(EquipmentSlot.BODY)));
            if (server.getMinecraftVersion().gte(MCVersion.MC1_21_5)) {
                slots.put(MCEquipmentSlot.SADDLE, Float.valueOf(this.ee.getDropChance(EquipmentSlot.SADDLE)));
            }
        }
        return slots;
    }

    @Override
    public void setAllDropChances(Map<MCEquipmentSlot, Float> slots) {
        for (Map.Entry<MCEquipmentSlot, Float> entry : slots.entrySet()) {
            float chance = entry.getValue().floatValue();
            switch (entry.getKey()) {
                case WEAPON: {
                    this.setWeaponDropChance(chance);
                    break;
                }
                case OFF_HAND: {
                    this.setOffHandDropChance(chance);
                    break;
                }
                case HELMET: {
                    this.setHelmetDropChance(chance);
                    break;
                }
                case CHESTPLATE: {
                    this.setChestplateDropChance(chance);
                    break;
                }
                case LEGGINGS: {
                    this.setLeggingsDropChance(chance);
                    break;
                }
                case BOOTS: {
                    this.setBootsDropChance(chance);
                    break;
                }
                case BODY: {
                    if (!Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) break;
                    this.ee.setDropChance(EquipmentSlot.BODY, chance);
                    break;
                }
                case SADDLE: {
                    if (!Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_21_5)) break;
                    this.ee.setDropChance(EquipmentSlot.SADDLE, chance);
                }
            }
        }
    }

    @Override
    public MCItemStack getWeapon() {
        return new BukkitMCItemStack(this.ee.getItemInMainHand());
    }

    @Override
    public MCItemStack getItemInOffHand() {
        return new BukkitMCItemStack(this.ee.getItemInOffHand());
    }

    @Override
    public MCItemStack getHelmet() {
        return new BukkitMCItemStack(this.ee.getHelmet());
    }

    @Override
    public MCItemStack getChestplate() {
        return new BukkitMCItemStack(this.ee.getChestplate());
    }

    @Override
    public MCItemStack getLeggings() {
        return new BukkitMCItemStack(this.ee.getLeggings());
    }

    @Override
    public MCItemStack getBoots() {
        return new BukkitMCItemStack(this.ee.getBoots());
    }

    @Override
    public void setWeapon(MCItemStack stack) {
        this.ee.setItemInMainHand(((BukkitMCItemStack)stack).asItemStack());
    }

    @Override
    public void setItemInOffHand(MCItemStack stack) {
        this.ee.setItemInOffHand(((BukkitMCItemStack)stack).asItemStack());
    }

    @Override
    public void setHelmet(MCItemStack stack) {
        this.ee.setHelmet(((BukkitMCItemStack)stack).asItemStack());
    }

    @Override
    public void setChestplate(MCItemStack stack) {
        this.ee.setChestplate(((BukkitMCItemStack)stack).asItemStack());
    }

    @Override
    public void setLeggings(MCItemStack stack) {
        this.ee.setLeggings(((BukkitMCItemStack)stack).asItemStack());
    }

    @Override
    public void setBoots(MCItemStack stack) {
        this.ee.setBoots(((BukkitMCItemStack)stack).asItemStack());
    }

    @Override
    public float getWeaponDropChance() {
        return this.ee.getItemInMainHandDropChance();
    }

    @Override
    public float getOffHandDropChance() {
        return this.ee.getItemInOffHandDropChance();
    }

    @Override
    public float getHelmetDropChance() {
        return this.ee.getHelmetDropChance();
    }

    @Override
    public float getChestplateDropChance() {
        return this.ee.getChestplateDropChance();
    }

    @Override
    public float getLeggingsDropChance() {
        return this.ee.getLeggingsDropChance();
    }

    @Override
    public float getBootsDropChance() {
        return this.ee.getBootsDropChance();
    }

    @Override
    public void setWeaponDropChance(float chance) {
        this.ee.setItemInMainHandDropChance(chance);
    }

    @Override
    public void setOffHandDropChance(float chance) {
        this.ee.setItemInOffHandDropChance(chance);
    }

    @Override
    public void setHelmetDropChance(float chance) {
        this.ee.setHelmetDropChance(chance);
    }

    @Override
    public void setChestplateDropChance(float chance) {
        this.ee.setChestplateDropChance(chance);
    }

    @Override
    public void setLeggingsDropChance(float chance) {
        this.ee.setLeggingsDropChance(chance);
    }

    @Override
    public void setBootsDropChance(float chance) {
        this.ee.setBootsDropChance(chance);
    }
}

