/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler;

import com.laytonsmith.core.compiler.TokenStream;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Token;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

class LexerObject {
    StringBuilder buffer;
    boolean stateInSingleQuote = false;
    boolean stateInDoubleQuote = false;
    boolean stateInMultiline = false;
    boolean stateInLineComment = false;
    boolean stateInBlockComment = false;
    boolean stateInSmartBlockComment = false;
    boolean stateInPureMscript = false;
    boolean stateInOptVar = false;
    boolean stateInVar = false;
    boolean stateInIvar = false;
    boolean stateInFileopts = false;
    StringBuffer fileopts = new StringBuffer();
    int startSingleQuote = 1;
    int startDoubleQuote = 1;
    int startMultiline = 1;
    int startBlockComment = 1;
    int braceStack = 0;
    int squareBraceStack = 0;
    List<Token> tokenList = null;
    String config;
    File file;
    int lineNum = 1;
    int column = 1;
    int lastColumn = 0;
    Target target = Target.UNKNOWN;
    final boolean usingNonPure;
    private static final SortedSet<TokenMap> TOKEN_MAP = new TreeSet<TokenMap>();

    private static void setupTokens() {
        TOKEN_MAP.add(new TokenMap("<=", Token.TType.LTE));
        TOKEN_MAP.add(new TokenMap("<", Token.TType.LT));
        TOKEN_MAP.add(new TokenMap(">", Token.TType.GT));
        TOKEN_MAP.add(new TokenMap(">=", Token.TType.GTE));
        TOKEN_MAP.add(new TokenMap("==", Token.TType.EQUALS));
        TOKEN_MAP.add(new TokenMap("===", Token.TType.STRICT_EQUALS));
        TOKEN_MAP.add(new TokenMap("!=", Token.TType.NOT_EQUALS));
        TOKEN_MAP.add(new TokenMap("!==", Token.TType.STRICT_NOT_EQUALS));
        TOKEN_MAP.add(new TokenMap("&&", Token.TType.LOGICAL_AND));
        TOKEN_MAP.add(new TokenMap("||", Token.TType.LOGICAL_OR));
        TOKEN_MAP.add(new TokenMap("!", Token.TType.LOGICAL_NOT));
        TOKEN_MAP.add(new TokenMap("+", Token.TType.PLUS));
        TOKEN_MAP.add(new TokenMap("-", Token.TType.MINUS));
        TOKEN_MAP.add(new TokenMap("*", Token.TType.MULTIPLICATION));
        TOKEN_MAP.add(new TokenMap("/", Token.TType.DIVISION));
        TOKEN_MAP.add(new TokenMap("++", Token.TType.INCREMENT));
        TOKEN_MAP.add(new TokenMap("--", Token.TType.DECREMENT));
        TOKEN_MAP.add(new TokenMap("%", Token.TType.MODULO));
        TOKEN_MAP.add(new TokenMap("**", Token.TType.EXPONENTIAL));
        TOKEN_MAP.add(new TokenMap(".", Token.TType.CONCAT));
        TOKEN_MAP.add(new TokenMap("->", Token.TType.DEREFERENCE));
        TOKEN_MAP.add(new TokenMap("::", Token.TType.DEREFERENCE));
        TOKEN_MAP.add(new TokenMap("${", Token.TType.CONST_START));
        TOKEN_MAP.add(new TokenMap("{", Token.TType.LCURLY_BRACKET));
        TOKEN_MAP.add(new TokenMap("}", Token.TType.RCURLY_BRACKET));
        TOKEN_MAP.add(new TokenMap("[", Token.TType.LSQUARE_BRACKET));
        TOKEN_MAP.add(new TokenMap("]", Token.TType.RSQUARE_BRACKET));
        TOKEN_MAP.add(new TokenMap("..", Token.TType.SLICE));
        TOKEN_MAP.add(new TokenMap("=", Token.TType.ASSIGNMENT));
        TOKEN_MAP.add(new TokenMap(":", Token.TType.LABEL));
        TOKEN_MAP.add(new TokenMap(",", Token.TType.COMMA));
        TOKEN_MAP.add(new TokenMap("(", Token.TType.FUNC_START));
        TOKEN_MAP.add(new TokenMap(")", Token.TType.FUNC_END));
    }

    LexerObject(String config, File file, boolean startInPureMscript) {
        this.config = config.replaceAll("\r\n", "\n") + "\n";
        this.file = file;
        this.stateInPureMscript = startInPureMscript;
        this.usingNonPure = !startInPureMscript;
        this.clearBuffer();
    }

    private void buffer(Object s) {
        this.buffer.append(s);
    }

    private void parseBuffer() {
        String last = this.clearBuffer().trim();
        if (!last.isEmpty()) {
            this.append(this.identifyToken(last));
        }
    }

    private String clearBuffer() {
        String buf = "";
        if (this.buffer != null) {
            buf = this.buffer.toString();
        }
        this.buffer = new StringBuilder(32);
        return buf;
    }

    private Token identifyToken(String item) {
        try {
            Long.parseLong(item.trim());
            return new Token(Token.TType.INTEGER, item, this.target);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble(item);
                return new Token(Token.TType.DOUBLE, item, this.target);
            }
            catch (NumberFormatException numberFormatException2) {
                if (item.trim().equals("$")) {
                    return new Token(Token.TType.FINAL_VAR, "$", this.target);
                }
                if (item.matches("\\$[a-zA-Z0-9]+")) {
                    return new Token(Token.TType.VARIABLE, item.trim(), this.target);
                }
                if (item.matches("@[a-zA-Z0-9]+")) {
                    return new Token(Token.TType.IVARIABLE, item.trim(), this.target);
                }
                return new Token(Token.TType.BARE_STRING, item.trim(), this.target);
            }
        }
    }

    private void append(String value, Token.TType type) {
        this.append(new Token(type, value, this.target));
    }

    private void append(Token t) {
        this.tokenList.add(t);
    }

    public TokenStream lex() throws ConfigCompileException {
        if (this.tokenList != null) {
            return new TokenStream(new ArrayList<Token>(this.tokenList), "", new HashMap<String, String>());
        }
        this.tokenList = new ArrayList<Token>();
        for (int i = 0; i < this.config.length(); ++i) {
            Character c = Character.valueOf(this.config.charAt(i));
            Character c2 = null;
            Character c3 = null;
            if (i < this.config.length() - 1) {
                c2 = Character.valueOf(this.config.charAt(i + 1));
            }
            if (i < this.config.length() - 2) {
                c3 = Character.valueOf(this.config.charAt(i + 2));
            }
            this.column += i - this.lastColumn;
            this.lastColumn = i;
            if (c.charValue() == '\n') {
                ++this.lineNum;
                this.column = 1;
            }
            this.target = new Target(this.lineNum, this.file, this.column);
            if (this.stateInFileopts) {
                if (c.charValue() == '\\' && c2.charValue() == '>') {
                    this.fileopts.append('>');
                    ++i;
                    continue;
                }
                if (c.charValue() == '>') {
                    this.stateInFileopts = false;
                    continue;
                }
                this.fileopts.append(c);
                continue;
            }
            if (!this.stateInDoubleQuote && !this.stateInSingleQuote) {
                if (!this.stateInBlockComment && !this.stateInLineComment) {
                    if (c.charValue() == '/' && c2.charValue() == '*') {
                        this.parseBuffer();
                        this.stateInBlockComment = true;
                        this.startBlockComment = this.lineNum;
                        if (c3.charValue() == '*') {
                            this.stateInSmartBlockComment = true;
                            ++i;
                        } else {
                            this.stateInSmartBlockComment = false;
                        }
                        ++i;
                        continue;
                    }
                    if (c.charValue() == '#') {
                        this.parseBuffer();
                        this.stateInLineComment = true;
                        continue;
                    }
                } else if (this.stateInBlockComment) {
                    if (c.charValue() == '*' && c2.charValue() == '/') {
                        this.stateInBlockComment = false;
                        ++i;
                        this.clearBuffer();
                        continue;
                    }
                } else if (this.stateInLineComment && c.charValue() == '\n') {
                    this.stateInLineComment = false;
                    this.clearBuffer();
                    continue;
                }
            }
            if ((this.stateInBlockComment || this.stateInLineComment) && this.stateInSmartBlockComment) {
                this.buffer(c);
            }
            if (!this.stateInDoubleQuote && c.charValue() == '\"') {
                this.parseBuffer();
                this.stateInDoubleQuote = true;
                this.startDoubleQuote = this.lineNum;
                continue;
            }
            if (!this.stateInSingleQuote && c.charValue() == '\'') {
                this.parseBuffer();
                this.stateInSingleQuote = true;
                this.startSingleQuote = this.lineNum;
                continue;
            }
            if ((this.stateInDoubleQuote || this.stateInSingleQuote) && c.charValue() == '\\') {
                switch (c2.charValue()) {
                    case 'n': {
                        this.buffer("\n");
                        ++i;
                        break;
                    }
                    case 't': {
                        this.buffer("\t");
                        ++i;
                        break;
                    }
                    case 'u': {
                        StringBuilder unicode = new StringBuilder();
                        for (int m = 0; m < 4; ++m) {
                            try {
                                unicode.append(this.config.charAt(i + 2 + m));
                                continue;
                            }
                            catch (IndexOutOfBoundsException e) {
                                this.error("Incomplete unicode escape");
                            }
                        }
                        try {
                            Integer.parseInt(unicode.toString(), 16);
                        }
                        catch (NumberFormatException e) {
                            this.error("Unrecognized unicode escape sequence");
                        }
                        this.buffer(Character.toChars(Integer.parseInt(unicode.toString(), 16)));
                        i += 4;
                        break;
                    }
                    case '\'': {
                        if (this.stateInDoubleQuote) {
                            this.error("Invalid escape found. It is an error to escape single quotes inside a double quote.");
                            break;
                        }
                        this.buffer("'");
                        ++i;
                        break;
                    }
                    case '\"': {
                        if (this.stateInSingleQuote) {
                            this.error("Invalid escape found. It is an error to escape double quotes inside a single quote.");
                            break;
                        }
                        this.buffer(Character.valueOf('\"'));
                        ++i;
                        break;
                    }
                    default: {
                        this.error("The escape sequence \\" + c2 + " is not a recognized escape sequence");
                        break;
                    }
                }
                continue;
            }
            if (this.stateInDoubleQuote) {
                if (c.charValue() == '\"') {
                    this.stateInDoubleQuote = false;
                    this.append(this.clearBuffer(), Token.TType.SMART_STRING);
                    this.error("Double quotes are currently unsupported");
                    continue;
                }
                this.buffer(c);
                continue;
            }
            if (this.stateInSingleQuote) {
                if (c.charValue() == '\'') {
                    this.stateInSingleQuote = false;
                    this.append(this.clearBuffer(), Token.TType.STRING);
                    continue;
                }
                this.buffer(c);
                continue;
            }
            if (c.charValue() == '>' && c2.charValue() == '>' && c3.charValue() == '>') {
                if (this.stateInMultiline) {
                    this.error("Found multiline start symbol while already in multiline!");
                }
                this.stateInMultiline = true;
                this.startMultiline = this.lineNum;
                i += 2;
                continue;
            }
            if (c.charValue() == '<' && c2.charValue() == '<' && c3.charValue() == '<') {
                if (!this.stateInMultiline) {
                    this.error("Found multiline end symbol while not in multiline!");
                }
                this.stateInMultiline = false;
                i += 2;
                continue;
            }
            if (Character.isWhitespace(c.charValue()) && c.charValue() != '\n') {
                this.parseBuffer();
                continue;
            }
            if (c.charValue() == '<' && c2.charValue() == '!') {
                if (!this.tokenList.isEmpty()) {
                    throw new ConfigCompileException("File options must come first in the file.", this.target);
                }
                this.stateInFileopts = true;
                ++i;
                continue;
            }
            if (!this.stateInPureMscript) {
                if (c.charValue() == '[') {
                    if (this.stateInOptVar) {
                        this.error("Found [ symbol, but a previous optional variable had already been started");
                    }
                    this.stateInOptVar = true;
                    this.parseBuffer();
                    this.append("[", Token.TType.LSQUARE_BRACKET);
                    continue;
                }
                if (c.charValue() == ']') {
                    if (!this.stateInOptVar) {
                        this.error("Found ] symbol, but no optional variable had been started");
                    }
                    this.stateInOptVar = false;
                    this.parseBuffer();
                    this.append("]", Token.TType.RSQUARE_BRACKET);
                    continue;
                }
                if (this.stateInOptVar && c.charValue() == '=') {
                    this.parseBuffer();
                    this.append("=", Token.TType.OPT_VAR_ASSIGN);
                    continue;
                }
                if (c.charValue() == '=') {
                    this.stateInPureMscript = true;
                    this.parseBuffer();
                    this.append("=", Token.TType.ALIAS_END);
                    continue;
                }
                if (c.charValue() == ':') {
                    this.parseBuffer();
                    this.append(":", Token.TType.LABEL);
                    continue;
                }
                if (c.charValue() == '\n') {
                    this.parseBuffer();
                    if (!this.tokenList.isEmpty() && this.tokenList.get((int)(this.tokenList.size() - 1)).type == Token.TType.NEWLINE) continue;
                    this.append("\n", Token.TType.NEWLINE);
                    continue;
                }
                this.buffer(c);
                continue;
            }
            if (c.charValue() == '\n') {
                if (this.stateInMultiline || this.tokenList.isEmpty() || this.tokenList.get((int)(this.tokenList.size() - 1)).type == Token.TType.NEWLINE) continue;
                this.parseBuffer();
                if (this.usingNonPure) {
                    if (this.tokenList.get((int)(this.tokenList.size() - 1)).type != Token.TType.NEWLINE) {
                        this.append("\n", Token.TType.NEWLINE);
                    }
                    this.stateInPureMscript = false;
                    continue;
                }
                if (this.stateInPureMscript) continue;
            }
            if (c.charValue() == '.' && Character.isDigit(c2.charValue())) {
                this.buffer(c);
                continue;
            }
            if (c.charValue() == '/' && (c2.charValue() == '/' || Character.isLetter(c2.charValue()))) {
                this.buffer(c);
                continue;
            }
            int skip = this.identifySymbol(i);
            if (skip != -1) {
                i += skip;
                continue;
            }
            this.buffer(c);
        }
        this.parseBuffer();
        return new TokenStream(new ArrayList<Token>(this.tokenList), this.fileopts.toString(), new HashMap<String, String>());
    }

    private int identifySymbol(int startAt) {
        char[] lookahead = new char[LexerObject.TOKEN_MAP.first().token.length()];
        for (int i = 0; i < lookahead.length; ++i) {
            lookahead[i] = i + startAt < this.config.length() - 1 ? this.config.charAt(i + startAt) : (char)32;
        }
        for (TokenMap tm : TOKEN_MAP) {
            boolean found = true;
            for (int i = 0; i < tm.token.length(); ++i) {
                if (tm.token.charAt(i) == lookahead[i]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            String last = this.clearBuffer();
            if (!last.isEmpty()) {
                this.append(this.identifyToken(last));
            }
            this.append(tm.token, tm.type);
            return tm.token.length() - 1;
        }
        return -1;
    }

    private void error(String message) throws ConfigCompileException {
        throw new ConfigCompileException(message, this.target);
    }

    static {
        LexerObject.setupTokens();
    }

    private static class TokenMap
    implements Comparable<TokenMap> {
        String token;
        Token.TType type;

        public TokenMap(String token, Token.TType type) {
            this.token = token;
            this.type = type;
        }

        @Override
        public int compareTo(TokenMap o) {
            if (this.token.length() == o.token.length()) {
                return this.token.compareTo(o.token);
            }
            if (this.token.length() < o.token.length()) {
                return 1;
            }
            return -1;
        }

        public String toString() {
            return this.token;
        }
    }
}

